/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.css;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTree;
import org.apache.flex.compiler.css.ICSSNamespaceDefinition;
import org.apache.flex.compiler.internal.css.CSSModelTreeType;
import org.apache.flex.compiler.internal.css.CSSNodeBase;
import org.apache.flex.compiler.internal.css.CSSStringPropertyValue;

public class CSSNamespaceDefinition
extends CSSNodeBase
implements ICSSNamespaceDefinition {
    private final String prefix;
    private final String uri;

    protected CSSNamespaceDefinition(String prefix, String uri, CommonTree tree, TokenStream tokenStream) {
        super(tree, tokenStream, CSSModelTreeType.NAMESPACE_DEFINITION);
        assert (uri != null) : "@namespace URI can't be null.";
        assert (CSSStringPropertyValue.isQuoted(uri)) : "Do not strip namespace quotes in parser.";
        this.prefix = prefix;
        this.uri = CSSStringPropertyValue.stripQuotes(uri);
        Preconditions.checkState((this.uri.length() > 0 ? 1 : 0) != 0, (Object)"@namespace URI can't be empty.");
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public String getURI() {
        return this.uri;
    }

    @Override
    public String toString() {
        return Joiner.on((String)" ").skipNulls().join((Object)"@namespace", (Object)this.prefix, new Object[]{'\"' + this.uri + '\"', ";"});
    }
}

