/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.as.codegen;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Stack;
import java.util.Vector;
import org.apache.flex.abc.ABCConstants;
import org.apache.flex.abc.instructionlist.InstructionList;
import org.apache.flex.abc.semantics.ECMASupport;
import org.apache.flex.abc.semantics.Instruction;
import org.apache.flex.abc.semantics.InstructionFactory;
import org.apache.flex.abc.semantics.Label;
import org.apache.flex.abc.semantics.MethodInfo;
import org.apache.flex.abc.semantics.Name;
import org.apache.flex.abc.semantics.Namespace;
import org.apache.flex.abc.semantics.NoOperandsInstruction;
import org.apache.flex.abc.semantics.Nsset;
import org.apache.flex.abc.semantics.PooledValue;
import org.apache.flex.compiler.constants.IASLanguageConstants;
import org.apache.flex.compiler.definitions.IAccessorDefinition;
import org.apache.flex.compiler.definitions.IConstantDefinition;
import org.apache.flex.compiler.definitions.IDefinition;
import org.apache.flex.compiler.definitions.ITypeDefinition;
import org.apache.flex.compiler.definitions.IVariableDefinition;
import org.apache.flex.compiler.exceptions.CodegenInterruptedException;
import org.apache.flex.compiler.exceptions.DuplicateLabelException;
import org.apache.flex.compiler.exceptions.UnknownControlFlowTargetException;
import org.apache.flex.compiler.internal.as.codegen.BindableHelper;
import org.apache.flex.compiler.internal.as.codegen.Binding;
import org.apache.flex.compiler.internal.as.codegen.ControlFlowContextManager;
import org.apache.flex.compiler.internal.as.codegen.ExceptionHandlingContext;
import org.apache.flex.compiler.internal.as.codegen.InlineFunctionLexicalScope;
import org.apache.flex.compiler.internal.as.codegen.InstructionListNode;
import org.apache.flex.compiler.internal.as.codegen.LexicalScope;
import org.apache.flex.compiler.internal.definitions.AccessorDefinition;
import org.apache.flex.compiler.internal.definitions.ClassDefinition;
import org.apache.flex.compiler.internal.definitions.DefinitionBase;
import org.apache.flex.compiler.internal.definitions.FunctionDefinition;
import org.apache.flex.compiler.internal.definitions.GetterDefinition;
import org.apache.flex.compiler.internal.definitions.NamespaceDefinition;
import org.apache.flex.compiler.internal.definitions.SetterDefinition;
import org.apache.flex.compiler.internal.definitions.TypeDefinitionBase;
import org.apache.flex.compiler.internal.semantics.SemanticUtils;
import org.apache.flex.compiler.internal.tree.as.BaseDefinitionNode;
import org.apache.flex.compiler.internal.tree.as.BaseVariableNode;
import org.apache.flex.compiler.internal.tree.as.BinaryOperatorInNode;
import org.apache.flex.compiler.internal.tree.as.DynamicAccessNode;
import org.apache.flex.compiler.internal.tree.as.EmbedNode;
import org.apache.flex.compiler.internal.tree.as.ExpressionNodeBase;
import org.apache.flex.compiler.internal.tree.as.ForLoopNode;
import org.apache.flex.compiler.internal.tree.as.FunctionNode;
import org.apache.flex.compiler.internal.tree.as.FunctionObjectNode;
import org.apache.flex.compiler.internal.tree.as.IdentifierNode;
import org.apache.flex.compiler.internal.tree.as.LabeledStatementNode;
import org.apache.flex.compiler.internal.tree.as.MemberAccessExpressionNode;
import org.apache.flex.compiler.internal.tree.as.NamespaceNode;
import org.apache.flex.compiler.internal.tree.as.RegExpLiteralNode;
import org.apache.flex.compiler.internal.tree.as.ScopedBlockNode;
import org.apache.flex.compiler.internal.tree.as.SwitchNode;
import org.apache.flex.compiler.internal.tree.as.TernaryOperatorNode;
import org.apache.flex.compiler.internal.tree.as.VariableExpressionNode;
import org.apache.flex.compiler.internal.tree.as.VariableNode;
import org.apache.flex.compiler.problems.AmbiguousGotoTargetProblem;
import org.apache.flex.compiler.problems.AnyNamespaceCannotBeQualifierProblem;
import org.apache.flex.compiler.problems.CodegenInternalProblem;
import org.apache.flex.compiler.problems.DuplicateLabelProblem;
import org.apache.flex.compiler.problems.DuplicateNamespaceDefinitionProblem;
import org.apache.flex.compiler.problems.ICompilerProblem;
import org.apache.flex.compiler.problems.InvalidLvalueProblem;
import org.apache.flex.compiler.problems.InvalidNamespaceInitializerProblem;
import org.apache.flex.compiler.problems.MultipleSwitchDefaultsProblem;
import org.apache.flex.compiler.problems.NonConstantParamInitializerProblem;
import org.apache.flex.compiler.problems.PackageCannotBeUsedAsValueProblem;
import org.apache.flex.compiler.problems.UnexpectedReturnProblem;
import org.apache.flex.compiler.problems.UnknownBreakTargetProblem;
import org.apache.flex.compiler.problems.UnknownContinueTargetProblem;
import org.apache.flex.compiler.problems.UnknownGotoTargetProblem;
import org.apache.flex.compiler.problems.UnknownNamespaceProblem;
import org.apache.flex.compiler.problems.VoidTypeProblem;
import org.apache.flex.compiler.projects.ICompilerProject;
import org.apache.flex.compiler.tree.as.IASNode;
import org.apache.flex.compiler.tree.as.IBinaryOperatorNode;
import org.apache.flex.compiler.tree.as.ICatchNode;
import org.apache.flex.compiler.tree.as.IContainerNode;
import org.apache.flex.compiler.tree.as.IDynamicAccessNode;
import org.apache.flex.compiler.tree.as.IExpressionNode;
import org.apache.flex.compiler.tree.as.IForLoopNode;
import org.apache.flex.compiler.tree.as.IFunctionCallNode;
import org.apache.flex.compiler.tree.as.IFunctionNode;
import org.apache.flex.compiler.tree.as.IIdentifierNode;
import org.apache.flex.compiler.tree.as.IImportNode;
import org.apache.flex.compiler.tree.as.ILanguageIdentifierNode;
import org.apache.flex.compiler.tree.as.IOperatorNode;
import org.apache.flex.compiler.tree.as.IParameterNode;
import org.apache.flex.compiler.tree.as.ITryNode;
import org.apache.flex.compiler.tree.as.ITypedExpressionNode;
import org.apache.flex.compiler.tree.as.IUnaryOperatorNode;
import org.apache.flex.compiler.tree.as.IWhileLoopNode;
import org.apache.flex.compiler.tree.as.IWithNode;
import org.apache.flex.compiler.tree.mxml.IMXMLEventSpecifierNode;

public class ABCGeneratingReducer {
    private LexicalScope currentScope;
    private InstructionList instanceInitializers;
    Stack<InstructionList> miniScopes = new Stack();
    public static final Name namespaceType = new Name("Namespace");
    public static final Name xmlType = new Name("XML");
    public static final Name xmlListType = new Name("XMLList");
    public static final Name regexType = new Name("RegExp");
    public static final Name voidType = new Name("void");
    public static final Instruction synthesizedReturnVoid = new NoOperandsInstruction(71);
    private int typeofCount = 0;

    public static void pushNumericConstant(long value, InstructionList result_list) {
        result_list.pushNumericConstant(value);
    }

    public void pushNumericConstant(InstructionList result_list, Number value, IDefinition type) {
        ICompilerProject project = this.currentScope.getProject();
        if (type == project.getBuiltinType(IASLanguageConstants.BuiltinType.INT)) {
            int val = ECMASupport.toInt32(value);
            if ((byte)val == val) {
                result_list.addInstruction(36, val);
            } else if ((short)val == val) {
                result_list.addInstruction(37, val);
            } else {
                result_list.addInstruction(45, (Object)val);
            }
        } else if (type == project.getBuiltinType(IASLanguageConstants.BuiltinType.UINT)) {
            long uval = ECMASupport.toUInt32(value.doubleValue());
            if ((uval & 0x7FL) == uval) {
                result_list.addInstruction(36, (int)uval);
            } else if ((uval & 0x7FFFL) == uval) {
                result_list.addInstruction(37, (int)uval);
            } else {
                result_list.addInstruction(46, uval);
            }
        } else {
            double dval = value.doubleValue();
            if (ECMASupport.isNan(dval)) {
                result_list.addInstruction(40);
            } else if (!Double.isInfinite(dval) && dval == (double)ECMASupport.toInt32(value)) {
                if (dval == 0.0 && 1.0 / dval == Double.NEGATIVE_INFINITY) {
                    result_list.addInstruction(47, dval);
                } else {
                    this.pushNumericConstant(result_list, ECMASupport.toInt32(value), project.getBuiltinType(IASLanguageConstants.BuiltinType.INT));
                }
            } else if (Double.isNaN(dval)) {
                result_list.addInstruction(40);
            } else {
                result_list.addInstruction(47, value.doubleValue());
            }
        }
    }

    public Collection<ICompilerProblem> getProblems() {
        return this.currentScope.getProblems();
    }

    InstructionList binaryOp(IASNode iNode, InstructionList l, InstructionList r, int opcode) {
        this.checkBinaryOp(iNode, opcode);
        return this.binaryOperatorBody(iNode, l, r, InstructionFactory.getInstruction(opcode));
    }

    InstructionList conditionalJump(IASNode iNode, InstructionList l, InstructionList r, int opcode) {
        this.checkBinaryOp(iNode, opcode);
        return this.binaryOperatorBody(iNode, l, r, InstructionFactory.getTargetableInstruction(opcode));
    }

    InstructionList binaryOperatorBody(IASNode iNode, InstructionList l, InstructionList r, Instruction operator) {
        InstructionList result = this.createInstructionList(iNode, l.size() + r.size() + 1);
        result.addAll(l);
        result.addAll(r);
        result.addInstruction(operator);
        return result;
    }

    public void checkBinaryOp(IASNode iNode, int opcode) {
        this.currentScope.getMethodBodySemanticChecker().checkBinaryOperator(iNode, opcode);
    }

    Binding dottedName(IASNode iNode, String qualifiers, String base_name) {
        if (iNode instanceof IdentifierNode) {
            return this.currentScope.resolveName((IdentifierNode)iNode);
        }
        if (iNode instanceof ExpressionNodeBase) {
            ExpressionNodeBase expr = (ExpressionNodeBase)iNode;
            Name n = expr.getMName(this.currentScope.getProject());
            if (n == null) {
                this.currentScope.addProblem(new CodegenInternalProblem(iNode, "Unable to resove member name: " + iNode.toString()));
                n = new Name(7, new Nsset(new Namespace(22, qualifiers)), base_name);
            }
            return this.currentScope.getBinding(iNode, n, expr.resolve(this.currentScope.getProject()));
        }
        this.currentScope.addProblem(new CodegenInternalProblem(iNode, "Unable to resove to a dotted name: " + iNode.toString()));
        return new Binding(iNode, new Name(7, new Nsset(new Namespace(22, qualifiers)), base_name), null);
    }

    Binding errorPackageName(IASNode iNode, String qualifiers, String base_name) {
        this.currentScope.addProblem(new PackageCannotBeUsedAsValueProblem(iNode, "'" + qualifiers + "." + base_name + "'"));
        return new Binding(iNode, new Name(qualifiers + "." + base_name), null);
    }

    private void generateAssignmentOp(IASNode site, Binding target, InstructionList result) {
        boolean inlined = this.generateInlineSetterAccess(target, result, true);
        if (!inlined) {
            result.addInstruction(this.getAssignmentOpcode(site, target), target.getName());
        }
    }

    int getAssignmentOpcode(IASNode site, Binding b) {
        if (b.getDefinition() instanceof IConstantDefinition && this.inInitializingContext(site)) {
            return 104;
        }
        if (b.isSuperQualified()) {
            return 5;
        }
        return 97;
    }

    boolean inInitializingContext(IASNode iNode) {
        return SemanticUtils.isInVariableDeclaration(iNode) || SemanticUtils.isInConstructor(iNode);
    }

    public InstructionList createInstructionList(IASNode iNode) {
        return this.createInstructionList(iNode, 0);
    }

    public InstructionList createInstructionList(IASNode iNode, int capacity) {
        String file_name = SemanticUtils.getFileName(iNode);
        int line_num = iNode.getLine() + 1;
        if (this.currentScope.emitFile(file_name)) {
            ++capacity;
        }
        if (this.currentScope.emitLine(line_num)) {
            ++capacity;
        }
        DebugInfoInstructionList result = capacity > 3 ? new DebugInfoInstructionList(capacity) : new DebugInfoInstructionList();
        if (this.currentScope.emitFile(file_name)) {
            this.currentScope.setDebugFile(file_name);
            result.addInstruction(241, this.currentScope.getDebugFile());
        }
        if (this.currentScope.emitLine(line_num)) {
            result.setDebugLine(line_num);
            this.currentScope.setDebugLine(line_num);
        }
        return result;
    }

    public Binding error_namespaceAccess(IASNode iNode, IASNode raw_qualifier, Binding qualified_name) {
        String qualifier = ((IdentifierNode)raw_qualifier).getName();
        this.currentScope.addProblem(new UnknownNamespaceProblem(raw_qualifier, qualifier));
        return qualified_name;
    }

    public InstructionList error_reduce_Op_AssignId(IASNode iNode, InstructionList non_lvalue, InstructionList rvalue) {
        this.currentScope.addProblem(new InvalidLvalueProblem(iNode));
        InstructionList result = this.createInstructionList(iNode, 1);
        result.addInstruction(33);
        return result;
    }

    InstructionList generateAccess(Binding name) {
        return this.generateAccess(name, AccessType.Strict);
    }

    InstructionList generateAccess(Binding name, AccessType accessType) {
        InstructionList result = new InstructionList(2);
        this.generateAccess(name, accessType, result);
        return result;
    }

    void generateAccess(Binding binding, InstructionList result) {
        this.generateAccess(binding, AccessType.Strict, result);
    }

    void generateAccess(Binding binding, AccessType accessType, InstructionList result) {
        if (binding.isLocal()) {
            result.addInstruction(binding.getlocal());
        } else {
            assert (binding.getName() != null) : "non-local Binding " + binding + " must have a name";
            this.currentScope.getMethodBodySemanticChecker().checkGetProperty(binding);
            boolean inlined = this.generateInlineGetterAccess(binding, result, false);
            if (!inlined) {
                this.generateAccess(binding, binding.isSuperQualified(), accessType, result);
            }
        }
    }

    void generateAccess(Binding binding, boolean is_super, AccessType accessType, InstructionList result) {
        Name name = binding.getName();
        assert (name != null) : "binding must have a name when calling generateAccess()";
        IASNode node = binding.getNode();
        if (name.isTypeName()) {
            ITypedExpressionNode typeNode = (ITypedExpressionNode)node;
            IExpressionNode collectionNode = typeNode.getCollectionNode();
            IDefinition collectionDefinition = SemanticUtils.getDefinition(collectionNode, this.currentScope.getProject());
            Binding collectionBinding = this.currentScope.getBinding(collectionNode, name.getTypeNameBase(), collectionDefinition);
            this.generateAccess(collectionBinding, is_super, AccessType.Strict, result);
            IExpressionNode typeTypeNode = typeNode.getTypeNode();
            IDefinition typeDefinition = SemanticUtils.getDefinition(typeTypeNode, this.currentScope.getProject());
            Binding typeBinding = this.currentScope.getBinding(typeTypeNode, name.getTypeNameParameter(), typeDefinition);
            this.generateTypeNameParameter(typeBinding, result);
            result.addInstruction(83, 1);
        } else {
            IDefinition def;
            IdentifierNode id;
            boolean useLocal0 = false;
            if (node instanceof IdentifierNode && SemanticUtils.isRefToClassBeingInited(id = (IdentifierNode)node, def = id.resolve(this.currentScope.getProject())) && !this.currentScope.insideInlineFunction()) {
                useLocal0 = true;
            }
            if (useLocal0) {
                result.addInstruction(208);
            } else if (is_super) {
                result.addAll(this.currentScope.findProperty(binding, true));
                result.addInstruction(4, name);
            } else if (accessType == AccessType.Lenient) {
                result.addAll(this.currentScope.findProperty(binding, false));
                result.addInstruction(102, name);
            } else {
                result.addAll(this.currentScope.getPropertyValue(binding));
            }
        }
    }

    private boolean generateInlineGetterAccess(Binding binding, InstructionList result, boolean isQualified) {
        IDefinition def = binding.getDefinition();
        if (!(def instanceof AccessorDefinition) || !this.currentScope.getMethodBodySemanticChecker().canGetterBeInlined((AccessorDefinition)def)) {
            return false;
        }
        AccessorDefinition accessorDefinition = (AccessorDefinition)def;
        if (accessorDefinition instanceof SetterDefinition) {
            accessorDefinition = accessorDefinition.resolveCorrespondingAccessor(this.currentScope.getProject());
        }
        assert (accessorDefinition != null) : "generateInlineGetterAccess() called with no getter definition";
        FunctionNode functionNode = (FunctionNode)accessorDefinition.getFunctionNode();
        return this.inlineFunction(accessorDefinition, functionNode, result, isQualified);
    }

    private boolean generateInlineSetterAccess(Binding binding, InstructionList result, boolean isQualified) {
        IDefinition def = binding.getDefinition();
        if (!(def instanceof AccessorDefinition) || !this.currentScope.getMethodBodySemanticChecker().canSetterBeInlined((AccessorDefinition)def)) {
            return false;
        }
        AccessorDefinition accessorDefinition = (AccessorDefinition)def;
        if (accessorDefinition instanceof GetterDefinition) {
            accessorDefinition = accessorDefinition.resolveCorrespondingAccessor(this.currentScope.getProject());
        }
        assert (accessorDefinition != null) : "generateInlineSetterAccess() called with no setter definition";
        FunctionNode functionNode = (FunctionNode)accessorDefinition.getFunctionNode();
        return this.inlineFunction(accessorDefinition, functionNode, result, isQualified);
    }

    private boolean generateInlineFunctionCall(Binding binding, InstructionList result, boolean isQualified, Vector<InstructionList> args) {
        IDefinition def = binding.getDefinition();
        if (!(def instanceof FunctionDefinition) || def instanceof IAccessorDefinition || !this.currentScope.getMethodBodySemanticChecker().canFunctionBeInlined((FunctionDefinition)def)) {
            return false;
        }
        FunctionDefinition functionDef = (FunctionDefinition)binding.getDefinition();
        FunctionNode functionNode = (FunctionNode)functionDef.getFunctionNode();
        InstructionList insn = this.createInstructionList(functionNode);
        for (InstructionList arg : args) {
            insn.addAll(arg);
        }
        if (this.inlineFunction(functionDef, functionNode, insn, isQualified)) {
            result.addAll(insn);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean inlineFunction(FunctionDefinition functionDef, FunctionNode functionNode, InstructionList result, boolean isQualified) {
        try {
            TypeDefinitionBase returnType;
            InlineFunctionLexicalScope inlineFunctionScope = this.currentScope.pushInlineFunctionFrame(functionDef.getContainingScope(), isQualified, functionNode);
            this.currentScope = inlineFunctionScope;
            ScopedBlockNode body = functionNode.getScopedNode();
            InstructionList insns = inlineFunctionScope.getGenerator().generateInstructions(body, 13, inlineFunctionScope);
            this.currentScope = this.currentScope.popFrame();
            ICompilerProject project = this.currentScope.getProject();
            if (this.currentScope.getMethodBodySemanticChecker().functionBodyHasNonInlineableInstructions(insns, functionDef.isInline(), functionDef.getBaseName())) {
                boolean bl = false;
                return bl;
            }
            inlineFunctionScope.assignActualsToFormals(functionDef, result);
            if (isQualified) {
                result.addInstruction(inlineFunctionScope.setContainingClass());
            }
            result.addAll(insns);
            if ((!(functionDef instanceof SetterDefinition) && result.canFallThrough() || result.hasPendingLabels()) && (returnType = (TypeDefinitionBase)functionDef.resolveReturnType(project)) != this.currentScope.getProject().getBuiltinType(IASLanguageConstants.BuiltinType.VOID) && returnType != this.currentScope.getProject().getBuiltinType(IASLanguageConstants.BuiltinType.ANY_TYPE)) {
                result.addInstruction(33);
                result.addInstruction(128, returnType.getMName(project));
            }
            result.labelNext(inlineFunctionScope.getInlinedFunctionCallSiteLabel());
            inlineFunctionScope.mergeIntoContainingScope(result);
        }
        finally {
            functionNode.discardFunctionBody();
        }
        return true;
    }

    InstructionList generateAssignment(IASNode iNode, Binding target, InstructionList rvalue) {
        return this.generateAssignment(iNode, target, rvalue, false);
    }

    InstructionList generateAssignment(IASNode iNode, Binding target, InstructionList rvalue, boolean need_value) {
        InstructionList result = this.createInstructionList(iNode, rvalue.size() + 4);
        int rhsOpcode = rvalue.lastElement().getOpcode();
        boolean rhsIsLocal = rhsOpcode == 98 || rhsOpcode == 208 || rhsOpcode == 209 || rhsOpcode == 210 || rhsOpcode == 211;
        result.addAll(rvalue);
        if (need_value) {
            result.addInstruction(42);
        }
        if (target.isLocal() || target.slotIdIsSet()) {
            if (target.getDefinition() != null) {
                ITypeDefinition tgtType = target.getDefinition().resolveType(this.currentScope.getProject());
                ITypeDefinition srcType = null;
                srcType = SemanticUtils.resolveRHSTypeOfAssignment(this.currentScope.getProject(), iNode);
                if (!(tgtType == null || tgtType == ClassDefinition.getAnyTypeClassDefinition() || srcType == tgtType && rhsIsLocal)) {
                    this.coerce(result, tgtType);
                }
            }
            if (SemanticUtils.isConstDefinition(target.getDefinition()) && !SemanticUtils.isInVariableDeclaration(iNode) && target.getName() != null) {
                result.addInstruction(44, "Illegal write to local const " + target.getName().getBaseName());
                result.addInstruction(3);
            } else if (target.slotIdIsSet()) {
                if (this.currentScope.needsActivation()) {
                    result.addInstruction(this.currentScope.getActivationStorage().getlocal());
                    result.addInstruction(43);
                }
                result.addInstruction(109, target.getSlotId());
            } else {
                result.addInstruction(target.setlocal());
            }
        } else {
            boolean inlined = this.generateInlineSetterAccess(target, result, false);
            if (!inlined) {
                IDefinition def = target.getDefinition();
                if (def instanceof GetterDefinition) {
                    boolean isSuper = target.isSuperQualified();
                    SetterDefinition setter = (SetterDefinition)((GetterDefinition)def).resolveCorrespondingAccessor(this.currentScope.getProject());
                    target = this.currentScope.getBinding(setter);
                    if (isSuper) {
                        target.setSuperQualified(true);
                    }
                }
                result.addAll(this.currentScope.findProperty(target, false));
                result.addInstruction(43);
                result.addInstruction(this.getAssignmentOpcode(iNode, target), target.getName());
            }
        }
        return result;
    }

    InstructionList generateCatchBlock(Label try_start, Label try_end, CatchPrototype catch_proto) {
        InstructionList scope_reinit = this.currentScope.getFlowManager().getScopeStackReinit();
        InstructionList current_catch = new InstructionList(catch_proto.catchBody.size() + scope_reinit.size() + 15);
        if (this.currentScope.needsThis()) {
            current_catch.addInstruction(208);
            current_catch.addInstruction(48);
        }
        if (this.currentScope.needsActivation()) {
            current_catch.addInstruction(this.currentScope.getActivationStorage().getlocal());
            current_catch.addInstruction(48);
        }
        current_catch.addAll(scope_reinit);
        int handler_number = this.currentScope.getMethodBodyVisitor().visitException(try_start, try_end, current_catch.getLabel(), catch_proto.catchType, catch_proto.catchVarName);
        Binding exception_storage = this.currentScope.getFlowManager().getFinallyContext().getExceptionStorage();
        current_catch.addInstruction(90, handler_number);
        current_catch.addInstruction(42);
        if (exception_storage != null) {
            current_catch.addInstruction(exception_storage.setlocal());
            current_catch.addInstruction(42);
        }
        current_catch.addInstruction(48);
        current_catch.addInstruction(43);
        current_catch.addInstruction(109, 1);
        current_catch.addAll(catch_proto.catchBody);
        if (current_catch.canFallThrough() || current_catch.hasPendingLabels()) {
            current_catch.addInstruction(29);
        }
        return current_catch;
    }

    InstructionList generateCompoundAssignment(IASNode iNode, Binding lvalue, InstructionList expr, int opcode, boolean need_value) {
        InstructionList result = this.createInstructionList(iNode, expr.size() + (lvalue.isLocal() ? 4 : 8));
        this.currentScope.getMethodBodySemanticChecker().checkCompoundAssignment(iNode, lvalue, opcode);
        if (lvalue.isLocal()) {
            ITypeDefinition type;
            result.addInstruction(lvalue.getlocal());
            result.addAll(expr);
            result.addInstruction(opcode);
            if (need_value) {
                result.addInstruction(42);
            }
            if (lvalue.getDefinition() != null && (type = lvalue.getDefinition().resolveType(this.currentScope.getProject())) != ClassDefinition.getAnyTypeClassDefinition()) {
                this.coerce(result, type);
            }
            result.addInstruction(lvalue.setlocal());
        } else {
            result.addAll(this.currentScope.findProperty(lvalue, true));
            result.addInstruction(42);
            result.addInstruction(102, lvalue.getName());
            result.addAll(expr);
            result.addInstruction(opcode);
            Binding value_temp = null;
            if (need_value) {
                value_temp = this.currentScope.allocateTemp();
                result.addInstruction(42);
                result.addInstruction(value_temp.setlocal());
            }
            result.addInstruction(this.getAssignmentOpcode(iNode, lvalue), lvalue.getName());
            if (need_value) {
                result.addInstruction(value_temp.getlocal());
                this.currentScope.releaseTemp(value_temp);
            }
        }
        return result;
    }

    InstructionList generateCompoundBracketAssignment(IASNode iNode, InstructionList stem, InstructionList index, InstructionList expr, int opcode, boolean need_value) {
        IDynamicAccessNode arrayIndexNode = (IDynamicAccessNode)((IBinaryOperatorNode)iNode).getLeftOperandNode();
        InstructionList result = this.createInstructionList(iNode, stem.size() * 2 + index.size() + expr.size() + 11);
        Binding index_temp = this.currentScope.allocateTemp();
        result.addAll(index);
        result.addInstruction(index_temp.setlocal());
        result.addAll(this.replicate(stem));
        result.addInstruction(index_temp.getlocal());
        result.addInstruction(this.arrayAccess(arrayIndexNode, 102));
        result.addAll(expr);
        result.addInstruction(opcode);
        Binding value_temp = this.currentScope.allocateTemp();
        result.addInstruction(value_temp.setlocal());
        result.addAll(stem);
        result.addInstruction(index_temp.getlocal());
        result.addInstruction(value_temp.getlocal());
        result.addInstruction(this.arrayAccess(arrayIndexNode, 97));
        if (need_value) {
            result.addInstruction(value_temp.getlocal());
        }
        this.currentScope.releaseTemp(value_temp);
        this.currentScope.releaseTemp(index_temp);
        return result;
    }

    InstructionList generateCompoundAssignmentToRuntimeName(IASNode iNode, RuntimeMultiname name, InstructionList expr, int opcode, boolean need_value) {
        InstructionList result = this.createInstructionList(iNode);
        result.addAll(name.generateRvalue(iNode));
        result.addAll(expr);
        result.addInstruction(opcode);
        if (need_value) {
            Binding temp = this.currentScope.allocateTemp();
            result.addInstruction(temp.setlocal());
            InstructionList temp_rhs = new InstructionList();
            temp_rhs.addInstruction(temp.getlocal());
            result.addAll(name.generateAssignment(iNode, temp_rhs));
            result.addInstruction(temp.getlocal());
            this.currentScope.releaseTemp(temp);
        } else {
            result = name.generateAssignment(iNode, result);
        }
        return result;
    }

    InstructionList generateCompoundMemberAssignment(IASNode iNode, InstructionList stem, Binding member, InstructionList expr, int fetch_opcode, int assign_opcode, boolean need_value) {
        InstructionList result = this.createInstructionList(iNode, stem.size() * 2 + expr.size() + 5);
        this.currentScope.getMethodBodySemanticChecker().checkCompoundAssignment(iNode, member, assign_opcode);
        result.addAll(this.replicate(stem));
        result.addInstruction(fetch_opcode, member.getName());
        result.addAll(expr);
        result.addInstruction(assign_opcode);
        if (need_value) {
            result.addInstruction(42);
        }
        result.addAll(stem);
        result.addInstruction(43);
        result.addInstruction(this.getAssignmentOpcode(iNode, member), member.getName());
        return result;
    }

    InstructionList generateCompoundLogicalAssignment(IASNode iNode, Binding lvalue, InstructionList expr, boolean is_and, boolean need_value) {
        InstructionList result = this.createInstructionList(iNode);
        int failure_test = is_and ? 18 : 17;
        this.currentScope.getMethodBodySemanticChecker().checkCompoundAssignment(iNode, lvalue, failure_test);
        Label tail = new Label();
        if (lvalue.isLocal()) {
            result.addInstruction(lvalue.getlocal());
            if (need_value) {
                result.addInstruction(42);
            }
            result.addInstruction(failure_test, tail);
            if (need_value) {
                result.addInstruction(41);
            }
            result.addAll(expr);
            if (need_value) {
                result.addInstruction(42);
            }
            result.addInstruction(lvalue.setlocal());
        } else {
            result.addAll(this.currentScope.getPropertyValue(lvalue));
            if (need_value) {
                result.addInstruction(42);
            }
            result.addInstruction(failure_test, tail);
            if (need_value) {
                result.addInstruction(41);
            }
            result.addAll(expr);
            if (need_value) {
                result.addInstruction(42);
            }
            result.addAll(this.currentScope.findProperty(lvalue, true));
            result.addInstruction(43);
            result.addInstruction(this.getAssignmentOpcode(iNode, lvalue), lvalue.getName());
        }
        result.labelNext(tail);
        return result;
    }

    InstructionList generateCompoundLogicalRuntimeNameAssignment(IASNode iNode, RuntimeMultiname name, InstructionList expr, boolean is_and, boolean need_value) {
        InstructionList result = this.createInstructionList(iNode);
        Label tail = new Label();
        int failure_test = is_and ? 18 : 17;
        Binding rhs_temp = null;
        InstructionList rhs_fetch = null;
        result.addAll(name.generateRvalue(iNode));
        if (need_value) {
            result.addInstruction(42);
        }
        result.addInstruction(failure_test, tail);
        if (need_value) {
            result.addInstruction(41);
        }
        result.addAll(expr);
        if (need_value) {
            rhs_temp = this.currentScope.allocateTemp();
            rhs_fetch = this.createInstructionList(iNode);
            result.addInstruction(42);
            result.addInstruction(rhs_temp.setlocal());
            rhs_fetch.addInstruction(rhs_temp.getlocal());
            result.addAll(name.generateAssignment(iNode, rhs_fetch));
            this.currentScope.releaseTemp(rhs_temp);
        } else {
            result = name.generateAssignment(iNode, result);
        }
        result.labelNext(tail);
        return result;
    }

    InstructionList generateCompoundLogicalBracketAssignment(IASNode iNode, InstructionList stem, InstructionList index, InstructionList expr, boolean is_and, boolean need_value) {
        IDynamicAccessNode arrayIndexNode = (IDynamicAccessNode)((IBinaryOperatorNode)iNode).getLeftOperandNode();
        InstructionList result = this.createInstructionList(iNode, stem.size() * 2 + index.size() + expr.size() + 11);
        Label tail = new Label();
        int failure_test = is_and ? 18 : 17;
        Binding index_temp = this.currentScope.allocateTemp();
        result.addAll(index);
        result.addInstruction(index_temp.setlocal());
        result.addAll(this.replicate(stem));
        result.addInstruction(index_temp.getlocal());
        result.addAll(stem);
        result.addInstruction(index_temp.getlocal());
        result.addInstruction(this.arrayAccess(arrayIndexNode, 102));
        result.addInstruction(42);
        result.addInstruction(failure_test, tail);
        result.addInstruction(41);
        result.addAll(expr);
        result.labelNext(tail);
        Binding value_temp = null;
        if (need_value) {
            value_temp = this.currentScope.allocateTemp();
            result.addInstruction(42);
            result.addInstruction(value_temp.setlocal());
        }
        result.addInstruction(this.arrayAccess(arrayIndexNode, 97));
        if (need_value) {
            result.addInstruction(value_temp.getlocal());
            this.currentScope.releaseTemp(value_temp);
        }
        this.currentScope.releaseTemp(index_temp);
        return result;
    }

    InstructionList generateCompoundLogicalMemberAssignment(IASNode iNode, InstructionList stem, Binding member, InstructionList expr, int fetch_opcode, boolean is_and, boolean need_value) {
        InstructionList result = this.createInstructionList(iNode);
        int failure_test = is_and ? 18 : 17;
        this.currentScope.getMethodBodySemanticChecker().checkCompoundAssignment(iNode, member, failure_test);
        Label tail = new Label();
        result.addAll(this.replicate(stem));
        result.addAll(stem);
        result.addInstruction(102, member.getName());
        result.addInstruction(42);
        result.addInstruction(failure_test, tail);
        result.addInstruction(41);
        result.addAll(expr);
        result.labelNext(tail);
        Binding value_temp = null;
        if (need_value) {
            value_temp = this.currentScope.allocateTemp();
            result.addInstruction(42);
            result.addInstruction(value_temp.setlocal());
        }
        result.addInstruction(this.getAssignmentOpcode(iNode, member), member.getName());
        if (need_value) {
            result.addInstruction(value_temp.getlocal());
            this.currentScope.releaseTemp(value_temp);
        }
        return result;
    }

    InstructionList generateFunctionBody(IASNode iNode, InstructionList function_body, Binding return_type) {
        return this.generateFunctionBody(iNode, function_body, return_type != null ? return_type.getName() : null);
    }

    InstructionList generateFunctionBody(IASNode iNode, InstructionList function_body, Name return_type) {
        this.currentScope.getMethodBodySemanticChecker().checkFunctionBody(iNode);
        this.currentScope.getMethodInfo().setReturnType(return_type);
        InstructionList result = this.currentScope.finishMethodDeclaration(!function_body.isEmpty() || this.haveInstanceInitializers(), SemanticUtils.getFileName(iNode));
        if (this.haveInstanceInitializers() && this.currentScope.getNestingState() == LexicalScope.NestingState.NotNested) {
            result.addAll(this.instanceInitializers);
            if (!function_body.hasSuchInstruction(73)) {
                this.currentScope.getMethodBodySemanticChecker().checkDefaultSuperCall(iNode);
                result.addInstruction(208);
                result.addInstruction(73, 0);
            }
        }
        result.addAll(function_body);
        if (result.canFallThrough() || result.hasPendingLabels()) {
            result.addInstruction(synthesizedReturnVoid);
        }
        return result;
    }

    private void generateNestedFunction(IASNode iNode, InstructionList controlFlowSensitiveDestination, Binding func_name, Name return_type, InstructionList function_body) {
        InstructionList init_insns;
        this.currentScope.setFunctionName(func_name.getName().getBaseName());
        this.currentScope.generateNestedFunction(this.generateFunctionBody(iNode, function_body, return_type));
        MethodInfo nested_method_info = this.currentScope.getMethodInfo();
        this.currentScope = this.currentScope.popFrame();
        this.currentScope.makeVariable(func_name);
        InstructionList instructionList = init_insns = SemanticUtils.canNestedFunctionBeHoisted(iNode) ? this.currentScope.getHoistedInitInstructions() : controlFlowSensitiveDestination;
        assert (!func_name.isLocal());
        init_insns.addInstruction(94, func_name.getName());
        init_insns.addInstruction(64, nested_method_info);
        init_insns.addInstruction(97, func_name.getName());
    }

    InstructionList generateTryCatchFinally(InstructionList try_stmt, Vector<CatchPrototype> catch_blocks, InstructionList finally_stmt) {
        InstructionList normal_flow_fixup = new InstructionList();
        InstructionList catch_insns = new InstructionList();
        InstructionList final_catch = new InstructionList();
        InstructionList finally_insns = new InstructionList();
        InstructionList final_throw = new InstructionList();
        ExceptionHandlingContext finally_context = this.currentScope.getFlowManager().getFinallyContext();
        Label final_catch_target = final_catch.getLabel();
        Binding exception_storage = finally_context.getExceptionStorage();
        Collection<Label> pending_normal_control_flow = try_stmt.stripPendingLabels();
        if (try_stmt.canFallThrough() || pending_normal_control_flow != null) {
            normal_flow_fixup.addInstruction(16, finally_context.finallyBlock);
        } else {
            normal_flow_fixup.addInstruction(2);
        }
        Label try_start = try_stmt.getLabel();
        Label try_end = normal_flow_fixup.getLastLabel();
        Label finally_region_end = null;
        if (null == catch_blocks) {
            finally_region_end = try_end;
        } else {
            for (CatchPrototype catch_proto : catch_blocks) {
                InstructionList catch_body = this.generateCatchBlock(try_start, try_end, catch_proto);
                boolean is_last_catch = catch_proto.equals(catch_blocks.lastElement());
                if (catch_body.canFallThrough()) {
                    catch_body.addInstruction(36, 0);
                    catch_body.addInstruction(finally_context.finallyReturnStorage.setlocal());
                    catch_body.addInstruction(16, finally_context.finallyBlock);
                } else if (is_last_catch) {
                    catch_body.addInstruction(2);
                }
                if (is_last_catch) {
                    finally_region_end = catch_body.getLastLabel();
                }
                catch_insns.addAll(catch_body);
            }
        }
        this.currentScope.getMethodBodyVisitor().visitException(try_start, finally_region_end, final_catch_target, null, null);
        if (this.currentScope.needsThis()) {
            final_catch.addInstruction(208);
            final_catch.addInstruction(48);
        }
        if (this.currentScope.needsActivation()) {
            final_catch.addInstruction(this.currentScope.getActivationStorage().getlocal());
            final_catch.addInstruction(48);
        }
        final_catch.addAll(this.currentScope.getFlowManager().getScopeStackReinit());
        final_catch.addInstruction(exception_storage.setlocal());
        final_catch.addInstruction(36, this.currentScope.getFlowManager().getFinallyAlternativesSize() + 1);
        final_catch.addInstruction(finally_context.finallyReturnStorage.setlocal());
        finally_insns.addInstruction(finally_context.finallyReturnStorage.getlocal());
        finally_insns.addInstruction(115);
        finally_insns.addAll(this.currentScope.getFlowManager().getFinallySwitch());
        if (!finally_stmt.isEmpty()) {
            finally_stmt.labelFirst(finally_context.finallyBlock);
        } else {
            finally_insns.labelFirst(finally_context.finallyBlock);
        }
        final_throw.addInstruction(exception_storage.getlocal());
        final_throw.labelCurrent(finally_context.finallyDoRethrow);
        final_throw.addInstruction(3);
        InstructionList result = new InstructionList();
        result.addInstruction(36, 0);
        result.addInstruction(finally_context.finallyReturnStorage.setlocal());
        result.addAll(try_stmt);
        result.addAllPendingLabels(pending_normal_control_flow);
        result.addAll(normal_flow_fixup);
        result.addAll(catch_insns);
        result.addAll(final_catch);
        result.addAll(finally_stmt);
        result.addAll(finally_insns);
        result.addAll(final_throw);
        for (ExceptionHandlingContext.FinallyReturn retblock : finally_context.finallyReturns) {
            result.addAll(retblock.getInstructions());
        }
        result.addInstruction(2);
        result.labelNext(finally_context.finallyDoFallthrough);
        return result;
    }

    public InstructionList reduce_typeNameParameter(IASNode iNode, Binding param_name) {
        InstructionList result = this.createInstructionList(iNode);
        this.generateTypeNameParameter(param_name, result);
        return result;
    }

    private void generateTypeNameParameter(Binding param, InstructionList result) {
        if (param == null || param.getName() == null || param.getName().couldBeAnyType()) {
            result.addInstruction(32);
        } else {
            this.generateAccess(param, false, AccessType.Strict, result);
        }
    }

    private ControlFlowContextManager.ControlFlowContextSearchCriteria getBreakCriteria() {
        return ControlFlowContextManager.breakWithOutLabelCriteria;
    }

    private ControlFlowContextManager.ControlFlowContextSearchCriteria getContinueCriteria() {
        return ControlFlowContextManager.continueWithOutLabelCriteria;
    }

    private ControlFlowContextManager.ControlFlowContextSearchCriteria getBreakCriteria(String label) {
        return this.currentScope.getFlowManager().breakWithLabelCriteria(label);
    }

    private ControlFlowContextManager.ControlFlowContextSearchCriteria getContinueCriteria(String label) {
        return this.currentScope.getFlowManager().continueWithLabelCriteria(label);
    }

    private ControlFlowContextManager.ControlFlowContextSearchCriteria getGotoCriteria(String label) {
        return this.currentScope.getFlowManager().gotoLabelCriteria(label, false);
    }

    private InstructionList getBranchTarget(ControlFlowContextManager.ControlFlowContextSearchCriteria criteria) throws UnknownControlFlowTargetException {
        return this.currentScope.getFlowManager().getBranchTarget(criteria);
    }

    Double getDoubleContent(IASNode iNode) {
        return SemanticUtils.getDoubleContent(iNode);
    }

    String getIdentifierContent(IASNode iNode) {
        return SemanticUtils.getIdentifierContent(iNode);
    }

    Integer getIntegerContent(IASNode iNode) {
        return SemanticUtils.getIntegerContent(iNode);
    }

    Integer getIntegerZeroContent(IASNode iNode) {
        return 0;
    }

    Long getIntegerZeroContentAsLong(IASNode iNode) {
        return 0L;
    }

    IMXMLEventSpecifierNode getMXMLEventSpecifierContent(IASNode iNode) {
        return SemanticUtils.getMXMLEventSpecifierContent(iNode);
    }

    private InstructionList getNonLocalControlFlow(InstructionList original, ControlFlowContextManager.ControlFlowContextSearchCriteria criterion) throws UnknownControlFlowTargetException {
        return this.currentScope.getFlowManager().getNonLocalControlFlow(original, criterion);
    }

    private InstructionList getNonLocalControlFlow(ControlFlowContextManager.ControlFlowContextSearchCriteria criterion) throws UnknownControlFlowTargetException {
        return this.currentScope.getFlowManager().getNonLocalControlFlow(this.getBranchTarget(criterion), criterion);
    }

    IDefinition getParameterContent(IASNode iNode) {
        return SemanticUtils.getParameterContent(iNode);
    }

    String getStringLiteralContent(IASNode iNode) {
        return SemanticUtils.getStringLiteralContent(iNode);
    }

    Long getUintContent(IASNode iNode) {
        return SemanticUtils.getUintContent(iNode);
    }

    boolean getBooleanContent(IASNode iNode) {
        return SemanticUtils.getBooleanContent(iNode);
    }

    private boolean haveInstanceInitializers() {
        return this.instanceInitializers != null;
    }

    int isDottedName(IASNode n) {
        MemberAccessExpressionNode ma;
        int result = Integer.MAX_VALUE;
        if (n instanceof MemberAccessExpressionNode && (ma = (MemberAccessExpressionNode)n).stemIsPackage()) {
            result = 2;
        }
        return result;
    }

    int isPackageName(IASNode n) {
        MemberAccessExpressionNode ma;
        int result = Integer.MAX_VALUE;
        if (n instanceof MemberAccessExpressionNode && (ma = (MemberAccessExpressionNode)n).isPackageReference()) {
            result = 1;
        }
        return result;
    }

    int qualifierIsCompileTimeConstant(IASNode iNode) {
        IdentifierNode qualifier = (IdentifierNode)SemanticUtils.getNthChild(iNode, 0);
        IDefinition def = qualifier.resolve(this.currentScope.getProject());
        int result = def instanceof NamespaceDefinition ? 1 : Integer.MAX_VALUE;
        return result;
    }

    int isCompileTimeConstant(IASNode iNode) {
        if (SemanticUtils.transformNameToConstantValue(iNode, this.currentScope.getProject()) != null) {
            return 1;
        }
        return Integer.MAX_VALUE;
    }

    private boolean isNamespace(Binding b) {
        return b.getDefinition() instanceof NamespaceDefinition;
    }

    private boolean isAnyNamespace(Binding b) {
        return b.getDefinition().equals(NamespaceDefinition.getAnyNamespaceReference());
    }

    int isEmptyArrayConstructor(IASNode iNode) {
        ICompilerProject project = this.currentScope.getProject();
        IIdentifierNode identifierNode = (IIdentifierNode)SemanticUtils.getNthChild(iNode, 1);
        if (identifierNode.resolve(project) == project.getBuiltinType(IASLanguageConstants.BuiltinType.ARRAY)) {
            return 1;
        }
        return Integer.MAX_VALUE;
    }

    int isEmptyObjectConstructor(IASNode iNode) {
        ICompilerProject project = this.currentScope.getProject();
        IIdentifierNode identifierNode = (IIdentifierNode)SemanticUtils.getNthChild(iNode, 1);
        if (identifierNode.resolve(project) == project.getBuiltinType(IASLanguageConstants.BuiltinType.OBJECT)) {
            return 1;
        }
        return Integer.MAX_VALUE;
    }

    public void prologue_anonymousFunction(IASNode iNode) {
        this.currentScope = this.currentScope.pushFrame();
        this.currentScope.declareAnonymousFunction();
        this.currentScope.setInitialControlFlowRegionNode(((FunctionObjectNode)iNode).getFunctionNode().getScopedNode());
    }

    public void prologue_functionObject(IASNode iNode) {
        FunctionNode innerFunctionNode = ((FunctionObjectNode)iNode).getFunctionNode();
        this.currentScope = this.currentScope.pushFrame();
        this.currentScope.declareFunctionObject(innerFunctionNode.getName());
        this.currentScope.setInitialControlFlowRegionNode(innerFunctionNode.getScopedNode());
        this.prologue_function(iNode);
    }

    public void prologue_blockStmt(IASNode iNode) {
        this.miniScopes.push(new InstructionList());
    }

    public void prologue_blockStmt_to_finally_clause(IASNode iNode) {
        this.currentScope.getFlowManager().startFinallyContext(iNode);
    }

    public void prologue_catchBlock(IASNode iNode) {
        this.currentScope.getFlowManager().startCatchContext((ICatchNode)iNode);
    }

    private void loop_prologue_common(IASNode loopNode, IASNode loopContents) {
        this.currentScope.getFlowManager().startLoopControlFlowContext(loopContents);
    }

    public void prologue_countedForStmt(IASNode iNode) {
        this.loop_prologue_common(iNode, ((IForLoopNode)iNode).getStatementContentsNode());
    }

    public void prologue_doStmt(IASNode iNode) {
        this.loop_prologue_common(iNode, ((IWhileLoopNode)iNode).getStatementContentsNode());
    }

    public void prologue_forEachStmt(IASNode iNode) {
        this.loop_prologue_common(iNode, ((IForLoopNode)iNode).getStatementContentsNode());
    }

    public void prologue_forInStmt(IASNode iNode) {
        this.loop_prologue_common(iNode, ((IForLoopNode)iNode).getStatementContentsNode());
    }

    void prologue_function(IASNode n) {
        FunctionDefinition func = null;
        IFunctionNode funcNode = null;
        if (n instanceof IFunctionNode) {
            funcNode = (IFunctionNode)n;
        } else if (n instanceof FunctionObjectNode) {
            funcNode = ((FunctionObjectNode)n).getFunctionNode();
        }
        if (funcNode instanceof FunctionNode) {
            Collection<ICompilerProblem> parseProblems = ((FunctionNode)funcNode).getParsingProblems();
            for (ICompilerProblem problem : parseProblems) {
                this.currentScope.addProblem(problem);
            }
        }
        assert (funcNode != null) : n + " has no FunctionNode child";
        func = (FunctionDefinition)funcNode.getDefinition();
        assert (func != null) : n + " has no definition.";
        this.currentScope.setLocalASScope(func.getContainedScope());
        this.currentScope.resetDebugInfo();
        this.currentScope.setDebugFile(SemanticUtils.getFileName(n));
        this.currentScope.getMethodBodySemanticChecker().checkFunctionDefinition(funcNode, func);
        for (int i = 0; i < funcNode.getChildCount(); ++i) {
            this.scanFunctionBodyForActivations(funcNode.getChild(i));
        }
    }

    public void prologue_labeledStmt(IASNode iNode) {
        try {
            this.currentScope.getFlowManager().startLabeledStatementControlFlowContext((LabeledStatementNode)iNode);
        }
        catch (DuplicateLabelException dup_label) {
            this.currentScope.addProblem(new DuplicateLabelProblem(iNode));
        }
    }

    public void prologue_mxmlEventSpecifier(IASNode iNode) {
        this.currentScope.makeParameter(this.getMXMLEventSpecifierContent(iNode).getEventParameterDefinition(), this.currentScope.getMethodInfo().getParamTypes().get(0));
    }

    public void prologue_switchStmt(IASNode iNode) {
        this.currentScope.getFlowManager().startSwitchContext((SwitchNode)iNode);
    }

    public void prologue_tryCatchFinallyStmt(IASNode iNode) {
        this.currentScope.getFlowManager().startExceptionContext((ITryNode)iNode);
        this.currentScope.getFlowManager().getFinallyContext().setHasFinallyBlock(true);
    }

    public void prologue_tryCatchStmt(IASNode iNode) {
        this.currentScope.getFlowManager().startExceptionContext((ITryNode)iNode);
    }

    public void prologue_tryFinallyStmt(IASNode iNode) {
        this.currentScope.getFlowManager().startExceptionContext((ITryNode)iNode);
        this.currentScope.getFlowManager().getFinallyContext().setHasFinallyBlock(true);
    }

    public void prologue_typedFunction_to_statement(IASNode iNode) {
        this.currentScope = this.currentScope.pushFrame();
        this.currentScope.declareNestedFunction();
        this.currentScope.setInitialControlFlowRegionNode(((IFunctionNode)iNode).getScopedNode());
        this.prologue_function(iNode);
    }

    public void prologue_typelessFunction_to_statement(IASNode iNode) {
        this.currentScope = this.currentScope.pushFrame();
        this.currentScope.declareNestedFunction();
        this.currentScope.setInitialControlFlowRegionNode(((IFunctionNode)iNode).getScopedNode());
        this.prologue_function(iNode);
    }

    public void prologue_typeof(IASNode iNode) {
        ++this.typeofCount;
    }

    public void prologue_whileStmt(IASNode iNode) {
        this.currentScope.getFlowManager().startLoopControlFlowContext(((IWhileLoopNode)iNode).getStatementContentsNode());
    }

    public void prologue_withStmt(IASNode iNode) {
        this.currentScope.getFlowManager().startWithContext(((IWithNode)iNode).getStatementContentsNode());
    }

    public InstructionList reduce_anonymousFunction(IASNode iNode, InstructionList function_body) {
        InstructionList result = this.createInstructionList(iNode, 1);
        this.currentScope.generateNestedFunction(function_body);
        result.addInstruction(64, this.currentScope.getMethodInfo());
        this.currentScope = this.currentScope.popFrame();
        return result;
    }

    public InstructionList reduce_functionObject(IASNode iNode, IASNode function_name, InstructionList plist, Binding return_binding, InstructionList function_body) {
        InstructionList result = this.createInstructionList(iNode);
        Binding nestedFunctionName = this.currentScope.resolveName((IdentifierNode)function_name);
        Name return_type = return_binding != null ? return_binding.getName() : null;
        this.currentScope.generateNestedFunction(this.generateFunctionBody(iNode, function_body, return_type));
        MethodInfo nested_method_info = this.currentScope.getMethodInfo();
        this.currentScope = this.currentScope.popFrame();
        this.currentScope = this.currentScope.pushFrame();
        this.currentScope.declareAnonymousFunction();
        this.currentScope.setInitialControlFlowRegionNode(((FunctionObjectNode)iNode).getFunctionNode().getScopedNode());
        this.currentScope.setNeedsActivation();
        this.currentScope.makeVariable(nestedFunctionName, SemanticUtils.getAETName(this.currentScope.getProject().getBuiltinType(IASLanguageConstants.BuiltinType.FUNCTION), this.currentScope.getProject()), null, null, LexicalScope.VariableMutability.Constant);
        InstructionList wrapper_insns = this.createInstructionList(iNode);
        wrapper_insns.addInstruction(64, nested_method_info);
        wrapper_insns.addInstruction(42);
        wrapper_insns.addInstruction(94, nestedFunctionName.getName());
        wrapper_insns.addInstruction(43);
        wrapper_insns.addInstruction(109, 1);
        wrapper_insns.addInstruction(72);
        this.currentScope.generateNestedFunction(this.generateFunctionBody(iNode, wrapper_insns, LexicalScope.anyType));
        MethodInfo wrapper_method_info = this.currentScope.getMethodInfo();
        this.currentScope = this.currentScope.popFrame();
        result.addInstruction(64, wrapper_method_info);
        result.addInstruction(208);
        result.addInstruction(65, 0);
        return result;
    }

    public InstructionList reduce_arrayIndexExpr(IASNode iNode, InstructionList stem, boolean is_super, InstructionList index) {
        InstructionList result;
        IDynamicAccessNode arrayIndexNode = (IDynamicAccessNode)iNode;
        if (is_super) {
            this.currentScope.getMethodBodySemanticChecker().checkSuperAccess(arrayIndexNode);
        }
        if (!is_super) {
            result = this.createInstructionList(arrayIndexNode, stem.size() + index.size() + 1);
            result.addAll(stem);
        } else {
            result = this.createInstructionList(arrayIndexNode, index.size() + 2);
            result.addInstruction(208);
        }
        result.addAll(index);
        result.addInstruction(this.arrayAccess(arrayIndexNode, is_super ? 4 : 102));
        return result;
    }

    public InstructionList reduce_arrayLiteral(IASNode iNode, Vector<InstructionList> elements) {
        InstructionList result = this.createInstructionList(iNode);
        for (InstructionList element : elements) {
            result.addAll(element);
        }
        result.addInstruction(86, elements.size());
        return result;
    }

    public InstructionList reduce_assignToBracketExpr_to_expression(IASNode iNode, InstructionList stem, InstructionList index, InstructionList r, boolean is_super) {
        IDynamicAccessNode arrayIndexNode = (IDynamicAccessNode)((IBinaryOperatorNode)iNode).getLeftOperandNode();
        this.currentScope.getMethodBodySemanticChecker().checkAssignToBracketExpr(iNode);
        Binding local = this.currentScope.allocateTemp();
        InstructionList result = this.createInstructionList(iNode, (is_super ? 1 : stem.size()) + index.size() + r.size() + 5);
        if (is_super) {
            result.addInstruction(208);
        } else {
            result.addAll(stem);
        }
        result.addAll(index);
        result.addAll(r);
        result.addInstruction(42);
        result.addInstruction(local.setlocal());
        result.addInstruction(this.arrayAccess(arrayIndexNode, is_super ? 5 : 97));
        result.addInstruction(local.getlocal());
        this.currentScope.releaseTemp(local);
        return result;
    }

    public InstructionList reduce_assignToBracketExpr_to_void_expression(IASNode iNode, InstructionList stem, InstructionList index, InstructionList r, boolean is_super) {
        IDynamicAccessNode arrayIndexNode = (IDynamicAccessNode)((IBinaryOperatorNode)iNode).getLeftOperandNode();
        this.currentScope.getMethodBodySemanticChecker().checkAssignToBracketExpr(iNode);
        int num_ins = 1;
        InstructionList result = this.createInstructionList(iNode, (is_super ? num_ins : stem.size()) + index.size() + r.size() + num_ins);
        if (is_super) {
            result.addInstruction(208);
        } else {
            result.addAll(stem);
        }
        result.addAll(index);
        result.addAll(r);
        result.addInstruction(this.arrayAccess(arrayIndexNode, is_super ? 5 : 97));
        return result;
    }

    public InstructionList reduce_assignToMemberExpr_to_expression(IASNode iNode, InstructionList stem, Binding member, InstructionList r) {
        this.currentScope.getMethodBodySemanticChecker().checkAssignment(iNode, member);
        Binding local = this.currentScope.allocateTemp();
        InstructionList result = this.createInstructionList(iNode, stem.size() + r.size() + 5);
        result.addAll(stem);
        result.addAll(r);
        result.addInstruction(42);
        result.addInstruction(local.setlocal());
        this.generateAssignmentOp(iNode, member, result);
        result.addInstruction(local.getlocal());
        this.currentScope.releaseTemp(local);
        return result;
    }

    public InstructionList reduce_assignToMemberExpr_to_void_expression(IASNode iNode, InstructionList stem, Binding member, InstructionList r) {
        this.currentScope.getMethodBodySemanticChecker().checkAssignment(iNode, member);
        InstructionList result = this.createInstructionList(iNode, stem.size() + r.size() + 1);
        result.addAll(stem);
        result.addAll(r);
        this.generateAssignmentOp(iNode, member, result);
        return result;
    }

    public InstructionList reduce_assignToDescendantsExpr(IASNode iNode, InstructionList stem, Binding member, InstructionList r, boolean need_value) {
        this.currentScope.getMethodBodySemanticChecker().checkAssignment(iNode, member);
        Binding local = null;
        InstructionList result = this.createInstructionList(iNode, stem.size() + r.size() + 5);
        result.addAll(stem);
        result.addAll(r);
        if (need_value) {
            local = this.currentScope.allocateTemp();
            result.addInstruction(42);
            result.addInstruction(local.setlocal());
        }
        this.generateAssignmentOp(iNode, member, result);
        if (need_value) {
            result.addInstruction(local.getlocal());
            this.currentScope.releaseTemp(local);
        }
        return result;
    }

    public InstructionList reduce_assignToNameExpr_to_void_expression(IASNode iNode, Binding lvalue, InstructionList r) {
        this.currentScope.getMethodBodySemanticChecker().checkAssignment(iNode, lvalue);
        return this.generateAssignment(iNode, lvalue, r);
    }

    public InstructionList reduce_assignToNameExpr_to_expression(IASNode iNode, Binding lvalue, InstructionList r) {
        this.currentScope.getMethodBodySemanticChecker().checkAssignment(iNode, lvalue);
        return this.generateAssignment(iNode, lvalue, r, true);
    }

    public InstructionList reduce_assignToQualifiedMemberExpr(IASNode iNode, InstructionList stem, Binding qualifier, Binding member, InstructionList rhs, boolean need_value) {
        InstructionList result = this.createInstructionList(iNode);
        result.addAll(stem);
        if (!this.isNamespace(qualifier)) {
            this.generateAccess(qualifier, result);
            result.addInstruction(128, namespaceType);
        }
        result.addAll(rhs);
        Binding value_temp = null;
        if (need_value) {
            value_temp = this.currentScope.allocateTemp();
            result.addInstruction(42);
            result.addInstruction(value_temp.setlocal());
        }
        this.generateAssignmentOp(iNode, member, result);
        if (need_value) {
            result.addInstruction(value_temp.getlocal());
            this.currentScope.releaseTemp(value_temp);
        }
        return result;
    }

    public InstructionList reduce_assignToQualifiedRuntimeMemberExpr(IASNode iNode, InstructionList stem, Binding qualifier, InstructionList runtime_member_selector, InstructionList rhs, boolean need_value) {
        InstructionList result = this.createInstructionList(iNode);
        result.addAll(stem);
        if (this.isNamespace(qualifier)) {
            result.addAll(runtime_member_selector);
            NamespaceDefinition ns_def = (NamespaceDefinition)qualifier.getDefinition();
            Name qualified_name = new Name(27, new Nsset(ns_def.resolveAETNamespace(this.currentScope.getProject())), null);
            result.addAll(rhs);
            result.addInstruction(97, qualified_name);
        } else {
            this.generateAccess(qualifier, result);
            result.addInstruction(128, namespaceType);
            result.addAll(runtime_member_selector);
            result.addAll(rhs);
            Binding value_temp = null;
            if (need_value) {
                value_temp = this.currentScope.allocateTemp();
                result.addInstruction(42);
                result.addInstruction(value_temp.setlocal());
            }
            result.addInstruction(97, new Name(17, null, null));
            if (need_value) {
                result.addInstruction(value_temp.getlocal());
                this.currentScope.releaseTemp(value_temp);
            }
        }
        return result;
    }

    public InstructionList reduce_assignToQualifiedAttributeExpr(IASNode iNode, InstructionList stem, Binding qualifier, Binding member, InstructionList rhs, boolean need_value) {
        InstructionList result = this.createInstructionList(iNode);
        result.addAll(stem);
        if (!this.isNamespace(qualifier)) {
            this.generateAccess(qualifier, result);
            result.addInstruction(128, namespaceType);
        }
        result.addAll(rhs);
        Binding value_temp = null;
        if (need_value) {
            value_temp = this.currentScope.allocateTemp();
            result.addInstruction(42);
            result.addInstruction(value_temp.setlocal());
        }
        this.generateAssignmentOp(iNode, member, result);
        if (need_value) {
            result.addInstruction(value_temp.getlocal());
            this.currentScope.releaseTemp(value_temp);
        }
        return result;
    }

    public InstructionList reduce_assignToQualifiedRuntimeAttributeExpr(IASNode iNode, InstructionList stem, Binding qualifier, InstructionList runtime_member_selector, InstructionList rhs, boolean need_value) {
        InstructionList result = this.createInstructionList(iNode);
        result.addAll(stem);
        if (this.isAnyNamespace(qualifier)) {
            IASNode site = qualifier.getNode() != null ? qualifier.getNode() : iNode;
            this.currentScope.addProblem(new AnyNamespaceCannotBeQualifierProblem(site));
        } else if (!this.isNamespace(qualifier)) {
            this.generateAccess(qualifier, result);
            result.addInstruction(128, namespaceType);
            result.addAll(runtime_member_selector);
            result.addInstruction(133);
            result.addAll(rhs);
            Binding value_temp = null;
            if (need_value) {
                value_temp = this.currentScope.allocateTemp();
                result.addInstruction(42);
                result.addInstruction(value_temp.setlocal());
            }
            result.addInstruction(97, new Name(18, null, null));
            if (need_value) {
                result.addInstruction(value_temp.getlocal());
                this.currentScope.releaseTemp(value_temp);
            }
        } else {
            result.addAll(runtime_member_selector);
            NamespaceDefinition ns_def = (NamespaceDefinition)qualifier.getDefinition();
            Name qualified_name = new Name(28, new Nsset(ns_def.resolveAETNamespace(this.currentScope.getProject())), null);
            result.addAll(rhs);
            Binding value_temp = null;
            if (need_value) {
                value_temp = this.currentScope.allocateTemp();
                result.addInstruction(42);
                result.addInstruction(value_temp.setlocal());
            }
            result.addInstruction(97, qualified_name);
            if (need_value) {
                result.addInstruction(value_temp.getlocal());
                this.currentScope.releaseTemp(value_temp);
            }
        }
        return result;
    }

    public InstructionList reduce_assignToRuntimeNameExpr(IASNode iNode, RuntimeMultiname lval, InstructionList r, boolean need_value) {
        InstructionList result;
        if (need_value) {
            Binding temp = this.currentScope.allocateTemp();
            result = this.createInstructionList(iNode);
            result.addAll(r);
            result.addInstruction(temp.setlocal());
            InstructionList temp_rhs = new InstructionList();
            temp_rhs.addInstruction(temp.getlocal());
            result.addAll(lval.generateAssignment(iNode, temp_rhs));
            result.addInstruction(temp.getlocal());
            this.currentScope.releaseTemp(temp);
        } else {
            result = lval.generateAssignment(iNode, r);
        }
        return result;
    }

    public InstructionList reduce_assignToUnqualifiedRuntimeAttributeExpr(IASNode iNode, InstructionList stem, InstructionList rt_attr, InstructionList rhs, boolean need_value) {
        InstructionList result = this.createInstructionList(iNode);
        result.addAll(stem);
        result.addAll(rt_attr);
        result.addAll(rhs);
        Binding value_temp = null;
        if (need_value) {
            value_temp = this.currentScope.allocateTemp();
            result.addInstruction(42);
            result.addInstruction(value_temp.setlocal());
        }
        result.addInstruction(97, new Name(28, new Nsset(new Namespace(22)), null));
        if (need_value) {
            result.addInstruction(value_temp.getlocal());
            this.currentScope.releaseTemp(value_temp);
        }
        return result;
    }

    public Binding reduce_attributeName(IASNode iNode, Binding attr_name) {
        return attr_name;
    }

    public InstructionList reduce_blockStmt_to_finally_clause(IASNode iNode, Vector<InstructionList> stmts) {
        InstructionList result = this.createInstructionList(iNode);
        for (InstructionList stmt : stmts) {
            result.addAll(stmt);
        }
        this.currentScope.getFlowManager().endFinallyContext();
        return result;
    }

    public InstructionList reduce_blockStmt_to_statement(IASNode iNode, Vector<InstructionList> stmts) {
        InstructionList result = this.createInstructionList(iNode);
        result.addAll(this.miniScopes.pop());
        for (InstructionList stmt : stmts) {
            if (stmt == null) continue;
            result.addAll(stmt);
        }
        return result;
    }

    public Boolean reduce_booleanLiteral(IASNode iNode) {
        return SemanticUtils.getBooleanContent(iNode);
    }

    public InstructionList reduce_breakStmt(IASNode iNode) {
        try {
            ControlFlowContextManager.ControlFlowContextSearchCriteria criterion = this.getBreakCriteria();
            return this.getNonLocalControlFlow(criterion);
        }
        catch (UnknownControlFlowTargetException no_target) {
            this.currentScope.addProblem(new UnknownBreakTargetProblem(iNode));
            return this.createInstructionList(iNode);
        }
    }

    public String reduce_by_concatenation(IASNode iNode, String first, String second) {
        return first + "." + second;
    }

    public CatchPrototype reduce_catchBlockTyped(IASNode iNode, Binding var_name, Binding exception, InstructionList action) {
        CatchPrototype result = new CatchPrototype();
        result.catchVarName = var_name.getName();
        result.catchType = exception.getName();
        result.catchBody = action;
        this.currentScope.getFlowManager().endCatchContext();
        return result;
    }

    public CatchPrototype reduce_catchBlockUntyped(IASNode iNode, Binding var_name, InstructionList action) {
        CatchPrototype result = new CatchPrototype();
        result.catchVarName = var_name.getName();
        result.catchType = null;
        result.catchBody = action;
        this.currentScope.getFlowManager().endCatchContext();
        return result;
    }

    public InstructionList reduce_commaExpr(IASNode iNode, InstructionList payload_expr, Vector<InstructionList> exprs) {
        InstructionList result = this.createInstructionList(iNode);
        for (InstructionList other_expr : exprs) {
            result.addAll(other_expr);
        }
        result.addAll(payload_expr);
        return result;
    }

    public ConditionalFragment reduce_conditionalFragment(IASNode iNode, InstructionList condition, Vector<InstructionList> consequents) {
        return new ConditionalFragment(iNode, condition, consequents);
    }

    public ConditionalFragment reduce_constantConditionalFragment(IASNode iNode, Object constantCondition, Vector<InstructionList> consequents) {
        return new ConditionalFragment(iNode, constantCondition, consequents);
    }

    public String reduce_constantStringConcatenation(IASNode iNode, String l, String r) {
        return l + r;
    }

    public String reduce_constantStringConcatenation(IASNode iNode, String l, Object r) {
        return this.reduce_constantStringConcatenation(iNode, l, ECMASupport.toString(r));
    }

    public String reduce_constantStringConcatenation(IASNode iNode, Object l, String r) {
        return this.reduce_constantStringConcatenation(iNode, ECMASupport.toString(l), r);
    }

    public Object reduce_constantAddition(IASNode iNode, Object l, Object r) {
        this.checkBinaryOp(iNode, 160);
        if (l instanceof String) {
            return this.reduce_constantStringConcatenation(iNode, (String)l, r);
        }
        if (r instanceof String) {
            return this.reduce_constantStringConcatenation(iNode, l, (String)r);
        }
        return ECMASupport.toNumeric(l).doubleValue() + ECMASupport.toNumeric(r).doubleValue();
    }

    public InstructionList reduce_continueStmt(IASNode iNode) {
        try {
            ControlFlowContextManager.ControlFlowContextSearchCriteria criterion = this.getContinueCriteria();
            return this.getNonLocalControlFlow(criterion);
        }
        catch (UnknownControlFlowTargetException no_target) {
            this.currentScope.addProblem(new UnknownContinueTargetProblem(iNode));
            return this.createInstructionList(iNode);
        }
    }

    public InstructionList reduce_countedForStmt(IASNode iNode, InstructionList init, InstructionList test_insns, InstructionList incr, InstructionList body) {
        InstructionList test_insns_with_debug_ops = ABCGeneratingReducer.ensureInstructionListHasDebugInfo(test_insns, init);
        InstructionList result = this.createInstructionList(iNode, init.size() + test_insns_with_debug_ops.size() + incr.size() + body.size() + 5);
        result.addAll(init);
        result.addInstruction(16, test_insns_with_debug_ops.getLabel());
        InstructionList loop_body = new InstructionList();
        Label loop_head = new Label();
        loop_body.addInstruction(9);
        loop_body.labelCurrent(loop_head);
        loop_body.addAll(body);
        if (!incr.isEmpty()) {
            this.currentScope.getFlowManager().resolveContinueLabel(incr);
        } else {
            this.currentScope.getFlowManager().resolveContinueLabel(loop_body);
        }
        result.addAll(loop_body);
        result.addAll(incr);
        test_insns_with_debug_ops.lastElement().setTarget(loop_head);
        result.addAll(test_insns_with_debug_ops);
        this.currentScope.getFlowManager().finishLoopControlFlowContext(result);
        return result;
    }

    private static InstructionList ensureInstructionListHasDebugInfo(InstructionList dest, InstructionList src) {
        if (dest.hasSuchInstruction(240)) {
            return dest;
        }
        String debugFile = null;
        int debugLine = -1;
        ArrayList<Instruction> srcInstructions = src.getInstructions();
        for (int i = 0; i < srcInstructions.size(); ++i) {
            Instruction insn = srcInstructions.get(i);
            if (insn.getOpcode() == 241) {
                debugFile = (String)insn.getOperand(0);
                continue;
            }
            if (insn.getOpcode() != 240) continue;
            debugLine = insn.getImmediate();
            break;
        }
        DebugInfoInstructionList result = new DebugInfoInstructionList(dest.size() + 2);
        if (debugFile != null) {
            result.addInstruction(241, debugFile);
        }
        if (debugLine != -1) {
            result.addInstruction(240, debugLine);
        }
        result.addAll(dest);
        return result;
    }

    public InstructionList reduce_defaultXMLNamespace(IASNode iNode, InstructionList ns_expr) {
        InstructionList result = this.createInstructionList(iNode);
        result.addAll(ns_expr);
        result.addInstruction(7);
        this.currentScope.setSetsDxns();
        return result;
    }

    public InstructionList reduce_deleteBracketExpr(IASNode iNode, InstructionList stem, InstructionList index) {
        IDynamicAccessNode arrayIndexNode = (IDynamicAccessNode)((IUnaryOperatorNode)iNode).getOperandNode();
        InstructionList result = this.createInstructionList(iNode, stem.size() + index.size() + 1);
        result.addAll(stem);
        result.addAll(index);
        result.addInstruction(this.arrayAccess(arrayIndexNode, 106));
        return result;
    }

    public InstructionList reduce_deleteAtBracketExpr(IASNode iNode, InstructionList stem, InstructionList index) {
        InstructionList result = this.createInstructionList(iNode, stem.size() + index.size() + 1);
        result.addAll(stem);
        result.addAll(index);
        Namespace ns = NamespaceDefinition.getDefaultNamespaceDefinition(this.currentScope.getLocalASScope()).resolveAETNamespace(this.currentScope.getProject());
        Name multinameLA = new Name(28, new Nsset(ns), null);
        result.addInstruction(106, multinameLA);
        return result;
    }

    public InstructionList reduce_deleteDescendantsExpr(IASNode iNode, InstructionList stem, Binding field) {
        InstructionList result = this.createInstructionList(iNode, stem.size() + 1);
        result.addAll(stem);
        result.addInstruction(41);
        result.addInstruction(38);
        return result;
    }

    public InstructionList reduce_deleteExprExprExpr(IASNode iNode, InstructionList expr) {
        InstructionList result = this.createInstructionList(iNode, expr.size() + 2);
        result.addInstruction(208);
        result.addAll(expr);
        result.addInstruction(this.arrayAccess(iNode, 106));
        return result;
    }

    public InstructionList reduce_deleteMemberExpr(IASNode iNode, InstructionList stem, Binding field) {
        this.currentScope.getMethodBodySemanticChecker().checkDeleteExpr(iNode, field);
        InstructionList result = this.createInstructionList(iNode, stem.size() + 1);
        result.addAll(stem);
        result.addInstruction(106, field.getName());
        return result;
    }

    public InstructionList reduce_deleteRuntimeNameExpr(IASNode iNode, InstructionList stem, RuntimeMultiname rt_name) {
        InstructionList result = this.createInstructionList(iNode);
        result.addAll(stem);
        if (rt_name.hasRuntimeQualifier()) {
            result.addAll(rt_name.getRuntimeQualifier(iNode));
        }
        if (rt_name.hasRuntimeName()) {
            result.addAll(rt_name.getRuntimeName(iNode));
        }
        result.addInstruction(106, rt_name.generateName());
        return result;
    }

    public InstructionList reduce_deleteNameExpr(IASNode iNode, Binding n) {
        this.currentScope.getMethodBodySemanticChecker().checkDeleteExpr(iNode, n);
        InstructionList result = this.createInstructionList(iNode, 2);
        result.addAll(this.currentScope.findProperty(n, false));
        result.addInstruction(106, n.getName());
        return result;
    }

    public InstructionList reduce_doStmt(IASNode iNode, InstructionList body, InstructionList cond) {
        InstructionList result = this.createInstructionList(iNode, cond.size() + body.size() + 1);
        this.currentScope.getFlowManager().resolveContinueLabel(cond);
        if (body.isEmpty() || body.firstElement().getOpcode() != 9) {
            result.addInstruction(9);
        }
        result.addAll(body);
        result.addAll(cond);
        result.addInstruction(17, result.getLabel());
        this.currentScope.getFlowManager().finishLoopControlFlowContext(result);
        return result;
    }

    public InstructionList reduce_e4xFilter(IASNode iNode, InstructionList stem, InstructionList filter) {
        InstructionList result = this.createInstructionList(iNode);
        LexicalScope.Hasnext2Wrapper hasnext = this.currentScope.hasnext2();
        Binding value_temp = this.currentScope.allocateTemp();
        Binding result_temp = this.currentScope.allocateTemp();
        result.addAll(stem);
        result.addInstruction(120);
        result.addInstruction(hasnext.stem_temp.setlocal());
        result.addInstruction(36, 0);
        result.addInstruction(hasnext.index_temp.setlocal());
        result.addAll(this.currentScope.getPropertyValue(xmlListType, this.currentScope.getProject().getBuiltinType(IASLanguageConstants.BuiltinType.XMLLIST)));
        result.addInstruction(44, "");
        result.addInstruction(66, 1);
        result.addInstruction(result_temp.setlocal());
        Label test = new Label();
        result.addInstruction(16, test);
        Label loop = new Label();
        result.labelNext(loop);
        result.addInstruction(9);
        result.addInstruction(hasnext.stem_temp.getlocal());
        result.addInstruction(hasnext.index_temp.getlocal());
        result.addInstruction(35);
        result.addInstruction(42);
        result.addInstruction(value_temp.setlocal());
        result.addInstruction(28);
        result.addAll(filter);
        Label no_match = new Label();
        result.addInstruction(18, no_match);
        result.addInstruction(result_temp.getlocal());
        result.addInstruction(hasnext.index_temp.getlocal());
        result.addInstruction(value_temp.getlocal());
        result.addInstruction(this.arrayAccess(iNode, 97));
        result.labelNext(no_match);
        result.addInstruction(29);
        result.labelNext(test);
        result.addInstruction(hasnext.instruction);
        result.addInstruction(17, loop);
        result.addInstruction(result_temp.getlocal());
        hasnext.release();
        this.currentScope.releaseTemp(value_temp);
        this.currentScope.releaseTemp(result_temp);
        return result;
    }

    public InstructionList reduce_embed(IASNode iNode) {
        InstructionList result;
        String name = "";
        try {
            name = ((EmbedNode)iNode).getName(this.currentScope.getProject(), this.getProblems());
        }
        catch (InterruptedException e) {
            throw new CodegenInterruptedException(e);
        }
        VariableNode variableNode = (VariableNode)iNode.getParent();
        IVariableDefinition variableDef = (IVariableDefinition)((Object)variableNode.getDefinition());
        ITypeDefinition variableType = variableDef.resolveType(this.currentScope.getProject());
        String typeName = variableType.getQualifiedName();
        if ("Class".equals(typeName)) {
            result = this.createInstructionList(iNode);
            Name embedName = new Name(name);
            result.addInstruction(96, embedName);
        } else if ("String".equals(typeName)) {
            result = this.createInstructionList(iNode);
            result.addInstruction(44, name);
        } else {
            assert (false) : "this problem should have been caught already at EmbedNode construction time";
            result = null;
        }
        return result;
    }

    public InstructionList reduce_forKeyValueStmt(IASNode iNode, Binding it, InstructionList base, InstructionList body, int opcode) {
        this.currentScope.getMethodBodySemanticChecker().checkLValue(iNode, it);
        InstructionList result = this.createInstructionList(iNode, body.size() + base.size() + 15);
        ForKeyValueLoopState fkv = new ForKeyValueLoopState();
        result.addAll(fkv.generatePrologue(iNode, base));
        result.addAll(this.generateAssignment(iNode, it, fkv.generateKeyOrValue(opcode)));
        result.addAll(body);
        result.addAll(fkv.generateEpilogue());
        this.currentScope.getFlowManager().finishLoopControlFlowContext(result);
        return result;
    }

    public InstructionList reduce_forVarDeclInStmt(IASNode iNode, InstructionList single_decl, InstructionList base, InstructionList body, int opcode) {
        InstructionList result = this.createInstructionList(iNode);
        result.addAll(single_decl);
        VariableNode var_node = ABCGeneratingReducer.findIteratorVariable((ForLoopNode)iNode);
        Binding it = this.currentScope.resolveName((IdentifierNode)var_node.getNameExpressionNode());
        this.currentScope.getMethodBodySemanticChecker().checkLValue(iNode, it);
        ForKeyValueLoopState fkv = new ForKeyValueLoopState();
        result.addAll(fkv.generatePrologue(iNode, base));
        result.addAll(this.generateAssignment(iNode, it, fkv.generateKeyOrValue(opcode)));
        result.addAll(body);
        result.addAll(fkv.generateEpilogue());
        this.currentScope.getFlowManager().finishLoopControlFlowContext(result);
        return result;
    }

    private static VariableNode findIteratorVariable(ForLoopNode for_loop_node) {
        assert (for_loop_node != null) : "'for' loop node can't be null";
        IASNode conditionalStatement = for_loop_node.getConditionalsContainerNode().getChild(0);
        BinaryOperatorInNode in_node = (BinaryOperatorInNode)conditionalStatement;
        VariableExpressionNode var_expr_node = (VariableExpressionNode)in_node.getLeftOperandNode();
        VariableNode var_node = (VariableNode)var_expr_node.getChild(0);
        return var_node;
    }

    public InstructionList reduce_forKeyValueArrayStmt(IASNode iNode, InstructionList stem, InstructionList index, InstructionList base, InstructionList body, int opcode, boolean is_super) {
        IContainerNode conditionalStatementsNode = ((IForLoopNode)iNode).getConditionalsContainerNode();
        IBinaryOperatorNode inNode = (IBinaryOperatorNode)SemanticUtils.getNthChild(conditionalStatementsNode, 0);
        IDynamicAccessNode arrayIndexNode = (IDynamicAccessNode)inNode.getLeftOperandNode();
        ForKeyValueLoopState fkv = new ForKeyValueLoopState();
        InstructionList result = this.createInstructionList(iNode, body.size() + base.size() + 15);
        result.addAll(fkv.generatePrologue(iNode, base));
        if (is_super) {
            result.addInstruction(208);
        } else {
            result.addAll(stem);
        }
        result.addAll(index);
        result.addAll(fkv.generateKeyOrValue(opcode));
        result.addInstruction(this.arrayAccess(arrayIndexNode, is_super ? 5 : 97));
        result.addAll(body);
        result.addAll(fkv.generateEpilogue());
        this.currentScope.getFlowManager().finishLoopControlFlowContext(result);
        return result;
    }

    public InstructionList reduce_forKeyValueMemberStmt(IASNode iNode, InstructionList stem, Binding member, InstructionList base, InstructionList body, int opcode, boolean is_super) {
        this.currentScope.getMethodBodySemanticChecker().checkLValue(iNode, member);
        ForKeyValueLoopState fkv = new ForKeyValueLoopState();
        InstructionList result = this.createInstructionList(iNode, body.size() + base.size() + 15);
        result.addAll(fkv.generatePrologue(iNode, base));
        if (is_super) {
            result.addInstruction(208);
        } else {
            result.addAll(stem);
        }
        result.addAll(fkv.generateKeyOrValue(opcode));
        this.generateAssignmentOp(iNode, member, result);
        result.addAll(body);
        result.addAll(fkv.generateEpilogue());
        this.currentScope.getFlowManager().finishLoopControlFlowContext(result);
        return result;
    }

    public InstructionList reduce_functionAsBracketExpr(IASNode iNode, InstructionList stem, InstructionList index, Vector<InstructionList> args) {
        IDynamicAccessNode arrayIndexNode = (IDynamicAccessNode)((IFunctionCallNode)iNode).getNameNode();
        InstructionList result = this.createInstructionList(iNode);
        result.addAll(stem);
        result.addInstruction(42);
        result.addAll(index);
        result.addInstruction(this.arrayAccess(arrayIndexNode, 102));
        result.addInstruction(43);
        for (InstructionList arg : args) {
            result.addAll(arg);
        }
        result.addInstruction(65, args.size());
        return result;
    }

    public InstructionList reduce_functionAsMemberExpr(IASNode iNode, InstructionList stem, Binding method_name, Vector<InstructionList> args) {
        this.currentScope.getMethodBodySemanticChecker().checkFunctionCall(iNode, method_name, args);
        InstructionList result = this.createInstructionList(iNode);
        result.addAll(stem);
        boolean inlined = this.generateInlineFunctionCall(method_name, result, true, args);
        if (!inlined) {
            for (InstructionList arg : args) {
                result.addAll(arg);
            }
            result.addInstruction(70, new Object[]{method_name.getName(), args.size()});
        }
        return result;
    }

    public InstructionList reduce_functionAsRandomExpr(IASNode iNode, InstructionList random_expr, Vector<InstructionList> args) {
        InstructionList result = this.createInstructionList(iNode);
        result.addAll(random_expr);
        result.addInstruction(208);
        for (InstructionList arg : args) {
            result.addAll(arg);
        }
        result.addInstruction(65, args.size());
        return result;
    }

    public InstructionList reduce_functionCallExpr_to_expression(IASNode iNode, Binding method_name, Vector<InstructionList> args) {
        return this.reduce_functionCall_common(iNode, method_name, args, true);
    }

    public InstructionList reduce_functionCallExpr_to_void_expression(IASNode iNode, Binding method_name, Vector<InstructionList> args) {
        return this.reduce_functionCall_common(iNode, method_name, args, false);
    }

    private InstructionList reduce_functionCall_common(IASNode iNode, Binding method_name, Vector<InstructionList> args, boolean need_result) {
        this.currentScope.getMethodBodySemanticChecker().checkFunctionCall(iNode, method_name, args);
        InstructionList result = this.createInstructionList(iNode);
        if (method_name.isLocal()) {
            result.addInstruction(method_name.getlocal());
            result.addInstruction(208);
            for (InstructionList arg : args) {
                result.addAll(arg);
            }
            result.addInstruction(65, args.size());
            if (!need_result) {
                result.addInstruction(41);
            }
        } else if (SemanticUtils.isMethodBinding(method_name.getDefinition())) {
            boolean inlined = this.generateInlineFunctionCall(method_name, result, false, args);
            if (!inlined) {
                result.addAll(this.currentScope.findProperty(method_name, true));
                for (InstructionList arg : args) {
                    result.addAll(arg);
                }
                int opcode = need_result ? 70 : 79;
                result.addInstruction(opcode, new Object[]{method_name.getName(), args.size()});
            }
        } else if (method_name.getDefinition() != null) {
            assert (!method_name.getName().isRuntimeName());
            boolean inlined = this.generateInlineGetterAccess(method_name, result, false);
            if (!inlined) {
                result.addAll(this.currentScope.getPropertyValue(method_name));
            }
            result.addInstruction(100);
            for (InstructionList arg : args) {
                result.addAll(arg);
            }
            result.addInstruction(65, args.size());
            if (!need_result) {
                result.addInstruction(41);
            }
        } else {
            result.addInstruction(93, method_name.getName());
            for (InstructionList arg : args) {
                result.addAll(arg);
            }
            int opcode = need_result ? 70 : 79;
            result.addInstruction(opcode, new Object[]{method_name.getName(), args.size()});
        }
        return result;
    }

    public InstructionList reduce_functionCallOfSuperclassMethod_to_expression(IASNode iNode, InstructionList stem, Binding method_name, Vector<InstructionList> args) {
        this.currentScope.getMethodBodySemanticChecker().checkSuperAccess(iNode);
        InstructionList result = this.createInstructionList(iNode);
        if (stem != null) {
            result.addAll(stem);
        } else {
            result.addInstruction(208);
        }
        for (InstructionList arg : args) {
            result.addAll(arg);
        }
        result.addInstruction(69, new Object[]{method_name.getName(), args.size()});
        return result;
    }

    public InstructionList reduce_functionCallOfSuperclassMethod_to_void_expression(IASNode iNode, InstructionList stem, Binding method_name, Vector<InstructionList> args) {
        this.currentScope.getMethodBodySemanticChecker().checkSuperAccess(iNode);
        InstructionList result = this.createInstructionList(iNode);
        if (stem != null) {
            result.addAll(stem);
        } else {
            result.addInstruction(208);
        }
        for (InstructionList arg : args) {
            result.addAll(arg);
        }
        result.addInstruction(78, new Object[]{method_name.getName(), args.size()});
        return result;
    }

    public InstructionList reduce_groupedVoidExpression(IASNode iNode, Vector<InstructionList> contents) {
        InstructionList result = this.createInstructionList(iNode);
        for (InstructionList expr : contents) {
            result.addAll(expr);
        }
        return result;
    }

    public InstructionList reduce_ifElseIf(IASNode iNode, InstructionList test, InstructionList then, Vector<ConditionalFragment> if_elseif) {
        this.convertConstantValueConditionsToInstructions(if_elseif);
        InstructionList result = this.createInstructionList(iNode);
        boolean has_else = !if_elseif.isEmpty();
        Label tail = null;
        result.addAll(test);
        if (has_else) {
            result.addInstruction(18, if_elseif.firstElement().getLabel());
        } else {
            tail = this.addBranch(result, tail, 18);
        }
        result.addAll(then);
        if (has_else) {
            tail = this.addInterstitialControlFlow(result, tail);
            for (int i = 0; i < if_elseif.size() - 1; ++i) {
                ConditionalFragment alternative = if_elseif.elementAt(i);
                if (!alternative.isUnconditionalAlternative()) {
                    result.addAll(alternative.condition);
                    ConditionalFragment next_alternative = if_elseif.elementAt(i + 1);
                    result.addInstruction(18, next_alternative.getLabel());
                }
                result.addAll(alternative.statement);
                tail = this.addInterstitialControlFlow(result, tail);
            }
            ConditionalFragment last_clause = if_elseif.lastElement();
            if (!last_clause.isUnconditionalAlternative()) {
                result.addAll(last_clause.condition);
                tail = this.addBranch(result, tail, 18);
                result.addAll(last_clause.statement);
            } else {
                result.addAll(last_clause.statement);
            }
        }
        if (tail != null) {
            result.labelNext(tail);
        }
        return result;
    }

    private Label addBranch(InstructionList insns, Label previousLabel, int opcode) {
        Label result = previousLabel != null ? previousLabel : new Label();
        insns.addInstruction(opcode, result);
        return result;
    }

    private Label addInterstitialControlFlow(InstructionList insns, Label previousLabel) {
        Label result = insns.canFallThrough() ? this.addBranch(insns, previousLabel, 16) : (insns.hasPendingLabels() ? this.addBranch(insns, previousLabel, 16) : previousLabel);
        return result;
    }

    public InstructionList reduce_importDirective(IASNode iNode) {
        this.currentScope.getMethodBodySemanticChecker().checkImportDirective((IImportNode)iNode);
        return this.createInstructionList(iNode);
    }

    public InstructionList reduce_labeledBreakStmt(IASNode iNode) {
        String target = ((IdentifierNode)SemanticUtils.getNthChild(iNode, 0)).getName();
        try {
            ControlFlowContextManager.ControlFlowContextSearchCriteria criterion = this.getBreakCriteria(target);
            return this.getNonLocalControlFlow(criterion);
        }
        catch (UnknownControlFlowTargetException no_target) {
            this.currentScope.addProblem(new UnknownBreakTargetProblem(SemanticUtils.getNthChild(iNode, 0)));
            return this.createInstructionList(iNode);
        }
    }

    public InstructionList reduce_labeledContinueStmt(IASNode iNode) {
        String target = ((IdentifierNode)SemanticUtils.getNthChild(iNode, 0)).getName();
        try {
            ControlFlowContextManager.ControlFlowContextSearchCriteria criterion = this.getContinueCriteria(target);
            return this.getNonLocalControlFlow(criterion);
        }
        catch (UnknownControlFlowTargetException no_target) {
            this.currentScope.addProblem(new UnknownContinueTargetProblem(SemanticUtils.getNthChild(iNode, 0)));
            return this.createInstructionList(iNode);
        }
    }

    public InstructionList reduce_gotoStmt(IASNode iNode) {
        IdentifierNode labelIdentifierNode = (IdentifierNode)SemanticUtils.getNthChild(iNode, 0);
        String target = labelIdentifierNode.getName();
        try {
            ControlFlowContextManager.ControlFlowContextSearchCriteria criterion = this.getGotoCriteria(target);
            return this.getNonLocalControlFlow(criterion);
        }
        catch (UnknownControlFlowTargetException no_target) {
            Collection<LabeledStatementNode> gotoLabels = this.currentScope.getFlowManager().getGotoLabels(target);
            if (gotoLabels.isEmpty()) {
                this.currentScope.addProblem(new UnknownGotoTargetProblem(labelIdentifierNode));
            } else {
                this.currentScope.addProblem(new AmbiguousGotoTargetProblem(labelIdentifierNode, gotoLabels));
            }
            return this.createInstructionList(iNode);
        }
    }

    public InstructionList reduce_labeledStmt(IASNode iNode, String label, InstructionList substatement) {
        InstructionList result = this.createInstructionList(iNode, 1);
        Label gotoLabel = this.currentScope.getFlowManager().getGotoLabel(label);
        if (gotoLabel != null) {
            result.labelNext(gotoLabel);
            result.addInstruction(9);
        }
        result.addAll(substatement);
        this.currentScope.getFlowManager().finishLabeledStatementControlFlowContext(result);
        return result;
    }

    public ConditionalFragment reduce_lastElse(IASNode iNode, InstructionList else_clause) {
        return new ConditionalFragment(iNode, null, else_clause);
    }

    public InstructionList reduce_logicalAndExpr(IASNode iNode, InstructionList l, InstructionList r) {
        InstructionList result = this.createInstructionList(iNode, l.size() + r.size() + 3);
        Label tail = new Label();
        result.addAll(l);
        result.addInstruction(42);
        result.addInstruction(18, tail);
        result.addInstruction(41);
        result.addAll(r);
        result.labelNext(tail);
        return result;
    }

    public InstructionList reduce_logicalNotExpr(IASNode iNode, InstructionList expr) {
        InstructionList result = this.createInstructionList(iNode, expr.size() + 1);
        result.addAll(expr);
        result.addInstruction(150);
        return result;
    }

    public InstructionList reduce_logicalOrExpr(IASNode iNode, InstructionList l, InstructionList r) {
        InstructionList result = this.createInstructionList(iNode, l.size() + r.size() + 3);
        Label tail = new Label();
        result.addAll(l);
        result.addInstruction(42);
        result.addInstruction(17, tail);
        result.addInstruction(41);
        result.addAll(r);
        result.labelNext(tail);
        return result;
    }

    public InstructionList reduce_memberAccessExpr(IASNode iNode, InstructionList stem, Binding member, int opcode) {
        this.currentScope.getMethodBodySemanticChecker().checkMemberAccess(iNode, member, opcode);
        InstructionList result = this.createInstructionList(iNode, stem.size() + 1);
        result.addAll(stem);
        boolean inlined = this.generateInlineGetterAccess(member, result, true);
        if (!inlined) {
            result.addInstruction(opcode, member.getName());
        }
        return result;
    }

    public InstructionList reduce_qualifiedMemberAccessExpr(IASNode iNode, InstructionList stem, Binding qualifier, Binding member, int opcode) {
        this.currentScope.getMethodBodySemanticChecker().checkMemberAccess(iNode, member, opcode);
        InstructionList result = this.createInstructionList(iNode);
        Name member_name = member.getName();
        result.addAll(stem);
        if (this.isNamespace(qualifier)) {
            result.addInstruction(opcode, member_name);
        } else {
            this.generateAccess(qualifier, result);
            result.addInstruction(128, namespaceType);
            result.addInstruction(opcode, member_name);
        }
        return result;
    }

    public InstructionList reduce_qualifiedAttributeRuntimeMemberExpr(IASNode iNode, InstructionList stem, Binding qualifier, InstructionList runtime_member_selector, int opcode) {
        InstructionList result = this.createInstructionList(iNode);
        result.addAll(stem);
        if (this.isNamespace(qualifier)) {
            result.addAll(runtime_member_selector);
            NamespaceDefinition ns_def = (NamespaceDefinition)qualifier.getDefinition();
            Name qualified_name = new Name(28, new Nsset(ns_def.resolveAETNamespace(this.currentScope.getProject())), null);
            result.addInstruction(opcode, qualified_name);
        } else {
            this.generateAccess(qualifier, result);
            result.addInstruction(128, namespaceType);
            result.addAll(runtime_member_selector);
            result.addInstruction(133);
            result.addInstruction(opcode, new Name(18, null, null));
        }
        return result;
    }

    public InstructionList reduce_qualifiedMemberRuntimeNameExpr(IASNode iNode, InstructionList stem, Binding qualifier, InstructionList runtime_member_selector) {
        InstructionList result = this.createInstructionList(iNode);
        result.addAll(stem);
        if (this.isNamespace(qualifier)) {
            result.addAll(runtime_member_selector);
            NamespaceDefinition ns_def = (NamespaceDefinition)qualifier.getDefinition();
            Name qualified_name = new Name(27, new Nsset(ns_def.resolveAETNamespace(this.currentScope.getProject())), null);
            result.addInstruction(102, qualified_name);
        } else {
            this.generateAccess(qualifier, result);
            result.addInstruction(128, namespaceType);
            result.addAll(runtime_member_selector);
            result.addInstruction(133);
            result.addInstruction(102, new Name(17, null, null));
        }
        return result;
    }

    public InstructionList reduce_qualifiedAttributeExpr(IASNode iNode, InstructionList stem, Binding qualifier, Binding member, int opcode) {
        InstructionList result = this.createInstructionList(iNode);
        result.addAll(stem);
        if (!this.isNamespace(qualifier)) {
            this.generateAccess(qualifier, result);
            result.addInstruction(128, namespaceType);
            result.addInstruction(opcode, member.getName());
        } else {
            result.addInstruction(opcode, member.getName());
        }
        return result;
    }

    public InstructionList reduce_unqualifiedAttributeExpr(IASNode iNode, InstructionList stem, InstructionList rt_attr, int opcode) {
        InstructionList result = this.createInstructionList(iNode);
        result.addAll(stem);
        result.addAll(rt_attr);
        result.addInstruction(opcode, new Name(28, new Nsset(new Namespace(22)), null));
        return result;
    }

    public InstructionList reduce_runtimeAttributeExp(IASNode iNode, InstructionList rt_attr) {
        InstructionList result = this.createInstructionList(iNode);
        result.addAll(rt_attr);
        Nsset qualifiers = SemanticUtils.getOpenNamespaces(iNode, this.currentScope.getProject());
        result.addInstruction(102, new Name(28, qualifiers, null));
        return result;
    }

    public InstructionList reduce_mxmlEventSpecifier(IASNode iNode, Vector<InstructionList> stmts) {
        InstructionList body = this.createInstructionList(iNode);
        for (InstructionList stmt : stmts) {
            body.addAll(stmt);
        }
        return this.generateFunctionBody(iNode, body, LexicalScope.anyType);
    }

    public Binding reduce_namespaceAccess(IASNode iNode, IASNode qualifier, Binding qualified_name) {
        this.currentScope.getMethodBodySemanticChecker().checkQualifier(qualifier);
        return qualified_name;
    }

    public RuntimeMultiname reduce_namespaceAccess_to_runtime_name(IASNode iNode, Binding qualified_name) {
        InstructionList qualifier = this.createInstructionList(iNode);
        this.generateAccess(this.reduce_simpleName(iNode.getChild(0)), qualifier);
        qualifier.addInstruction(128, namespaceType);
        return new RuntimeMultiname(qualifier, qualified_name.getName());
    }

    public InstructionList reduce_namespaceAsName_to_expression(IASNode iNode) {
        InstructionList result = this.createInstructionList(iNode);
        Binding b = this.reduce_simpleName(iNode);
        this.generateAccess(b, result);
        result.addInstruction(128, namespaceType);
        return result;
    }

    public Name reduce_namespaceAsName_to_multinameL(IASNode iNode) {
        return this.reduce_namespaceAsName_to_multinameL(iNode, false);
    }

    public Name reduce_namespaceAsName_to_multinameL(IASNode iNode, boolean is_attribute) {
        IdentifierNode qualifier = (IdentifierNode)iNode;
        NamespaceDefinition ns = (NamespaceDefinition)qualifier.resolve(this.currentScope.getProject());
        int name_kind = is_attribute ? 28 : 27;
        return new Name(name_kind, new Nsset(ns.resolveAETNamespace(this.currentScope.getProject())), null);
    }

    public Binding reduce_namespaceAsName_to_name(IASNode iNode) {
        return this.currentScope.resolveName((IdentifierNode)iNode);
    }

    public InstructionList reduce_namespaceDeclaration(IASNode iNode, Binding ns_name) {
        NamespaceDefinition def = ((NamespaceNode)iNode).getDefinition();
        return this.reduce_namespaceDeclarationConstantInitializer(iNode, ns_name, def.resolveAETNamespace(this.currentScope.getProject()));
    }

    public InstructionList reduce_namespaceDeclarationConstantInitializer(IASNode iNode, Binding ns_name, String uri) {
        return this.reduce_namespaceDeclarationConstantInitializer(iNode, ns_name, new Namespace(8, uri));
    }

    public InstructionList reduce_namespaceDeclarationConstantInitializer(IASNode iNode, Binding ns_name, Namespace initializer) {
        this.currentScope.getMethodBodySemanticChecker().checkNamespaceDeclaration(iNode, ns_name);
        NamespaceDefinition def = ((NamespaceNode)iNode).getDefinition();
        switch (SemanticUtils.getMultiDefinitionType(def, this.currentScope.getProject())) {
            case AMBIGUOUS: {
                this.currentScope.addProblem(new DuplicateNamespaceDefinitionProblem(iNode));
                break;
            }
            case NONE: {
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        if (initializer == null) {
            this.getProblems().add(new InvalidNamespaceInitializerProblem(iNode));
            return null;
        }
        this.currentScope.makeNamespace(ns_name, initializer);
        if (ns_name.isLocal()) {
            this.currentScope.getHoistedInitInstructions().addInstruction(49, initializer);
            this.currentScope.getHoistedInitInstructions().addInstruction(ns_name.setlocal());
        }
        return null;
    }

    public InstructionList reduce_namespaceDeclarationInitializer(IASNode iNode, Binding ns_name, Binding second_ns) {
        Namespace ns_init = null;
        if (second_ns.getDefinition() instanceof NamespaceDefinition) {
            NamespaceDefinition ns_def = (NamespaceDefinition)second_ns.getDefinition();
            ns_init = ns_def.resolveAETNamespace(this.currentScope.getProject());
        }
        return this.reduce_namespaceDeclarationConstantInitializer(iNode, ns_name, ns_init);
    }

    public RuntimeMultiname reduce_namespaceMultinameL(IASNode iNode, IASNode qualifier_node, InstructionList expr) {
        this.currentScope.getMethodBodySemanticChecker().checkQualifier(qualifier_node);
        Name qualifier = this.reduce_namespaceAsName_to_multinameL(qualifier_node);
        return new RuntimeMultiname(qualifier, expr);
    }

    public RuntimeMultiname reduce_namespaceRTQName(IASNode iNode, InstructionList qualifier, Binding qualified_name) {
        return new RuntimeMultiname(qualifier, qualified_name.getName());
    }

    public RuntimeMultiname reduce_namespaceRTQNameL(IASNode iNode, InstructionList qualifier, InstructionList expr) {
        return new RuntimeMultiname(qualifier, expr);
    }

    public InstructionList reduce_neqExpr(IASNode iNode, InstructionList l, InstructionList r) {
        InstructionList result = this.binaryOp(iNode, l, r, 171);
        result.addInstruction(150);
        return result;
    }

    public Binding reduce_nameToTypeName(Binding name, boolean check_name) {
        if (check_name) {
            this.currentScope.getMethodBodySemanticChecker().checkTypeName(name);
        }
        return name;
    }

    public InstructionList reduce_newMemberProperty(IASNode iNode, InstructionList stem, Binding member, Vector<InstructionList> args) {
        this.currentScope.getMethodBodySemanticChecker().checkNewExpr(iNode);
        InstructionList result = this.createInstructionList(iNode);
        result.addAll(stem);
        for (InstructionList arg : args) {
            result.addAll(arg);
        }
        result.addInstruction(74, new Object[]{member.getName(), args.size()});
        return result;
    }

    public InstructionList reduce_newAsRandomExpr(IASNode iNode, InstructionList random_expr, Vector<InstructionList> args) {
        this.currentScope.getMethodBodySemanticChecker().checkNewExpr(iNode);
        InstructionList result = this.createInstructionList(iNode);
        result.addAll(random_expr);
        for (InstructionList arg : args) {
            result.addAll(arg);
        }
        result.addInstruction(66, args.size());
        return result;
    }

    public InstructionList reduce_newEmptyArray(IASNode iNode) {
        InstructionList result = this.createInstructionList(iNode);
        result.addInstruction(86, 0);
        return result;
    }

    public InstructionList reduce_newEmptyObject(IASNode iNode) {
        InstructionList result = this.createInstructionList(iNode);
        result.addInstruction(85, 0);
        return result;
    }

    public InstructionList reduce_newExpr(IASNode iNode, Binding class_binding, Vector<InstructionList> args) {
        this.currentScope.getMethodBodySemanticChecker().checkNewExpr(iNode, class_binding, args);
        InstructionList result = this.createInstructionList(iNode);
        Name class_name = class_binding.getName();
        if (class_binding.isLocal() || class_name.isTypeName()) {
            this.generateAccess(class_binding, result);
            for (InstructionList arg : args) {
                result.addAll(arg);
            }
            result.addInstruction(66, args.size());
        } else {
            result.addAll(this.currentScope.findProperty(class_binding, true));
            for (InstructionList arg : args) {
                result.addAll(arg);
            }
            result.addInstruction(74, new Object[]{class_name, args.size()});
        }
        return result;
    }

    public InstructionList reduce_newVectorLiteral(IASNode iNode, InstructionList literal) {
        return literal;
    }

    public InstructionList reduce_nilExpr_to_conditionalJump(IASNode iNode) {
        InstructionList result = this.createInstructionList(iNode, 1);
        result.addInstruction(InstructionFactory.getTargetableInstruction(16));
        return result;
    }

    public InstructionList reduce_nilExpr_to_expression(IASNode iNode) {
        InstructionList result = this.createInstructionList(iNode, 1);
        result.addInstruction(33);
        return result;
    }

    public Object reduce_nullLiteral_to_constant_value(IASNode iNode) {
        return ABCConstants.NULL_VALUE;
    }

    public InstructionList reduce_nullLiteral_to_object_literal(IASNode iNode) {
        InstructionList result = this.createInstructionList(iNode, 1);
        result.addInstruction(32);
        return result;
    }

    public InstructionList reduce_objectLiteral(IASNode iNode, Vector<InstructionList> elements) {
        InstructionList result = this.createInstructionList(iNode);
        for (InstructionList element : elements) {
            result.addAll(element);
        }
        result.addInstruction(85, elements.size());
        return result;
    }

    public InstructionList reduce_objectLiteralElement(IASNode iNode, InstructionList id, InstructionList value) {
        InstructionList result = this.createInstructionList(iNode, value.size() + 1);
        result.addAll(id);
        result.addInstruction(112);
        result.addAll(value);
        return result;
    }

    public InstructionList reduce_optionalParameter(IASNode iNode, Name param_name, Binding param_type, Object raw_default_value) {
        PooledValue transformed_default_value;
        IParameterNode parameter_node = (IParameterNode)iNode;
        if (raw_default_value == null) {
            this.currentScope.addProblem(new NonConstantParamInitializerProblem(parameter_node.getAssignedValueNode()));
            transformed_default_value = new PooledValue(ABCConstants.UNDEFINED_VALUE);
        } else {
            PooledValue default_value = new PooledValue(raw_default_value);
            transformed_default_value = this.currentScope.getMethodBodySemanticChecker().checkInitialValue(parameter_node, param_type, default_value);
        }
        this.currentScope.makeParameter(this.getParameterContent(iNode), param_type.getName());
        this.currentScope.addDefaultValue(transformed_default_value);
        return null;
    }

    public Binding reduce_parameterizedName(IASNode iNode, Binding base, Binding param) {
        Name param_name = param.getName();
        return new Binding(iNode, new Name(base.getName(), param_name), null);
    }

    public InstructionList reduce_parameterizedTypeExpression(IASNode iNode, InstructionList base, InstructionList param) {
        InstructionList result = this.createInstructionList(iNode);
        result.addAll(base);
        result.addAll(param);
        result.addInstruction(83, 1);
        return result;
    }

    public InstructionList reduce_plist(IASNode iNode, Vector<InstructionList> pdecl) {
        return null;
    }

    public InstructionList reduce_postDecBracketExpr(IASNode iNode, InstructionList stem, InstructionList index, boolean need_result) {
        IDynamicAccessNode arrayIndexNode = (IDynamicAccessNode)((IUnaryOperatorNode)iNode).getOperandNode();
        this.currentScope.getMethodBodySemanticChecker().checkIncDec(iNode, false);
        InstructionList result = this.createInstructionList(iNode);
        result.addAll(stem);
        Binding stem_tmp = this.currentScope.allocateTemp();
        result.addInstruction(42);
        result.addInstruction(stem_tmp.setlocal());
        result.addAll(index);
        result.addInstruction(42);
        Binding index_tmp = this.currentScope.allocateTemp();
        result.addInstruction(index_tmp.setlocal());
        result.addInstruction(this.arrayAccess(arrayIndexNode, 102));
        result.addInstruction(this.op_unplus());
        if (need_result) {
            result.addInstruction(42);
        }
        result.addInstruction(147);
        Binding result_tmp = this.currentScope.allocateTemp();
        result.addInstruction(result_tmp.setlocal());
        result.addInstruction(stem_tmp.getlocal());
        result.addInstruction(index_tmp.getlocal());
        result.addInstruction(result_tmp.getlocal());
        result.addInstruction(this.arrayAccess(arrayIndexNode, 97));
        this.currentScope.releaseTemp(stem_tmp);
        this.currentScope.releaseTemp(index_tmp);
        this.currentScope.releaseTemp(result_tmp);
        return result;
    }

    public InstructionList reduce_postDecMemberExpr(IASNode iNode, InstructionList stem, Binding field, boolean need_result) {
        this.currentScope.getMethodBodySemanticChecker().checkIncDec(iNode, false, field);
        InstructionList result = this.createInstructionList(iNode);
        result.addAll(stem);
        result.addInstruction(42);
        result.addInstruction(102, field.getName());
        result.addInstruction(this.op_unplus());
        Binding orig_tmp = null;
        if (need_result) {
            result.addInstruction(42);
            orig_tmp = this.currentScope.allocateTemp();
            result.addInstruction(orig_tmp.setlocal());
        }
        result.addInstruction(147);
        this.generateAssignmentOp(iNode, field, result);
        if (need_result) {
            result.addInstruction(orig_tmp.getlocal());
            this.currentScope.releaseTemp(orig_tmp);
        }
        return result;
    }

    public InstructionList reduce_postDecNameExpr(IASNode iNode, Binding unary, boolean need_result) {
        this.currentScope.getMethodBodySemanticChecker().checkIncDec(iNode, false, unary);
        InstructionList result = this.createInstructionList(iNode);
        if (unary.isLocal()) {
            ICompilerProject project = this.currentScope.getProject();
            IDefinition inType = SemanticUtils.resolveUnaryExprType(iNode, project);
            ITypeDefinition intType = project.getBuiltinType(IASLanguageConstants.BuiltinType.INT);
            ITypeDefinition numberType = project.getBuiltinType(IASLanguageConstants.BuiltinType.NUMBER);
            if (inType == intType) {
                if (need_result) {
                    result.addInstruction(unary.getlocal());
                }
                result.addInstruction(unary.declocal_i());
            } else if (inType == numberType) {
                if (need_result) {
                    result.addInstruction(unary.getlocal());
                }
                result.addInstruction(unary.declocal());
            } else {
                result.addInstruction(unary.getlocal());
                result.addInstruction(this.op_unplus());
                if (need_result) {
                    result.addInstruction(42);
                }
                result.addInstruction(147);
                this.coerce(result, inType);
                result.addInstruction(unary.setlocal());
            }
        } else {
            Name n = unary.getName();
            result.addAll(this.currentScope.findProperty(unary, true));
            result.addInstruction(102, n);
            result.addInstruction(this.op_unplus());
            if (need_result) {
                result.addInstruction(42);
            }
            result.addInstruction(147);
            result.addAll(this.currentScope.findProperty(unary, true));
            result.addInstruction(43);
            result.addInstruction(97, n);
        }
        return result;
    }

    public InstructionList reduce_postIncBracketExpr(IASNode iNode, InstructionList stem, InstructionList index, boolean need_result) {
        IDynamicAccessNode arrayIndexNode = (IDynamicAccessNode)((IUnaryOperatorNode)iNode).getOperandNode();
        this.currentScope.getMethodBodySemanticChecker().checkIncDec(iNode, true);
        InstructionList result = this.createInstructionList(iNode);
        result.addAll(stem);
        result.addInstruction(42);
        Binding stem_tmp = this.currentScope.allocateTemp();
        result.addInstruction(stem_tmp.setlocal());
        result.addAll(index);
        result.addInstruction(42);
        Binding index_tmp = this.currentScope.allocateTemp();
        result.addInstruction(index_tmp.setlocal());
        result.addInstruction(this.arrayAccess(arrayIndexNode, 102));
        result.addInstruction(this.op_unplus());
        if (need_result) {
            result.addInstruction(42);
        }
        result.addInstruction(145);
        Binding result_tmp = this.currentScope.allocateTemp();
        result.addInstruction(result_tmp.setlocal());
        result.addInstruction(stem_tmp.getlocal());
        result.addInstruction(index_tmp.getlocal());
        result.addInstruction(result_tmp.getlocal());
        result.addInstruction(this.arrayAccess(arrayIndexNode, 97));
        this.currentScope.releaseTemp(stem_tmp);
        this.currentScope.releaseTemp(index_tmp);
        this.currentScope.releaseTemp(result_tmp);
        return result;
    }

    public InstructionList reduce_postIncMemberExpr(IASNode iNode, InstructionList stem, Binding field, boolean need_result) {
        this.currentScope.getMethodBodySemanticChecker().checkIncDec(iNode, true, field);
        InstructionList result = this.createInstructionList(iNode);
        result.addAll(stem);
        result.addInstruction(42);
        result.addInstruction(102, field.getName());
        result.addInstruction(this.op_unplus());
        Binding orig_tmp = null;
        if (need_result) {
            result.addInstruction(42);
            orig_tmp = this.currentScope.allocateTemp();
            result.addInstruction(orig_tmp.setlocal());
        }
        result.addInstruction(145);
        result.addInstruction(97, field.getName());
        if (need_result) {
            result.addInstruction(orig_tmp.getlocal());
            this.currentScope.releaseTemp(orig_tmp);
        }
        return result;
    }

    public InstructionList reduce_postIncNameExpr(IASNode iNode, Binding unary, boolean need_result) {
        this.currentScope.getMethodBodySemanticChecker().checkIncDec(iNode, true, unary);
        InstructionList result = this.createInstructionList(iNode);
        if (unary.isLocal()) {
            ICompilerProject project = this.currentScope.getProject();
            IDefinition inType = SemanticUtils.resolveUnaryExprType(iNode, project);
            ITypeDefinition intType = project.getBuiltinType(IASLanguageConstants.BuiltinType.INT);
            ITypeDefinition numberType = project.getBuiltinType(IASLanguageConstants.BuiltinType.NUMBER);
            if (inType == intType) {
                if (need_result) {
                    result.addInstruction(unary.getlocal());
                }
                result.addInstruction(unary.inclocal_i());
            } else if (inType == numberType) {
                if (need_result) {
                    result.addInstruction(unary.getlocal());
                }
                result.addInstruction(unary.inclocal());
            } else {
                result.addInstruction(unary.getlocal());
                result.addInstruction(this.op_unplus());
                if (need_result) {
                    result.addInstruction(42);
                }
                result.addInstruction(145);
                this.coerce(result, inType);
                result.addInstruction(unary.setlocal());
            }
        } else {
            Name n = unary.getName();
            result.addAll(this.currentScope.findProperty(unary, true));
            result.addInstruction(102, n);
            result.addInstruction(this.op_unplus());
            if (need_result) {
                result.addInstruction(42);
            }
            result.addInstruction(145);
            result.addAll(this.currentScope.findProperty(unary, true));
            result.addInstruction(43);
            result.addInstruction(97, n);
        }
        return result;
    }

    public InstructionList reduce_preDecBracketExpr(IASNode iNode, InstructionList stem, InstructionList index, boolean need_result) {
        IDynamicAccessNode arrayIndexNode = (IDynamicAccessNode)((IUnaryOperatorNode)iNode).getOperandNode();
        this.currentScope.getMethodBodySemanticChecker().checkIncDec(iNode, false);
        InstructionList result = this.createInstructionList(iNode);
        result.addAll(stem);
        Binding stem_tmp = this.currentScope.allocateTemp();
        result.addInstruction(42);
        result.addInstruction(stem_tmp.setlocal());
        result.addAll(index);
        result.addInstruction(42);
        Binding index_tmp = this.currentScope.allocateTemp();
        result.addInstruction(index_tmp.setlocal());
        result.addInstruction(this.arrayAccess(arrayIndexNode, 102));
        result.addInstruction(147);
        if (need_result) {
            result.addInstruction(42);
        }
        Binding result_tmp = this.currentScope.allocateTemp();
        result.addInstruction(result_tmp.setlocal());
        result.addInstruction(stem_tmp.getlocal());
        result.addInstruction(index_tmp.getlocal());
        result.addInstruction(result_tmp.getlocal());
        result.addInstruction(this.arrayAccess(arrayIndexNode, 97));
        this.currentScope.releaseTemp(stem_tmp);
        this.currentScope.releaseTemp(index_tmp);
        this.currentScope.releaseTemp(result_tmp);
        return result;
    }

    public InstructionList reduce_preDecMemberExpr(IASNode iNode, InstructionList stem, Binding field, boolean need_result) {
        this.currentScope.getMethodBodySemanticChecker().checkIncDec(iNode, false, field);
        InstructionList result = this.createInstructionList(iNode);
        result.addAll(stem);
        result.addInstruction(42);
        result.addInstruction(102, field.getName());
        result.addInstruction(147);
        Binding result_tmp = null;
        if (need_result) {
            result.addInstruction(42);
            result_tmp = this.currentScope.allocateTemp();
            result.addInstruction(result_tmp.setlocal());
        }
        result.addInstruction(97, field.getName());
        if (need_result) {
            result.addInstruction(result_tmp.getlocal());
            this.currentScope.releaseTemp(result_tmp);
        }
        return result;
    }

    public InstructionList reduce_preDecNameExpr(IASNode iNode, Binding unary, boolean need_result) {
        this.currentScope.getMethodBodySemanticChecker().checkIncDec(iNode, false, unary);
        InstructionList result = this.createInstructionList(iNode);
        if (unary.isLocal()) {
            ICompilerProject project = this.currentScope.getProject();
            IDefinition inType = SemanticUtils.resolveUnaryExprType(iNode, project);
            ITypeDefinition intType = project.getBuiltinType(IASLanguageConstants.BuiltinType.INT);
            ITypeDefinition numberType = project.getBuiltinType(IASLanguageConstants.BuiltinType.NUMBER);
            if (inType == intType) {
                result.addInstruction(unary.declocal_i());
                if (need_result) {
                    result.addInstruction(unary.getlocal());
                }
            } else if (inType == numberType) {
                result.addInstruction(unary.declocal());
                if (need_result) {
                    result.addInstruction(unary.getlocal());
                }
            } else {
                result.addInstruction(unary.getlocal());
                result.addInstruction(147);
                if (need_result) {
                    result.addInstruction(42);
                }
                this.coerce(result, inType);
                result.addInstruction(unary.setlocal());
            }
        } else {
            Name n = unary.getName();
            result.addAll(this.currentScope.findProperty(unary, true));
            result.addInstruction(102, n);
            result.addInstruction(147);
            if (need_result) {
                result.addInstruction(42);
            }
            result.addAll(this.currentScope.findProperty(unary, true));
            result.addInstruction(43);
            result.addInstruction(97, n);
        }
        return result;
    }

    public InstructionList reduce_preIncBracketExpr(IASNode iNode, InstructionList stem, InstructionList index, boolean need_result) {
        IDynamicAccessNode arrayIndexNode = (IDynamicAccessNode)((IUnaryOperatorNode)iNode).getOperandNode();
        this.currentScope.getMethodBodySemanticChecker().checkIncDec(iNode, true);
        InstructionList result = this.createInstructionList(iNode);
        result.addAll(stem);
        Binding stem_tmp = this.currentScope.allocateTemp();
        result.addInstruction(42);
        result.addInstruction(stem_tmp.setlocal());
        result.addAll(index);
        result.addInstruction(42);
        Binding index_tmp = this.currentScope.allocateTemp();
        result.addInstruction(index_tmp.setlocal());
        result.addInstruction(this.arrayAccess(arrayIndexNode, 102));
        result.addInstruction(145);
        if (need_result) {
            result.addInstruction(42);
        }
        Binding result_tmp = this.currentScope.allocateTemp();
        result.addInstruction(result_tmp.setlocal());
        result.addInstruction(stem_tmp.getlocal());
        result.addInstruction(index_tmp.getlocal());
        result.addInstruction(result_tmp.getlocal());
        result.addInstruction(this.arrayAccess(arrayIndexNode, 97));
        this.currentScope.releaseTemp(stem_tmp);
        this.currentScope.releaseTemp(index_tmp);
        this.currentScope.releaseTemp(result_tmp);
        return result;
    }

    public InstructionList reduce_preIncMemberExpr(IASNode iNode, InstructionList stem, Binding field, boolean need_result) {
        this.currentScope.getMethodBodySemanticChecker().checkIncDec(iNode, true, field);
        InstructionList result = this.createInstructionList(iNode);
        result.addAll(stem);
        result.addInstruction(42);
        result.addInstruction(102, field.getName());
        result.addInstruction(145);
        Binding result_tmp = null;
        if (need_result) {
            result.addInstruction(42);
            result_tmp = this.currentScope.allocateTemp();
            result.addInstruction(result_tmp.setlocal());
        }
        result.addInstruction(97, field.getName());
        if (need_result) {
            result.addInstruction(result_tmp.getlocal());
            this.currentScope.releaseTemp(result_tmp);
        }
        return result;
    }

    public InstructionList reduce_preIncNameExpr(IASNode iNode, Binding unary, boolean need_result) {
        this.currentScope.getMethodBodySemanticChecker().checkIncDec(iNode, true, unary);
        InstructionList result = this.createInstructionList(iNode);
        if (unary.isLocal()) {
            ICompilerProject project = this.currentScope.getProject();
            IDefinition inType = SemanticUtils.resolveUnaryExprType(iNode, project);
            ITypeDefinition intType = project.getBuiltinType(IASLanguageConstants.BuiltinType.INT);
            ITypeDefinition numberType = project.getBuiltinType(IASLanguageConstants.BuiltinType.NUMBER);
            if (inType == intType) {
                result.addInstruction(unary.inclocal_i());
                if (need_result) {
                    result.addInstruction(unary.getlocal());
                }
            } else if (inType == numberType) {
                result.addInstruction(unary.inclocal());
                if (need_result) {
                    result.addInstruction(unary.getlocal());
                }
            } else {
                result.addInstruction(unary.getlocal());
                result.addInstruction(145);
                if (need_result) {
                    result.addInstruction(42);
                }
                this.coerce(result, inType);
                result.addInstruction(unary.setlocal());
            }
        } else {
            Name n = unary.getName();
            result.addAll(this.currentScope.findProperty(unary, true));
            result.addInstruction(102, n);
            result.addInstruction(145);
            if (need_result) {
                result.addInstruction(42);
            }
            result.addAll(this.currentScope.findProperty(unary, true));
            result.addInstruction(43);
            result.addInstruction(97, n);
        }
        return result;
    }

    public void coerce(InstructionList il, IDefinition toType) {
        if (toType == null) {
            return;
        }
        assert (toType instanceof ITypeDefinition);
        ICompilerProject project = this.currentScope.getProject();
        if (toType == project.getBuiltinType(IASLanguageConstants.BuiltinType.ANY_TYPE)) {
            il.addInstruction(130);
        } else if (toType == project.getBuiltinType(IASLanguageConstants.BuiltinType.STRING)) {
            il.addInstruction(133);
        } else if (toType == project.getBuiltinType(IASLanguageConstants.BuiltinType.BOOLEAN)) {
            il.addInstruction(118);
        } else if (toType == project.getBuiltinType(IASLanguageConstants.BuiltinType.NUMBER)) {
            il.addInstruction(117);
        } else if (toType == project.getBuiltinType(IASLanguageConstants.BuiltinType.INT)) {
            il.addInstruction(115);
        } else if (toType == project.getBuiltinType(IASLanguageConstants.BuiltinType.UINT)) {
            il.addInstruction(116);
        } else {
            il.addInstruction(128, ((DefinitionBase)toType).getMName(project));
        }
    }

    public InstructionList reduce_regexLiteral(IASNode iNode) {
        String flags = ((RegExpLiteralNode)iNode).getFlagString();
        InstructionList result = this.createInstructionList(iNode, flags.isEmpty() ? 4 : 5);
        result.addAll(this.currentScope.getPropertyValue(regexType, this.currentScope.getProject().getBuiltinType(IASLanguageConstants.BuiltinType.REGEXP)));
        result.addInstruction(44, this.getStringLiteralContent(iNode));
        if (!flags.isEmpty()) {
            result.addInstruction(44, flags);
            result.addInstruction(66, 2);
        } else {
            result.addInstruction(66, 1);
        }
        return result;
    }

    public InstructionList reduce_requiredParameter(IASNode iNode, Name param_name, Binding param_type) {
        this.currentScope.makeParameter(this.getParameterContent(iNode), param_type.getName());
        return null;
    }

    public InstructionList reduce_restParameter(IASNode iNode, Name param_name, Binding param_type) {
        this.currentScope.getMethodBodySemanticChecker().checkRestParameter(iNode, param_type);
        this.currentScope.makeParameter(this.getParameterContent(iNode), param_type.getName());
        return null;
    }

    public InstructionList reduce_returnVoidSideEffect(IASNode iNode, InstructionList value) {
        this.currentScope.getMethodBodySemanticChecker().checkReturnValue(iNode);
        InstructionList result = this.createInstructionList(iNode);
        result.addAll(value);
        result.addInstruction(71);
        return result;
    }

    public InstructionList reduce_returnValue(IASNode iNode, InstructionList value) {
        this.currentScope.getMethodBodySemanticChecker().checkReturnValue(iNode);
        return this.reduce_returnWithSideEffects(iNode, value, 72);
    }

    public InstructionList reduce_returnVoidValue(IASNode iNode, InstructionList no_value) {
        this.currentScope.getMethodBodySemanticChecker().checkReturnVoid(iNode);
        return this.reduce_returnWithSideEffects(iNode, no_value, 71);
    }

    private InstructionList reduce_returnWithSideEffects(IASNode iNode, InstructionList value, int opcode) {
        InstructionList result = this.createInstructionList(iNode);
        result.addAll(value);
        Binding result_temp = null;
        boolean need_temp = this.currentScope.getFlowManager().hasNontrivialFlowCharacteristics();
        if (need_temp) {
            result_temp = this.currentScope.allocateTemp();
            result.addInstruction(result_temp.setlocal());
        }
        InstructionList controlFlowStub = null;
        FunctionDefinition function_def = SemanticUtils.getFunctionDefinition(iNode);
        if (need_temp) {
            controlFlowStub = this.createInstructionList(iNode);
            controlFlowStub.addInstruction(result_temp.getlocal());
            this.addRelevantReturnOpcode(function_def, opcode, controlFlowStub);
        } else {
            this.addRelevantReturnOpcode(function_def, opcode, result);
        }
        try {
            if (need_temp) {
                result.addAll(this.getNonLocalControlFlow(controlFlowStub, ControlFlowContextManager.FIND_ALL_CONTEXTS));
            } else {
                InstructionList prev_result = result;
                result = this.getNonLocalControlFlow(result, ControlFlowContextManager.FIND_ALL_CONTEXTS);
                assert (result == prev_result);
            }
        }
        catch (UnknownControlFlowTargetException cant_return) {
            this.currentScope.addProblem(new UnexpectedReturnProblem(iNode));
            return this.createInstructionList(iNode);
        }
        return result;
    }

    public InstructionList reduce_returnVoid(IASNode iNode) {
        InstructionList result = this.createInstructionList(iNode, 1);
        this.currentScope.getMethodBodySemanticChecker().checkReturnVoid(iNode);
        FunctionDefinition functionDef = SemanticUtils.getFunctionDefinition(iNode);
        this.addRelevantReturnOpcode(functionDef, 71, result);
        try {
            return this.getNonLocalControlFlow(result, ControlFlowContextManager.FIND_ALL_CONTEXTS);
        }
        catch (UnknownControlFlowTargetException cant_return) {
            this.currentScope.addProblem(new UnexpectedReturnProblem(iNode));
            return this.createInstructionList(iNode);
        }
    }

    private void addRelevantReturnOpcode(FunctionDefinition functionDef, int opcode, InstructionList result) {
        if (this.currentScope.insideInlineFunction()) {
            Label inlinedFunctionCallSiteLabel = ((InlineFunctionLexicalScope)this.currentScope).getInlinedFunctionCallSiteLabel();
            switch (opcode) {
                case 71: {
                    TypeDefinitionBase returnType;
                    result.addInstruction(33);
                    if (functionDef != null && (returnType = (TypeDefinitionBase)functionDef.resolveReturnType(this.currentScope.getProject())) != null && !returnType.equals(ClassDefinition.getVoidClassDefinition()) && !returnType.equals(ClassDefinition.getAnyTypeClassDefinition())) {
                        result.addInstruction(128, returnType.getMName(this.currentScope.getProject()));
                    }
                    result.addInstruction(16, inlinedFunctionCallSiteLabel);
                    break;
                }
                case 72: {
                    result.addInstruction(16, inlinedFunctionCallSiteLabel);
                    break;
                }
                default: {
                    result.addInstruction(opcode);
                    break;
                }
            }
        } else {
            result.addInstruction(opcode);
        }
    }

    public InstructionList reduce_runtimeNameExpression(IASNode iNode, InstructionList expr) {
        return expr;
    }

    public Binding reduce_simpleName(IASNode iNode) {
        Binding result;
        IdentifierNode identifier = (IdentifierNode)iNode;
        if (identifier.getName().equals("*") && SemanticUtils.isE4XWildcardProperty(identifier)) {
            ICompilerProject project = this.currentScope.getProject();
            Nsset qualifiers = SemanticUtils.getOpenNamespaces(iNode, project);
            Name name = new Name(9, qualifiers, null);
            result = new Binding(iNode, name, identifier.resolve(project));
        } else {
            result = this.currentScope.resolveName(identifier);
            this.currentScope.getMethodBodySemanticChecker().checkSimpleName(iNode, result);
        }
        return result;
    }

    public Name reduce_declName(IASNode iNode) {
        BaseDefinitionNode bdn = (BaseDefinitionNode)iNode.getAncestorOfType(BaseDefinitionNode.class);
        DefinitionBase db = bdn.getDefinition();
        Name n = db.getMName(this.currentScope.getProject());
        return n;
    }

    public InstructionList reduce_strictneqExpr(IASNode iNode, InstructionList l, InstructionList r) {
        InstructionList result = this.binaryOp(iNode, l, r, 172);
        result.addInstruction(150);
        return result;
    }

    public Binding reduce_superAccess(IASNode iNode, Binding qualified_name) {
        this.currentScope.getMethodBodySemanticChecker().checkSuperAccess(iNode);
        qualified_name.setSuperQualified(true);
        return qualified_name;
    }

    public InstructionList reduce_superCallExpr(IASNode iNode, Vector<InstructionList> args) {
        this.currentScope.getMethodBodySemanticChecker().checkExplicitSuperCall(iNode, args);
        InstructionList result = this.createInstructionList(iNode);
        result.addInstruction(208);
        for (InstructionList arg : args) {
            result.addAll(arg);
        }
        result.addInstruction(73, args.size());
        return result;
    }

    public InstructionList reduce_switchStmt(IASNode iNode, InstructionList switch_expr, Vector<ConditionalFragment> cases) {
        if (cases.size() == 0) {
            return this.reduce_trivial_switchStmt(iNode, switch_expr);
        }
        ExpressionNodeBase conditional = ((SwitchNode)iNode).getConditionalNode();
        LookupSwitchInfo lookupSwitchInfo = this.getLookupSwitchInfo(conditional, cases);
        if (lookupSwitchInfo != null) {
            return this.reduce_lookup_switchStmt(iNode, switch_expr, cases, lookupSwitchInfo);
        }
        return this.reduce_ifelse_switchStmt(iNode, switch_expr, cases);
    }

    private LookupSwitchInfo getLookupSwitchInfo(IExpressionNode conditional, Vector<ConditionalFragment> cases) {
        ITypeDefinition conditionalType = conditional.resolveType(this.currentScope.getProject());
        if (!SemanticUtils.isBuiltin(conditionalType, IASLanguageConstants.BuiltinType.INT, this.currentScope.getProject()) && !SemanticUtils.isBuiltin(conditionalType, IASLanguageConstants.BuiltinType.UINT, this.currentScope.getProject())) {
            return null;
        }
        LookupSwitchInfo lookupSwitchInfo = new LookupSwitchInfo();
        boolean hasConditionalCases = false;
        for (ConditionalFragment currentCase : cases) {
            if (currentCase.isUnconditionalAlternative()) {
                lookupSwitchInfo.defaultCase = currentCase;
                continue;
            }
            if (currentCase.constantCondition == null) {
                return null;
            }
            assert (SemanticUtils.isBuiltin(conditionalType, IASLanguageConstants.BuiltinType.INT, this.currentScope.getProject()) || SemanticUtils.isBuiltin(conditionalType, IASLanguageConstants.BuiltinType.UINT, this.currentScope.getProject())) : "only switching on type int or uint supported";
            long value = SemanticUtils.isBuiltin(conditionalType, IASLanguageConstants.BuiltinType.UINT, this.currentScope.getProject()) ? ECMASupport.toUInt32(currentCase.constantCondition) : (long)ECMASupport.toInt32(currentCase.constantCondition);
            if (value > Integer.MAX_VALUE || value < Integer.MIN_VALUE) {
                return null;
            }
            lookupSwitchInfo.minCase = Math.min((int)value, lookupSwitchInfo.minCase);
            lookupSwitchInfo.maxCase = Math.max((int)value, lookupSwitchInfo.maxCase);
            hasConditionalCases = true;
        }
        if (!hasConditionalCases) {
            return null;
        }
        int range = lookupSwitchInfo.maxCase - lookupSwitchInfo.minCase;
        if (range > 20 && range < cases.size() * 2) {
            return null;
        }
        if (range > 18) {
            return null;
        }
        return lookupSwitchInfo;
    }

    private InstructionList reduce_lookup_switchStmt(IASNode iNode, InstructionList switch_expr, Vector<ConditionalFragment> cases, LookupSwitchInfo lookupSwitchInfo) {
        InstructionList result = this.createInstructionList(iNode);
        result.addAll(switch_expr);
        result.addInstruction(115);
        int caseOffset = 0;
        if (lookupSwitchInfo.minCase > 0) {
            caseOffset = lookupSwitchInfo.minCase;
            lookupSwitchInfo.minCase = 0;
            lookupSwitchInfo.maxCase -= caseOffset;
            result.addInstruction(45, (Object)caseOffset);
            result.addInstruction(198);
        } else if (lookupSwitchInfo.minCase < 0) {
            caseOffset = lookupSwitchInfo.minCase;
            lookupSwitchInfo.minCase = 0;
            lookupSwitchInfo.maxCase -= caseOffset;
            result.addInstruction(45, new Integer(lookupSwitchInfo.minCase + 1));
            result.addInstruction(197);
        }
        Label switchTail = null;
        Label defaultLabel = lookupSwitchInfo.defaultCase != null ? lookupSwitchInfo.defaultCase.getLabel() : (switchTail = new Label());
        Object[] caseLabels = new Label[lookupSwitchInfo.maxCase + 2];
        Arrays.fill(caseLabels, defaultLabel);
        for (ConditionalFragment current_case : cases) {
            if (current_case.isUnconditionalAlternative()) continue;
            Object caseValue = current_case.constantCondition;
            if (caseValue instanceof Double) {
                caseValue = new Integer(((Double)caseValue).intValue());
            }
            assert (caseValue instanceof Integer) : "reduce_lookup_switchStmt called on non integer case value";
            int index = (Integer)caseValue - caseOffset;
            if (caseLabels[index] != defaultLabel) continue;
            caseLabels[index] = current_case.getLabel();
        }
        result.addInstruction(27, caseLabels);
        Label default_case_label = null;
        for (ConditionalFragment current_case : cases) {
            if (current_case.isUnconditionalAlternative()) {
                if (default_case_label == null) {
                    default_case_label = current_case.statement.getLabel();
                } else {
                    this.currentScope.addProblem(new MultipleSwitchDefaultsProblem(current_case.site));
                }
            }
            result.addAll(current_case.statement);
        }
        switchTail = this.addInterstitialControlFlow(result, switchTail);
        this.currentScope.getFlowManager().finishSwitchControlFlowContext(result);
        if (switchTail != null) {
            result.labelNext(switchTail);
        }
        return result;
    }

    private InstructionList reduce_ifelse_switchStmt(IASNode iNode, InstructionList switch_expr, Vector<ConditionalFragment> cases) {
        assert (cases.size() > 0) : "reduce_ifelse_switchStmt called on switch stmt with no cases";
        this.convertConstantValueConditionsToInstructions(cases);
        InstructionList result = this.createInstructionList(iNode);
        Label default_case_label = null;
        Label switch_tail = null;
        Binding switch_temp = this.currentScope.allocateTemp();
        result.addAll(switch_expr);
        result.addInstruction(switch_temp.setlocal());
        if (!cases.elementAt(0).isUnconditionalAlternative() || cases.size() == 1) {
            result.addInstruction(16, cases.elementAt(0).getLabel());
        } else {
            result.addInstruction(16, cases.elementAt(1).getLabel());
        }
        for (ConditionalFragment current_case : cases) {
            if (current_case.statement.isEmpty() || current_case.statement.firstElement().getOpcode() != 9) {
                InstructionList labeled_list = this.createInstructionList(iNode);
                labeled_list.addInstruction(9);
                labeled_list.addAll(current_case.statement);
                current_case.statement = labeled_list;
            }
            if (current_case.isUnconditionalAlternative()) {
                if (default_case_label == null) {
                    default_case_label = current_case.statement.getLabel();
                } else {
                    this.currentScope.addProblem(new MultipleSwitchDefaultsProblem(current_case.site));
                }
            }
            current_case.getStatementLabel();
            result.addAll(current_case.statement);
        }
        switch_tail = this.addInterstitialControlFlow(result, null);
        for (ConditionalFragment current_case : cases) {
            if (current_case.isUnconditionalAlternative()) continue;
            result.addAll(current_case.condition);
            result.addInstruction(switch_temp.getlocal());
            result.addInstruction(25, current_case.getStatementLabel());
        }
        if (default_case_label != null) {
            result.addInstruction(16, default_case_label);
        }
        this.currentScope.releaseTemp(switch_temp);
        this.currentScope.getFlowManager().finishSwitchControlFlowContext(result);
        if (switch_tail != null) {
            result.labelNext(switch_tail);
        }
        return result;
    }

    private InstructionList reduce_trivial_switchStmt(IASNode iNode, InstructionList switch_expr) {
        InstructionList result = this.createInstructionList(iNode);
        result.addAll(switch_expr);
        result.addInstruction(41);
        this.currentScope.getFlowManager().finishSwitchControlFlowContext(result);
        return result;
    }

    private void convertConstantValueConditionsToInstructions(Vector<ConditionalFragment> cases) {
        for (ConditionalFragment current_case : cases) {
            current_case.convertConstantConditionToInstruction();
            if (!current_case.isConstantConditional()) continue;
            current_case.condition = this.transform_constant_value(current_case.site, current_case.constantCondition);
        }
    }

    public InstructionList reduce_ternaryExpr(IASNode iNode, InstructionList test, InstructionList when_true, InstructionList when_false) {
        IBinaryOperatorNode binaryNode = (IBinaryOperatorNode)iNode.getAncestorOfType(IBinaryOperatorNode.class);
        boolean isBracketAssign = binaryNode != null && binaryNode.getOperator() == IOperatorNode.OperatorType.ASSIGNMENT && binaryNode.getLeftOperandNode() instanceof DynamicAccessNode;
        ITypeDefinition destinationType = null;
        if (isBracketAssign) {
            destinationType = binaryNode.getLeftOperandNode().resolveType(this.currentScope.getProject());
        }
        TernaryOperatorNode ternaryNode = (TernaryOperatorNode)iNode;
        boolean need_coerce = false;
        InstructionList result = this.createInstructionList(iNode, test.size() + when_true.size() + when_false.size() + 2);
        Label tail = new Label();
        result.addAll(test);
        result.addInstruction(18, when_false.getLabel());
        result.addAll(when_true);
        IExpressionNode valueNode = ternaryNode.getLeftOperandNode();
        ITypeDefinition type_def = valueNode.resolveType(this.currentScope.getProject());
        boolean bl = need_coerce = type_def != null && !type_def.equals(destinationType);
        if (need_coerce && isBracketAssign) {
            this.coerce(result, destinationType);
        }
        result.addInstruction(16, tail);
        result.addAll(when_false);
        valueNode = ternaryNode.getRightOperandNode();
        type_def = valueNode.resolveType(this.currentScope.getProject());
        boolean bl2 = need_coerce = type_def != null && !type_def.equals(destinationType);
        if (need_coerce && isBracketAssign) {
            this.coerce(result, destinationType);
        }
        result.labelNext(tail);
        return result;
    }

    public InstructionList reduce_throwStmt(IASNode iNode, InstructionList tossable) {
        this.currentScope.getMethodBodySemanticChecker().checkThrow(iNode);
        InstructionList result = this.createInstructionList(iNode, tossable.size() + 1);
        result.addAll(tossable);
        result.addInstruction(3);
        return result;
    }

    public InstructionList reduce_tryCatchFinallyStmt(IASNode iNode, InstructionList try_stmt, InstructionList finally_stmt, Vector<CatchPrototype> catch_blocks) {
        InstructionList result = this.generateTryCatchFinally(try_stmt, catch_blocks, finally_stmt);
        this.currentScope.getFlowManager().finishExceptionContext();
        return result;
    }

    public InstructionList reduce_tryCatchStmt(IASNode iNode, InstructionList try_stmt, Vector<CatchPrototype> catch_blocks) {
        InstructionList result = this.createInstructionList(iNode);
        if (try_stmt.isEmpty()) {
            try_stmt = this.createInstructionList(iNode);
            try_stmt.addInstruction(2);
        }
        Label catch_tail = new Label();
        result.addAll(try_stmt);
        result.addInstruction(16, catch_tail);
        Label try_start = result.getLabel();
        Label try_end = result.getLastLabel();
        for (CatchPrototype catch_proto : catch_blocks) {
            boolean is_last_catch = catch_proto.equals(catch_blocks.lastElement());
            InstructionList catch_body = this.generateCatchBlock(try_start, try_end, catch_proto);
            if (!is_last_catch && catch_body.canFallThrough()) {
                catch_body.addInstruction(16, catch_tail);
            }
            result.addAll(catch_body);
        }
        this.currentScope.getFlowManager().finishExceptionContext();
        result.labelNext(catch_tail);
        return result;
    }

    public InstructionList reduce_tryFinallyStmt(IASNode iNode, InstructionList try_stmt, InstructionList finally_stmt) {
        InstructionList result = this.generateTryCatchFinally(try_stmt, null, finally_stmt);
        this.currentScope.getFlowManager().finishExceptionContext();
        return result;
    }

    public InstructionList reduce_typedFunction_to_statement(IASNode iNode, InstructionList plist, Binding return_type, InstructionList block) {
        Binding nestedFunctionName = this.currentScope.resolveName((IdentifierNode)SemanticUtils.getNthChild(iNode, 0));
        InstructionList result = this.createInstructionList(iNode);
        this.generateNestedFunction(iNode, this.miniScopes.empty() ? result : this.miniScopes.peek(), nestedFunctionName, return_type.getName(), block);
        this.currentScope.getMethodBodySemanticChecker().checkNestedFunctionDecl((IFunctionNode)iNode);
        return result;
    }

    public InstructionList reduce_typedVariableDecl(IASNode iNode, Name var_name, Binding var_type, Vector<InstructionList> chained_decls) {
        BaseVariableNode var_node = (BaseVariableNode)iNode;
        this.currentScope.getMethodBodySemanticChecker().checkVariableDeclaration(iNode);
        boolean needsHoistedInitInsns = this.currentScope.needsHoistedInitInsns(var_name, false);
        Binding var = this.currentScope.resolveName((IdentifierNode)var_node.getNameExpressionNode());
        this.currentScope.makeVariable(var, var_type.getName(), ((BaseDefinitionNode)iNode).getMetaInfos());
        if (needsHoistedInitInsns) {
            this.addHoistedInstructionsForVarDecl(var_name, var_type);
        }
        InstructionList result = this.createInstructionList(iNode);
        for (InstructionList decl : chained_decls) {
            result.addAll(decl);
        }
        return result;
    }

    private void addHoistedInstructionsForVarDecl(Name var_name, Binding var_type) {
        Binding var_binding = this.currentScope.getLocalBinding(var_name);
        if (var_binding != null && var_binding.isLocal()) {
            InstructionList init_insns = this.currentScope.getHoistedInitInstructions();
            ICompilerProject project = this.currentScope.getProject();
            IDefinition type_def = var_type.getDefinition();
            if (type_def == project.getBuiltinType(IASLanguageConstants.BuiltinType.INT) || type_def == project.getBuiltinType(IASLanguageConstants.BuiltinType.UINT)) {
                init_insns.addInstruction(36, 0);
                init_insns.addInstruction(var_binding.setlocal());
            } else if (type_def == project.getBuiltinType(IASLanguageConstants.BuiltinType.BOOLEAN)) {
                init_insns.addInstruction(39);
                init_insns.addInstruction(var_binding.setlocal());
            } else if (type_def == project.getBuiltinType(IASLanguageConstants.BuiltinType.NUMBER)) {
                init_insns.addInstruction(40);
                init_insns.addInstruction(var_binding.setlocal());
            } else if (type_def == project.getBuiltinType(IASLanguageConstants.BuiltinType.ANY_TYPE)) {
                init_insns.addInstruction(33);
                init_insns.addInstruction(var_binding.setlocal());
            } else if (type_def instanceof ITypeDefinition && ((ITypeDefinition)type_def).isInstanceOf(project.getBuiltinType(IASLanguageConstants.BuiltinType.OBJECT), project)) {
                init_insns.addInstruction(32);
                init_insns.addInstruction(var_binding.setlocal());
            } else {
                init_insns.addInstruction(33);
                init_insns.addInstruction(var_binding.setlocal());
            }
        }
    }

    public InstructionList reduce_typedVariableDeclWithInitializer(IASNode iNode, Name var_name, Binding var_type, InstructionList var_initializer, Vector<InstructionList> chained_decls) {
        BaseVariableNode var_node = (BaseVariableNode)iNode;
        this.currentScope.getMethodBodySemanticChecker().checkVariableDeclaration(iNode);
        boolean refedBeforeInited = this.currentScope.needsHoistedInitInsns(var_name, true);
        Binding var = this.currentScope.resolveName((IdentifierNode)var_node.getNameExpressionNode());
        this.currentScope.makeVariable(var, var_type.getName(), ((BaseDefinitionNode)iNode).getMetaInfos());
        if (refedBeforeInited) {
            this.addHoistedInstructionsForVarDecl(var_name, var_type);
        }
        this.currentScope.getMethodBodySemanticChecker().checkInitialization(iNode, var);
        InstructionList result = this.generateAssignment(iNode, var, var_initializer);
        for (InstructionList decl : chained_decls) {
            result.addAll(decl);
        }
        return result;
    }

    public InstructionList reduce_typedVariableDeclWithConstantInitializer(IASNode iNode, Name var_name, Binding var_type, Object constant_var_initializer, Vector<InstructionList> chained_decls) {
        BaseVariableNode var_node = (BaseVariableNode)iNode;
        PooledValue transformed_constant_initializer = this.currentScope.getMethodBodySemanticChecker().checkInitialValue(var_node, var_type, new PooledValue(constant_var_initializer));
        if (!SemanticUtils.isConst(iNode, this.currentScope.getProject())) {
            InstructionList var_initializer = this.transform_pooled_value(iNode, transformed_constant_initializer);
            return this.reduce_typedVariableDeclWithInitializer(iNode, var_name, var_type, var_initializer, chained_decls);
        }
        this.currentScope.getMethodBodySemanticChecker().checkVariableDeclaration(iNode);
        InstructionList result = this.createInstructionList(iNode);
        Binding var = this.currentScope.resolveName((IdentifierNode)var_node.getNameExpressionNode());
        this.currentScope.makeVariable(var, var_type.getName(), ((BaseDefinitionNode)iNode).getMetaInfos(), transformed_constant_initializer.getValue());
        if (var.isLocal()) {
            InstructionList var_initializer = this.transform_pooled_value(iNode, transformed_constant_initializer);
            this.currentScope.getHoistedInitInstructions().addAll(this.reduce_typedVariableDeclWithInitializer(iNode, var_name, var_type, var_initializer, new Vector<InstructionList>()));
        }
        for (InstructionList decl : chained_decls) {
            result.addAll(decl);
        }
        return result;
    }

    public InstructionList reduce_typedBindableVariableDecl(IASNode iNode, Name name, Binding var_type, Vector<InstructionList> chained_decls) {
        BaseVariableNode vn = (BaseVariableNode)iNode;
        this.currentScope.getMethodBodySemanticChecker().checkBindableVariableDeclaration(iNode, vn.getDefinition());
        InstructionList result = this.createInstructionList(iNode);
        Binding var = this.currentScope.resolveName((IdentifierNode)vn.getNameExpressionNode());
        this.currentScope.makeBindableVariable(var, var_type.getName(), vn.getMetaInfos());
        for (InstructionList decl : chained_decls) {
            result.addAll(decl);
        }
        return result;
    }

    public InstructionList reduce_typedBindableVariableDeclWithInitializer(IASNode iNode, Name var_name, Binding var_type, InstructionList var_initializer, Vector<InstructionList> chained_decls) {
        BaseVariableNode vn = (BaseVariableNode)iNode;
        this.currentScope.getMethodBodySemanticChecker().checkBindableVariableDeclaration(iNode, vn.getDefinition());
        Binding var = this.currentScope.resolveName((IdentifierNode)vn.getNameExpressionNode());
        this.currentScope.makeBindableVariable(var, var_type.getName(), vn.getMetaInfos());
        InstructionList result = this.generateAssignment(iNode, new Binding(iNode, BindableHelper.getBackingPropertyName(var_name), null), var_initializer);
        for (InstructionList decl : chained_decls) {
            result.addAll(decl);
        }
        return result;
    }

    public Binding reduce_typedVariableExpression(IASNode iNode, Name var_name, Binding var_type) {
        VariableExpressionNode var_expr_node = (VariableExpressionNode)iNode;
        BaseVariableNode var_node = (BaseVariableNode)var_expr_node.getTargetVariable();
        this.currentScope.getMethodBodySemanticChecker().checkVariableDeclaration(SemanticUtils.getNthChild(iNode, 0));
        Binding var = this.currentScope.resolveName((IdentifierNode)var_node.getNameExpressionNode());
        this.currentScope.makeVariable(var, var_type.getName(), var_node.getMetaInfos());
        return var;
    }

    public InstructionList reduce_typelessFunction(IASNode iNode, InstructionList plist, InstructionList block) {
        Binding nestedFunctionName = this.currentScope.resolveName((IdentifierNode)SemanticUtils.getNthChild(iNode, 0));
        InstructionList result = this.createInstructionList(iNode);
        this.generateNestedFunction(iNode, this.miniScopes.empty() ? result : this.miniScopes.peek(), nestedFunctionName, null, block);
        this.currentScope.getMethodBodySemanticChecker().checkNestedFunctionDecl((IFunctionNode)iNode);
        return result;
    }

    public InstructionList reduce_typeof_expr(IASNode iNode, InstructionList operand) {
        InstructionList result = this.unaryOp(iNode, operand, 149);
        --this.typeofCount;
        return result;
    }

    public InstructionList reduce_typeof_name(IASNode iNode, Binding binding) {
        InstructionList result = null;
        if (binding.getDefinition() != null) {
            ICompilerProject project;
            ITypeDefinition typezo = binding.getDefinition().resolveType(this.currentScope.getProject());
            if (typezo == (project = this.currentScope.getProject()).getBuiltinType(IASLanguageConstants.BuiltinType.STRING)) {
                result = this.createInstructionList(iNode);
                result.addInstruction(44, "string");
            } else if (typezo == project.getBuiltinType(IASLanguageConstants.BuiltinType.NUMBER) || typezo == project.getBuiltinType(IASLanguageConstants.BuiltinType.INT) || typezo == project.getBuiltinType(IASLanguageConstants.BuiltinType.UINT)) {
                result = this.createInstructionList(iNode);
                result.addInstruction(44, "number");
            } else if (typezo == project.getBuiltinType(IASLanguageConstants.BuiltinType.BOOLEAN)) {
                result = this.createInstructionList(iNode);
                result.addInstruction(44, "boolean");
            }
        }
        if (result == null) {
            result = this.createInstructionList(iNode);
            this.generateAccess(binding, AccessType.Lenient, result);
            result.addInstruction(149);
        }
        --this.typeofCount;
        return result;
    }

    public InstructionList reduce_useNamespaceDirective(IASNode iNode, Binding ns_name) {
        this.currentScope.getMethodBodySemanticChecker().checkUseNamespaceDirective(iNode, ns_name);
        return this.createInstructionList(iNode);
    }

    public InstructionList reduce_variableExpression(IASNode iNode, Vector<InstructionList> decls) {
        InstructionList result = this.createInstructionList(iNode);
        for (InstructionList var_decl : decls) {
            result.addAll(var_decl);
        }
        return result;
    }

    public InstructionList reduce_vectorLiteral(IASNode iNode, Binding type_param, Vector<InstructionList> elements) {
        this.currentScope.getMethodBodySemanticChecker().checkVectorLiteral(iNode, type_param);
        InstructionList result = this.createInstructionList(iNode);
        Nsset ns_set = new Nsset(new Namespace(22, "__AS3__.vec"));
        Name vector_name = new Name(7, ns_set, "Vector");
        result.addAll(this.currentScope.getPropertyValue(vector_name, this.currentScope.getProject().getBuiltinType(IASLanguageConstants.BuiltinType.VECTOR)));
        this.generateTypeNameParameter(type_param, result);
        result.addInstruction(83, 1);
        result.pushNumericConstant(elements.size());
        result.addInstruction(66, 1);
        Instruction setter = this.arrayAccess(iNode, 97);
        for (int i = 0; i < elements.size(); ++i) {
            result.addInstruction(42);
            result.pushNumericConstant(i);
            result.addAll(elements.elementAt(i));
            result.addInstruction(setter);
        }
        return result;
    }

    public InstructionList reduce_voidExpr_to_expression(IASNode iNode) {
        InstructionList il = this.createInstructionList(iNode);
        il.addInstruction(33);
        return il;
    }

    public Binding reduce_voidExpr_to_return_type_name(IASNode node) {
        return new Binding(node, voidType, null);
    }

    public Binding reduce_voidExpr_to_type_name(IASNode node) {
        this.getProblems().add(new VoidTypeProblem(node));
        return new Binding(node, voidType, null);
    }

    public Object reduce_void0Literal_to_constant_value(IASNode iNode) {
        return ABCConstants.UNDEFINED_VALUE;
    }

    public InstructionList reduce_void0Literal_to_object_literal(IASNode iNode) {
        InstructionList result = this.createInstructionList(iNode, 1);
        result.addInstruction(33);
        return result;
    }

    public InstructionList reduce_instructionListExpression(IASNode iNode) {
        return ((InstructionListNode)iNode).getInstructions();
    }

    public InstructionList reduce_void0Operator(IASNode iNode) {
        InstructionList result = this.createInstructionList(iNode, 1);
        result.addInstruction(33);
        return result;
    }

    public Object reduce_voidOperator_to_constant_value(IASNode iNode, Object constant_value) {
        return ABCConstants.UNDEFINED_VALUE;
    }

    public InstructionList reduce_voidOperator_to_expression(IASNode iNode, InstructionList expr) {
        InstructionList result = this.createInstructionList(iNode, 1);
        result.addAll(expr);
        result.addInstruction(41);
        result.addInstruction(33);
        return result;
    }

    public InstructionList reduce_whileStmt(IASNode iNode, InstructionList cond, InstructionList body) {
        InstructionList result = this.createInstructionList(iNode, cond.size() + body.size() + 5);
        this.currentScope.getFlowManager().resolveContinueLabel(cond);
        result.addInstruction(16, cond.getLabel());
        result.addInstruction(9);
        Label loop = result.getLastLabel();
        result.addAll(body);
        result.addAll(cond);
        result.addInstruction(17, loop);
        this.currentScope.getFlowManager().finishLoopControlFlowContext(result);
        return result;
    }

    public InstructionList reduce_withStmt(IASNode iNode, InstructionList new_scope, InstructionList body) {
        InstructionList result = this.createInstructionList(iNode);
        result.addAll(new_scope);
        if (this.currentScope.getFlowManager().hasWithStorage()) {
            result.addInstruction(42);
            result.addInstruction(this.currentScope.getFlowManager().getWithStorage().setlocal());
        }
        result.addInstruction(28);
        result.addAll(body);
        result.addInstruction(29);
        this.currentScope.getFlowManager().finishWithContext(result);
        return result;
    }

    public InstructionList reduce_XMLContent(IASNode iNode, Vector<InstructionList> exprs) {
        InstructionList result = this.createInstructionList(iNode);
        result.addAll(this.currentScope.getPropertyValue(xmlType, this.currentScope.getProject().getBuiltinType(IASLanguageConstants.BuiltinType.XML)));
        XMLContentState[] content_state = this.computeXMLContentStateMatrix(exprs);
        result.addAll(exprs.elementAt(0));
        for (int i = 1; i < exprs.size(); ++i) {
            result.addAll(exprs.elementAt(i));
            switch (content_state[i]) {
                case TagName: {
                    result.addInstruction(44, " ");
                    result.addInstruction(160);
                    break;
                }
                case Attr: {
                    if (content_state[i - 1] == XMLContentState.TagName) break;
                    result.addInstruction(44, " ");
                    result.addInstruction(43);
                    result.addInstruction(160);
                    break;
                }
                case ValueNeedsEquals: {
                    if (content_state[i - 1] == XMLContentState.Attr) {
                        result.addInstruction(44, "=");
                        result.addInstruction(43);
                        result.addInstruction(160);
                    }
                }
                case Value: {
                    result.addInstruction(114);
                    result.addInstruction(44, "\"");
                    result.addInstruction(43);
                    result.addInstruction(160);
                    result.addInstruction(44, "\"");
                    result.addInstruction(160);
                    break;
                }
                case ContentExpression: {
                    result.addInstruction(113);
                }
            }
            result.addInstruction(160);
        }
        result.addInstruction(66, 1);
        return result;
    }

    public InstructionList reduce_XMLList(IASNode iNode, Vector<InstructionList> exprs) {
        InstructionList result = this.createInstructionList(iNode);
        result.addAll(this.currentScope.getPropertyValue(xmlListType, this.currentScope.getProject().getBuiltinType(IASLanguageConstants.BuiltinType.XMLLIST)));
        result.addAll(exprs.get(1));
        for (int i = 2; i < exprs.size() - 1; ++i) {
            result.addAll(exprs.get(i));
            result.addInstruction(160);
        }
        result.addInstruction(66, 1);
        return result;
    }

    public InstructionList reduce_XMLListConst(IASNode iNode, Vector<String> elements) {
        InstructionList result = this.createInstructionList(iNode);
        result.addAll(this.currentScope.getPropertyValue(xmlListType, this.currentScope.getProject().getBuiltinType(IASLanguageConstants.BuiltinType.XMLLIST)));
        StringBuilder buffer = new StringBuilder();
        for (int i = 1; i < elements.size() - 1; ++i) {
            buffer.append(elements.elementAt(i));
        }
        result.addInstruction(44, buffer.toString());
        result.addInstruction(66, 1);
        return result;
    }

    InstructionList replicate(InstructionList prototype) {
        return (InstructionList)prototype.clone();
    }

    public void setInstanceInitializers(InstructionList insns) {
        this.instanceInitializers = insns;
    }

    public void setCurrentscope(LexicalScope scope) {
        this.currentScope = scope;
    }

    public InstructionList transform_boolean_constant(IASNode iNode, Boolean boolean_constant) {
        InstructionList result = this.createInstructionList(iNode, 1);
        if (Boolean.TRUE.equals(boolean_constant)) {
            result.addInstruction(38);
        } else {
            result.addInstruction(39);
        }
        return result;
    }

    public InstructionList transform_double_constant(IASNode iNode, Double double_constant) {
        InstructionList result = this.createInstructionList(iNode, 1);
        this.pushNumericConstant(result, double_constant, SemanticUtils.resolveType(iNode, this.currentScope.getProject()));
        return result;
    }

    public InstructionList transform_numeric_constant(IASNode iNode, Number numeric_constant) {
        if (numeric_constant instanceof Integer) {
            return this.transform_integer_constant(iNode, (Integer)numeric_constant);
        }
        if (numeric_constant instanceof Long) {
            return this.transform_long_constant(iNode, (Long)numeric_constant);
        }
        if (numeric_constant instanceof Double) {
            return this.transform_double_constant(iNode, (Double)numeric_constant);
        }
        return this.createInstructionList(iNode, 1);
    }

    public InstructionList transform_pooled_value(IASNode iNode, PooledValue pooled_value) {
        return this.transform_constant_value(iNode, pooled_value.getValue());
    }

    public InstructionList transform_constant_value(IASNode iNode, Object constant_value) {
        assert (!(constant_value instanceof PooledValue)) : "transform_constant_value should not be called with a PooledValue";
        if (constant_value instanceof Boolean) {
            return this.transform_boolean_constant(iNode, (Boolean)constant_value);
        }
        if (constant_value instanceof Number) {
            return this.transform_numeric_constant(iNode, (Number)constant_value);
        }
        if (constant_value instanceof String) {
            return this.transform_string_constant(iNode, (String)constant_value);
        }
        InstructionList result = this.createInstructionList(iNode, 1);
        if (constant_value instanceof Namespace) {
            result.addInstruction(49, constant_value);
        } else if (constant_value == ABCConstants.NULL_VALUE) {
            result.addInstruction(32);
        } else if (constant_value == ABCConstants.UNDEFINED_VALUE) {
            result.addInstruction(33);
        } else assert (false) : "unknown constant type";
        return result;
    }

    public Object transform_string_constant_to_constant(IASNode iNode, String string_constant) {
        return string_constant;
    }

    public Object transform_boolean_constant_to_constant(IASNode iNode, Boolean boolean_constant) {
        return boolean_constant;
    }

    public Object transform_numeric_constant_to_constant(IASNode iNode, Number numeric_constant) {
        return numeric_constant;
    }

    public InstructionList transform_expression_to_conditionalJump(IASNode iNode, InstructionList expression) {
        InstructionList result = this.createInstructionList(iNode, expression.size() + 1);
        result.addAll(expression);
        result.addInstruction(InstructionFactory.getTargetableInstruction(17));
        return result;
    }

    public Object transform_expression_to_constant_value(IASNode iNode, InstructionList expression) {
        return null;
    }

    public InstructionList transform_expression_to_void_expression(IASNode iNode, InstructionList expression) {
        InstructionList result = this.createInstructionList(iNode, expression.size() + 1);
        result.addAll(expression);
        result.addInstruction(41);
        return result;
    }

    public InstructionList transform_integer_constant(IASNode iNode, Integer integer_constant) {
        InstructionList result = this.createInstructionList(iNode, 1);
        this.pushNumericConstant(result, integer_constant, SemanticUtils.resolveType(iNode, this.currentScope.getProject()));
        return result;
    }

    public InstructionList transform_long_constant(IASNode iNode, Long long_constant) {
        InstructionList result = this.createInstructionList(iNode, 1);
        this.pushNumericConstant(result, long_constant, SemanticUtils.resolveType(iNode, this.currentScope.getProject()));
        return result;
    }

    public Object transform_name_to_constant_value(IASNode iNode) {
        this.currentScope.getMethodBodySemanticChecker().checkConstantValue(iNode);
        return SemanticUtils.transformNameToConstantValue(iNode, this.currentScope.getProject());
    }

    public InstructionList transform_name_to_expression(IASNode iNode, Binding name) {
        return this.generateAccess(name, this.determineAccessType(iNode));
    }

    public InstructionList transform_non_resolving_identifier(IASNode iNode, String non_resolving_identifier) {
        InstructionList result = this.createInstructionList(iNode, 1);
        result.addInstruction(44, non_resolving_identifier);
        return result;
    }

    public InstructionList transform_runtime_name_expression(IASNode iNode, RuntimeMultiname runtime_name_expression) {
        return runtime_name_expression.generateRvalue(iNode);
    }

    public InstructionList transform_string_constant(IASNode iNode, String string_constant) {
        InstructionList result = this.createInstructionList(iNode, 1);
        result.addInstruction(44, string_constant);
        return result;
    }

    public InstructionList transform_uint_constant(IASNode iNode, Long uint_constant) {
        InstructionList result = this.createInstructionList(iNode, 1);
        this.pushNumericConstant(result, uint_constant, SemanticUtils.resolveType(iNode, this.currentScope.getProject()));
        return result;
    }

    InstructionList unaryOp(IASNode iNode, InstructionList operand, int opcode) {
        this.checkUnaryOp(iNode, opcode);
        InstructionList result = this.createInstructionList(iNode, operand.size() + 1);
        result.addAll(operand);
        result.addInstruction(opcode);
        return result;
    }

    public void checkUnaryOp(IASNode iNode, int opcode) {
        this.currentScope.getMethodBodySemanticChecker().checkUnaryOperator(iNode, opcode);
    }

    void scanFunctionBodyForActivations(IASNode n) {
        if (n != null) {
            switch (n.getNodeID()) {
                case WithID: 
                case AnonymousFunctionID: 
                case FunctionID: {
                    this.currentScope.setNeedsActivation();
                    break;
                }
                default: {
                    for (int i = 0; i < n.getChildCount(); ++i) {
                        this.scanFunctionBodyForActivations(n.getChild(i));
                    }
                }
            }
        }
    }

    public static boolean isStringLiteral(InstructionList insns) {
        return insns.lastElement().getOpcode() == 44;
    }

    public static String getStringLiteral(InstructionList insns) {
        assert (ABCGeneratingReducer.isStringLiteral(insns));
        return insns.lastElement().getOperand(0).toString();
    }

    private XMLContentState[] computeXMLContentStateMatrix(Vector<InstructionList> exprs) {
        XMLContentState[] result = new XMLContentState[exprs.size()];
        assert (ABCGeneratingReducer.isStringLiteral(exprs.elementAt(0))) : exprs.elementAt(0);
        String first_element = ABCGeneratingReducer.getStringLiteral(exprs.elementAt(0));
        result[0] = first_element.equals("<") || first_element.equals("</") ? XMLContentState.TagStart : XMLContentState.TagLiteral;
        block16: for (int i = 1; i < exprs.size(); ++i) {
            InstructionList insns = exprs.elementAt(i);
            if (ABCGeneratingReducer.isStringLiteral(insns)) {
                switch (result[i - 1]) {
                    case TagName: 
                    case Attr: 
                    case ValueNeedsEquals: 
                    case Value: 
                    case TagStart: 
                    case TagLiteral: {
                        if (ABCGeneratingReducer.getStringLiteral(insns).matches(".*>")) {
                            result[i] = XMLContentState.TagEnd;
                            break;
                        }
                        result[i] = XMLContentState.TagLiteral;
                        break;
                    }
                    case ContentExpression: 
                    case TagEnd: 
                    case ContentLiteral: {
                        result[i] = ABCGeneratingReducer.getStringLiteral(insns).matches("<.*") ? XMLContentState.TagStart : XMLContentState.ContentLiteral;
                    }
                }
                continue;
            }
            switch (result[i - 1]) {
                case TagStart: {
                    result[i] = XMLContentState.TagName;
                    continue block16;
                }
                case TagName: 
                case Value: {
                    result[i] = XMLContentState.Attr;
                    continue block16;
                }
                case Attr: {
                    result[i] = XMLContentState.ValueNeedsEquals;
                    continue block16;
                }
                case ContentExpression: 
                case TagEnd: 
                case ContentLiteral: {
                    result[i] = XMLContentState.ContentExpression;
                    continue block16;
                }
                case TagLiteral: {
                    switch (this.getXMLLiteralContentState(ABCGeneratingReducer.getStringLiteral(exprs.elementAt(i - 1)))) {
                        case TagStart: {
                            result[i] = XMLContentState.TagName;
                            continue block16;
                        }
                        case Attr: {
                            result[i] = XMLContentState.Value;
                            continue block16;
                        }
                        case Value: {
                            result[i] = XMLContentState.Attr;
                            continue block16;
                        }
                    }
                    result[i] = XMLContentState.ContentExpression;
                    continue block16;
                }
                default: {
                    assert (false) : "Unhandled case " + (Object)((Object)result[i - 1]);
                    continue block16;
                }
            }
        }
        return result;
    }

    private XMLContentState getXMLLiteralContentState(String literal) {
        char lastChar = literal.charAt(literal.length() - 1);
        if (lastChar == '<') {
            return XMLContentState.TagStart;
        }
        if (lastChar == '=') {
            return XMLContentState.Attr;
        }
        return XMLContentState.ContentExpression;
    }

    int op_unplus() {
        return 117;
    }

    public InstructionList reduce_arrayIndexExpr_to_mxmlDataBindingSetter(IASNode iNode, InstructionList stem, InstructionList index, boolean isSuper) {
        IDynamicAccessNode arrayIndexNode = (IDynamicAccessNode)iNode;
        int stemInstructionCount = isSuper ? 1 : stem.size();
        InstructionList result = this.createInstructionList(arrayIndexNode, stemInstructionCount + index.size() + 3 + 1);
        if (isSuper) {
            result.addInstruction(208);
        } else {
            result.addAll(stem);
        }
        result.addAll(index);
        result.addInstruction(209);
        int opCode = isSuper ? 5 : 97;
        result.addInstruction(this.arrayAccess(arrayIndexNode, opCode));
        return result;
    }

    public InstructionList reduce_memberAccessExpr_to_mxmlDataBindingSetter(IASNode memberAccessExpr, InstructionList stem, Binding member) {
        this.currentScope.getMethodBodySemanticChecker().checkLValue(memberAccessExpr, member);
        InstructionList result = this.createInstructionList(memberAccessExpr, stem.size() + 2 + 1);
        result.addAll(stem);
        result.addInstruction(209);
        result.addInstruction(97, member.getName());
        return result;
    }

    public InstructionList reduce_qualifiedMemberAccessExpr_to_mxmlDataBindingSetter(IASNode qualifiedMemberAccessExpr, InstructionList stem, Binding qualifier, Binding member) {
        InstructionList result = this.createInstructionList(qualifiedMemberAccessExpr);
        Name member_name = member.getName();
        result.addAll(stem);
        if (!this.isNamespace(qualifier)) {
            this.generateAccess(qualifier, result);
            result.addInstruction(128, namespaceType);
        }
        result.addInstruction(209);
        result.addInstruction(97, member_name);
        return result;
    }

    public InstructionList reduce_qualifiedMemberRuntimeNameExpr_to_mxmlDataBindingSetter(IASNode qualifiedMemberRuntimeExpr, InstructionList stem, Binding qualifier, InstructionList runtime_member) {
        InstructionList result = this.createInstructionList(qualifiedMemberRuntimeExpr);
        result.addAll(stem);
        if (this.isNamespace(qualifier)) {
            result.addAll(runtime_member);
            NamespaceDefinition ns_def = (NamespaceDefinition)qualifier.getDefinition();
            Name qualified_name = new Name(27, new Nsset(ns_def.resolveAETNamespace(this.currentScope.getProject())), null);
            result.addInstruction(209);
            result.addInstruction(97, qualified_name);
        } else {
            this.generateAccess(qualifier, result);
            result.addInstruction(128, namespaceType);
            result.addAll(runtime_member);
            result.addInstruction(209);
            result.addInstruction(97, new Name(17, null, null));
        }
        return result;
    }

    public InstructionList reduceRuntimeName_to_mxmlDataBindingSetter(IASNode runtimeNameNode, RuntimeMultiname runtime_name_expression) {
        InstructionList rhs = new InstructionList(1);
        rhs.addInstruction(209);
        return runtime_name_expression.generateGetOrSet(runtimeNameNode, 97, rhs);
    }

    public InstructionList reduceName_to_mxmlDataBindingSetter(IASNode nameNode, Binding name) {
        this.currentScope.getMethodBodySemanticChecker().checkLValue(nameNode, name);
        InstructionList result = new InstructionList(4);
        result.addAll(this.currentScope.findProperty(name, true));
        result.addInstruction(209);
        result.addInstruction(97, name.getName());
        return result;
    }

    private Instruction arrayAccess(IASNode iNode, int opcode) {
        IExpressionNode arrayNode;
        ICompilerProject project = this.currentScope.getProject();
        ITypeDefinition superDef = null;
        if (iNode instanceof IDynamicAccessNode && (arrayNode = ((IDynamicAccessNode)iNode).getLeftOperandNode()) instanceof ILanguageIdentifierNode && ((ILanguageIdentifierNode)((Object)arrayNode)).getKind() == ILanguageIdentifierNode.LanguageIdentifierKind.SUPER) {
            IIdentifierNode superNode = (IIdentifierNode)arrayNode;
            superDef = superNode.resolveType(project);
        }
        Nsset nsSet = superDef != null ? SemanticUtils.getOpenNamespacesForSuper(iNode, project, superDef) : SemanticUtils.getOpenNamespaces(iNode, project);
        Name name = new Name(27, nsSet, null);
        return InstructionFactory.getInstruction(opcode, name);
    }

    private AccessType determineAccessType(IASNode iNode) {
        MemberAccessExpressionNode maen;
        if (iNode.getParent() instanceof MemberAccessExpressionNode && !(maen = (MemberAccessExpressionNode)iNode.getParent()).isMemberReference(iNode)) {
            return AccessType.Strict;
        }
        return this.typeofCount > 0 ? AccessType.Lenient : AccessType.Strict;
    }

    private static enum XMLContentState {
        TagStart,
        TagLiteral,
        TagName,
        Attr,
        ValueNeedsEquals,
        Value,
        TagEnd,
        ContentLiteral,
        ContentExpression;

    }

    private static class LookupSwitchInfo {
        public int minCase = Integer.MAX_VALUE;
        public int maxCase = Integer.MIN_VALUE;
        public ConditionalFragment defaultCase;

        private LookupSwitchInfo() {
        }
    }

    private static enum AccessType {
        Strict,
        Lenient;

    }

    private static class DebugInfoInstructionList
    extends InstructionList {
        public static final int NO_LINE = -1;
        private int line_num = -1;

        DebugInfoInstructionList(int capacity) {
            super(capacity);
        }

        DebugInfoInstructionList() {
        }

        void setDebugLine(int line_num) {
            this.line_num = line_num;
        }

        @Override
        public Instruction addInstruction(Instruction insn) {
            if (this.line_num != -1 && insn.isExecutable()) {
                int line = this.line_num;
                this.line_num = -1;
                this.addInstruction(240, line);
            }
            return super.addInstruction(insn);
        }
    }

    private class ForKeyValueLoopState {
        Label test = new Label();
        Label loop = new Label();
        LexicalScope.Hasnext2Wrapper hasnext = ABCGeneratingReducer.access$000(ABCGeneratingReducer.this).hasnext2();

        private ForKeyValueLoopState() {
        }

        InstructionList generatePrologue(IASNode iNode, InstructionList base) {
            InstructionList result = ABCGeneratingReducer.this.createInstructionList(iNode);
            result.addInstruction(36, 0);
            result.addInstruction(this.hasnext.index_temp.setlocal());
            result.addAll(base);
            result.addInstruction(this.hasnext.stem_temp.setlocal());
            result.addInstruction(16, this.test);
            result.addInstruction(9);
            result.labelCurrent(this.loop);
            return result;
        }

        InstructionList generateKeyOrValue(int opcode) {
            InstructionList result = new InstructionList();
            result.addInstruction(this.hasnext.stem_temp.getlocal());
            result.addInstruction(this.hasnext.index_temp.getlocal());
            result.addInstruction(opcode);
            return result;
        }

        InstructionList generateEpilogue() {
            InstructionList result = new InstructionList();
            result.addInstruction(this.hasnext.instruction);
            result.labelCurrent(this.test);
            ABCGeneratingReducer.this.currentScope.getFlowManager().resolveContinueLabel(result);
            result.addInstruction(17, this.loop);
            this.hasnext.release();
            return result;
        }
    }

    class RuntimeMultiname {
        Name compileTimeQualifier;
        InstructionList runtimeQualifier;
        Name compileTimeName;
        InstructionList runtimeName;

        RuntimeMultiname(InstructionList qualifier, InstructionList runtime_name) {
            this.runtimeQualifier = qualifier;
            this.runtimeName = runtime_name;
        }

        RuntimeMultiname(InstructionList qualifier, Name name) {
            this.runtimeQualifier = qualifier;
            this.compileTimeName = name;
        }

        RuntimeMultiname(Name qualifier, InstructionList nameL) {
            assert (qualifier.getKind() == 27 || qualifier.getKind() == 28) : "Bad qualifier kind " + qualifier.getKind() + " on name " + qualifier.toString();
            this.compileTimeQualifier = qualifier;
            this.runtimeName = nameL;
        }

        InstructionList generateGetOrSet(IASNode iNode, int opcode, InstructionList rhs) {
            InstructionList result = ABCGeneratingReducer.this.createInstructionList(iNode);
            if (this.compileTimeQualifier != null && this.runtimeName != null) {
                Binding name_temp = ABCGeneratingReducer.this.currentScope.allocateTemp();
                result.addAll(this.runtimeName);
                result.addInstruction(42);
                result.addInstruction(name_temp.setlocal());
                result.addInstruction(93, this.compileTimeQualifier);
                result.addInstruction(name_temp.getlocal());
                if (rhs != null) {
                    result.addAll(rhs);
                }
                result.addInstruction(opcode, this.compileTimeQualifier);
            } else if (this.runtimeQualifier != null && this.runtimeName != null) {
                Binding name_temp = ABCGeneratingReducer.this.currentScope.allocateTemp();
                Binding qual_temp = ABCGeneratingReducer.this.currentScope.allocateTemp();
                Name rtqnl = new Name(17, null, null);
                result.addAll(this.getRuntimeName(iNode));
                result.addInstruction(name_temp.setlocal());
                result.addAll(this.getRuntimeQualifier(iNode));
                result.addInstruction(42);
                result.addInstruction(qual_temp.setlocal());
                result.addInstruction(name_temp.getlocal());
                result.addInstruction(93, rtqnl);
                result.addInstruction(qual_temp.getlocal());
                result.addInstruction(name_temp.getlocal());
                if (rhs != null) {
                    result.addAll(rhs);
                }
                result.addInstruction(opcode, rtqnl);
                ABCGeneratingReducer.this.currentScope.releaseTemp(name_temp);
                ABCGeneratingReducer.this.currentScope.releaseTemp(qual_temp);
            } else {
                assert (this.runtimeQualifier != null && this.compileTimeName != null) : "Unknown runtime name configuration: " + this.toString();
                Name rtqn = new Name(15, null, this.compileTimeName.getBaseName());
                result.addAll(this.getRuntimeQualifier(iNode));
                result.addInstruction(42);
                result.addInstruction(93, rtqn);
                result.addInstruction(43);
                if (rhs != null) {
                    result.addAll(rhs);
                }
                result.addInstruction(opcode, rtqn);
            }
            return result;
        }

        public InstructionList getRuntimeQualifier(IASNode iNode) {
            assert (this.hasRuntimeQualifier());
            InstructionList result = ABCGeneratingReducer.this.createInstructionList(iNode);
            result.addAll(ABCGeneratingReducer.this.replicate(this.runtimeQualifier));
            Instruction last = result.lastElement();
            if (last.getOpcode() != 128 || last.getOperandCount() == 0 || !namespaceType.equals(last.getOperand(0))) {
                result.addInstruction(128, namespaceType);
            }
            return result;
        }

        public boolean hasRuntimeQualifier() {
            return this.runtimeQualifier != null;
        }

        public boolean hasRuntimeName() {
            return this.runtimeName != null;
        }

        public InstructionList getRuntimeName(IASNode iNode) {
            assert (this.hasRuntimeName());
            InstructionList result = ABCGeneratingReducer.this.createInstructionList(iNode);
            result.addAll(ABCGeneratingReducer.this.replicate(this.runtimeName));
            if (result.lastElement().getOpcode() != 133) {
                result.addInstruction(133);
            }
            return result;
        }

        public Name generateName() {
            Name result;
            if (this.compileTimeQualifier != null) {
                result = this.compileTimeQualifier;
            } else if (this.runtimeQualifier != null && this.runtimeName != null) {
                result = new Name(17, null, null);
            } else {
                assert (this.runtimeQualifier != null && this.compileTimeName != null) : "Unknown runtime name configuration: " + this.toString();
                result = new Name(15, null, this.compileTimeName.getBaseName());
            }
            return result;
        }

        InstructionList generateAssignment(IASNode iNode, InstructionList value) {
            return this.generateGetOrSet(iNode, this.getAssignmentOpcode(iNode), value);
        }

        int getAssignmentOpcode(IASNode iNode) {
            if (SemanticUtils.isConst(iNode, ABCGeneratingReducer.this.currentScope.getProject()) && ABCGeneratingReducer.this.inInitializingContext(iNode)) {
                return 104;
            }
            return 97;
        }

        InstructionList generateRvalue(IASNode iNode) {
            return this.generateGetOrSet(iNode, 102, null);
        }

        public String toString() {
            return "\n\t" + this.compileTimeQualifier + ",\n\t" + this.runtimeQualifier + ",\n\t" + this.compileTimeName + ",\n\t" + this.runtimeName;
        }
    }

    public class ConditionalFragment {
        IASNode site;
        InstructionList condition;
        Object constantCondition;
        InstructionList statement;
        private Label statementLabel = null;

        ConditionalFragment(IASNode site, InstructionList condition, InstructionList statement) {
            this.site = site;
            this.condition = condition;
            this.constantCondition = null;
            this.statement = statement;
        }

        ConditionalFragment(IASNode site, InstructionList condition, Vector<InstructionList> statements) {
            this(site, condition, null, statements);
        }

        ConditionalFragment(IASNode site, Object constantConditional, Vector<InstructionList> statements) {
            this(site, null, constantConditional, statements);
        }

        private ConditionalFragment(IASNode site, InstructionList condition, Object constantCondition, Vector<InstructionList> statements) {
            assert (condition == null || constantCondition == null) : "condition and constantCondition can't both be non-null";
            this.site = site;
            this.condition = condition;
            this.constantCondition = constantCondition;
            this.statement = ABCGeneratingReducer.this.createInstructionList(site);
            for (InstructionList stmt : statements) {
                this.statement.addAll(stmt);
            }
        }

        Label getLabel() {
            if (!this.isUnconditionalAlternative()) {
                if (this.condition != null) {
                    return this.condition.getLabel();
                }
                return this.getStatementLabel();
            }
            return this.getStatementLabel();
        }

        Label getStatementLabel() {
            if (null == this.statementLabel) {
                this.statementLabel = this.statement.getLabel();
            }
            return this.statementLabel;
        }

        boolean isUnconditionalAlternative() {
            return null == this.condition && null == this.constantCondition;
        }

        void convertConstantConditionToInstruction() {
            if (this.constantCondition == null && this.condition != null || this.condition == null) {
                return;
            }
            this.condition = ABCGeneratingReducer.this.transform_constant_value(this.site, this.constantCondition);
            this.constantCondition = null;
        }

        boolean isConstantConditional() {
            return this.constantCondition != null;
        }
    }

    public static class CatchPrototype {
        Name catchType;
        Name catchVarName;
        InstructionList catchBody;
    }
}

