/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.config;

import flex.management.ManageableComponent;
import flex.management.runtime.messaging.endpoints.EndpointControl;
import flex.messaging.Destination;
import flex.messaging.FlexComponent;
import flex.messaging.FlexContext;
import flex.messaging.MessageBroker;
import flex.messaging.Server;
import flex.messaging.client.FlexClientManager;
import flex.messaging.cluster.ClusterManager;
import flex.messaging.config.AdapterSettings;
import flex.messaging.config.ChannelSettings;
import flex.messaging.config.ClusterSettings;
import flex.messaging.config.ConfigMap;
import flex.messaging.config.ConfigurationException;
import flex.messaging.config.DestinationSettings;
import flex.messaging.config.FactorySettings;
import flex.messaging.config.FlexClientSettings;
import flex.messaging.config.LoggingSettings;
import flex.messaging.config.LoginCommandSettings;
import flex.messaging.config.MessageFilterSettings;
import flex.messaging.config.PropertiesSettings;
import flex.messaging.config.SecurityConstraint;
import flex.messaging.config.SecuritySettings;
import flex.messaging.config.ServiceSettings;
import flex.messaging.config.ServicesConfiguration;
import flex.messaging.config.SharedServerSettings;
import flex.messaging.config.SystemSettings;
import flex.messaging.config.TargetSettings;
import flex.messaging.config.ValidatorSettings;
import flex.messaging.endpoints.AbstractEndpoint;
import flex.messaging.endpoints.Endpoint;
import flex.messaging.endpoints.Endpoint2;
import flex.messaging.log.Log;
import flex.messaging.log.Target;
import flex.messaging.security.LoginCommand;
import flex.messaging.security.LoginManager;
import flex.messaging.services.AuthenticationService;
import flex.messaging.services.Service;
import flex.messaging.services.ServiceAdapter;
import flex.messaging.util.ClassUtil;
import flex.messaging.util.RedeployManager;
import flex.messaging.util.StringUtils;
import flex.messaging.util.ToStringPrettyPrinter;
import flex.messaging.util.UUIDGenerator;
import flex.messaging.validators.DeserializationValidator;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MessagingConfiguration
implements ServicesConfiguration {
    private final String asyncMessageBrokerType = "flex.messaging.AsyncMessageBroker";
    private final String asyncFlexClientManagerType = "flex.messaging.client.AsyncFlexClientManager";
    private final Map<String, ChannelSettings> channelSettings = new HashMap<String, ChannelSettings>();
    private final List<String> defaultChannels = new ArrayList<String>(4);
    private final SecuritySettings securitySettings;
    private final List<ServiceSettings> serviceSettings;
    private final List<SharedServerSettings> sharedServerSettings;
    private LoggingSettings loggingSettings;
    private SystemSettings systemSettings;
    private FlexClientSettings flexClientSettings;
    private final Map<String, ClusterSettings> clusterSettings = new HashMap<String, ClusterSettings>();
    private final Map<String, FactorySettings> factorySettings = new HashMap<String, FactorySettings>();
    private final List<MessageFilterSettings> messageFilterSettings;
    private final Map<String, ValidatorSettings> validatorSettings;

    public MessagingConfiguration() {
        this.serviceSettings = new ArrayList<ServiceSettings>();
        this.sharedServerSettings = new ArrayList<SharedServerSettings>();
        this.securitySettings = new SecuritySettings();
        this.messageFilterSettings = new ArrayList<MessageFilterSettings>();
        this.validatorSettings = new HashMap<String, ValidatorSettings>();
    }

    public void configureBroker(MessageBroker broker) {
        boolean async = broker.getClass().getName().equals("flex.messaging.AsyncMessageBroker");
        broker.setChannelSettings(this.channelSettings);
        broker.setSecuritySettings(this.securitySettings);
        broker.setSystemSettings(this.systemSettings);
        broker.setFlexClientSettings(this.flexClientSettings);
        this.createValidators(broker);
        this.createAuthorizationManager(broker);
        this.createFlexClientManager(broker);
        this.createRedeployManager(broker);
        this.createFactories(broker);
        if (async) {
            this.createSharedServers(broker);
        }
        this.createEndpoints(broker);
        broker.setDefaultChannels(this.defaultChannels);
        this.prepareClusters(broker);
        this.createServices(broker);
        if (async) {
            this.createMessageFilters(broker);
        }
        this.createUUIDGenerator(broker);
    }

    public MessageBroker createBroker(String id, ClassLoader loader) {
        MessageBroker broker;
        try {
            Class messageBrokerClass = ClassUtil.createClass("flex.messaging.AsyncMessageBroker", loader);
            Constructor constructor = messageBrokerClass.getConstructor(Boolean.TYPE);
            broker = (MessageBroker)constructor.newInstance(this.systemSettings.isManageable());
        }
        catch (Throwable t) {
            broker = new MessageBroker(this.systemSettings.isManageable());
        }
        broker.setEnforceEndpointValidation(this.systemSettings.isEnforceEndpointValidation());
        broker.setId(id);
        broker.setClassLoader(loader);
        return broker;
    }

    private void createFactories(MessageBroker broker) {
        for (Map.Entry<String, FactorySettings> entry : this.factorySettings.entrySet()) {
            String id = entry.getKey();
            FactorySettings factorySetting = entry.getValue();
            broker.addFactory(id, factorySetting.createFactory(broker.getClassLoader()));
        }
    }

    private void createFlexClientManager(MessageBroker broker) {
        FlexClientManager flexClientManager = null;
        try {
            Class flexClientManagerClass = ClassUtil.createClass("flex.messaging.client.AsyncFlexClientManager", broker.getClassLoader());
            Constructor ctor = flexClientManagerClass.getConstructor(broker.getClass());
            flexClientManager = (FlexClientManager)ctor.newInstance(broker);
        }
        catch (Throwable t) {
            flexClientManager = new FlexClientManager(broker.isManaged(), broker);
        }
        broker.setFlexClientManager(flexClientManager);
    }

    private void createRedeployManager(MessageBroker broker) {
        RedeployManager redeployManager = new RedeployManager();
        redeployManager.setEnabled(this.systemSettings.getRedeployEnabled());
        redeployManager.setWatchInterval(this.systemSettings.getWatchInterval());
        redeployManager.setTouchFiles(this.systemSettings.getTouchFiles());
        redeployManager.setWatchFiles(this.systemSettings.getWatchFiles());
        broker.setRedeployManager(redeployManager);
    }

    private void createAuthorizationManager(MessageBroker broker) {
        LoginManager loginManager = new LoginManager();
        LoginCommand loginCommand = null;
        Map loginCommands = this.securitySettings.getLoginCommands();
        LoginCommandSettings loginCommandSettings = (LoginCommandSettings)loginCommands.get("all");
        if (loginCommandSettings != null) {
            loginCommand = this.initLoginCommand(loginCommandSettings);
        } else {
            String serverInfo = this.securitySettings.getServerInfo();
            loginCommandSettings = (LoginCommandSettings)loginCommands.get(serverInfo);
            if (loginCommandSettings != null) {
                loginCommand = this.initLoginCommand(loginCommandSettings);
            } else {
                serverInfo = serverInfo.toLowerCase();
                for (String serverMatch : loginCommands.keySet()) {
                    loginCommandSettings = (LoginCommandSettings)loginCommands.get(serverMatch);
                    if (serverInfo.indexOf(serverMatch.toLowerCase()) == -1) continue;
                    loginCommands.put(serverInfo, loginCommandSettings);
                    loginCommand = this.initLoginCommand(loginCommandSettings);
                    break;
                }
            }
        }
        if (loginCommand == null) {
            if (Log.isWarn()) {
                Log.getLogger((String)"Configuration").warn("No login command was found for '" + this.securitySettings.getServerInfo() + "'. Please ensure that the login-command tag has the correct server attribute value, or use 'all' to use the login command regardless of the server.");
            }
        } else {
            loginManager.setLoginCommand(loginCommand);
        }
        if (loginCommandSettings != null) {
            loginManager.setPerClientAuthentication(loginCommandSettings.isPerClientAuthentication());
        }
        broker.setLoginManager(loginManager);
    }

    private LoginCommand initLoginCommand(LoginCommandSettings loginCommandSettings) {
        String loginClass = loginCommandSettings.getClassName();
        Class c = ClassUtil.createClass(loginClass, FlexContext.getMessageBroker() == null ? null : FlexContext.getMessageBroker().getClassLoader());
        LoginCommand loginCommand = (LoginCommand)ClassUtil.createDefaultInstance(c, LoginCommand.class);
        return loginCommand;
    }

    private void createSharedServers(MessageBroker broker) {
        for (SharedServerSettings settings : this.sharedServerSettings) {
            String id = settings.getId();
            String className = settings.getClassName();
            Class serverClass = ClassUtil.createClass(className, broker.getClassLoader());
            FlexComponent server = (FlexComponent)ClassUtil.createDefaultInstance(serverClass, serverClass);
            server.initialize(id, settings.getProperties());
            if (broker.isManaged() && server instanceof ManageableComponent) {
                ManageableComponent manageableServer = (ManageableComponent)server;
                manageableServer.setManaged(true);
                manageableServer.setParent(broker);
            }
            broker.addServer((Server)server);
            if (!Log.isInfo()) continue;
            Log.getLogger((String)"Configuration").info("Server '" + id + "' of type '" + className + "' created.");
        }
    }

    private void createEndpoints(MessageBroker broker) {
        for (String id : this.channelSettings.keySet()) {
            String endpointClassName;
            ChannelSettings chanSettings;
            String url;
            Endpoint endpoint = broker.createEndpoint(id, url = (chanSettings = this.channelSettings.get(id)).getUri(), endpointClassName = chanSettings.getEndpointType());
            if (endpoint instanceof AbstractEndpoint) {
                AbstractEndpoint abstractEndpoint = (AbstractEndpoint)endpoint;
                abstractEndpoint.setRemote(chanSettings.isRemote());
                abstractEndpoint.setServerOnly(chanSettings.getServerOnly());
            }
            endpoint.setSecurityConstraint(chanSettings.getConstraint());
            endpoint.setClientType(chanSettings.getClientType());
            String referencedServerId = chanSettings.getServerId();
            if (referencedServerId != null && endpoint instanceof Endpoint2) {
                Server server = broker.getServer(referencedServerId);
                if (server == null) {
                    ConfigurationException ce = new ConfigurationException();
                    ce.setMessage(11128, new Object[]{chanSettings.getId(), referencedServerId});
                    throw ce;
                }
                ((Endpoint2)endpoint).setServer(broker.getServer(referencedServerId));
            }
            endpoint.initialize(id, chanSettings.getProperties());
            if (!Log.isInfo()) continue;
            String endpointURL = endpoint.getUrl();
            String endpointSecurity = EndpointControl.getSecurityConstraintOf(endpoint);
            if (StringUtils.isEmpty((String)endpointSecurity)) {
                endpointSecurity = "None";
            }
            Log.getLogger((String)"Configuration").info("Endpoint '" + id + "' created with security: " + endpointSecurity + StringUtils.NEWLINE + "at URL: " + endpointURL);
        }
    }

    private void createServices(MessageBroker broker) {
        AuthenticationService authService = new AuthenticationService();
        authService.setMessageBroker(broker);
        for (ServiceSettings svcSettings : this.serviceSettings) {
            String svcId = svcSettings.getId();
            String svcClassName = svcSettings.getClassName();
            Service service = broker.createService(svcId, svcClassName);
            service.initialize(svcId, svcSettings.getProperties());
            for (ChannelSettings chanSettings : svcSettings.getDefaultChannels()) {
                service.addDefaultChannel(chanSettings.getId());
            }
            Map svcAdapterSettings = svcSettings.getAllAdapterSettings();
            for (AdapterSettings as : svcAdapterSettings.values()) {
                service.registerAdapter(as.getId(), as.getClassName());
                if (!as.isDefault()) continue;
                service.setDefaultAdapter(as.getId());
            }
            Map destinationSettings = svcSettings.getDestinationSettings();
            for (String destName : destinationSettings.keySet()) {
                DestinationSettings destSettings = (DestinationSettings)destinationSettings.get(destName);
                this.createDestination(destSettings, service, svcSettings);
            }
        }
    }

    private void createDestination(DestinationSettings destSettings, Service service, ServiceSettings svcSettings) {
        String destId = destSettings.getId();
        Destination destination = service.createDestination(destId);
        List chanSettings = destSettings.getChannelSettings();
        if (chanSettings.size() > 0) {
            ArrayList<String> channelIds = new ArrayList<String>(2);
            for (ChannelSettings cs : chanSettings) {
                channelIds.add(cs.getId());
            }
            destination.setChannels(channelIds);
        }
        SecurityConstraint constraint = destSettings.getConstraint();
        destination.setSecurityConstraint(constraint);
        destination.initialize(destId, svcSettings.getProperties());
        destination.initialize(destId, destSettings.getAdapterSettings().getProperties());
        destination.initialize(destId, destSettings.getProperties());
        this.createAdapter(destination, destSettings, svcSettings);
    }

    private void createAdapter(Destination destination, DestinationSettings destSettings, ServiceSettings svcSettings) {
        AdapterSettings adapterSettings = destSettings.getAdapterSettings();
        String adapterId = adapterSettings.getId();
        ServiceAdapter adapter = destination.createAdapter(adapterId);
        adapter.initialize(adapterId, svcSettings.getProperties());
        adapter.initialize(adapterId, adapterSettings.getProperties());
        adapter.initialize(adapterId, destSettings.getProperties());
    }

    public void createLogAndTargets() {
        if (this.loggingSettings == null) {
            Log.setPrettyPrinterClass((String)ToStringPrettyPrinter.class.getName());
            return;
        }
        Log.createLog();
        ConfigMap properties = this.loggingSettings.getProperties();
        if (properties.getPropertyAsString("pretty-printer", null) == null) {
            Log.setPrettyPrinterClass((String)ToStringPrettyPrinter.class.getName());
        }
        Log.initialize(null, (ConfigMap)properties);
        List targets = this.loggingSettings.getTargets();
        for (TargetSettings targetSettings : targets) {
            String className = targetSettings.getClassName();
            Class c = ClassUtil.createClass(className, FlexContext.getMessageBroker() == null ? null : FlexContext.getMessageBroker().getClassLoader());
            try {
                Target target = (Target)c.newInstance();
                target.setLevel(Log.readLevel((String)targetSettings.getLevel()));
                target.setFilters(targetSettings.getFilters());
                target.initialize(null, targetSettings.getProperties());
                Log.addTarget((Target)target);
            }
            catch (Throwable t) {
                if (t instanceof InvocationTargetException) {
                    t = t.getCause();
                }
                System.err.println("*** Error setting up logging system");
                t.printStackTrace();
                ConfigurationException cx = new ConfigurationException();
                cx.setMessage(10126, new Object[]{className});
                cx.setRootCause(t);
                throw cx;
            }
        }
    }

    private void createMessageFilters(MessageBroker broker) {
        Class asyncFilterClass = ClassUtil.createClass("flex.messaging.filters.BaseAsyncMessageFilter");
        Class syncFilterClass = ClassUtil.createClass("flex.messaging.filters.BaseSyncMessageFilter");
        for (MessageFilterSettings settings : this.messageFilterSettings) {
            boolean filterIsAsync;
            String id = settings.getId();
            String className = settings.getClassName();
            Class filterClass = ClassUtil.createClass(className, broker.getClassLoader());
            FlexComponent filter = (FlexComponent)ClassUtil.createDefaultInstance(filterClass, null);
            MessageFilterSettings.FilterType filterType = settings.getFilterType();
            boolean bl = filterIsAsync = filterType == MessageFilterSettings.FilterType.ASYNC;
            if (filterIsAsync && !asyncFilterClass.isAssignableFrom(filterClass) || !filterIsAsync && !syncFilterClass.isAssignableFrom(filterClass)) {
                ConfigurationException cx = new ConfigurationException();
                int errorCode = filterIsAsync ? 11144 : 11145;
                cx.setMessage(errorCode, new Object[]{settings.getId()});
                throw cx;
            }
            filter.initialize(id, settings.getProperties());
            if (broker.isManaged() && filter instanceof ManageableComponent) {
                ManageableComponent manageableFilter = (ManageableComponent)filter;
                manageableFilter.setManaged(true);
                manageableFilter.setParent(broker);
            }
            try {
                String methodName = filterIsAsync ? "getAsyncMessageFilterChain" : "getSyncMessageFilterChain";
                Method getMessageFilterChain = broker.getClass().getDeclaredMethod(methodName, new Class[0]);
                Object filterChain = getMessageFilterChain.invoke((Object)broker, (Object[])null);
                Class arg = filterIsAsync ? asyncFilterClass : syncFilterClass;
                Method addFilter = filterChain.getClass().getDeclaredMethod("add", arg);
                addFilter.invoke(filterChain, filter);
            }
            catch (Exception e) {
                ConfigurationException cx = new ConfigurationException();
                int errorCode = filterType == MessageFilterSettings.FilterType.ASYNC ? 11138 : 11143;
                cx.setMessage(errorCode, new Object[]{settings.getId()});
                cx.setRootCause((Throwable)e);
                throw cx;
            }
            if (!Log.isInfo()) continue;
            Log.getLogger((String)"Configuration").info("MessageFilter '" + id + "' of type '" + className + "' created.");
        }
    }

    private void createValidators(MessageBroker broker) {
        for (ValidatorSettings settings : this.validatorSettings.values()) {
            Class expectedClass;
            String className = settings.getClassName();
            String type = settings.getType();
            Class validatorClass = ClassUtil.createClass(className, broker.getClassLoader());
            Object validator = ClassUtil.createDefaultInstance(validatorClass, expectedClass = ClassUtil.createClass(type, broker.getClassLoader()));
            if (!(validator instanceof DeserializationValidator)) continue;
            DeserializationValidator deserializationValidator = (DeserializationValidator)validator;
            deserializationValidator.initialize(null, settings.getProperties());
            broker.setDeserializationValidator(deserializationValidator);
            if (!Log.isInfo()) continue;
            Log.getLogger((String)"Configuration").info("DeserializationValidator of type '" + className + "' created.");
        }
    }

    private void createUUIDGenerator(MessageBroker broker) {
        String className = this.systemSettings.getUUIDGeneratorClassName();
        if (className == null || className.length() == 0) {
            return;
        }
        Class uuidGeneratorClass = ClassUtil.createClass(className, broker.getClassLoader());
        if (!UUIDGenerator.class.isAssignableFrom(uuidGeneratorClass)) {
            ConfigurationException cx = new ConfigurationException();
            cx.setMessage(11148, new Object[]{UUIDGenerator.class.getName()});
            throw cx;
        }
        Object uuidGenerator = ClassUtil.createDefaultInstance(uuidGeneratorClass, UUIDGenerator.class);
        broker.setUUIDGenerator((UUIDGenerator)uuidGenerator);
    }

    private void prepareClusters(MessageBroker broker) {
        ClusterManager clusterManager = broker.getClusterManager();
        for (String clusterId : this.clusterSettings.keySet()) {
            ClusterSettings cs = this.clusterSettings.get(clusterId);
            clusterManager.prepareCluster(cs);
        }
    }

    public void addSharedServerSettings(SharedServerSettings settings) {
        this.sharedServerSettings.add(settings);
    }

    public void addChannelSettings(String id, ChannelSettings settings) {
        this.channelSettings.put(id, settings);
    }

    public ChannelSettings getChannelSettings(String id) {
        return this.channelSettings.get(id);
    }

    public Map getAllChannelSettings() {
        return this.channelSettings;
    }

    public void addDefaultChannel(String id) {
        this.defaultChannels.add(id);
    }

    public List getDefaultChannels() {
        return this.defaultChannels;
    }

    public SecuritySettings getSecuritySettings() {
        return this.securitySettings;
    }

    public void addServiceSettings(ServiceSettings settings) {
        this.serviceSettings.add(settings);
    }

    public ServiceSettings getServiceSettings(String id) {
        for (ServiceSettings serviceSettings : this.serviceSettings) {
            if (!serviceSettings.getId().equals(id)) continue;
            return serviceSettings;
        }
        return null;
    }

    public List getAllServiceSettings() {
        return this.serviceSettings;
    }

    public LoggingSettings getLoggingSettings() {
        return this.loggingSettings;
    }

    public void setLoggingSettings(LoggingSettings loggingSettings) {
        this.loggingSettings = loggingSettings;
    }

    public void setSystemSettings(SystemSettings ss) {
        this.systemSettings = ss;
    }

    public SystemSettings getSystemSettings() {
        return this.systemSettings;
    }

    public void setFlexClientSettings(FlexClientSettings value) {
        this.flexClientSettings = value;
    }

    public FlexClientSettings getFlexClientSettings() {
        return this.flexClientSettings;
    }

    public void addClusterSettings(ClusterSettings settings) {
        if (settings.isDefault()) {
            for (ClusterSettings cs : this.clusterSettings.values()) {
                if (!cs.isDefault()) continue;
                ConfigurationException cx = new ConfigurationException();
                cx.setMessage(10214, new Object[]{settings.getClusterName(), cs.getClusterName()});
                throw cx;
            }
        }
        if (this.clusterSettings.containsKey(settings.getClusterName())) {
            ConfigurationException cx = new ConfigurationException();
            cx.setMessage(10206, new Object[]{settings.getClusterName()});
            throw cx;
        }
        this.clusterSettings.put(settings.getClusterName(), settings);
    }

    public ClusterSettings getClusterSettings(String clusterId) {
        for (ClusterSettings cs : this.clusterSettings.values()) {
            if (cs.getClusterName() == clusterId) {
                return cs;
            }
            if (cs.getClusterName() == null || !cs.getClusterName().equals(clusterId)) continue;
            return cs;
        }
        return null;
    }

    public ClusterSettings getDefaultCluster() {
        for (ClusterSettings cs : this.clusterSettings.values()) {
            if (!cs.isDefault()) continue;
            return cs;
        }
        return null;
    }

    public void addFactorySettings(String id, FactorySettings settings) {
        this.factorySettings.put(id, settings);
    }

    public void addMessageFilterSettings(MessageFilterSettings settings) {
        this.messageFilterSettings.add(settings);
    }

    public void addValidatorSettings(ValidatorSettings settings) {
        String type = settings.getType();
        if (this.validatorSettings.containsKey(type)) {
            ConfigurationException ce = new ConfigurationException();
            ce.setMessage(11136, new Object[]{type});
            throw ce;
        }
        this.validatorSettings.put(type, settings);
    }

    public void reportUnusedProperties() {
        ArrayList<Object[]> findings = new ArrayList<Object[]>();
        for (ServiceSettings serviceSettings : this.serviceSettings) {
            this.gatherUnusedProperties(serviceSettings.getId(), serviceSettings.getSourceFile(), "service", (PropertiesSettings)serviceSettings, findings);
            for (DestinationSettings destinationSettings : serviceSettings.getDestinationSettings().values()) {
                this.gatherUnusedProperties(destinationSettings.getId(), destinationSettings.getSourceFile(), "destination", (PropertiesSettings)destinationSettings, findings);
                AdapterSettings adapterSettings = destinationSettings.getAdapterSettings();
                if (adapterSettings == null) continue;
                this.gatherUnusedProperties(adapterSettings.getId(), adapterSettings.getSourceFile(), "adapter", (PropertiesSettings)adapterSettings, findings);
            }
        }
        for (ChannelSettings channelSettings : this.channelSettings.values()) {
            if (channelSettings.isRemote()) continue;
            this.gatherUnusedProperties(channelSettings.getId(), channelSettings.getSourceFile(), "channel", (PropertiesSettings)channelSettings, findings);
        }
        for (SharedServerSettings serverSettings : this.sharedServerSettings) {
            this.gatherUnusedProperties(serverSettings.getId(), serverSettings.getSourceFile(), "server", serverSettings, findings);
        }
        if (!findings.isEmpty()) {
            int errorNumber = 10149;
            ConfigurationException exception = new ConfigurationException();
            StringBuffer allDetails = new StringBuffer();
            for (int i = 0; i < findings.size(); ++i) {
                allDetails.append(StringUtils.NEWLINE);
                allDetails.append("  ");
                exception.setDetails(errorNumber, "pattern", findings.get(i));
                allDetails.append(exception.getDetails());
                exception.setDetails(null);
            }
            exception.setMessage(errorNumber, new Object[]{allDetails});
            throw exception;
        }
    }

    private void gatherUnusedProperties(String settingsId, String settingsSource, String settingsType, PropertiesSettings settings, Collection<Object[]> result) {
        List unusedProperties = settings.getProperties().findAllUnusedProperties();
        int size = unusedProperties.size();
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                String path = (String)unusedProperties.get(i);
                result.add(new Object[]{path, settingsType, settingsId, settingsSource});
            }
        }
    }
}

