/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.upnp.tester.gui;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.apache.felix.upnp.tester.Mediator;
import org.apache.felix.upnp.tester.discovery.DeviceNode;
import org.apache.felix.upnp.tester.gui.UPnPDeviceTreeNode;
import org.apache.felix.upnp.tester.gui.Util;
import org.osgi.service.upnp.UPnPService;

class TreePopup
extends JPopupMenu
implements PopupMenuListener {
    JTree tree;
    JMenuItem item;

    public TreePopup(final JTree tree) {
        this.tree = tree;
        this.item = this.add(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                UPnPDeviceTreeNode selectedNode = (UPnPDeviceTreeNode)tree.getLastSelectedPathComponent();
                String url = "";
                if (selectedNode.category.equals("DeviceNode")) {
                    UPnPDeviceTreeNode parent = (UPnPDeviceTreeNode)selectedNode.getParent();
                    while (parent.category != "RootDeviceNode") {
                        parent = (UPnPDeviceTreeNode)parent.getParent();
                    }
                    DeviceNode device = (DeviceNode)parent.getUserObject();
                    String udn = (String)device.getReference().getProperty("UPnP.device.UDN");
                    url = Mediator.getDriverProxy().getDeviceDescriptionURI(udn);
                } else if (selectedNode.category.equals("RootDeviceNode")) {
                    DeviceNode node = (DeviceNode)selectedNode.getUserObject();
                    String udn = (String)node.getReference().getProperty("UPnP.device.UDN");
                    url = Mediator.getDriverProxy().getDeviceDescriptionURI(udn);
                } else if (selectedNode.category.equals("UPnPService")) {
                    UPnPDeviceTreeNode parent = (UPnPDeviceTreeNode)selectedNode.getParent();
                    while (parent.category != "RootDeviceNode") {
                        parent = (UPnPDeviceTreeNode)parent.getParent();
                    }
                    DeviceNode device = (DeviceNode)parent.getUserObject();
                    String udn = (String)device.getReference().getProperty("UPnP.device.UDN");
                    UPnPService service = (UPnPService)selectedNode.getUserObject();
                    url = Mediator.getDriverProxy().getServiceDescriptionURI(udn, service.getId());
                }
                Util.openUrl(url);
            }
        });
        this.item.setText("Show Description");
        this.addPopupMenuListener(this);
    }

    public void popupMenuCanceled(PopupMenuEvent e) {
    }

    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
    }

    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        if (Mediator.getDriverProxy().isDriverAvailable()) {
            UPnPDeviceTreeNode selectedNode = (UPnPDeviceTreeNode)this.tree.getLastSelectedPathComponent();
            if (selectedNode.category.equals("DeviceNode") || selectedNode.category.equals("RootDeviceNode") || selectedNode.category.equals("UPnPService")) {
                this.item.setEnabled(true);
            } else {
                this.item.setEnabled(false);
            }
        } else {
            this.item.setEnabled(false);
        }
    }
}

