/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scrplugin.helper;

import java.util.ArrayList;
import java.util.List;
import org.apache.felix.scrplugin.Log;

public class IssueLog {
    private final boolean strictMode;
    private final List<Entry> errors = new ArrayList<Entry>();
    private final List<Entry> warnings = new ArrayList<Entry>();
    private final List<Entry> deprecationWarnings = new ArrayList<Entry>();

    public IssueLog(boolean strictMode) {
        this.strictMode = strictMode;
    }

    public int getNumberOfErrors() {
        return this.errors.size();
    }

    public boolean hasErrors() {
        return this.errors.size() > 0 || this.strictMode && (this.warnings.size() > 0 || this.deprecationWarnings.size() > 0);
    }

    public void addError(String message, String location) {
        this.errors.add(new Entry(message, location));
    }

    public void addWarning(String message, String location) {
        this.warnings.add(new Entry(message, location));
    }

    public void addDeprecationWarning(String message, String location) {
        this.deprecationWarnings.add(new Entry(message, location));
    }

    public void logMessages(Log log) {
        for (Entry entry : this.deprecationWarnings) {
            if (this.strictMode) {
                log.error(entry.message, entry.location, entry.lineNumber, entry.columnNumber);
                continue;
            }
            log.warn(entry.message, entry.location, entry.lineNumber, entry.columnNumber);
        }
        if (this.deprecationWarnings.size() > 0) {
            String msg = "It is highly recommended to fix these problems, as future versions might not support these features anymore.";
            if (this.strictMode) {
                log.error("It is highly recommended to fix these problems, as future versions might not support these features anymore.");
            } else {
                log.warn("It is highly recommended to fix these problems, as future versions might not support these features anymore.");
            }
        }
        for (Entry entry : this.warnings) {
            if (this.strictMode) {
                log.error(entry.message, entry.location, entry.lineNumber, entry.columnNumber);
                continue;
            }
            log.warn(entry.message, entry.location, entry.lineNumber, entry.columnNumber);
        }
        for (Entry entry : this.errors) {
            log.error(entry.message, entry.location, entry.lineNumber, entry.columnNumber);
        }
    }

    private static class Entry {
        static final int LINE_NUMBER_UNKNOWN = 1;
        static final int COLUMN_NUMBER_UNKNOWN = 1;
        final String message;
        final String location;
        final int lineNumber;
        final int columnNumber;

        Entry(String message, String location) {
            this(message, location, 1, 1);
        }

        Entry(String message, String location, int lineNumber, int columnNumber) {
            this.message = message;
            this.location = location;
            this.lineNumber = lineNumber;
            this.columnNumber = columnNumber;
        }

        public String toString() {
            return this.location + " [" + this.lineNumber + "," + this.columnNumber + "] : " + this.message;
        }
    }
}

