/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.lookup;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.annotations.VisibleForTesting;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.lookup.LookupExtractorFactory;
import org.apache.druid.query.lookup.LookupIntrospectHandler;
import org.apache.druid.server.lookup.DataFetcher;
import org.apache.druid.server.lookup.PollingLookup;
import org.apache.druid.server.lookup.cache.polling.PollingCacheFactory;
import org.joda.time.Period;

@JsonTypeName(value="pollingLookup")
public class PollingLookupFactory
implements LookupExtractorFactory {
    private static final Logger LOGGER = new Logger(PollingLookupFactory.class);
    @JsonProperty(value="pollPeriod")
    private final Period pollPeriod;
    @JsonProperty(value="dataFetcher")
    private final DataFetcher dataFetcher;
    @JsonProperty(value="cacheProvider")
    private final PollingCacheFactory cacheFactory;
    private final PollingLookup pollingLookup;
    private final AtomicBoolean started = new AtomicBoolean(false);
    private final String id = Integer.toHexString(System.identityHashCode(this));

    @JsonCreator
    public PollingLookupFactory(@JsonProperty(value="pollPeriod") Period pollPeriod, @JsonProperty(value="dataFetcher") DataFetcher dataFetcher, @JsonProperty(value="cacheFactory") PollingCacheFactory cacheFactory) {
        this.pollPeriod = pollPeriod == null ? Period.ZERO : pollPeriod;
        this.dataFetcher = dataFetcher;
        this.cacheFactory = cacheFactory;
        this.pollingLookup = new PollingLookup(this.pollPeriod.toStandardDuration().getMillis(), this.dataFetcher, this.cacheFactory);
    }

    @VisibleForTesting
    protected PollingLookupFactory(Period pollPeriod, DataFetcher dataFetcher, PollingCacheFactory pollingCacheFactory, PollingLookup pollingLookup) {
        this.pollPeriod = pollPeriod;
        this.dataFetcher = dataFetcher;
        this.cacheFactory = pollingCacheFactory;
        this.pollingLookup = pollingLookup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean start() {
        AtomicBoolean atomicBoolean = this.started;
        synchronized (atomicBoolean) {
            if (!this.started.get()) {
                LOGGER.info("started polling lookup [%s]", new Object[]{this.id});
                this.started.set(this.pollingLookup.isOpen());
            }
            return this.started.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean close() {
        AtomicBoolean atomicBoolean = this.started;
        synchronized (atomicBoolean) {
            if (this.started.getAndSet(false)) {
                LOGGER.info("closing polling lookup [%s]", new Object[]{this.id});
                this.pollingLookup.close();
            }
            return !this.started.get();
        }
    }

    public boolean replaces(@Nullable LookupExtractorFactory lookupExtractorFactory) {
        if (lookupExtractorFactory == null) {
            return true;
        }
        return !this.equals(lookupExtractorFactory);
    }

    @Nullable
    public LookupIntrospectHandler getIntrospectHandler() {
        return null;
    }

    public void awaitInitialization() {
    }

    public boolean isInitialized() {
        return true;
    }

    public PollingLookup get() {
        return this.pollingLookup;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PollingLookupFactory)) {
            return false;
        }
        PollingLookupFactory that = (PollingLookupFactory)o;
        if (this.pollPeriod != null ? !this.pollPeriod.equals((Object)that.pollPeriod) : that.pollPeriod != null) {
            return false;
        }
        if (this.dataFetcher != null ? !this.dataFetcher.equals(that.dataFetcher) : that.dataFetcher != null) {
            return false;
        }
        return this.cacheFactory != null ? that.cacheFactory != null && this.cacheFactory.getClass() == that.cacheFactory.getClass() : that.cacheFactory == null;
    }

    public int hashCode() {
        return Objects.hash(this.pollPeriod, this.dataFetcher, this.cacheFactory);
    }
}

