/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.histogram;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.apache.druid.query.aggregation.histogram.ApproximateHistogram;

final class ApproximateHistogramFoldingBufferAggregatorHelper {
    private final int resolution;
    private final float upperLimit;
    private final float lowerLimit;
    private float[] tmpBufferA;
    private long[] tmpBufferB;

    public ApproximateHistogramFoldingBufferAggregatorHelper(int resolution, float lowerLimit, float upperLimit) {
        this.resolution = resolution;
        this.lowerLimit = lowerLimit;
        this.upperLimit = upperLimit;
        this.tmpBufferA = new float[resolution];
        this.tmpBufferB = new long[resolution];
    }

    public void init(ByteBuffer buf, int position) {
        ApproximateHistogram h = new ApproximateHistogram(this.resolution, this.lowerLimit, this.upperLimit);
        ByteBuffer mutationBuffer = buf.duplicate();
        mutationBuffer.position(position);
        h.toBytesDense(mutationBuffer);
    }

    public void aggregate(ByteBuffer buf, int position, @Nullable ApproximateHistogram hNext) {
        if (hNext == null) {
            return;
        }
        ByteBuffer mutationBuffer = buf.duplicate();
        mutationBuffer.position(position);
        ApproximateHistogram h0 = ApproximateHistogram.fromBytesDense(mutationBuffer);
        this.foldFast(h0, hNext);
        mutationBuffer.position(position);
        h0.toBytesDense(mutationBuffer);
    }

    public void foldFast(ApproximateHistogram left, ApproximateHistogram right) {
        left.setLowerLimit(this.lowerLimit);
        left.setUpperLimit(this.upperLimit);
        left.foldFast(right, this.tmpBufferA, this.tmpBufferB);
    }

    public ApproximateHistogram get(ByteBuffer buf, int position) {
        ByteBuffer mutationBuffer = buf.asReadOnlyBuffer();
        mutationBuffer.position(position);
        return ApproximateHistogram.fromBytesDense(mutationBuffer);
    }

    public void put(ByteBuffer buf, int position, ApproximateHistogram histogram) {
        ByteBuffer mutationBuffer = buf.duplicate();
        mutationBuffer.position(position);
        histogram.toBytesDense(mutationBuffer);
    }
}

