/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.k8s.overlord.common;

import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.batch.v1.Job;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.informers.SharedIndexInformer;
import io.fabric8.kubernetes.client.informers.cache.Indexer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.k8s.overlord.common.InformerEventHandler;
import org.apache.druid.k8s.overlord.common.KubernetesClientApi;
import org.apache.druid.k8s.overlord.common.KubernetesResourceEventNotifier;
import org.apache.druid.k8s.overlord.common.SharedInformerCacheReader;

public class DruidKubernetesCachingClient {
    private static final EmittingLogger log = new EmittingLogger(DruidKubernetesCachingClient.class);
    public static final String JOB_NAME_INDEX = "byJobName";
    public static final String OVERLORD_NAMESPACE_INDEX = "byOverlordNamespace";
    private final SharedIndexInformer<Pod> podInformer;
    private final SharedIndexInformer<Job> jobInformer;
    private final KubernetesResourceEventNotifier eventNotifier;
    private final KubernetesClientApi baseClient;
    private final long informerResyncPeriodMillis;

    public DruidKubernetesCachingClient(KubernetesClientApi baseClient, String namespace, long informerResyncPeriodMillis) {
        this.baseClient = baseClient;
        this.informerResyncPeriodMillis = informerResyncPeriodMillis;
        this.eventNotifier = new KubernetesResourceEventNotifier();
        this.podInformer = this.setupPodInformer(namespace);
        this.jobInformer = this.setupJobInformer(namespace);
    }

    public void stop() {
        if (this.podInformer != null) {
            this.podInformer.stop();
        }
        if (this.jobInformer != null) {
            this.jobInformer.stop();
        }
        this.eventNotifier.cancelAll();
    }

    public KubernetesClientApi getBaseClient() {
        return this.baseClient;
    }

    public KubernetesClient getClient() {
        return this.baseClient.getClient();
    }

    public <T> T readPodCache(SharedInformerCacheReader<T, Pod> executor) {
        return executor.readFromCache((Indexer<Pod>)this.podInformer.getIndexer());
    }

    public <T> T readJobCache(SharedInformerCacheReader<T, Job> executor) {
        return executor.readFromCache((Indexer<Job>)this.jobInformer.getIndexer());
    }

    private SharedIndexInformer<Pod> setupPodInformer(String namespace) {
        SharedIndexInformer podInformer = ((FilterWatchListDeletable)((NonNamespaceOperation)this.baseClient.getClient().pods().inNamespace(namespace)).withLabel("druid.k8s.peons")).inform(new InformerEventHandler<Pod>((pod, eventType) -> {
            log.debug("Pod[%s] got %s", new Object[]{pod.getMetadata().getName(), eventType.name()});
            this.notifyPodChange((Pod)pod);
        }), this.informerResyncPeriodMillis);
        Function<Pod, List> jobNameIndexer = pod -> {
            String jobName;
            if (pod.getMetadata() != null && pod.getMetadata().getLabels() != null && (jobName = (String)pod.getMetadata().getLabels().get("job-name")) != null) {
                return Collections.singletonList(jobName);
            }
            return Collections.emptyList();
        };
        HashMap<String, Function<Pod, List>> customPodIndexers = new HashMap<String, Function<Pod, List>>();
        customPodIndexers.put(JOB_NAME_INDEX, jobNameIndexer);
        podInformer.addIndexers(customPodIndexers);
        return podInformer;
    }

    private SharedIndexInformer<Job> setupJobInformer(String namespace) {
        SharedIndexInformer jobInformer = ((FilterWatchListDeletable)((NonNamespaceOperation)this.baseClient.getClient().batch().v1().jobs().inNamespace(namespace)).withLabel("druid.k8s.peons")).inform(new InformerEventHandler<Job>((job, eventType) -> {
            log.debug("Job[%s] got %s", new Object[]{job.getMetadata().getName(), eventType.name()});
            this.eventNotifier.notifyJobChange(job.getMetadata().getName(), (Job)job);
        }), this.informerResyncPeriodMillis);
        Function<Job, List> overlordNamespaceIndexer = job -> {
            String overlordNamespace;
            if (job.getMetadata() != null && job.getMetadata().getLabels() != null && (overlordNamespace = (String)job.getMetadata().getLabels().get("druid.overlord.namespace")) != null) {
                return Collections.singletonList(overlordNamespace);
            }
            return Collections.emptyList();
        };
        Function<Job, List> jobNameIndexer = job -> {
            if (job.getMetadata() != null && job.getMetadata().getName() != null) {
                return Collections.singletonList(job.getMetadata().getName());
            }
            return Collections.emptyList();
        };
        HashMap<String, Function<Job, List>> customJobIndexers = new HashMap<String, Function<Job, List>>();
        customJobIndexers.put(OVERLORD_NAMESPACE_INDEX, overlordNamespaceIndexer);
        customJobIndexers.put(JOB_NAME_INDEX, jobNameIndexer);
        jobInformer.addIndexers(customJobIndexers);
        return jobInformer;
    }

    private void notifyPodChange(Pod pod) {
        String jobName;
        if (pod.getMetadata() != null && pod.getMetadata().getLabels() != null && (jobName = (String)pod.getMetadata().getLabels().get("job-name")) != null) {
            this.eventNotifier.notifyPodChange(jobName, pod);
        }
    }

    public CompletableFuture<Job> waitForJobChange(String jobName) {
        return this.eventNotifier.waitForJobChange(jobName);
    }

    public CompletableFuture<Pod> waitForPodChange(String jobName) {
        return this.eventNotifier.waitForPodChange(jobName);
    }

    public void cancelJobWatcher(String jobName) {
        this.eventNotifier.cancelJobWatcher(jobName);
    }

    public void cancelPodWatcher(String jobName) {
        this.eventNotifier.cancelPodWatcher(jobName);
    }

    public long getInformerResyncPeriodMillis() {
        return this.informerResyncPeriodMillis;
    }
}

