/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.storage.google;

import java.io.IOException;
import java.net.URI;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.storage.google.GoogleStorage;
import org.apache.druid.storage.google.GoogleStorageObjectMetadata;
import org.apache.druid.storage.google.GoogleStorageObjectPage;

public class ObjectStorageIterator
implements Iterator<GoogleStorageObjectMetadata> {
    private final GoogleStorage storage;
    private final Iterator<URI> uris;
    private final long maxListingLength;
    private GoogleStorageObjectPage googleStorageObjectPage;
    private URI currentUri;
    private String nextPageToken;
    private Iterator<GoogleStorageObjectMetadata> blobIterator;
    private GoogleStorageObjectMetadata currentObject;

    public ObjectStorageIterator(GoogleStorage storage, Iterator<URI> uris, long maxListingLength) {
        this.storage = storage;
        this.uris = uris;
        this.maxListingLength = maxListingLength;
        this.advanceURI();
        this.fetchNextPage();
        this.advanceStorageObject();
    }

    private void advanceURI() {
        this.currentUri = this.uris.next();
    }

    private void fetchNextPage() {
        try {
            String currentBucket = this.currentUri.getAuthority();
            String currentPrefix = StringUtils.maybeRemoveLeadingSlash((String)this.currentUri.getPath());
            this.googleStorageObjectPage = this.storage.list(currentBucket, currentPrefix, this.maxListingLength, this.nextPageToken);
            this.blobIterator = this.googleStorageObjectPage.getObjectList().iterator();
            this.nextPageToken = this.googleStorageObjectPage.getNextPageToken();
        }
        catch (IOException io) {
            throw new RuntimeException(io);
        }
    }

    @Override
    public boolean hasNext() {
        return this.currentObject != null;
    }

    @Override
    public GoogleStorageObjectMetadata next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        GoogleStorageObjectMetadata retVal = this.currentObject;
        this.advanceStorageObject();
        return retVal;
    }

    private void advanceStorageObject() {
        while (this.blobIterator.hasNext() || this.nextPageToken != null || this.uris.hasNext()) {
            while (this.blobIterator.hasNext()) {
                GoogleStorageObjectMetadata next = this.blobIterator.next();
                if (next.getName().endsWith("/") || Long.signum(next.getSize()) <= 0) continue;
                this.currentObject = next;
                return;
            }
            if (this.nextPageToken != null) {
                this.fetchNextPage();
                continue;
            }
            if (!this.uris.hasNext()) continue;
            this.advanceURI();
            this.fetchNextPage();
        }
        this.currentObject = null;
    }
}

