/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.k8s.overlord.common;

import io.fabric8.kubernetes.api.model.batch.v1.Job;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.k8s.overlord.common.PeonPhase;
import org.joda.time.Period;
import org.joda.time.PeriodType;
import org.joda.time.ReadableInstant;

public class JobResponse {
    private static final EmittingLogger LOGGER = new EmittingLogger(JobResponse.class);
    private final Job job;
    private final PeonPhase phase;

    public JobResponse(@Nullable Job job, PeonPhase phase) {
        this.job = job;
        this.phase = phase;
    }

    public Job getJob() {
        return this.job;
    }

    public PeonPhase getPhase() {
        return this.phase;
    }

    public long getJobDuration() {
        long duration = -1L;
        String jobName = this.job != null && this.job.getMetadata() != null ? this.job.getMetadata().getName() : "";
        try {
            if (this.job != null && this.job.getStatus() != null && this.job.getStatus().getStartTime() != null && this.job.getStatus().getCompletionTime() != null) {
                duration = new Period((ReadableInstant)DateTimes.of((String)this.job.getStatus().getStartTime()), (ReadableInstant)DateTimes.of((String)this.job.getStatus().getCompletionTime()), PeriodType.millis()).getMillis();
            }
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e, "Error calculating duration for job: %s", new Object[]{jobName});
        }
        return duration;
    }
}

