/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2.logging;

import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.logging.FormattedLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SLF4JLog
extends FormattedLog {
    private final Logger logger;
    private final Level level;

    public SLF4JLog() {
        this(LoggerFactory.getLogger((String)DBI.class.getPackage().getName()));
    }

    public SLF4JLog(Logger logger) {
        this(logger, Level.TRACE);
    }

    public SLF4JLog(Logger logger, Level level) {
        this.logger = logger;
        this.level = level;
    }

    @Override
    protected boolean isEnabled() {
        return this.level.isEnabled(this.logger);
    }

    @Override
    protected void log(String msg) {
        this.level.log(this.logger, msg);
    }

    public static enum Level {
        TRACE{

            @Override
            boolean isEnabled(Logger logger) {
                return logger.isTraceEnabled();
            }

            @Override
            void log(Logger logger, String msg) {
                logger.trace(msg);
            }
        }
        ,
        DEBUG{

            @Override
            boolean isEnabled(Logger logger) {
                return logger.isDebugEnabled();
            }

            @Override
            void log(Logger logger, String msg) {
                logger.debug(msg);
            }
        }
        ,
        INFO{

            @Override
            boolean isEnabled(Logger logger) {
                return logger.isInfoEnabled();
            }

            @Override
            void log(Logger logger, String msg) {
                logger.info(msg);
            }
        }
        ,
        WARN{

            @Override
            boolean isEnabled(Logger logger) {
                return logger.isWarnEnabled();
            }

            @Override
            void log(Logger logger, String msg) {
                logger.warn(msg);
            }
        }
        ,
        ERROR{

            @Override
            boolean isEnabled(Logger logger) {
                return logger.isErrorEnabled();
            }

            @Override
            void log(Logger logger, String msg) {
                logger.error(msg);
            }
        };


        abstract boolean isEnabled(Logger var1);

        abstract void log(Logger var1, String var2);
    }
}

