/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.k8s.overlord.taskadapter;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;
import io.fabric8.kubernetes.api.model.EnvVarSourceBuilder;
import io.fabric8.kubernetes.api.model.ObjectFieldSelector;
import io.fabric8.kubernetes.api.model.PodSpecFluent;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.batch.v1.Job;
import io.fabric8.kubernetes.api.model.batch.v1.JobBuilder;
import io.fabric8.kubernetes.api.model.batch.v1.JobFluent;
import io.fabric8.kubernetes.api.model.batch.v1.JobSpecFluent;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.druid.error.DruidException;
import org.apache.druid.error.InternalServerError;
import org.apache.druid.indexing.common.config.TaskConfig;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.k8s.overlord.KubernetesTaskRunnerConfig;
import org.apache.druid.k8s.overlord.common.Base64Compression;
import org.apache.druid.k8s.overlord.common.K8sTaskId;
import org.apache.druid.k8s.overlord.common.KubernetesOverlordUtils;
import org.apache.druid.k8s.overlord.taskadapter.PodTemplateSelector;
import org.apache.druid.k8s.overlord.taskadapter.PodTemplateWithName;
import org.apache.druid.k8s.overlord.taskadapter.TaskAdapter;
import org.apache.druid.server.DruidNode;
import org.apache.druid.tasklogs.TaskLogs;

public class PodTemplateTaskAdapter
implements TaskAdapter {
    public static final String TYPE = "customTemplateAdapter";
    private static final Logger log = new Logger(PodTemplateTaskAdapter.class);
    private final KubernetesTaskRunnerConfig taskRunnerConfig;
    private final TaskConfig taskConfig;
    private final DruidNode node;
    private final ObjectMapper mapper;
    private final TaskLogs taskLogs;
    private final PodTemplateSelector podTemplateSelector;

    public PodTemplateTaskAdapter(KubernetesTaskRunnerConfig taskRunnerConfig, TaskConfig taskConfig, DruidNode node, ObjectMapper mapper, TaskLogs taskLogs, PodTemplateSelector podTemplateSelector) {
        this.taskRunnerConfig = taskRunnerConfig;
        this.taskConfig = taskConfig;
        this.node = node;
        this.mapper = mapper;
        this.taskLogs = taskLogs;
        this.podTemplateSelector = podTemplateSelector;
    }

    @Override
    public String getAdapterType() {
        return TYPE;
    }

    @Override
    public Job fromTask(Task task) throws IOException {
        Optional<PodTemplateWithName> selectedPodTemplate = this.podTemplateSelector.getPodTemplateForTask(task);
        if (selectedPodTemplate == null || !selectedPodTemplate.isPresent()) {
            throw InternalServerError.exception((String)"Could not find pod template for task [%s]. Check the overlord logs for errors selecting the pod template", (Object[])new Object[]{task.getId()});
        }
        PodTemplateWithName podTemplateWithName = (PodTemplateWithName)selectedPodTemplate.get();
        return ((JobBuilder)((JobFluent.SpecNested)((JobFluent.SpecNested)((JobFluent.SpecNested)((JobFluent.SpecNested)((JobSpecFluent.TemplateNested)((PodTemplateSpecFluent.SpecNested)((PodSpecFluent.ContainersNested)((JobSpecFluent.TemplateNested)((PodTemplateSpecFluent.MetadataNested)((PodTemplateSpecFluent.MetadataNested)((PodTemplateSpecFluent.MetadataNested)((JobFluent.SpecNested)((JobBuilder)((JobFluent.MetadataNested)((JobFluent.MetadataNested)((JobFluent.MetadataNested)((JobFluent.MetadataNested)new JobBuilder().withNewMetadata().withName(new K8sTaskId(this.taskRunnerConfig.getK8sTaskPodNamePrefix(), task).getK8sJobName())).addToLabels(this.getJobLabels(this.taskRunnerConfig, task))).addToAnnotations(this.getJobAnnotations(this.taskRunnerConfig, task))).addToAnnotations("task.jobTemplate", podTemplateWithName.getName())).endMetadata()).withNewSpec().withTemplate(podTemplateWithName.getPodTemplate().getTemplate())).editTemplate().editOrNewMetadata().addToAnnotations(this.getPodTemplateAnnotations(task))).addToAnnotations("task.jobTemplate", podTemplateWithName.getName())).addToLabels(this.getPodLabels(this.taskRunnerConfig, task))).endMetadata()).editSpec().editFirstContainer().addAllToEnv(this.getEnv(task))).endContainer()).endSpec()).endTemplate()).withActiveDeadlineSeconds(Long.valueOf(this.taskRunnerConfig.getTaskTimeout().toStandardDuration().getStandardSeconds()))).withBackoffLimit(Integer.valueOf(0))).withTtlSecondsAfterFinished(Integer.valueOf((int)this.taskRunnerConfig.getTaskCleanupDelay().toStandardDuration().getStandardSeconds()))).endSpec()).build();
    }

    @Override
    public Task toTask(Job from) throws IOException {
        Map annotations = from.getSpec().getTemplate().getMetadata().getAnnotations();
        if (annotations == null) {
            log.info("No annotations found on pod spec for job [%s]. Trying to load task payload from deep storage.", new Object[]{from.getMetadata().getName()});
            return this.toTaskUsingDeepStorage(from);
        }
        String task = (String)annotations.get("task");
        if (task == null) {
            log.info("No task annotation found on pod spec for job [%s]. Trying to load task payload from deep storage.", new Object[]{from.getMetadata().getName()});
            return this.toTaskUsingDeepStorage(from);
        }
        return (Task)this.mapper.readValue(Base64Compression.decompressBase64(task), Task.class);
    }

    private Task toTaskUsingDeepStorage(Job from) throws IOException {
        Optional taskBody = this.taskLogs.streamTaskPayload(this.getTaskId(from).getOriginalTaskId());
        if (!taskBody.isPresent()) {
            throw InternalServerError.exception((String)"Could not load task payload from deep storage for job [%s]. Check the overlord logs for errors uploading task payloads to deep storage.", (Object[])new Object[]{from.getMetadata().getName()});
        }
        String task = IOUtils.toString((InputStream)((InputStream)taskBody.get()), (Charset)Charset.defaultCharset());
        return (Task)this.mapper.readValue(task, Task.class);
    }

    @Override
    public K8sTaskId getTaskId(Job from) {
        Map annotations = from.getSpec().getTemplate().getMetadata().getAnnotations();
        if (annotations == null) {
            throw DruidException.defensive().build("No annotations found on pod spec for job [%s]", new Object[]{from.getMetadata().getName()});
        }
        String taskId = (String)annotations.get("task.id");
        if (taskId == null) {
            throw DruidException.defensive().build("No task_id annotation found on pod spec for job [%s]", new Object[]{from.getMetadata().getName()});
        }
        return new K8sTaskId(this.taskRunnerConfig.getK8sTaskPodNamePrefix(), taskId);
    }

    private Collection<EnvVar> getEnv(Task task) throws IOException {
        ArrayList envVars = Lists.newArrayList((Object[])new EnvVar[]{((EnvVarBuilder)((EnvVarBuilder)new EnvVarBuilder().withName("TASK_DIR")).withValue(Paths.get(this.taskConfig.getBaseDir(), new String[0]).resolve(task.getId()).toString())).build(), ((EnvVarBuilder)((EnvVarBuilder)new EnvVarBuilder().withName("druid_indexer_task_baseTaskDir")).withValue(this.taskConfig.getBaseDir())).build(), ((EnvVarBuilder)((EnvVarBuilder)new EnvVarBuilder().withName("TASK_ID")).withValue(task.getId())).build(), ((EnvVarBuilder)((EnvVarBuilder)new EnvVarBuilder().withName("LOAD_BROADCAST_DATASOURCE_MODE")).withValue(task.getBroadcastDatasourceLoadingSpec().getMode().toString())).build(), ((EnvVarBuilder)((EnvVarBuilder)new EnvVarBuilder().withName("LOAD_BROADCAST_SEGMENTS")).withValue(Boolean.toString(task.supportsQueries()))).build()});
        if (!this.shouldUseDeepStorageForTaskPayload(task)) {
            envVars.add(((EnvVarBuilder)((EnvVarBuilder)new EnvVarBuilder().withName("TASK_JSON")).withValueFrom(((EnvVarSourceBuilder)new EnvVarSourceBuilder().withFieldRef(new ObjectFieldSelector(null, StringUtils.format((String)"metadata.annotations['%s']", (Object[])new Object[]{"task"})))).build())).build());
        }
        return envVars;
    }

    private Map<String, String> getPodLabels(KubernetesTaskRunnerConfig config, Task task) {
        return this.getJobLabels(config, task);
    }

    private Map<String, String> getPodTemplateAnnotations(Task task) throws IOException {
        ImmutableMap.Builder podTemplateAnnotationBuilder = ImmutableMap.builder().put((Object)"tls.enabled", (Object)String.valueOf(this.node.isEnableTlsPort())).put((Object)"task.id", (Object)task.getId()).put((Object)"task.type", (Object)task.getType()).put((Object)"task.group.id", (Object)task.getGroupId()).put((Object)"task.datasource", (Object)task.getDataSource());
        if (!this.shouldUseDeepStorageForTaskPayload(task)) {
            podTemplateAnnotationBuilder.put((Object)"task", (Object)Base64Compression.compressBase64(this.mapper.writeValueAsString((Object)task)));
        }
        return podTemplateAnnotationBuilder.build();
    }

    private Map<String, String> getJobLabels(KubernetesTaskRunnerConfig config, Task task) {
        Preconditions.checkNotNull((Object)config.getNamespace(), (Object)"When using Custom Pod Templates, druid.indexer.runner.namespace cannot be null.");
        String overlordNamespace = config.getOverlordNamespace().isEmpty() ? config.getNamespace() : config.getOverlordNamespace();
        return ImmutableMap.builder().putAll(config.getLabels()).put((Object)"druid.k8s.peons", (Object)"true").put((Object)"druid.overlord.namespace", (Object)overlordNamespace).put((Object)this.getDruidLabel("task.id"), (Object)KubernetesOverlordUtils.convertTaskIdToK8sLabel(task.getId())).put((Object)this.getDruidLabel("task.type"), (Object)KubernetesOverlordUtils.convertStringToK8sLabel(task.getType())).put((Object)this.getDruidLabel("task.group.id"), (Object)KubernetesOverlordUtils.convertTaskIdToK8sLabel(task.getGroupId())).put((Object)this.getDruidLabel("task.datasource"), (Object)KubernetesOverlordUtils.convertStringToK8sLabel(task.getDataSource())).build();
    }

    private Map<String, String> getJobAnnotations(KubernetesTaskRunnerConfig config, Task task) {
        return ImmutableMap.builder().putAll(config.getAnnotations()).put((Object)"task.id", (Object)task.getId()).put((Object)"task.type", (Object)task.getType()).put((Object)"task.group.id", (Object)task.getGroupId()).put((Object)"task.datasource", (Object)task.getDataSource()).build();
    }

    private String getDruidLabel(String baseLabel) {
        return "druid." + baseLabel;
    }

    @Override
    public boolean shouldUseDeepStorageForTaskPayload(Task task) throws IOException {
        String compressedTaskPayload = Base64Compression.compressBase64(this.mapper.writeValueAsString((Object)task));
        return (long)compressedTaskPayload.length() > 130048L;
    }
}

