/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.k8s.overlord.common.httpclient.vertx;

import io.fabric8.kubernetes.client.http.HttpClient;
import io.fabric8.kubernetes.client.vertx.VertxHttpClientBuilder;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.file.FileSystemOptions;
import org.apache.druid.k8s.overlord.common.httpclient.DruidKubernetesHttpClientFactory;
import org.apache.druid.k8s.overlord.common.httpclient.vertx.DruidKubernetesVertxHttpClientConfig;

public class DruidKubernetesVertxHttpClientFactory
implements DruidKubernetesHttpClientFactory {
    public static final String TYPE_NAME = "vertx";
    private final Vertx vertx;

    public DruidKubernetesVertxHttpClientFactory(DruidKubernetesVertxHttpClientConfig httpClientConfig) {
        this.vertx = DruidKubernetesVertxHttpClientFactory.createVertxInstance(httpClientConfig);
    }

    public VertxHttpClientBuilder<DruidKubernetesVertxHttpClientFactory> newBuilder() {
        return new VertxHttpClientBuilder((HttpClient.Factory)this, this.vertx);
    }

    private static Vertx createVertxInstance(DruidKubernetesVertxHttpClientConfig httpClientConfig) {
        Vertx vertx;
        String originalDnsResolverProperty = System.getProperty("vertx.disableDnsResolver");
        try {
            System.setProperty("vertx.disableDnsResolver", "true");
            vertx = Vertx.vertx((VertxOptions)new VertxOptions().setFileSystemOptions(new FileSystemOptions().setFileCachingEnabled(false).setClassPathResolvingEnabled(false)).setWorkerPoolSize(httpClientConfig.getWorkerPoolSize()).setEventLoopPoolSize(httpClientConfig.getEventLoopPoolSize()).setInternalBlockingPoolSize(httpClientConfig.getInternalBlockingPoolSize()).setUseDaemonThread(Boolean.valueOf(true)));
        }
        finally {
            if (originalDnsResolverProperty == null) {
                System.clearProperty("vertx.disableDnsResolver");
            } else {
                System.setProperty("vertx.disableDnsResolver", originalDnsResolverProperty);
            }
        }
        return vertx;
    }
}

