/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.filtration;

import com.google.common.collect.BoundType;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import java.util.ArrayList;
import java.util.List;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.sql.calcite.filtration.Filtration;
import org.joda.time.Interval;

public class RangeSets {
    public static <T extends Comparable<T>> RangeSet<T> of(Range<T> range) {
        return RangeSets.unionRanges(ImmutableList.of(range));
    }

    public static <T extends Comparable<T>> RangeSet<T> unionRanges(Iterable<Range<T>> ranges) {
        TreeRangeSet rangeSet = null;
        for (Range<T> range : ranges) {
            if (rangeSet == null) {
                rangeSet = TreeRangeSet.create();
            }
            rangeSet.add(range);
        }
        return rangeSet;
    }

    public static <T extends Comparable<T>> RangeSet<T> unionRangeSets(Iterable<RangeSet<T>> rangeSets) {
        TreeRangeSet rangeSet = TreeRangeSet.create();
        for (RangeSet<T> set : rangeSets) {
            rangeSet.addAll(set);
        }
        return rangeSet;
    }

    public static <T extends Comparable<T>> RangeSet<T> intersectRanges(Iterable<Range<T>> ranges) {
        TreeRangeSet rangeSet = null;
        for (Range<T> range : ranges) {
            if (rangeSet == null) {
                rangeSet = TreeRangeSet.create();
                rangeSet.add(range);
                continue;
            }
            rangeSet = TreeRangeSet.create((RangeSet)rangeSet.subRangeSet(range));
        }
        return rangeSet;
    }

    public static <T extends Comparable<T>> RangeSet<T> intersectRangeSets(Iterable<RangeSet<T>> rangeSets) {
        TreeRangeSet rangeSet = null;
        for (RangeSet<T> set : rangeSets) {
            if (rangeSet == null) {
                rangeSet = TreeRangeSet.create();
                rangeSet.addAll(set);
                continue;
            }
            rangeSet.removeAll(set.complement());
        }
        return rangeSet;
    }

    public static RangeSet<Long> fromIntervals(Iterable<Interval> intervals) {
        TreeRangeSet retVal = TreeRangeSet.create();
        for (Interval interval : intervals) {
            retVal.add(Range.closedOpen((Comparable)Long.valueOf(interval.getStartMillis()), (Comparable)Long.valueOf(interval.getEndMillis())));
        }
        return retVal;
    }

    public static List<Interval> toIntervals(RangeSet<Long> rangeSet) {
        ArrayList<Interval> retVal = new ArrayList<Interval>();
        for (Range range : rangeSet.asRanges()) {
            long end;
            long start;
            long millis;
            if (range.hasLowerBound()) {
                millis = (Long)range.lowerEndpoint();
                start = millis + (long)(range.lowerBoundType() == BoundType.OPEN ? 1 : 0);
            } else {
                start = Filtration.eternity().getStartMillis();
            }
            if (range.hasUpperBound()) {
                millis = (Long)range.upperEndpoint();
                end = millis + (long)(range.upperBoundType() == BoundType.OPEN ? 0 : 1);
            } else {
                end = Filtration.eternity().getEndMillis();
            }
            retVal.add(Intervals.utc((long)start, (long)end));
        }
        return retVal;
    }
}

