/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.distributed.proxy.generic.pessimistic_locking;

import io.github.bucket4j.BucketExceptions;
import io.github.bucket4j.TimeMeter;
import io.github.bucket4j.distributed.proxy.AbstractProxyManager;
import io.github.bucket4j.distributed.proxy.ClientSideConfig;
import io.github.bucket4j.distributed.proxy.generic.GenericEntry;
import io.github.bucket4j.distributed.proxy.generic.pessimistic_locking.LockBasedTransaction;
import io.github.bucket4j.distributed.remote.CommandResult;
import io.github.bucket4j.distributed.remote.RemoteCommand;
import io.github.bucket4j.distributed.remote.Request;
import java.util.concurrent.CompletableFuture;

public abstract class AbstractLockBasedProxyManager<K>
extends AbstractProxyManager<K> {
    protected AbstractLockBasedProxyManager(ClientSideConfig clientSideConfig) {
        super(AbstractLockBasedProxyManager.injectTimeClock(clientSideConfig));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> CommandResult<T> execute(K key, Request<T> request) {
        LockBasedTransaction transaction = this.allocateTransaction(key);
        try {
            CommandResult<T> commandResult = this.execute(request, transaction);
            return commandResult;
        }
        finally {
            transaction.release();
        }
    }

    @Override
    public boolean isAsyncModeSupported() {
        return false;
    }

    @Override
    public <T> CompletableFuture<CommandResult<T>> executeAsync(K key, Request<T> request) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected CompletableFuture<Void> removeAsync(Object key) {
        return null;
    }

    protected abstract LockBasedTransaction allocateTransaction(K var1);

    private <T> CommandResult<T> execute(Request<T> request, LockBasedTransaction transaction) {
        byte[] persistedDataOnBeginOfTransaction;
        RemoteCommand<T> command = request.getCommand();
        transaction.begin();
        try {
            persistedDataOnBeginOfTransaction = transaction.lockAndGet();
        }
        catch (Throwable t) {
            this.unlockAndRollback(transaction);
            throw new BucketExceptions.BucketExecutionException(t);
        }
        if (persistedDataOnBeginOfTransaction == null && !request.getCommand().isInitializationCommand()) {
            this.unlockAndRollback(transaction);
            return CommandResult.bucketNotFound();
        }
        try {
            GenericEntry entry = new GenericEntry(persistedDataOnBeginOfTransaction, request.getBackwardCompatibilityVersion());
            CommandResult<T> result = command.execute(entry, super.getClientSideTime());
            if (entry.isModified()) {
                byte[] bytes = entry.getModifiedStateBytes();
                if (persistedDataOnBeginOfTransaction == null) {
                    transaction.create(bytes, entry.getModifiedState());
                } else {
                    transaction.update(bytes, entry.getModifiedState());
                }
            }
            transaction.unlock();
            transaction.commit();
            return result;
        }
        catch (Throwable t) {
            this.unlockAndRollback(transaction);
            throw new BucketExceptions.BucketExecutionException(t);
        }
    }

    private void unlockAndRollback(LockBasedTransaction transaction) {
        try {
            transaction.unlock();
        }
        finally {
            transaction.rollback();
        }
    }

    private static ClientSideConfig injectTimeClock(ClientSideConfig clientSideConfig) {
        if (clientSideConfig.getClientSideClock().isPresent()) {
            return clientSideConfig;
        }
        return clientSideConfig.withClientClock(TimeMeter.SYSTEM_MILLISECONDS);
    }
}

