/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.testing.metrics;

import com.google.inject.Inject;
import com.sun.jersey.spi.container.ResourceFilters;
import java.util.HashSet;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.emitter.core.EventMap;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.server.http.security.StateResourceFilter;
import org.apache.druid.testing.metrics.EventMapDeserializer;

@Path(value="/druid-ext/testing-tools/events")
public class EventCollectorResource {
    private static final Logger log = new Logger(EventCollectorResource.class);
    private final ServiceEmitter emitter;

    @Inject
    public EventCollectorResource(ServiceEmitter emitter) {
        this.emitter = emitter;
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ResourceFilters(value={StateResourceFilter.class})
    public Response postEvents(List<EventMap> events) {
        HashSet<String> services = new HashSet<String>();
        HashSet<String> hosts = new HashSet<String>();
        int collectedEvents = 0;
        for (EventMap map : events) {
            try {
                String host;
                EventMapDeserializer deserializer = new EventMapDeserializer(map);
                this.emitter.emit(deserializer.asEvent());
                ++collectedEvents;
                String service = deserializer.getService();
                if (service != null) {
                    services.add(service);
                }
                if ((host = deserializer.getHost()) == null) continue;
                hosts.add(host);
            }
            catch (Exception e) {
                log.noStackTrace().error((Throwable)e, "Could not collect event[%s]", new Object[]{map});
            }
        }
        log.debug("Collected [%d] events from service[%s], host[%s].", new Object[]{collectedEvents, services, hosts});
        return Response.ok((Object)"{}").build();
    }
}

