/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.timeline.partition;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.RangeSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.druid.timeline.partition.NumberedPartitionChunk;
import org.apache.druid.timeline.partition.PartitionChunk;
import org.apache.druid.timeline.partition.ShardSpec;
import org.apache.druid.timeline.partition.ShardSpecLookup;

public class NumberedShardSpec
implements ShardSpec {
    @JsonIgnore
    private final int partitionNum;
    @JsonIgnore
    private final int partitions;

    @JsonCreator
    public NumberedShardSpec(@JsonProperty(value="partitionNum") int partitionNum, @JsonProperty(value="partitions") int partitions) {
        Preconditions.checkArgument((partitionNum >= 0 ? 1 : 0) != 0, (Object)"partitionNum >= 0");
        Preconditions.checkArgument((partitions >= 0 ? 1 : 0) != 0, (Object)"partitions >= 0");
        this.partitionNum = partitionNum;
        this.partitions = partitions;
    }

    @Override
    @JsonProperty(value="partitionNum")
    public int getPartitionNum() {
        return this.partitionNum;
    }

    @Override
    public ShardSpecLookup getLookup(List<? extends ShardSpec> shardSpecs) {
        return NumberedShardSpec.createNumberedLookup(shardSpecs);
    }

    static ShardSpecLookup createNumberedLookup(List<? extends ShardSpec> shardSpecs) {
        return NumberedShardSpec.createLookup(shardSpecs);
    }

    static ShardSpecLookup createLookup(List<? extends ShardSpec> shardSpecs) {
        return (timestamp, row) -> (ShardSpec)shardSpecs.get(0);
    }

    @Override
    public List<String> getDomainDimensions() {
        return ImmutableList.of();
    }

    @Override
    public boolean possibleInDomain(Map<String, RangeSet<String>> domain) {
        return true;
    }

    @Override
    @JsonProperty(value="partitions")
    public int getNumCorePartitions() {
        return this.partitions;
    }

    @Override
    public <T> PartitionChunk<T> createChunk(T obj) {
        return NumberedPartitionChunk.make(this.partitionNum, this.partitions, obj);
    }

    @Override
    public String getType() {
        return "numbered";
    }

    public String toString() {
        return "NumberedShardSpec{partitionNum=" + this.partitionNum + ", partitions=" + this.partitions + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NumberedShardSpec that = (NumberedShardSpec)o;
        return this.partitionNum == that.partitionNum && this.partitions == that.partitions;
    }

    public int hashCode() {
        return Objects.hash(this.partitionNum, this.partitions);
    }
}

