/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.virtual;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Doubles;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.Numbers;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.math.expr.Parser;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.expression.NestedDataExpressions;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.filter.ColumnIndexSelector;
import org.apache.druid.query.filter.DruidPredicateFactory;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.BaseSingleValueDimensionSelector;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.ColumnSelector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.IdLookup;
import org.apache.druid.segment.NilColumnValueSelector;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.druid.segment.column.ColumnHolder;
import org.apache.druid.segment.column.ColumnIndexSupplier;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.DictionaryEncodedColumn;
import org.apache.druid.segment.column.NumericColumn;
import org.apache.druid.segment.column.SelectableColumn;
import org.apache.druid.segment.column.Types;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.column.ValueTypes;
import org.apache.druid.segment.data.IndexedInts;
import org.apache.druid.segment.data.ReadableOffset;
import org.apache.druid.segment.nested.NestedColumnIndexSupplier;
import org.apache.druid.segment.nested.NestedColumnSelectorFactory;
import org.apache.druid.segment.nested.NestedColumnTypeInspector;
import org.apache.druid.segment.nested.NestedCommonFormatColumn;
import org.apache.druid.segment.nested.NestedPathArrayElement;
import org.apache.druid.segment.nested.NestedPathFinder;
import org.apache.druid.segment.nested.NestedPathPart;
import org.apache.druid.segment.nested.NestedVectorColumnSelectorFactory;
import org.apache.druid.segment.nested.StructuredData;
import org.apache.druid.segment.nested.VariantColumn;
import org.apache.druid.segment.serde.NoIndexesColumnIndexSupplier;
import org.apache.druid.segment.vector.BaseDoubleVectorValueSelector;
import org.apache.druid.segment.vector.BaseFloatVectorValueSelector;
import org.apache.druid.segment.vector.BaseLongVectorValueSelector;
import org.apache.druid.segment.vector.NilVectorSelector;
import org.apache.druid.segment.vector.ReadableVectorOffset;
import org.apache.druid.segment.vector.SingleValueDimensionVectorSelector;
import org.apache.druid.segment.vector.VectorColumnSelectorFactory;
import org.apache.druid.segment.vector.VectorObjectSelector;
import org.apache.druid.segment.vector.VectorValueSelector;
import org.apache.druid.segment.virtual.ExpressionSelectors;
import org.apache.druid.segment.virtual.ExpressionVectorSelectors;

@JsonTypeName(value="nested-field")
public class NestedFieldVirtualColumn
implements VirtualColumn {
    private static final NestedDataExpressions.JsonQueryExprMacro JSON_QUERY = new NestedDataExpressions.JsonQueryExprMacro();
    private static final NestedDataExpressions.JsonValueExprMacro JSON_VALUE = new NestedDataExpressions.JsonValueExprMacro();
    private final String outputName;
    private final NestedFieldSpec fieldSpec;
    private final boolean hasNegativeArrayIndex;

    @JsonCreator
    public NestedFieldVirtualColumn(@JsonProperty(value="columnName") String columnName, @JsonProperty(value="outputName") String outputName, @JsonProperty(value="expectedType") @Nullable ColumnType expectedType, @JsonProperty(value="pathParts") @Nullable List<NestedPathPart> parts, @JsonProperty(value="processFromRaw") @Nullable Boolean processFromRaw, @JsonProperty(value="path") @Nullable String path, @JsonProperty(value="useJqSyntax") @Nullable Boolean useJqSyntax) {
        List<NestedPathPart> pathParts;
        this.outputName = outputName;
        if (path != null) {
            Preconditions.checkArgument((parts == null ? 1 : 0) != 0, (Object)"Cannot define both 'path' and 'pathParts'");
        } else if (parts == null) {
            throw new IllegalArgumentException("Must define exactly one of 'path' or 'pathParts'");
        }
        if (parts != null) {
            pathParts = parts;
        } else {
            boolean isInputJq = useJqSyntax != null && useJqSyntax != false;
            pathParts = isInputJq ? NestedPathFinder.parseJqPath(path) : NestedPathFinder.parseJsonPath(path);
        }
        boolean hasNegative = false;
        for (NestedPathPart part : pathParts) {
            NestedPathArrayElement elementPart;
            if (!(part instanceof NestedPathArrayElement) || (elementPart = (NestedPathArrayElement)part).getIndex() >= 0) continue;
            hasNegative = true;
            break;
        }
        this.hasNegativeArrayIndex = hasNegative;
        this.fieldSpec = new NestedFieldSpec(columnName, expectedType, pathParts, processFromRaw != null && processFromRaw != false);
    }

    @VisibleForTesting
    public NestedFieldVirtualColumn(String columnName, String path, String outputName) {
        this(columnName, outputName, null, null, null, path, false);
    }

    @VisibleForTesting
    public NestedFieldVirtualColumn(String columnName, String path, String outputName, @Nullable ColumnType expectedType) {
        this(columnName, outputName, expectedType, null, null, path, false);
    }

    @Override
    @Nullable
    public byte[] getCacheKey() {
        String partsString = NestedPathFinder.toNormalizedJsonPath(this.fieldSpec.parts);
        return new CacheKeyBuilder(-1).appendString("nested-field").appendString(this.outputName).appendString(this.fieldSpec.columnName).appendString(partsString).appendBoolean(this.fieldSpec.processFromRaw).build();
    }

    @Override
    @JsonProperty
    public String getOutputName() {
        return this.outputName;
    }

    @JsonProperty
    public String getColumnName() {
        return this.fieldSpec.columnName;
    }

    @JsonProperty(value="pathParts")
    public List<NestedPathPart> getPathParts() {
        return this.fieldSpec.parts;
    }

    @Nullable
    @JsonProperty
    public ColumnType getExpectedType() {
        return this.fieldSpec.expectedType;
    }

    @JsonProperty
    public boolean isProcessFromRaw() {
        return this.fieldSpec.processFromRaw;
    }

    @Override
    public DimensionSelector makeDimensionSelector(DimensionSpec dimensionSpec, ColumnSelectorFactory selectorFactory, @Nullable ColumnSelector columnSelector, @Nullable ReadableOffset offset) {
        if (columnSelector == null) {
            return dimensionSpec.decorate(new FieldDimensionSelector(this.makeColumnValueSelectorUsingColumnSelectorFactory(selectorFactory)));
        }
        ColumnHolder holder = columnSelector.getColumnHolder(this.fieldSpec.columnName);
        if (holder == null) {
            return dimensionSpec.decorate(DimensionSelector.constant(null, dimensionSpec.getExtractionFn()));
        }
        if (this.hasNegativeArrayIndex) {
            return dimensionSpec.decorate(new FieldDimensionSelector(this.makeColumnValueSelectorUsingColumnSelectorFactory(selectorFactory)));
        }
        return dimensionSpec.decorate(this.makeDimensionSelectorUndecorated(holder, dimensionSpec.getExtractionFn(), selectorFactory, offset));
    }

    private DimensionSelector makeDimensionSelectorUndecorated(ColumnHolder holder, @Nullable ExtractionFn extractionFn, ColumnSelectorFactory selectorFactory, ReadableOffset offset) {
        SelectableColumn theColumn = holder.getColumn();
        NestedColumnTypeInspector nestedTypeInspector = theColumn.as(NestedColumnTypeInspector.class);
        NestedColumnSelectorFactory nestedColumnSelectorFactory = theColumn.as(NestedColumnSelectorFactory.class);
        if (nestedTypeInspector != null && nestedColumnSelectorFactory != null) {
            ColumnType logicalType = nestedTypeInspector.getFieldLogicalType(this.fieldSpec.parts);
            if (logicalType != null && logicalType.isArray()) {
                return new FieldDimensionSelector(nestedColumnSelectorFactory.makeColumnValueSelector(this.fieldSpec.parts, selectorFactory, offset));
            }
            return nestedColumnSelectorFactory.makeDimensionSelector(this.fieldSpec.parts, extractionFn, selectorFactory, offset);
        }
        if (this.fieldSpec.parts.isEmpty()) {
            if (theColumn instanceof DictionaryEncodedColumn) {
                DictionaryEncodedColumn column = (DictionaryEncodedColumn)theColumn;
                return new BestEffortCastingValueSelector(column.makeDimensionSelector(offset, extractionFn));
            }
            return ValueTypes.makeNumericWrappingDimensionSelector((ValueType)holder.getCapabilities().getType(), selectorFactory.makeColumnValueSelector(this.fieldSpec.columnName), extractionFn);
        }
        if (this.isRootArrayElementPathAndArrayColumn(theColumn)) {
            VariantColumn arrayColumn = (VariantColumn)theColumn;
            final ColumnValueSelector<?> arraySelector = arrayColumn.makeColumnValueSelector(offset);
            final int elementNumber = ((NestedPathArrayElement)this.fieldSpec.parts.get(0)).getIndex();
            if (elementNumber < 0) {
                throw new IAE("Cannot make array element selector, negative array index not supported", new Object[0]);
            }
            return new BaseSingleValueDimensionSelector(){

                @Override
                @Nullable
                protected String getValue() {
                    Object[] array;
                    Object o = arraySelector.getObject();
                    if (o instanceof Object[] && elementNumber < (array = (Object[])o).length) {
                        Object element = array[elementNumber];
                        if (element == null) {
                            return null;
                        }
                        return String.valueOf(element);
                    }
                    return null;
                }

                @Override
                public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                    arraySelector.inspectRuntimeShape(inspector);
                }
            };
        }
        return DimensionSelector.constant(null, extractionFn);
    }

    @Override
    public ColumnValueSelector<?> makeColumnValueSelector(String columnName, ColumnSelectorFactory selectorFactory, @Nullable ColumnSelector columnSelector, @Nullable ReadableOffset offset) {
        if (columnSelector == null) {
            return this.makeColumnValueSelectorUsingColumnSelectorFactory(selectorFactory);
        }
        ColumnHolder holder = columnSelector.getColumnHolder(this.fieldSpec.columnName);
        if (holder == null) {
            return NilColumnValueSelector.instance();
        }
        SelectableColumn theColumn = holder.getColumn();
        if (this.fieldSpec.processFromRaw || this.hasNegativeArrayIndex) {
            return this.makeColumnValueSelectorUsingColumnSelectorFactory(selectorFactory);
        }
        NestedColumnTypeInspector nestedTypeInspector = theColumn.as(NestedColumnTypeInspector.class);
        NestedColumnSelectorFactory nestedColumnSelectorFactory = theColumn.as(NestedColumnSelectorFactory.class);
        if (nestedTypeInspector != null && nestedColumnSelectorFactory != null) {
            ColumnType fieldType = nestedTypeInspector.getFieldLogicalType(this.fieldSpec.parts);
            if (fieldType != null && this.fieldSpec.expectedType != null && !this.fieldSpec.expectedType.equals(fieldType)) {
                return ExpressionSelectors.castColumnValueSelector(offset::getOffset, nestedColumnSelectorFactory.makeColumnValueSelector(this.fieldSpec.parts, selectorFactory, offset), fieldType, this.fieldSpec.expectedType);
            }
            return nestedColumnSelectorFactory.makeColumnValueSelector(this.fieldSpec.parts, selectorFactory, offset);
        }
        if (this.fieldSpec.parts.isEmpty()) {
            if (theColumn instanceof DictionaryEncodedColumn && !(theColumn instanceof VariantColumn)) {
                DictionaryEncodedColumn column = (DictionaryEncodedColumn)theColumn;
                return new BestEffortCastingValueSelector(column.makeDimensionSelector(offset, null));
            }
            return selectorFactory.makeColumnValueSelector(this.fieldSpec.columnName);
        }
        if (this.isRootArrayElementPathAndArrayColumn(theColumn)) {
            VariantColumn arrayColumn = (VariantColumn)theColumn;
            ColumnValueSelector<?> arraySelector = arrayColumn.makeColumnValueSelector(offset);
            int elementNumber = ((NestedPathArrayElement)this.fieldSpec.parts.get(0)).getIndex();
            if (elementNumber < 0) {
                throw new IAE("Cannot make array element selector, negative array index not supported", new Object[0]);
            }
            return new ArrayElementColumnValueSelector(arraySelector, elementNumber);
        }
        return NilColumnValueSelector.instance();
    }

    @Override
    public boolean canVectorize(ColumnInspector inspector) {
        return !this.hasNegativeArrayIndex;
    }

    @Override
    public SingleValueDimensionVectorSelector makeSingleValueVectorDimensionSelector(DimensionSpec dimensionSpec, VectorColumnSelectorFactory selectorFactory, ColumnSelector columnSelector, ReadableVectorOffset offset) {
        ColumnHolder holder = columnSelector.getColumnHolder(this.fieldSpec.columnName);
        if (holder == null) {
            return dimensionSpec.decorate(NilVectorSelector.create(offset));
        }
        return dimensionSpec.decorate(this.makeSingleValueVectorDimensionSelectorUndecorated(holder, selectorFactory, offset));
    }

    private SingleValueDimensionVectorSelector makeSingleValueVectorDimensionSelectorUndecorated(ColumnHolder holder, VectorColumnSelectorFactory selectorFactory, ReadableVectorOffset offset) {
        SelectableColumn theColumn = holder.getColumn();
        NestedVectorColumnSelectorFactory nestedColumnSelectorFactory = theColumn.as(NestedVectorColumnSelectorFactory.class);
        if (nestedColumnSelectorFactory != null) {
            return nestedColumnSelectorFactory.makeSingleValueDimensionVectorSelector(this.fieldSpec.parts, selectorFactory, offset);
        }
        if (this.fieldSpec.parts.isEmpty()) {
            return ((DictionaryEncodedColumn)theColumn).makeSingleValueDimensionVectorSelector(offset);
        }
        return NilVectorSelector.create(offset);
    }

    @Override
    public VectorObjectSelector makeVectorObjectSelector(String columnName, VectorColumnSelectorFactory selectorFactory, ColumnSelector columnSelector, ReadableVectorOffset offset) {
        ColumnHolder holder = columnSelector.getColumnHolder(this.fieldSpec.columnName);
        if (holder == null) {
            return NilVectorSelector.create(offset);
        }
        SelectableColumn column = holder.getColumn();
        NestedColumnTypeInspector nestedTypeInspector = column.as(NestedColumnTypeInspector.class);
        NestedVectorColumnSelectorFactory nestedColumnSelectorFactory = column.as(NestedVectorColumnSelectorFactory.class);
        if (NestedFieldVirtualColumn.isNestedColumn(holder)) {
            if (this.fieldSpec.processFromRaw || nestedTypeInspector == null || nestedColumnSelectorFactory == null) {
                return new RawFieldVectorObjectSelector(selectorFactory.makeObjectSelector(this.fieldSpec.columnName), this.fieldSpec.parts, this.fieldSpec.processFromRaw ? ColumnType.NESTED_DATA : this.getExpectedType());
            }
            ColumnType leastRestrictiveType = nestedTypeInspector.getFieldLogicalType(this.fieldSpec.parts);
            if (leastRestrictiveType != null && leastRestrictiveType.isNumeric() && !Types.isNumeric(this.fieldSpec.expectedType)) {
                return ExpressionVectorSelectors.castValueSelectorToObject(offset, columnName, nestedColumnSelectorFactory.makeVectorValueSelector(this.fieldSpec.parts, selectorFactory, offset), leastRestrictiveType, this.fieldSpec.expectedType == null ? ColumnType.STRING : this.fieldSpec.expectedType);
            }
            VectorObjectSelector objectSelector = nestedColumnSelectorFactory.makeVectorObjectSelector(this.fieldSpec.parts, selectorFactory, offset);
            return this.castVectorObjectSelectorIfNeeded(columnName, offset, leastRestrictiveType, objectSelector);
        }
        if (this.fieldSpec.parts.isEmpty()) {
            ColumnCapabilities capabilities = holder.getCapabilities();
            if (capabilities.isNumeric()) {
                Preconditions.checkArgument((this.fieldSpec.expectedType != null ? 1 : 0) != 0, (Object)"Asked for a VectorObjectSelector on a numeric column, 'expectedType' must not be null");
                return ExpressionVectorSelectors.castValueSelectorToObject(offset, this.fieldSpec.columnName, selectorFactory.makeValueSelector(this.fieldSpec.columnName), capabilities.toColumnType(), this.fieldSpec.expectedType);
            }
            VectorObjectSelector delegate = selectorFactory.makeObjectSelector(this.fieldSpec.columnName);
            return this.castVectorObjectSelectorIfNeeded(columnName, offset, capabilities.toColumnType(), delegate);
        }
        if (this.isRootArrayElementPathAndArrayColumn(column)) {
            VariantColumn arrayColumn = (VariantColumn)column;
            ExpressionType elementType = ExpressionType.fromColumnTypeStrict(arrayColumn.getLogicalType().isArray() ? arrayColumn.getLogicalType().getElementType() : arrayColumn.getLogicalType());
            ExpressionType castTo = this.fieldSpec.expectedType == null ? ExpressionType.STRING : ExpressionType.fromColumnTypeStrict(this.fieldSpec.expectedType);
            VectorObjectSelector arraySelector = arrayColumn.makeVectorObjectSelector(offset);
            int elementNumber = ((NestedPathArrayElement)this.fieldSpec.parts.get(0)).getIndex();
            if (elementNumber < 0) {
                throw new IAE("Cannot make array element selector, negative array index not supported", new Object[0]);
            }
            return new ArrayElementVectorObjectSelector(arraySelector, offset, elementNumber, elementType, castTo);
        }
        return NilVectorSelector.create(offset);
    }

    @Override
    public VectorValueSelector makeVectorValueSelector(String columnName, VectorColumnSelectorFactory selectorFactory, ColumnSelector columnSelector, ReadableVectorOffset offset) {
        ColumnHolder holder = columnSelector.getColumnHolder(this.fieldSpec.columnName);
        if (holder == null) {
            return NilVectorSelector.create(offset);
        }
        SelectableColumn theColumn = holder.getColumn();
        NestedColumnTypeInspector nestedTypeInspector = theColumn.as(NestedColumnTypeInspector.class);
        NestedVectorColumnSelectorFactory nestedColumnSelectorFactory = theColumn.as(NestedVectorColumnSelectorFactory.class);
        if (!NestedFieldVirtualColumn.isNestedColumn(holder)) {
            if (this.fieldSpec.parts.isEmpty()) {
                if (holder.getCapabilities().isNumeric()) {
                    return selectorFactory.makeValueSelector(this.fieldSpec.columnName);
                }
                ColumnType castTo = this.fieldSpec.expectedType != null ? this.fieldSpec.expectedType : ColumnType.DOUBLE;
                return ExpressionVectorSelectors.castObjectSelectorToNumeric(offset, columnName, selectorFactory.makeObjectSelector(this.fieldSpec.columnName), holder.getCapabilities().toColumnType(), castTo);
            }
            if (this.isRootArrayElementPathAndArrayColumn(theColumn)) {
                VariantColumn arrayColumn = (VariantColumn)theColumn;
                VectorObjectSelector arraySelector = arrayColumn.makeVectorObjectSelector(offset);
                int elementNumber = ((NestedPathArrayElement)this.fieldSpec.parts.get(0)).getIndex();
                if (elementNumber < 0) {
                    throw new IAE("Cannot make array element selector, negative array index not supported", new Object[0]);
                }
                if (this.fieldSpec.expectedType != null && this.fieldSpec.expectedType.is(ValueType.LONG)) {
                    return new ArrayElementLongVectorValueSelector(offset, arraySelector, elementNumber);
                }
                if (this.fieldSpec.expectedType != null && this.fieldSpec.expectedType.is(ValueType.FLOAT)) {
                    return new ArrayElementFloatVectorValueSelector(offset, arraySelector, elementNumber);
                }
                return new ArrayElementDoubleVectorValueSelector(offset, arraySelector, elementNumber);
            }
            return NilVectorSelector.create(offset);
        }
        if (nestedTypeInspector == null || nestedColumnSelectorFactory == null) {
            ColumnType objectType = this.fieldSpec.expectedType == null ? ColumnType.DOUBLE : this.fieldSpec.expectedType;
            return new RawFieldVectorObjectSelector(selectorFactory.makeObjectSelector(this.fieldSpec.columnName), this.fieldSpec.parts, objectType);
        }
        if (nestedTypeInspector.isNumeric(this.fieldSpec.parts) || this.fieldSpec.expectedType == null) {
            return nestedColumnSelectorFactory.makeVectorValueSelector(this.fieldSpec.parts, selectorFactory, offset);
        }
        VectorObjectSelector fieldSelector = nestedColumnSelectorFactory.makeVectorObjectSelector(this.fieldSpec.parts, selectorFactory, offset);
        ColumnType leastRestrictiveType = nestedTypeInspector.getFieldLogicalType(this.fieldSpec.parts);
        return ExpressionVectorSelectors.castObjectSelectorToNumeric(offset, columnName, fieldSelector, leastRestrictiveType, this.fieldSpec.expectedType);
    }

    @Override
    @Nullable
    public ColumnIndexSupplier getIndexSupplier(String columnName, ColumnIndexSelector indexSelector) {
        ColumnHolder holder = indexSelector.getColumnHolder(this.fieldSpec.columnName);
        if (holder == null) {
            return null;
        }
        SelectableColumn theColumn = holder.getColumn();
        NestedColumnTypeInspector typeInspector = theColumn.as(NestedColumnTypeInspector.class);
        NestedColumnIndexSupplier indexSupplier = theColumn.as(NestedColumnIndexSupplier.class);
        if (NestedFieldVirtualColumn.isNestedColumn(holder)) {
            if (typeInspector == null || indexSupplier == null) {
                return NoIndexesColumnIndexSupplier.getInstance();
            }
            ColumnIndexSupplier nestedColumnPathIndexSupplier = indexSupplier.getColumnIndexSupplier(this.fieldSpec.parts);
            if (nestedColumnPathIndexSupplier == null && this.fieldSpec.processFromRaw) {
                return NoIndexesColumnIndexSupplier.getInstance();
            }
            if (this.fieldSpec.expectedType != null) {
                Set<ColumnType> types = typeInspector.getFieldTypes(this.fieldSpec.parts);
                if (this.fieldSpec.expectedType.isNumeric() && (types == null || types.stream().anyMatch(t -> !t.isNumeric()))) {
                    return NoIndexesColumnIndexSupplier.getInstance();
                }
            }
            return nestedColumnPathIndexSupplier;
        }
        if (this.fieldSpec.parts.isEmpty()) {
            ColumnIndexSupplier baseIndexSupplier = indexSelector.getIndexSupplier(this.fieldSpec.columnName);
            if (this.fieldSpec.expectedType != null) {
                if (theColumn instanceof NumericColumn) {
                    return baseIndexSupplier;
                }
                if (theColumn instanceof NestedCommonFormatColumn) {
                    NestedCommonFormatColumn commonFormat = (NestedCommonFormatColumn)theColumn;
                    if (this.fieldSpec.expectedType.isNumeric() && !commonFormat.getLogicalType().isNumeric()) {
                        return NoIndexesColumnIndexSupplier.getInstance();
                    }
                } else {
                    return this.fieldSpec.expectedType.isNumeric() ? NoIndexesColumnIndexSupplier.getInstance() : baseIndexSupplier;
                }
            }
            return baseIndexSupplier;
        }
        if (this.isRootArrayElementPathAndArrayColumn(theColumn)) {
            return NoIndexesColumnIndexSupplier.getInstance();
        }
        return null;
    }

    @Override
    public ColumnCapabilities capabilities(String columnName) {
        if (this.fieldSpec.processFromRaw) {
            return ColumnCapabilitiesImpl.createDefault().setType(ColumnType.NESTED_DATA).setHasMultipleValues(false).setHasNulls(true);
        }
        return ColumnCapabilitiesImpl.createDefault().setType(this.fieldSpec.expectedType != null ? this.fieldSpec.expectedType : ColumnType.STRING).setHasNulls(true);
    }

    @Override
    @Nullable
    public ColumnCapabilities capabilities(ColumnInspector inspector, String columnName) {
        if (this.fieldSpec.processFromRaw) {
            if (this.fieldSpec.expectedType != null && this.fieldSpec.expectedType.isArray() && ColumnType.NESTED_DATA.equals(this.fieldSpec.expectedType.getElementType())) {
                return ColumnCapabilitiesImpl.createDefault().setType(ColumnType.ofArray(ColumnType.NESTED_DATA)).setHasMultipleValues(false).setHasNulls(true);
            }
            return ColumnCapabilitiesImpl.createDefault().setType(ColumnType.NESTED_DATA).setHasMultipleValues(false).setHasNulls(true);
        }
        ColumnCapabilities capabilities = inspector.getColumnCapabilities(this.fieldSpec.columnName);
        if (capabilities != null) {
            if (capabilities.is(ValueType.COMPLEX) && capabilities.getComplexTypeName().equals("json") && capabilities.isDictionaryEncoded().isTrue()) {
                boolean useDictionary = this.fieldSpec.parts.isEmpty() || !(this.fieldSpec.parts.get(this.fieldSpec.parts.size() - 1) instanceof NestedPathArrayElement);
                return ColumnCapabilitiesImpl.createDefault().setType(this.fieldSpec.expectedType != null ? this.fieldSpec.expectedType : ColumnType.STRING).setDictionaryEncoded(useDictionary).setDictionaryValuesSorted(useDictionary).setDictionaryValuesUnique(useDictionary).setHasBitmapIndexes(useDictionary).setHasNulls(true);
            }
            if (this.fieldSpec.parts.isEmpty()) {
                ColumnCapabilitiesImpl copy = ColumnCapabilitiesImpl.copyOf(capabilities);
                if (this.fieldSpec.expectedType != null) {
                    copy.setType(this.fieldSpec.expectedType);
                    copy.setHasNulls(copy.hasNulls().or(ColumnCapabilities.Capable.of(this.fieldSpec.expectedType.getType() != capabilities.getType())));
                }
                return copy;
            }
            if (capabilities.isPrimitive()) {
                return null;
            }
        }
        return this.capabilities(columnName);
    }

    @Override
    public List<String> requiredColumns() {
        return Collections.singletonList(this.fieldSpec.columnName);
    }

    @Override
    public boolean usesDotNotation() {
        return false;
    }

    @Override
    @Nullable
    public VirtualColumn.EquivalenceKey getEquivalanceKey() {
        return this.fieldSpec;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NestedFieldVirtualColumn that = (NestedFieldVirtualColumn)o;
        return this.outputName.equals(that.outputName) && this.fieldSpec.equals(that.fieldSpec);
    }

    public int hashCode() {
        return Objects.hash(this.outputName, this.fieldSpec);
    }

    public String toString() {
        return "NestedFieldVirtualColumn{columnName='" + this.fieldSpec.columnName + "', outputName='" + this.outputName + "', typeHint='" + String.valueOf(this.fieldSpec.expectedType) + "', pathParts='" + String.valueOf(this.fieldSpec.parts) + "', allowFallback=" + this.fieldSpec.processFromRaw + "}";
    }

    private ColumnValueSelector<?> makeColumnValueSelectorUsingColumnSelectorFactory(ColumnSelectorFactory factory) {
        Expr jsonExpr;
        Expr identifier = Parser.identifier(this.fieldSpec.columnName);
        Expr path = Parser.constant(NestedPathFinder.toNormalizedJsonPath(this.fieldSpec.parts));
        if (this.fieldSpec.processFromRaw) {
            jsonExpr = JSON_QUERY.apply(List.of(identifier, path));
        } else {
            List<Expr> args;
            if (this.fieldSpec.expectedType != null) {
                Expr castType = Parser.constant(ExpressionType.fromColumnTypeStrict(this.fieldSpec.expectedType).asTypeString());
                args = List.of(identifier, path, castType);
            } else {
                args = List.of(identifier, path);
            }
            jsonExpr = JSON_VALUE.apply(args);
        }
        return ExpressionSelectors.makeColumnValueSelector(factory, jsonExpr);
    }

    private boolean isRootArrayElementPathAndArrayColumn(SelectableColumn theColumn) {
        return this.fieldSpec.parts.size() == 1 && this.fieldSpec.parts.get(0) instanceof NestedPathArrayElement && theColumn instanceof VariantColumn;
    }

    private VectorObjectSelector castVectorObjectSelectorIfNeeded(String columnName, ReadableVectorOffset offset, ColumnType leastRestrictiveType, VectorObjectSelector objectSelector) {
        if (this.fieldSpec.expectedType != null && !Objects.equals(this.fieldSpec.expectedType, leastRestrictiveType)) {
            return ExpressionVectorSelectors.castObject(offset, columnName, objectSelector, leastRestrictiveType, this.fieldSpec.expectedType);
        }
        return objectSelector;
    }

    private static boolean isNestedColumn(ColumnHolder holder) {
        return holder.getCapabilities().toColumnType().equals(ColumnType.NESTED_DATA);
    }

    private static class NestedFieldSpec
    implements VirtualColumn.EquivalenceKey {
        private final String columnName;
        @Nullable
        private final ColumnType expectedType;
        private final List<NestedPathPart> parts;
        private final boolean processFromRaw;

        private NestedFieldSpec(String columnName, @Nullable ColumnType expectedType, List<NestedPathPart> parts, boolean processFromRaw) {
            this.columnName = columnName;
            this.expectedType = expectedType;
            this.parts = parts;
            this.processFromRaw = processFromRaw;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NestedFieldSpec that = (NestedFieldSpec)o;
            return this.processFromRaw == that.processFromRaw && Objects.equals(this.columnName, that.columnName) && Objects.equals(this.expectedType, that.expectedType) && Objects.equals(this.parts, that.parts);
        }

        public int hashCode() {
            return Objects.hash(this.columnName, this.expectedType, this.parts, this.processFromRaw);
        }
    }

    public static final class FieldDimensionSelector
    extends BaseSingleValueDimensionSelector {
        private final ColumnValueSelector<?> valueSelector;

        public FieldDimensionSelector(ColumnValueSelector<?> valueSelector) {
            this.valueSelector = valueSelector;
        }

        @Override
        public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
            inspector.visit("valueSelector", this.valueSelector);
        }

        @Override
        @Nullable
        protected String getValue() {
            Object val = this.valueSelector.getObject();
            if (val == null || val instanceof String) {
                return (String)val;
            }
            if (val instanceof Object[]) {
                Object[] arrayVal = (Object[])val;
                if (arrayVal.length == 1) {
                    return String.valueOf(arrayVal[0]);
                }
                return null;
            }
            return String.valueOf(val);
        }
    }

    private static final class BestEffortCastingValueSelector
    implements DimensionSelector {
        private final DimensionSelector baseSelector;

        public BestEffortCastingValueSelector(DimensionSelector baseSelector) {
            this.baseSelector = baseSelector;
        }

        @Override
        public IndexedInts getRow() {
            return this.baseSelector.getRow();
        }

        @Override
        public ValueMatcher makeValueMatcher(@Nullable String value) {
            return this.baseSelector.makeValueMatcher(value);
        }

        @Override
        public ValueMatcher makeValueMatcher(DruidPredicateFactory predicateFactory) {
            return this.baseSelector.makeValueMatcher(predicateFactory);
        }

        @Override
        public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
            this.baseSelector.inspectRuntimeShape(inspector);
        }

        @Override
        @Nullable
        public Object getObject() {
            return this.baseSelector.getObject();
        }

        @Override
        public Class<?> classOfObject() {
            return this.baseSelector.classOfObject();
        }

        @Override
        public int getValueCardinality() {
            return this.baseSelector.getValueCardinality();
        }

        @Override
        @Nullable
        public String lookupName(int id) {
            return this.baseSelector.lookupName(id);
        }

        @Override
        @Nullable
        public ByteBuffer lookupNameUtf8(int id) {
            return this.baseSelector.lookupNameUtf8(id);
        }

        @Override
        public boolean supportsLookupNameUtf8() {
            return this.baseSelector.supportsLookupNameUtf8();
        }

        @Override
        public float getFloat() {
            IndexedInts row = this.getRow();
            if (row.size() != 1) {
                return 0.0f;
            }
            return Numbers.tryParseFloat(this.lookupName(row.get(0)), 0.0f);
        }

        @Override
        public double getDouble() {
            IndexedInts row = this.getRow();
            if (row.size() != 1) {
                return 0.0;
            }
            return Numbers.tryParseDouble(this.lookupName(row.get(0)), 0.0);
        }

        @Override
        public long getLong() {
            IndexedInts row = this.getRow();
            if (row.size() != 1) {
                return 0L;
            }
            return Numbers.tryParseLong(this.lookupName(row.get(0)), 0L);
        }

        @Override
        public boolean isNull() {
            IndexedInts row = this.getRow();
            if (row.size() != 1) {
                return true;
            }
            String s = this.lookupName(row.get(0));
            return s == null || Doubles.tryParse((String)s) == null;
        }

        @Override
        public boolean nameLookupPossibleInAdvance() {
            return this.baseSelector.nameLookupPossibleInAdvance();
        }

        @Override
        @Nullable
        public IdLookup idLookup() {
            return this.baseSelector.idLookup();
        }
    }

    private static final class ArrayElementColumnValueSelector
    implements ColumnValueSelector<Object> {
        private final ColumnValueSelector<?> arraySelector;
        private final int elementNumber;

        public ArrayElementColumnValueSelector(ColumnValueSelector<?> arraySelector, int elementNumber) {
            this.arraySelector = arraySelector;
            this.elementNumber = elementNumber;
        }

        @Override
        public boolean isNull() {
            Object o = this.getObject();
            return !(o instanceof Number);
        }

        @Override
        public long getLong() {
            Object o = this.getObject();
            return o instanceof Number ? ((Number)o).longValue() : 0L;
        }

        @Override
        public float getFloat() {
            Object o = this.getObject();
            return o instanceof Number ? ((Number)o).floatValue() : 0.0f;
        }

        @Override
        public double getDouble() {
            Object o = this.getObject();
            return o instanceof Number ? ((Number)o).doubleValue() : 0.0;
        }

        @Override
        public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
            this.arraySelector.inspectRuntimeShape(inspector);
        }

        @Override
        @Nullable
        public Object getObject() {
            Object[] array;
            Object o = this.arraySelector.getObject();
            if (o instanceof Object[] && this.elementNumber < (array = (Object[])o).length) {
                return array[this.elementNumber];
            }
            return null;
        }

        @Override
        public Class<?> classOfObject() {
            return Object.class;
        }
    }

    public static final class RawFieldVectorObjectSelector
    implements VectorObjectSelector,
    VectorValueSelector {
        private final VectorObjectSelector baseSelector;
        private final List<NestedPathPart> parts;
        private final Object[] vector;
        @Nullable
        private final ColumnType expectedType;
        @Nullable
        private final ExpressionType expectedExpressionType;

        public RawFieldVectorObjectSelector(VectorObjectSelector baseSelector, List<NestedPathPart> parts, @Nullable ColumnType expectedType) {
            this.baseSelector = baseSelector;
            this.parts = parts;
            this.vector = new Object[baseSelector.getMaxVectorSize()];
            this.expectedType = expectedType;
            this.expectedExpressionType = ExpressionType.fromColumnType(expectedType);
        }

        @Override
        public Object[] getObjectVector() {
            Object[] baseVector = this.baseSelector.getObjectVector();
            for (int i = 0; i < this.baseSelector.getCurrentVectorSize(); ++i) {
                this.vector[i] = this.compute(baseVector[i]);
            }
            return this.vector;
        }

        @Override
        public long[] getLongVector() {
            Object[] objects = this.getObjectVector();
            long[] retVal = new long[this.baseSelector.getMaxVectorSize()];
            for (int i = 0; i < this.baseSelector.getCurrentVectorSize(); ++i) {
                retVal[i] = Numbers.tryParseLong(objects[i], 0L);
            }
            return retVal;
        }

        @Override
        public float[] getFloatVector() {
            Object[] objects = this.getObjectVector();
            float[] retVal = new float[this.baseSelector.getMaxVectorSize()];
            for (int i = 0; i < this.baseSelector.getCurrentVectorSize(); ++i) {
                retVal[i] = Numbers.tryParseFloat(objects[i], 0.0f);
            }
            return retVal;
        }

        @Override
        public double[] getDoubleVector() {
            Object[] objects = this.getObjectVector();
            double[] retVal = new double[this.baseSelector.getMaxVectorSize()];
            for (int i = 0; i < this.baseSelector.getCurrentVectorSize(); ++i) {
                retVal[i] = Numbers.tryParseDouble(objects[i], 0.0);
            }
            return retVal;
        }

        @Override
        public boolean[] getNullVector() {
            Object[] objects = this.getObjectVector();
            boolean[] retVal = new boolean[this.baseSelector.getMaxVectorSize()];
            for (int i = 0; i < this.baseSelector.getCurrentVectorSize(); ++i) {
                retVal[i] = objects[i] == null || objects[i] instanceof String && Doubles.tryParse((String)((String)objects[i])) == null;
            }
            return retVal;
        }

        @Override
        public int getMaxVectorSize() {
            return this.baseSelector.getMaxVectorSize();
        }

        @Override
        public int getCurrentVectorSize() {
            return this.baseSelector.getCurrentVectorSize();
        }

        @Nullable
        private Object compute(Object input) {
            StructuredData data = StructuredData.wrap(input);
            Object obj = NestedPathFinder.find(data == null ? null : data.getValue(), this.parts);
            if (this.expectedType == null) {
                return obj;
            }
            if (this.expectedType.equals(ColumnType.NESTED_DATA)) {
                return StructuredData.wrap(obj);
            }
            return ExprEval.bestEffortOf(obj).castTo(this.expectedExpressionType).value();
        }
    }

    private static final class ArrayElementVectorObjectSelector
    implements VectorObjectSelector {
        private final Object[] elements;
        private final VectorObjectSelector arraySelector;
        private final ReadableVectorOffset offset;
        private final int elementNumber;
        private final ExpressionType elementType;
        private final ExpressionType castTo;
        private int id;

        public ArrayElementVectorObjectSelector(VectorObjectSelector arraySelector, ReadableVectorOffset offset, int elementNumber, ExpressionType elementType, ExpressionType castTo) {
            this.arraySelector = arraySelector;
            this.offset = offset;
            this.elementNumber = elementNumber;
            this.elementType = elementType;
            this.castTo = castTo;
            this.elements = new Object[arraySelector.getMaxVectorSize()];
            this.id = -1;
        }

        @Override
        public Object[] getObjectVector() {
            if (this.offset.getId() != this.id) {
                Object[] delegate = this.arraySelector.getObjectVector();
                for (int i = 0; i < this.arraySelector.getCurrentVectorSize(); ++i) {
                    Object maybeArray = delegate[i];
                    if (maybeArray instanceof Object[]) {
                        Object[] anArray = (Object[])maybeArray;
                        if (this.elementNumber < anArray.length) {
                            this.elements[i] = ExprEval.ofType(this.elementType, anArray[this.elementNumber]).castTo(this.castTo).value();
                            continue;
                        }
                        this.elements[i] = null;
                        continue;
                    }
                    this.elements[i] = null;
                }
                this.id = this.offset.getId();
            }
            return this.elements;
        }

        @Override
        public int getMaxVectorSize() {
            return this.arraySelector.getMaxVectorSize();
        }

        @Override
        public int getCurrentVectorSize() {
            return this.arraySelector.getCurrentVectorSize();
        }
    }

    private static final class ArrayElementLongVectorValueSelector
    extends BaseLongVectorValueSelector {
        private final long[] longs;
        private final boolean[] nulls;
        private final VectorObjectSelector arraySelector;
        private final int elementNumber;
        private int id;

        public ArrayElementLongVectorValueSelector(ReadableVectorOffset offset, VectorObjectSelector arraySelector, int elementNumber) {
            super(offset);
            this.arraySelector = arraySelector;
            this.elementNumber = elementNumber;
            this.longs = new long[offset.getMaxVectorSize()];
            this.nulls = new boolean[offset.getMaxVectorSize()];
            this.id = -1;
        }

        private void computeNumbers() {
            if (this.offset.getId() != this.id) {
                Object[] maybeArrays = this.arraySelector.getObjectVector();
                for (int i = 0; i < this.arraySelector.getCurrentVectorSize(); ++i) {
                    Object maybeArray = maybeArrays[i];
                    if (maybeArray instanceof Object[]) {
                        Object[] anArray = (Object[])maybeArray;
                        if (this.elementNumber < anArray.length) {
                            Double d;
                            if (anArray[this.elementNumber] instanceof Number) {
                                Number n = (Number)anArray[this.elementNumber];
                                this.longs[i] = n.longValue();
                                this.nulls[i] = false;
                                continue;
                            }
                            Double d2 = d = anArray[this.elementNumber] instanceof String ? Doubles.tryParse((String)((String)anArray[this.elementNumber])) : null;
                            if (d != null) {
                                this.longs[i] = d.longValue();
                                this.nulls[i] = false;
                                continue;
                            }
                            this.longs[i] = 0L;
                            this.nulls[i] = true;
                            continue;
                        }
                        this.nullElement(i);
                        continue;
                    }
                    this.nullElement(i);
                }
                this.id = this.offset.getId();
            }
        }

        private void nullElement(int i) {
            this.longs[i] = 0L;
            this.nulls[i] = true;
        }

        @Override
        public long[] getLongVector() {
            if (this.offset.getId() != this.id) {
                this.computeNumbers();
            }
            return this.longs;
        }

        @Override
        @Nullable
        public boolean[] getNullVector() {
            if (this.offset.getId() != this.id) {
                this.computeNumbers();
            }
            return this.nulls;
        }
    }

    private static final class ArrayElementFloatVectorValueSelector
    extends BaseFloatVectorValueSelector {
        private final float[] floats;
        private final boolean[] nulls;
        private final VectorObjectSelector arraySelector;
        private final int elementNumber;
        private int id;

        public ArrayElementFloatVectorValueSelector(ReadableVectorOffset offset, VectorObjectSelector arraySelector, int elementNumber) {
            super(offset);
            this.arraySelector = arraySelector;
            this.elementNumber = elementNumber;
            this.floats = new float[offset.getMaxVectorSize()];
            this.nulls = new boolean[offset.getMaxVectorSize()];
            this.id = -1;
        }

        private void computeNumbers() {
            if (this.offset.getId() != this.id) {
                Object[] maybeArrays = this.arraySelector.getObjectVector();
                for (int i = 0; i < this.arraySelector.getCurrentVectorSize(); ++i) {
                    Object maybeArray = maybeArrays[i];
                    if (maybeArray instanceof Object[]) {
                        Object[] anArray = (Object[])maybeArray;
                        if (this.elementNumber < anArray.length) {
                            Double d;
                            if (anArray[this.elementNumber] instanceof Number) {
                                Number n = (Number)anArray[this.elementNumber];
                                this.floats[i] = n.floatValue();
                                this.nulls[i] = false;
                                continue;
                            }
                            Double d2 = d = anArray[this.elementNumber] instanceof String ? Doubles.tryParse((String)((String)anArray[this.elementNumber])) : null;
                            if (d != null) {
                                this.floats[i] = d.floatValue();
                                this.nulls[i] = false;
                                continue;
                            }
                            this.nullElement(i);
                            continue;
                        }
                        this.nullElement(i);
                        continue;
                    }
                    this.nullElement(i);
                }
                this.id = this.offset.getId();
            }
        }

        private void nullElement(int i) {
            this.floats[i] = 0.0f;
            this.nulls[i] = true;
        }

        @Override
        public float[] getFloatVector() {
            if (this.offset.getId() != this.id) {
                this.computeNumbers();
            }
            return this.floats;
        }

        @Override
        public boolean[] getNullVector() {
            if (this.offset.getId() != this.id) {
                this.computeNumbers();
            }
            return this.nulls;
        }
    }

    private static final class ArrayElementDoubleVectorValueSelector
    extends BaseDoubleVectorValueSelector {
        private final double[] doubles;
        private final boolean[] nulls;
        private final VectorObjectSelector arraySelector;
        private final int elementNumber;
        private int id;

        public ArrayElementDoubleVectorValueSelector(ReadableVectorOffset offset, VectorObjectSelector arraySelector, int elementNumber) {
            super(offset);
            this.arraySelector = arraySelector;
            this.elementNumber = elementNumber;
            this.doubles = new double[offset.getMaxVectorSize()];
            this.nulls = new boolean[offset.getMaxVectorSize()];
            this.id = -1;
        }

        private void computeNumbers() {
            if (this.offset.getId() != this.id) {
                Object[] maybeArrays = this.arraySelector.getObjectVector();
                for (int i = 0; i < this.arraySelector.getCurrentVectorSize(); ++i) {
                    Object maybeArray = maybeArrays[i];
                    if (maybeArray instanceof Object[]) {
                        Object[] anArray = (Object[])maybeArray;
                        if (this.elementNumber < anArray.length) {
                            Double d;
                            if (anArray[this.elementNumber] instanceof Number) {
                                Number n = (Number)anArray[this.elementNumber];
                                this.doubles[i] = n.doubleValue();
                                this.nulls[i] = false;
                                continue;
                            }
                            Double d2 = d = anArray[this.elementNumber] instanceof String ? Doubles.tryParse((String)((String)anArray[this.elementNumber])) : null;
                            if (d != null) {
                                this.doubles[i] = d;
                                this.nulls[i] = false;
                                continue;
                            }
                            this.nullElement(i);
                            continue;
                        }
                        this.nullElement(i);
                        continue;
                    }
                    this.nullElement(i);
                }
                this.id = this.offset.getId();
            }
        }

        private void nullElement(int i) {
            this.doubles[i] = 0.0;
            this.nulls[i] = true;
        }

        @Override
        public double[] getDoubleVector() {
            if (this.offset.getId() != this.id) {
                this.computeNumbers();
            }
            return this.doubles;
        }

        @Override
        public boolean[] getNullVector() {
            if (this.offset.getId() != this.id) {
                this.computeNumbers();
            }
            return this.nulls;
        }
    }
}

