/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.nested;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.annotation.Nullable;
import org.apache.druid.error.DruidException;
import org.apache.druid.java.util.common.FileUtils;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.java.util.common.io.smoosh.SmooshedFileMapper;
import org.apache.druid.segment.column.StringEncodingStrategies;
import org.apache.druid.segment.column.TypeStrategies;
import org.apache.druid.segment.data.DictionaryWriter;
import org.apache.druid.segment.data.FixedIndexed;
import org.apache.druid.segment.data.FrontCodedIntArrayIndexed;
import org.apache.druid.segment.data.Indexed;
import org.apache.druid.segment.serde.ColumnSerializerUtils;
import org.apache.druid.utils.CloseableUtils;

public final class DictionaryIdLookup
implements Closeable {
    private final String name;
    private final File tempBasePath;
    @Nullable
    private final DictionaryWriter<String> stringDictionaryWriter;
    private File stringDictionaryFile = null;
    private SmooshedFileMapper stringBufferMapper = null;
    private Indexed<ByteBuffer> stringDictionary = null;
    @Nullable
    private final DictionaryWriter<Long> longDictionaryWriter;
    private File longDictionaryFile = null;
    private SmooshedFileMapper longBufferMapper = null;
    private FixedIndexed<Long> longDictionary = null;
    @Nullable
    private final DictionaryWriter<Double> doubleDictionaryWriter;
    private File doubleDictionaryFile = null;
    SmooshedFileMapper doubleBufferMapper = null;
    FixedIndexed<Double> doubleDictionary = null;
    @Nullable
    private final DictionaryWriter<int[]> arrayDictionaryWriter;
    private File arrayDictionaryFile = null;
    private SmooshedFileMapper arrayBufferMapper = null;
    private FrontCodedIntArrayIndexed arrayDictionary = null;
    private final Closer closer = Closer.create();

    public DictionaryIdLookup(String name, File tempBaseDir, @Nullable DictionaryWriter<String> stringDictionaryWriter, @Nullable DictionaryWriter<Long> longDictionaryWriter, @Nullable DictionaryWriter<Double> doubleDictionaryWriter, @Nullable DictionaryWriter<int[]> arrayDictionaryWriter) {
        this.name = name;
        this.tempBasePath = tempBaseDir;
        this.stringDictionaryWriter = stringDictionaryWriter;
        this.longDictionaryWriter = longDictionaryWriter;
        this.doubleDictionaryWriter = doubleDictionaryWriter;
        this.arrayDictionaryWriter = arrayDictionaryWriter;
    }

    public int[] getArrayValue(int id) {
        this.ensureArrayDictionaryLoaded();
        return this.arrayDictionary.get(id - this.arrayOffset());
    }

    @Nullable
    public Object getDictionaryValue(int id) {
        this.ensureStringDictionaryLoaded();
        this.ensureLongDictionaryLoaded();
        this.ensureDoubleDictionaryLoaded();
        this.ensureArrayDictionaryLoaded();
        if (id < this.longOffset()) {
            return StringUtils.fromUtf8Nullable(this.stringDictionary.get(id));
        }
        if (id < this.doubleOffset()) {
            return this.longDictionary.get(id - this.longOffset());
        }
        if (id < this.arrayOffset()) {
            return this.doubleDictionary.get(id - this.doubleOffset());
        }
        return this.arrayDictionary.get(id - this.arrayOffset());
    }

    public int lookupString(@Nullable String value) {
        this.ensureStringDictionaryLoaded();
        byte[] bytes = StringUtils.toUtf8Nullable(value);
        int index = this.stringDictionary.indexOf(bytes == null ? null : ByteBuffer.wrap(bytes));
        if (index < 0) {
            throw DruidException.defensive("Value not found in column[%s] string dictionary", this.name);
        }
        return index;
    }

    public int lookupLong(@Nullable Long value) {
        this.ensureLongDictionaryLoaded();
        int index = this.longDictionary.indexOf(value);
        if (index < 0) {
            throw DruidException.defensive("Value not found in column[%s] long dictionary", this.name);
        }
        return index + this.longOffset();
    }

    public int lookupDouble(@Nullable Double value) {
        this.ensureDoubleDictionaryLoaded();
        int index = this.doubleDictionary.indexOf(value);
        if (index < 0) {
            throw DruidException.defensive("Value not found in column[%s] double dictionary", this.name);
        }
        return index + this.doubleOffset();
    }

    public int lookupArray(@Nullable int[] value) {
        this.ensureArrayDictionaryLoaded();
        int index = this.arrayDictionary.indexOf(value);
        if (index < 0) {
            throw DruidException.defensive("Value not found in column[%s] array dictionary", this.name);
        }
        return index + this.arrayOffset();
    }

    @Nullable
    public SmooshedFileMapper getStringBufferMapper() {
        return this.stringBufferMapper;
    }

    @Nullable
    public SmooshedFileMapper getLongBufferMapper() {
        return this.longBufferMapper;
    }

    @Nullable
    public SmooshedFileMapper getDoubleBufferMapper() {
        return this.doubleBufferMapper;
    }

    @Nullable
    public SmooshedFileMapper getArrayBufferMapper() {
        return this.arrayBufferMapper;
    }

    @Override
    public void close() {
        CloseableUtils.closeAndWrapExceptions(this.closer);
    }

    private int longOffset() {
        return this.stringDictionaryWriter != null ? this.stringDictionaryWriter.getCardinality() : 0;
    }

    private int doubleOffset() {
        return this.longOffset() + (this.longDictionaryWriter != null ? this.longDictionaryWriter.getCardinality() : 0);
    }

    private int arrayOffset() {
        return this.doubleOffset() + (this.doubleDictionaryWriter != null ? this.doubleDictionaryWriter.getCardinality() : 0);
    }

    private void ensureStringDictionaryLoaded() {
        if (this.stringDictionary == null) {
            String fileName = ColumnSerializerUtils.getInternalFileName(this.name, "__stringDictionary");
            this.stringDictionaryFile = this.makeTempDir(fileName);
            this.stringBufferMapper = this.closer.register(ColumnSerializerUtils.mapSerializer(this.stringDictionaryFile, this.stringDictionaryWriter, fileName));
            try {
                ByteBuffer stringBuffer = this.stringBufferMapper.mapFile(fileName);
                this.stringDictionary = (Indexed)StringEncodingStrategies.getStringDictionarySupplier(this.stringBufferMapper, stringBuffer, ByteOrder.nativeOrder()).get();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void ensureLongDictionaryLoaded() {
        if (this.longDictionary == null) {
            String fileName = ColumnSerializerUtils.getInternalFileName(this.name, "__longDictionary");
            this.longDictionaryFile = this.makeTempDir(fileName);
            this.longBufferMapper = this.closer.register(ColumnSerializerUtils.mapSerializer(this.longDictionaryFile, this.longDictionaryWriter, fileName));
            try {
                ByteBuffer buffer = this.longBufferMapper.mapFile(fileName);
                this.longDictionary = (FixedIndexed)FixedIndexed.read(buffer, TypeStrategies.LONG, ByteOrder.nativeOrder(), 8).get();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void ensureDoubleDictionaryLoaded() {
        if (this.doubleDictionary == null) {
            String fileName = ColumnSerializerUtils.getInternalFileName(this.name, "__doubleDictionary");
            this.doubleDictionaryFile = this.makeTempDir(fileName);
            this.doubleBufferMapper = this.closer.register(ColumnSerializerUtils.mapSerializer(this.doubleDictionaryFile, this.doubleDictionaryWriter, fileName));
            try {
                ByteBuffer buffer = this.doubleBufferMapper.mapFile(fileName);
                this.doubleDictionary = (FixedIndexed)FixedIndexed.read(buffer, TypeStrategies.DOUBLE, ByteOrder.nativeOrder(), 8).get();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void ensureArrayDictionaryLoaded() {
        if (this.arrayDictionary == null && this.arrayDictionaryWriter != null) {
            String fileName = ColumnSerializerUtils.getInternalFileName(this.name, "__arrayDictionary");
            this.arrayDictionaryFile = this.makeTempDir(fileName);
            this.arrayBufferMapper = this.closer.register(ColumnSerializerUtils.mapSerializer(this.arrayDictionaryFile, this.arrayDictionaryWriter, fileName));
            try {
                ByteBuffer buffer = this.arrayBufferMapper.mapFile(fileName);
                this.arrayDictionary = (FrontCodedIntArrayIndexed)FrontCodedIntArrayIndexed.read(buffer, ByteOrder.nativeOrder()).get();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private File makeTempDir(String fileName) {
        try {
            File f = new File(this.tempBasePath, StringUtils.urlEncode(fileName));
            FileUtils.mkdirp(f);
            this.closer.register(() -> FileUtils.deleteDirectory(f));
            return f;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public int getStringCardinality() {
        this.ensureStringDictionaryLoaded();
        return this.stringDictionary == null ? 0 : this.stringDictionary.size();
    }

    public int getLongCardinality() {
        this.ensureLongDictionaryLoaded();
        return this.longDictionary == null ? 0 : this.longDictionary.size();
    }

    public int getDoubleCardinality() {
        this.ensureDoubleDictionaryLoaded();
        return this.doubleDictionary == null ? 0 : this.doubleDictionary.size();
    }

    public int getArrayCardinality() {
        this.ensureArrayDictionaryLoaded();
        return this.arrayDictionary == null ? 0 : this.arrayDictionary.size();
    }
}

