/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.join;

import java.util.Optional;
import java.util.Set;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.FrameBasedInlineDataSource;
import org.apache.druid.segment.join.JoinConditionAnalysis;
import org.apache.druid.segment.join.Joinable;
import org.apache.druid.segment.join.JoinableFactory;
import org.apache.druid.segment.join.table.FrameBasedIndexedTable;
import org.apache.druid.segment.join.table.IndexedTableJoinable;

public class FrameBasedInlineJoinableFactory
implements JoinableFactory {
    @Override
    public boolean isDirectlyJoinable(DataSource dataSource) {
        return dataSource instanceof FrameBasedInlineDataSource;
    }

    @Override
    public Optional<Joinable> build(DataSource dataSource, JoinConditionAnalysis condition) {
        FrameBasedInlineDataSource frameBasedInlineDataSource = (FrameBasedInlineDataSource)dataSource;
        if (condition.canHashJoin()) {
            Set<String> rightKeyColumns = condition.getRightEquiConditionKeys();
            return Optional.of(new IndexedTableJoinable(new FrameBasedIndexedTable(frameBasedInlineDataSource, rightKeyColumns, DateTimes.nowUtc().toString())));
        }
        return Optional.empty();
    }
}

