/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.filter;

import com.google.common.annotations.VisibleForTesting;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.filter.DruidDoublePredicate;
import org.apache.druid.query.filter.DruidFloatPredicate;
import org.apache.druid.query.filter.DruidLongPredicate;
import org.apache.druid.query.filter.DruidObjectPredicate;
import org.apache.druid.query.filter.DruidPredicateFactory;
import org.apache.druid.query.filter.DruidPredicateMatch;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.filter.FilterTuning;
import org.apache.druid.segment.filter.DimensionPredicateFilter;

public class RegexFilter
extends DimensionPredicateFilter {
    private final Pattern pattern;

    public RegexFilter(String dimension, Pattern pattern, ExtractionFn extractionFn, FilterTuning filterTuning) {
        super(dimension, new PatternDruidPredicateFactory(pattern), extractionFn, filterTuning);
        this.pattern = pattern;
    }

    @Override
    public String toString() {
        return "RegexFilter{pattern='" + String.valueOf(this.pattern) + "'}";
    }

    @Override
    public boolean supportsRequiredColumnRewrite() {
        return true;
    }

    @Override
    public Filter rewriteRequiredColumns(Map<String, String> columnRewrites) {
        String rewriteDimensionTo = columnRewrites.get(this.dimension);
        if (rewriteDimensionTo == null) {
            throw new IAE("Received a non-applicable rewrite: %s, filter's dimension: %s", columnRewrites, this.dimension);
        }
        return new RegexFilter(rewriteDimensionTo, this.pattern, this.extractionFn, this.filterTuning);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RegexFilter that = (RegexFilter)o;
        return Objects.equals(this.pattern.toString(), that.pattern.toString());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.pattern.toString());
    }

    @VisibleForTesting
    static class PatternDruidPredicateFactory
    implements DruidPredicateFactory {
        private final Pattern pattern;

        PatternDruidPredicateFactory(Pattern pattern) {
            this.pattern = pattern;
        }

        @Override
        public DruidObjectPredicate<String> makeStringPredicate() {
            return input -> input == null ? DruidPredicateMatch.UNKNOWN : DruidPredicateMatch.of(this.pattern.matcher((CharSequence)input).find());
        }

        @Override
        public DruidLongPredicate makeLongPredicate() {
            return input -> DruidPredicateMatch.of(this.pattern.matcher(String.valueOf(input)).find());
        }

        @Override
        public DruidFloatPredicate makeFloatPredicate() {
            return input -> DruidPredicateMatch.of(this.pattern.matcher(String.valueOf(input)).find());
        }

        @Override
        public DruidDoublePredicate makeDoublePredicate() {
            return input -> DruidPredicateMatch.of(this.pattern.matcher(String.valueOf(input)).find());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PatternDruidPredicateFactory that = (PatternDruidPredicateFactory)o;
            return Objects.equals(this.pattern.toString(), that.pattern.toString());
        }

        public int hashCode() {
            return Objects.hash(this.pattern.toString());
        }

        public String toString() {
            return "RegexFilter$PatternDruidPredicateFactory{pattern='" + String.valueOf(this.pattern) + "'}";
        }
    }
}

