/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.data;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.function.Supplier;
import org.apache.druid.segment.data.ColumnarLongs;
import org.apache.druid.segment.data.CompressedBlockReader;
import org.apache.druid.utils.CloseableUtils;

public final class CompressedLongsReader
implements ColumnarLongs {
    private final CompressedBlockReader blockReader;
    private final ByteBuffer buffer;

    public static Supplier<CompressedLongsReader> fromByteBuffer(ByteBuffer buffer, ByteOrder order) {
        Supplier<CompressedBlockReader> baseReader = CompressedBlockReader.fromByteBuffer(buffer, order, order, false);
        return () -> new CompressedLongsReader((CompressedBlockReader)baseReader.get());
    }

    public CompressedLongsReader(CompressedBlockReader blockReader) {
        this.blockReader = blockReader;
        this.buffer = blockReader.getDecompressedDataBuffer().asReadOnlyBuffer().order(blockReader.getDecompressedDataBuffer().order());
    }

    @Override
    public long get(int index) {
        long byteOffset = (long)index * 8L;
        int offset = this.blockReader.loadBlock(byteOffset);
        return this.buffer.getLong(offset);
    }

    @Override
    public int size() {
        return (int)(this.blockReader.getSize() / 8L);
    }

    @Override
    public void close() {
        CloseableUtils.closeAndWrapExceptions(this.blockReader);
    }
}

