/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby.epinephelinae.vector;

import com.google.common.base.Preconditions;
import org.apache.druid.query.groupby.epinephelinae.vector.DictionaryBuildingSingleValueStringGroupByVectorColumnSelector;
import org.apache.druid.query.groupby.epinephelinae.vector.DoubleGroupByVectorColumnSelector;
import org.apache.druid.query.groupby.epinephelinae.vector.FloatGroupByVectorColumnSelector;
import org.apache.druid.query.groupby.epinephelinae.vector.GroupByVectorColumnSelector;
import org.apache.druid.query.groupby.epinephelinae.vector.LongGroupByVectorColumnSelector;
import org.apache.druid.query.groupby.epinephelinae.vector.NilGroupByVectorColumnSelector;
import org.apache.druid.query.groupby.epinephelinae.vector.NullableDoubleGroupByVectorColumnSelector;
import org.apache.druid.query.groupby.epinephelinae.vector.NullableFloatGroupByVectorColumnSelector;
import org.apache.druid.query.groupby.epinephelinae.vector.NullableLongGroupByVectorColumnSelector;
import org.apache.druid.query.groupby.epinephelinae.vector.SingleValueStringGroupByVectorColumnSelector;
import org.apache.druid.segment.VectorColumnProcessorFactory;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.vector.MultiValueDimensionVectorSelector;
import org.apache.druid.segment.vector.SingleValueDimensionVectorSelector;
import org.apache.druid.segment.vector.VectorObjectSelector;
import org.apache.druid.segment.vector.VectorValueSelector;

public class GroupByVectorColumnProcessorFactory
implements VectorColumnProcessorFactory<GroupByVectorColumnSelector> {
    private static final GroupByVectorColumnProcessorFactory INSTANCE = new GroupByVectorColumnProcessorFactory();

    private GroupByVectorColumnProcessorFactory() {
    }

    public static GroupByVectorColumnProcessorFactory instance() {
        return INSTANCE;
    }

    @Override
    public GroupByVectorColumnSelector makeSingleValueDimensionProcessor(ColumnCapabilities capabilities, SingleValueDimensionVectorSelector selector) {
        Preconditions.checkArgument((boolean)capabilities.is(ValueType.STRING), (Object)"groupBy dimension processors must be STRING typed");
        return new SingleValueStringGroupByVectorColumnSelector(selector);
    }

    @Override
    public GroupByVectorColumnSelector makeMultiValueDimensionProcessor(ColumnCapabilities capabilities, MultiValueDimensionVectorSelector selector) {
        Preconditions.checkArgument((boolean)capabilities.is(ValueType.STRING), (Object)"groupBy dimension processors must be STRING typed");
        throw new UnsupportedOperationException("Vectorized groupBys on multi-value dictionary-encoded dimensions are not yet implemented");
    }

    @Override
    public GroupByVectorColumnSelector makeFloatProcessor(ColumnCapabilities capabilities, VectorValueSelector selector) {
        if (capabilities.hasNulls().isFalse()) {
            return new FloatGroupByVectorColumnSelector(selector);
        }
        return new NullableFloatGroupByVectorColumnSelector(selector);
    }

    @Override
    public GroupByVectorColumnSelector makeDoubleProcessor(ColumnCapabilities capabilities, VectorValueSelector selector) {
        if (capabilities.hasNulls().isFalse()) {
            return new DoubleGroupByVectorColumnSelector(selector);
        }
        return new NullableDoubleGroupByVectorColumnSelector(selector);
    }

    @Override
    public GroupByVectorColumnSelector makeLongProcessor(ColumnCapabilities capabilities, VectorValueSelector selector) {
        if (capabilities.hasNulls().isFalse()) {
            return new LongGroupByVectorColumnSelector(selector);
        }
        return new NullableLongGroupByVectorColumnSelector(selector);
    }

    @Override
    public GroupByVectorColumnSelector makeArrayProcessor(ColumnCapabilities capabilities, VectorObjectSelector selector) {
        throw new UnsupportedOperationException("Vectorized groupBys on ARRAY columns are not yet implemented");
    }

    @Override
    public GroupByVectorColumnSelector makeObjectProcessor(ColumnCapabilities capabilities, VectorObjectSelector selector) {
        if (capabilities.is(ValueType.STRING)) {
            if (capabilities.hasMultipleValues().isTrue()) {
                throw new UnsupportedOperationException("Vectorized groupBys on multi-value dictionary-encoded dimensions are not yet implemented");
            }
            return new DictionaryBuildingSingleValueStringGroupByVectorColumnSelector(selector);
        }
        return NilGroupByVectorColumnSelector.INSTANCE;
    }

    @Override
    public boolean useDictionaryEncodedSelector(ColumnCapabilities capabilities) {
        Preconditions.checkArgument((capabilities != null ? 1 : 0) != 0, (Object)"Capabilities must not be null");
        Preconditions.checkArgument((boolean)capabilities.is(ValueType.STRING), (Object)"Must only be called on a STRING column");
        return capabilities.isDictionaryEncoded().isTrue();
    }
}

