/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby.epinephelinae.vector;

import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.druid.query.groupby.ResultRow;
import org.apache.druid.query.groupby.epinephelinae.DictionaryBuildingUtils;
import org.apache.druid.query.groupby.epinephelinae.collection.MemoryPointer;
import org.apache.druid.query.groupby.epinephelinae.vector.GroupByVectorColumnSelector;
import org.apache.druid.segment.DimensionHandlerUtils;
import org.apache.druid.segment.vector.VectorObjectSelector;

public class DictionaryBuildingSingleValueStringGroupByVectorColumnSelector
implements GroupByVectorColumnSelector {
    private static final int GROUP_BY_MISSING_VALUE = -1;
    private final VectorObjectSelector selector;
    private final List<String> dictionary = new ArrayList<String>();
    private final Object2IntOpenHashMap<String> reverseDictionary = new Object2IntOpenHashMap();

    public DictionaryBuildingSingleValueStringGroupByVectorColumnSelector(VectorObjectSelector selector) {
        this.selector = selector;
        this.reverseDictionary.defaultReturnValue(-1);
    }

    @Override
    public int getGroupingKeySize() {
        return 4;
    }

    @Override
    public int writeKeys(WritableMemory keySpace, int keySize, int keyOffset, int startRow, int endRow) {
        Object[] vector = this.selector.getObjectVector();
        int stateFootprintIncrease = 0;
        int i = startRow;
        int j = keyOffset;
        while (i < endRow) {
            String value = DimensionHandlerUtils.convertObjectToString(vector[i]);
            int dictId = this.reverseDictionary.getInt((Object)value);
            if (dictId < 0) {
                int nextId = this.dictionary.size();
                this.dictionary.add(value);
                this.reverseDictionary.put((Object)value, nextId);
                keySpace.putInt((long)j, nextId);
                stateFootprintIncrease += DictionaryBuildingUtils.estimateEntryFootprint((value == null ? 0 : value.length()) * 2);
            } else {
                keySpace.putInt((long)j, dictId);
            }
            ++i;
            j += keySize;
        }
        return stateFootprintIncrease;
    }

    @Override
    public void writeKeyToResultRow(MemoryPointer keyMemory, int keyOffset, ResultRow resultRow, int resultRowPosition) {
        int id = keyMemory.memory().getInt(keyMemory.position() + (long)keyOffset);
        if (id != -1) {
            String value = this.dictionary.get(id);
            resultRow.set(resultRowPosition, value);
        } else {
            resultRow.set(resultRowPosition, null);
        }
    }

    @Override
    public void reset() {
        this.dictionary.clear();
        this.reverseDictionary.clear();
    }
}

