/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.filter.vector;

import java.util.BitSet;
import javax.annotation.Nullable;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.query.filter.DruidObjectPredicate;
import org.apache.druid.query.filter.DruidPredicateFactory;
import org.apache.druid.query.filter.vector.BaseVectorValueMatcher;
import org.apache.druid.query.filter.vector.ReadableVectorMatch;
import org.apache.druid.query.filter.vector.VectorMatch;
import org.apache.druid.query.filter.vector.VectorValueMatcher;
import org.apache.druid.query.filter.vector.VectorValueMatcherFactory;
import org.apache.druid.segment.IdLookup;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.filter.ConstantMatcherType;
import org.apache.druid.segment.filter.ValueMatchers;
import org.apache.druid.segment.vector.SingleValueDimensionVectorSelector;

public class SingleValueStringVectorValueMatcher
implements VectorValueMatcherFactory {
    private final SingleValueDimensionVectorSelector selector;

    public SingleValueStringVectorValueMatcher(SingleValueDimensionVectorSelector selector) {
        this.selector = selector;
    }

    @Override
    public VectorValueMatcher makeMatcher(@Nullable String value) {
        ConstantMatcherType constantMatcherType = ValueMatchers.toConstantMatcherTypeIfPossible(this.selector, false, value == null ? DruidObjectPredicate.isNull() : DruidObjectPredicate.equalTo(value));
        if (constantMatcherType != null) {
            return constantMatcherType.asVectorMatcher(this.selector);
        }
        IdLookup idLookup = this.selector.idLookup();
        if (idLookup != null) {
            final int id = idLookup.lookupId(value);
            if (id < 0) {
                return VectorValueMatcher.allFalseSingleValueDimensionMatcher(this.selector);
            }
            final boolean hasNull = this.selector.lookupName(0) == null;
            return new BaseVectorValueMatcher(this.selector){
                final VectorMatch match;
                {
                    super(selector);
                    this.match = VectorMatch.wrap(new int[SingleValueStringVectorValueMatcher.this.selector.getMaxVectorSize()]);
                }

                @Override
                public ReadableVectorMatch match(ReadableVectorMatch mask, boolean includeUnknown) {
                    int[] vector = SingleValueStringVectorValueMatcher.this.selector.getRowVector();
                    int[] selection = this.match.getSelection();
                    int numRows = 0;
                    for (int i = 0; i < mask.getSelectionSize(); ++i) {
                        int rowNum = mask.getSelection()[i];
                        int rowId = vector[rowNum];
                        if ((!includeUnknown || !hasNull || rowId != 0) && rowId != id) continue;
                        selection[numRows++] = rowNum;
                    }
                    this.match.setSelectionSize(numRows);
                    return this.match;
                }
            };
        }
        return this.makeMatcher(DruidObjectPredicate.equalTo(value));
    }

    @Override
    public VectorValueMatcher makeMatcher(Object matchValue, ColumnType matchValueType) {
        ExprEval<?> eval = ExprEval.ofType(ExpressionType.fromColumnType(matchValueType), matchValue);
        ExprEval<?> castForComparison = ExprEval.castForEqualityComparison(eval, ExpressionType.STRING);
        if (castForComparison == null || castForComparison.asString() == null) {
            return VectorValueMatcher.allFalseSingleValueDimensionMatcher(this.selector);
        }
        return this.makeMatcher(castForComparison.asString());
    }

    @Override
    public VectorValueMatcher makeMatcher(DruidPredicateFactory predicateFactory) {
        return this.makeMatcher(predicateFactory.makeStringPredicate());
    }

    private VectorValueMatcher makeMatcher(final DruidObjectPredicate<String> predicate) {
        ConstantMatcherType constantMatcherType = ValueMatchers.toConstantMatcherTypeIfPossible(this.selector, false, predicate);
        if (constantMatcherType != null) {
            return constantMatcherType.asVectorMatcher(this.selector);
        }
        if (this.selector.getValueCardinality() > 0) {
            final BitSet checkedIds = new BitSet(this.selector.getValueCardinality());
            final BitSet matchingIds = new BitSet(this.selector.getValueCardinality());
            return new BaseVectorValueMatcher(this.selector){
                private final VectorMatch match;
                {
                    super(selector);
                    this.match = VectorMatch.wrap(new int[SingleValueStringVectorValueMatcher.this.selector.getMaxVectorSize()]);
                }

                @Override
                public ReadableVectorMatch match(ReadableVectorMatch mask, boolean includeUnknown) {
                    int[] vector = SingleValueStringVectorValueMatcher.this.selector.getRowVector();
                    int[] selection = this.match.getSelection();
                    int numRows = 0;
                    for (int i = 0; i < mask.getSelectionSize(); ++i) {
                        boolean matches;
                        int rowNum = mask.getSelection()[i];
                        int id = vector[rowNum];
                        if (checkedIds.get(id)) {
                            matches = matchingIds.get(id);
                        } else {
                            String val = SingleValueStringVectorValueMatcher.this.selector.lookupName(id);
                            matches = predicate.apply(val).matches(includeUnknown);
                            checkedIds.set(id);
                            if (matches) {
                                matchingIds.set(id);
                            }
                        }
                        if (!matches) continue;
                        selection[numRows++] = rowNum;
                    }
                    this.match.setSelectionSize(numRows);
                    return this.match;
                }
            };
        }
        return new BaseVectorValueMatcher(this.selector){
            final VectorMatch match;
            {
                super(selector);
                this.match = VectorMatch.wrap(new int[SingleValueStringVectorValueMatcher.this.selector.getMaxVectorSize()]);
            }

            @Override
            public ReadableVectorMatch match(ReadableVectorMatch mask, boolean includeUnknown) {
                int[] vector = SingleValueStringVectorValueMatcher.this.selector.getRowVector();
                int[] selection = this.match.getSelection();
                int numRows = 0;
                for (int i = 0; i < mask.getSelectionSize(); ++i) {
                    int rowNum = mask.getSelection()[i];
                    String val = SingleValueStringVectorValueMatcher.this.selector.lookupName(vector[rowNum]);
                    if (!predicate.apply(val).matches(includeUnknown)) continue;
                    selection[numRows++] = rowNum;
                }
                this.match.setSelectionSize(numRows);
                return this.match;
            }
        };
    }
}

