/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.explain;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.util.Objects;
import org.apache.druid.query.explain.ExplainAttributes;

public class ExplainPlan {
    @JsonProperty(value="PLAN")
    private final String plan;
    @JsonProperty(value="RESOURCES")
    private final String resources;
    @JsonProperty(value="ATTRIBUTES")
    @JsonDeserialize(using=ExplainAttributesDeserializer.class)
    private final ExplainAttributes attributes;

    @JsonCreator
    public ExplainPlan(@JsonProperty(value="PLAN") String plan, @JsonProperty(value="RESOURCES") String resources, @JsonProperty(value="ATTRIBUTES") ExplainAttributes attributes) {
        this.plan = plan;
        this.resources = resources;
        this.attributes = attributes;
    }

    public String getPlan() {
        return this.plan;
    }

    public String getResources() {
        return this.resources;
    }

    public ExplainAttributes getAttributes() {
        return this.attributes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExplainPlan that = (ExplainPlan)o;
        return Objects.equals(this.plan, that.plan) && Objects.equals(this.resources, that.resources) && Objects.equals(this.attributes, that.attributes);
    }

    public int hashCode() {
        return Objects.hash(this.plan, this.resources, this.attributes);
    }

    private static class ExplainAttributesDeserializer
    extends JsonDeserializer<ExplainAttributes> {
        private ExplainAttributesDeserializer() {
        }

        public ExplainAttributes deserialize(JsonParser jsonParser, DeserializationContext context) throws IOException {
            ObjectMapper objectMapper = (ObjectMapper)jsonParser.getCodec();
            return (ExplainAttributes)objectMapper.readValue(jsonParser.getText(), ExplainAttributes.class);
        }
    }
}

