/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ForwardingListeningExecutorService;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.druid.query.PrioritizedQueryRunnerCallable;
import org.apache.druid.query.QueryProcessingPool;

public class ForwardingQueryProcessingPool
extends ForwardingListeningExecutorService
implements QueryProcessingPool {
    private final ListeningExecutorService delegate;
    @Nullable
    private final ScheduledExecutorService timeoutService;

    public ForwardingQueryProcessingPool(ExecutorService executorService, @Nullable ScheduledExecutorService timeoutService) {
        this.delegate = MoreExecutors.listeningDecorator((ExecutorService)executorService);
        this.timeoutService = timeoutService != null ? MoreExecutors.listeningDecorator((ScheduledExecutorService)timeoutService) : null;
    }

    @VisibleForTesting
    public ForwardingQueryProcessingPool(ExecutorService executorService) {
        this(executorService, null);
    }

    @Override
    public <T, V> ListenableFuture<T> submitRunnerTask(PrioritizedQueryRunnerCallable<T, V> task) {
        return this.delegate().submit(task);
    }

    @Override
    public <T, V> ListenableFuture<T> submitRunnerTask(PrioritizedQueryRunnerCallable<T, V> task, long timeout, TimeUnit unit) {
        if (this.timeoutService != null) {
            return Futures.withTimeout((ListenableFuture)this.delegate().submit(task), (long)timeout, (TimeUnit)unit, (ScheduledExecutorService)this.timeoutService);
        }
        return this.submitRunnerTask(task);
    }

    protected ListeningExecutorService delegate() {
        return this.delegate;
    }

    public void shutdown() {
        super.shutdown();
        if (this.timeoutService != null) {
            this.timeoutService.shutdown();
        }
    }
}

