/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.common;

import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

public class Either<L, R> {
    private final L error;
    private final R value;

    private Either(L error, R value) {
        this.error = error;
        this.value = value;
    }

    public static <L, R> Either<L, R> error(L error) {
        return new Either<Object, Object>(Preconditions.checkNotNull(error, (Object)"error"), null);
    }

    public static <L, R> Either<L, R> value(@Nullable R value) {
        return new Either<Object, R>(null, value);
    }

    public boolean isValue() {
        return this.error == null;
    }

    public boolean isError() {
        return this.error != null;
    }

    public L error() {
        if (this.isError()) {
            return this.error;
        }
        throw new IllegalStateException("Not an error; check isError first");
    }

    @Nullable
    public R valueOrThrow() {
        if (this.isValue()) {
            return this.value;
        }
        if (this.error instanceof Throwable) {
            throw new RuntimeException((Throwable)this.error);
        }
        throw new RuntimeException(this.error.toString());
    }

    public <T> Either<L, T> map(Function<R, T> fn) {
        if (this.isValue()) {
            return Either.value(fn.apply(this.value));
        }
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Either either = (Either)o;
        return Objects.equals(this.error, either.error) && Objects.equals(this.value, either.value);
    }

    public int hashCode() {
        return Objects.hash(this.error, this.value);
    }

    public String toString() {
        if (this.isValue()) {
            return "Value[" + String.valueOf(this.value) + "]";
        }
        return "Error[" + String.valueOf(this.error) + "]";
    }
}

