/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.processor;

import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.druid.frame.allocation.MemoryAllocator;
import org.apache.druid.frame.channel.PartitionedReadableFrameChannel;
import org.apache.druid.frame.channel.WritableFrameChannel;
import org.apache.druid.java.util.common.ISE;

public class PartitionedOutputChannel {
    @Nullable
    @GuardedBy(value="this")
    private WritableFrameChannel writableChannel;
    @Nullable
    @GuardedBy(value="this")
    private MemoryAllocator frameMemoryAllocator;
    private final Supplier<PartitionedReadableFrameChannel> readableChannelSupplier;

    private PartitionedOutputChannel(@Nullable WritableFrameChannel writableChannel, @Nullable MemoryAllocator frameMemoryAllocator, Supplier<PartitionedReadableFrameChannel> readableChannelSupplier) {
        this.writableChannel = writableChannel;
        this.frameMemoryAllocator = frameMemoryAllocator;
        this.readableChannelSupplier = readableChannelSupplier;
    }

    public static PartitionedOutputChannel pair(WritableFrameChannel writableChannel, MemoryAllocator frameMemoryAllocator, Supplier<PartitionedReadableFrameChannel> readableChannelSupplier) {
        return new PartitionedOutputChannel((WritableFrameChannel)Preconditions.checkNotNull((Object)writableChannel, (Object)"writableChannel"), (MemoryAllocator)Preconditions.checkNotNull((Object)frameMemoryAllocator, (Object)"frameMemoryAllocator"), readableChannelSupplier);
    }

    public synchronized WritableFrameChannel getWritableChannel() {
        if (this.writableChannel == null) {
            throw new ISE("Writable channel is not available. The output channel might be marked as read-only, hence no writes are allowed.", new Object[0]);
        }
        return this.writableChannel;
    }

    public synchronized MemoryAllocator getFrameMemoryAllocator() {
        if (this.frameMemoryAllocator == null) {
            throw new ISE("Frame allocator is not available. The output channel might be marked as read-only, hence memory allocator is not required.", new Object[0]);
        }
        return this.frameMemoryAllocator;
    }

    public synchronized Supplier<PartitionedReadableFrameChannel> getReadableChannelSupplier() {
        return this.readableChannelSupplier;
    }

    public synchronized PartitionedOutputChannel mapWritableChannel(Function<WritableFrameChannel, WritableFrameChannel> mapFn) {
        if (this.writableChannel == null) {
            return this;
        }
        return new PartitionedOutputChannel(mapFn.apply(this.writableChannel), this.frameMemoryAllocator, this.readableChannelSupplier);
    }

    public PartitionedOutputChannel readOnly() {
        return new PartitionedOutputChannel(null, null, this.readableChannelSupplier);
    }

    public synchronized void convertToReadOnly() {
        this.writableChannel = null;
        this.frameMemoryAllocator = null;
    }
}

