/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.processor;

import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.druid.frame.Frame;
import org.apache.druid.frame.channel.ReadableFrameChannel;
import org.apache.druid.frame.channel.WritableFrameChannel;
import org.apache.druid.frame.processor.FrameProcessor;
import org.apache.druid.frame.processor.ReturnOrAwait;
import org.apache.druid.java.util.common.Pair;

public class FrameChannelBatcher
implements FrameProcessor<Pair<List<Frame>, IntSet>> {
    private final List<ReadableFrameChannel> channels;
    private final int maxFrames;
    private final IntSet channelsToRead;
    private List<Frame> out = new ArrayList<Frame>();

    public FrameChannelBatcher(List<ReadableFrameChannel> channels, int maxFrames) {
        this.channels = channels;
        this.maxFrames = maxFrames;
        this.channelsToRead = new IntOpenHashSet();
        for (int i = 0; i < channels.size(); ++i) {
            if (channels.get(i).isFinished()) continue;
            this.channelsToRead.add(i);
        }
    }

    @Override
    public List<ReadableFrameChannel> inputChannels() {
        return this.channels;
    }

    @Override
    public List<WritableFrameChannel> outputChannels() {
        return Collections.emptyList();
    }

    @Override
    public ReturnOrAwait<Pair<List<Frame>, IntSet>> runIncrementally(IntSet readableInputs) {
        if (this.channelsToRead.isEmpty()) {
            return ReturnOrAwait.returnObject(Pair.of(this.flush(), IntSets.emptySet()));
        }
        if (readableInputs.isEmpty()) {
            return ReturnOrAwait.awaitAny(this.channelsToRead);
        }
        int firstChannel = ThreadLocalRandom.current().nextInt(this.channels.size());
        for (int i = 0; i < this.channels.size() && this.out.size() < this.maxFrames; ++i) {
            int channelNumber = (firstChannel + i) % this.channels.size();
            if (!readableInputs.contains(channelNumber) || !this.channelsToRead.contains(channelNumber)) continue;
            ReadableFrameChannel channel = this.channels.get(channelNumber);
            if (channel.canRead()) {
                this.out.add(channel.read());
                continue;
            }
            if (!channel.isFinished()) continue;
            this.channelsToRead.remove(channelNumber);
        }
        if (this.out.size() >= this.maxFrames) {
            return ReturnOrAwait.returnObject(Pair.of(this.flush(), this.channelsToRead));
        }
        return ReturnOrAwait.awaitAny(this.channelsToRead);
    }

    @Override
    public void cleanup() {
    }

    private List<Frame> flush() {
        List<Frame> tmp = this.out;
        this.out = null;
        return tmp;
    }
}

