/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.field;

import org.apache.datasketches.memory.Memory;
import org.apache.druid.frame.Frame;

public class FieldPositionHelper {
    private final Frame frame;
    private final Memory offsetRegion;
    private final Memory dataRegion;
    private final int columnIndex;
    private final long fieldsBytesSize;

    public FieldPositionHelper(Frame frame, Memory offsetRegion, Memory dataRegion, int columnIndex, int numFields) {
        this.frame = frame;
        this.offsetRegion = offsetRegion;
        this.dataRegion = dataRegion;
        this.columnIndex = columnIndex;
        this.fieldsBytesSize = this.columnIndex == 0 ? (long)numFields * 4L : (long)(this.columnIndex - 1) * 4L;
    }

    public long computeFieldPosition(int rowNum) {
        long rowPosition = (rowNum = this.frame.physicalRow(rowNum)) == 0 ? 0L : this.offsetRegion.getLong(((long)rowNum - 1L) * 8L);
        long fieldPosition = this.columnIndex == 0 ? rowPosition + this.fieldsBytesSize : rowPosition + (long)this.dataRegion.getInt(rowPosition + this.fieldsBytesSize);
        return fieldPosition;
    }
}

