/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.impl;

import java.util.List;
import java.util.Map;
import org.apache.druid.data.input.InputEntity;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.InputRowSchema;
import org.apache.druid.data.input.TextReader;
import org.apache.druid.data.input.impl.MapInputRowParser;
import org.apache.druid.java.util.common.parsers.ParseException;

public class LinesReader
extends TextReader.Strings {
    private static final String LINE_COLUMN = "line";

    LinesReader(InputRowSchema inputRowSchema, InputEntity source) {
        super(inputRowSchema, source);
    }

    @Override
    public List<InputRow> parseInputRows(String intermediateRow) throws ParseException {
        return List.of(MapInputRowParser.parse(this.getInputRowSchema(), this.parseLine(intermediateRow)));
    }

    @Override
    protected List<Map<String, Object>> toMap(String intermediateRow) {
        return List.of(this.parseLine(intermediateRow));
    }

    private Map<String, Object> parseLine(String line) {
        return Map.of(LINE_COLUMN, line);
    }

    @Override
    public int getNumHeaderLinesToSkip() {
        return 0;
    }

    @Override
    public boolean needsToProcessHeaderLine() {
        return false;
    }

    @Override
    public void processHeaderLine(String line) {
    }
}

