/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.storage.google;

import com.google.inject.Inject;
import java.io.IOException;
import java.net.URI;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.druid.data.SearchableVersionedDataFinder;
import org.apache.druid.data.input.impl.CloudObjectLocation;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.storage.google.GoogleDataSegmentPuller;
import org.apache.druid.storage.google.GoogleStorage;
import org.apache.druid.storage.google.GoogleStorageObjectMetadata;
import org.apache.druid.storage.google.GoogleStorageObjectPage;
import org.apache.druid.storage.google.GoogleUtils;

public class GoogleTimestampVersionedDataFinder
extends GoogleDataSegmentPuller
implements SearchableVersionedDataFinder<URI> {
    private static final long MAX_LISTING_KEYS = 1000L;

    @Inject
    public GoogleTimestampVersionedDataFinder(GoogleStorage storage) {
        super(storage);
    }

    public URI getLatestVersion(URI descriptorBase, @Nullable Pattern pattern) {
        try {
            long mostRecent = Long.MIN_VALUE;
            URI latest = null;
            CloudObjectLocation baseLocation = new CloudObjectLocation(descriptorBase);
            GoogleStorageObjectPage googleStorageObjectPage = this.storage.list(baseLocation.getBucket(), baseLocation.getPath(), 1000L, null);
            for (GoogleStorageObjectMetadata objectMetadata : googleStorageObjectPage.getObjectList()) {
                long latestModified;
                if (GoogleUtils.isDirectoryPlaceholder(objectMetadata)) continue;
                CloudObjectLocation objectLocation = new CloudObjectLocation(objectMetadata.getBucket(), objectMetadata.getName());
                String keyString = StringUtils.maybeRemoveLeadingSlash((String)objectMetadata.getName().substring(baseLocation.getPath().length()));
                if (pattern != null && !pattern.matcher(keyString).matches() || (latestModified = objectMetadata.getLastUpdateTimeMillis().longValue()) < mostRecent) continue;
                mostRecent = latestModified;
                latest = objectLocation.toUri("gs");
            }
            return latest;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

