/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.querykit;

import org.apache.druid.msq.querykit.QueryKit;
import org.apache.druid.query.Query;

public class QueryKitSpec {
    private final QueryKit<Query<?>> queryKit;
    private final String queryId;
    private final int maxLeafWorkerCount;
    private final int maxNonLeafWorkerCount;
    private final int targetPartitionsPerWorker;

    public QueryKitSpec(QueryKit<Query<?>> queryKit, String queryId, int maxLeafWorkerCount, int maxNonLeafWorkerCount, int targetPartitionsPerWorker) {
        this.queryId = queryId;
        this.queryKit = queryKit;
        this.maxLeafWorkerCount = maxLeafWorkerCount;
        this.maxNonLeafWorkerCount = maxNonLeafWorkerCount;
        this.targetPartitionsPerWorker = targetPartitionsPerWorker;
    }

    public QueryKit<Query<?>> getQueryKit() {
        return this.queryKit;
    }

    public String getQueryId() {
        return this.queryId;
    }

    public int getMaxLeafWorkerCount() {
        return this.maxLeafWorkerCount;
    }

    public int getMaxNonLeafWorkerCount() {
        return this.maxNonLeafWorkerCount;
    }

    public int getNumPartitionsForShuffle() {
        return this.maxNonLeafWorkerCount * this.targetPartitionsPerWorker;
    }
}

