/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexer;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nullable;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.Rows;
import org.apache.druid.hll.HyperLogLogCollector;
import org.apache.druid.indexer.HadoopDruidIndexerConfig;
import org.apache.druid.indexer.HadoopDruidIndexerMapper;
import org.apache.druid.indexer.HadoopyShardSpec;
import org.apache.druid.indexer.JobHelper;
import org.apache.druid.indexer.Jobby;
import org.apache.druid.indexer.TaskMetricsUtils;
import org.apache.druid.indexer.Utils;
import org.apache.druid.indexer.granularity.GranularitySpec;
import org.apache.druid.indexer.granularity.UniformGranularitySpec;
import org.apache.druid.indexer.partitions.DimensionBasedPartitionsSpec;
import org.apache.druid.indexer.partitions.HashedPartitionsSpec;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.timeline.partition.HashBasedNumberedShardSpec;
import org.apache.druid.timeline.partition.HashPartitionFunction;
import org.apache.druid.timeline.partition.ShardSpec;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Partitioner;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.joda.time.DateTime;
import org.joda.time.DateTimeComparator;
import org.joda.time.Interval;

public class DetermineHashedPartitionsJob
implements Jobby {
    private static final Logger log = new Logger(DetermineHashedPartitionsJob.class);
    private final HadoopDruidIndexerConfig config;
    private String failureCause;
    private Job groupByJob;
    private long startTime;

    public DetermineHashedPartitionsJob(HadoopDruidIndexerConfig config) {
        this.config = config;
    }

    public boolean run() {
        try {
            block15: {
                this.startTime = System.currentTimeMillis();
                this.groupByJob = Job.getInstance((Configuration)new Configuration(), (String)StringUtils.format((String)"%s-determine_partitions_hashed-%s", (Object[])new Object[]{this.config.getDataSource(), this.config.getIntervals()}));
                JobHelper.injectSystemProperties(this.groupByJob.getConfiguration(), this.config);
                this.config.addJobProperties(this.groupByJob);
                this.groupByJob.setMapperClass(DetermineCardinalityMapper.class);
                this.groupByJob.setMapOutputKeyClass(LongWritable.class);
                this.groupByJob.setMapOutputValueClass(BytesWritable.class);
                this.groupByJob.setReducerClass(DetermineCardinalityReducer.class);
                this.groupByJob.setOutputKeyClass(NullWritable.class);
                this.groupByJob.setOutputValueClass(NullWritable.class);
                this.groupByJob.setOutputFormatClass(SequenceFileOutputFormat.class);
                this.groupByJob.setPartitionerClass(DetermineHashedPartitionsPartitioner.class);
                if (this.config.getInputIntervals().isEmpty()) {
                    this.groupByJob.setNumReduceTasks(1);
                } else {
                    this.groupByJob.setNumReduceTasks(Iterators.size(this.config.getSegmentGranularIntervals().iterator()));
                }
                JobHelper.setupClasspath(JobHelper.distributedClassPath(this.config.getWorkingPath()), JobHelper.distributedClassPath(this.config.makeIntermediatePath()), this.groupByJob);
                this.config.addInputPaths(this.groupByJob);
                this.config.intoConfiguration(this.groupByJob);
                FileOutputFormat.setOutputPath((Job)this.groupByJob, (Path)this.config.makeGroupedDataDir());
                this.groupByJob.submit();
                log.info("Job %s submitted, status available at: %s", new Object[]{this.groupByJob.getJobName(), this.groupByJob.getTrackingURL()});
                if (this.groupByJob.getJobID() != null) {
                    JobHelper.writeJobIdToFile(this.config.getHadoopJobIdFileName(), this.groupByJob.getJobID().toString());
                }
                try {
                    if (!this.groupByJob.waitForCompletion(true)) {
                        log.error("Job failed: %s", new Object[]{this.groupByJob.getJobID()});
                        this.failureCause = Utils.getFailureMessage(this.groupByJob, HadoopDruidIndexerConfig.JSON_MAPPER);
                        return false;
                    }
                }
                catch (IOException ioe) {
                    if (Utils.checkAppSuccessForJobIOException(ioe, this.groupByJob, this.config.isUseYarnRMJobStatusFallback())) break block15;
                    throw ioe;
                }
            }
            log.info("Job completed, loading up partitions for intervals[%s].", new Object[]{this.config.getSegmentGranularIntervals()});
            FileSystem fileSystem = null;
            if (this.config.getInputIntervals().isEmpty()) {
                Path intervalInfoPath = this.config.makeIntervalInfoPath();
                fileSystem = intervalInfoPath.getFileSystem(this.groupByJob.getConfiguration());
                if (!Utils.exists((JobContext)this.groupByJob, fileSystem, intervalInfoPath)) {
                    throw new ISE("Path[%s] didn't exist!?", new Object[]{intervalInfoPath});
                }
                List intervals = (List)HadoopDruidIndexerConfig.JSON_MAPPER.readValue(Utils.openInputStream((JobContext)this.groupByJob, intervalInfoPath), (TypeReference)new TypeReference<List<Interval>>(){});
                this.config.setGranularitySpec((GranularitySpec)new UniformGranularitySpec(this.config.getGranularitySpec().getSegmentGranularity(), this.config.getGranularitySpec().getQueryGranularity(), Boolean.valueOf(this.config.getGranularitySpec().isRollup()), intervals));
                log.info("Determined Intervals for Job [%s].", new Object[]{this.config.getSegmentGranularIntervals()});
            }
            TreeMap<Long, List<HadoopyShardSpec>> shardSpecs = new TreeMap<Long, List<HadoopyShardSpec>>((Comparator<Long>)DateTimeComparator.getInstance());
            DimensionBasedPartitionsSpec partitionsSpec = this.config.getPartitionsSpec();
            if (!(partitionsSpec instanceof HashedPartitionsSpec)) {
                throw new ISE("%s is expected, but got %s", new Object[]{HashedPartitionsSpec.class.getName(), partitionsSpec.getClass().getName()});
            }
            HashPartitionFunction partitionFunction = ((HashedPartitionsSpec)partitionsSpec).getPartitionFunction();
            int shardCount = 0;
            for (Interval segmentGranularity : this.config.getSegmentGranularIntervals()) {
                DateTime bucket = segmentGranularity.getStart();
                Path partitionInfoPath = this.config.makeSegmentPartitionInfoPath(segmentGranularity);
                if (fileSystem == null) {
                    fileSystem = partitionInfoPath.getFileSystem(this.groupByJob.getConfiguration());
                }
                if (Utils.exists((JobContext)this.groupByJob, fileSystem, partitionInfoPath)) {
                    Long numRows = (Long)HadoopDruidIndexerConfig.JSON_MAPPER.readValue(Utils.openInputStream((JobContext)this.groupByJob, partitionInfoPath), Long.class);
                    log.info("Found approximately [%,d] rows in data.", new Object[]{numRows});
                    int numberOfShards = (int)Math.ceil((double)numRows.longValue() / (double)this.config.getTargetPartitionSize());
                    log.info("Creating [%,d] shards", new Object[]{numberOfShards});
                    ArrayList actualSpecs = Lists.newArrayListWithExpectedSize((int)numberOfShards);
                    for (int i = 0; i < numberOfShards; ++i) {
                        actualSpecs.add(new HadoopyShardSpec((ShardSpec)new HashBasedNumberedShardSpec(i, numberOfShards, Integer.valueOf(i), Integer.valueOf(numberOfShards), null, partitionFunction, HadoopDruidIndexerConfig.JSON_MAPPER), shardCount++));
                        log.info("DateTime[%s], partition[%d], spec[%s]", new Object[]{bucket, i, actualSpecs.get(i)});
                    }
                    shardSpecs.put(bucket.getMillis(), actualSpecs);
                    continue;
                }
                log.info("Path[%s] didn't exist!?", new Object[]{partitionInfoPath});
            }
            this.config.setShardSpecs(shardSpecs);
            log.info("DetermineHashedPartitionsJob took %d millis", new Object[]{System.currentTimeMillis() - this.startTime});
            return true;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Map<String, Object> getStats() {
        if (this.groupByJob == null) {
            return null;
        }
        try {
            Counters jobCounters = this.groupByJob.getCounters();
            Map metrics = TaskMetricsUtils.makeIngestionRowMetrics((long)jobCounters.findCounter((Enum)HadoopDruidIndexerConfig.IndexJobCounters.ROWS_PROCESSED_COUNTER).getValue(), (long)jobCounters.findCounter((Enum)HadoopDruidIndexerConfig.IndexJobCounters.ROWS_PROCESSED_WITH_ERRORS_COUNTER).getValue(), (long)jobCounters.findCounter((Enum)HadoopDruidIndexerConfig.IndexJobCounters.ROWS_UNPARSEABLE_COUNTER).getValue(), (long)jobCounters.findCounter((Enum)HadoopDruidIndexerConfig.IndexJobCounters.ROWS_THROWN_AWAY_COUNTER).getValue());
            return metrics;
        }
        catch (IllegalStateException ise) {
            log.debug("Couldn't get counters due to job state", new Object[0]);
            return null;
        }
        catch (Exception e) {
            log.debug((Throwable)e, "Encountered exception in getStats().", new Object[0]);
            return null;
        }
    }

    @Nullable
    public String getErrorMessage() {
        return this.failureCause;
    }

    public static class DetermineCardinalityMapper
    extends HadoopDruidIndexerMapper<LongWritable, BytesWritable> {
        private static HashFunction hashFunction = Hashing.murmur3_128();
        @Nullable
        private Granularity rollupGranularity = null;
        @Nullable
        private Map<Interval, HyperLogLogCollector> hyperLogLogs;
        @Nullable
        private HadoopDruidIndexerConfig config;
        private boolean determineIntervals;

        @Override
        protected void setup(Mapper.Context context) throws IOException, InterruptedException {
            super.setup(context);
            this.rollupGranularity = this.getConfig().getGranularitySpec().getQueryGranularity();
            this.config = HadoopDruidIndexerConfig.fromConfiguration(context.getConfiguration());
            Iterable<Interval> intervals = this.config.getSegmentGranularIntervals();
            if (intervals.iterator().hasNext()) {
                this.determineIntervals = false;
                ImmutableMap.Builder builder = ImmutableMap.builder();
                for (Interval bucketInterval : intervals) {
                    builder.put((Object)bucketInterval, (Object)HyperLogLogCollector.makeLatestCollector());
                }
                this.hyperLogLogs = builder.build();
            } else {
                this.determineIntervals = true;
                this.hyperLogLogs = new HashMap<Interval, HyperLogLogCollector>();
            }
        }

        @Override
        protected void innerMap(InputRow inputRow, Mapper.Context context) throws IOException {
            Interval interval;
            List groupKey = Rows.toGroupKey((long)this.rollupGranularity.bucketStart(inputRow.getTimestamp()).getMillis(), (InputRow)inputRow);
            if (this.determineIntervals) {
                interval = this.config.getGranularitySpec().getSegmentGranularity().bucket(DateTimes.utc((long)inputRow.getTimestampFromEpoch()));
                this.hyperLogLogs.computeIfAbsent(interval, intv -> HyperLogLogCollector.makeLatestCollector());
            } else {
                Optional maybeInterval = this.config.getGranularitySpec().bucketInterval(DateTimes.utc((long)inputRow.getTimestampFromEpoch()));
                if (!maybeInterval.isPresent()) {
                    throw new ISE("No bucket found for timestamp: %s", new Object[]{inputRow.getTimestampFromEpoch()});
                }
                interval = (Interval)maybeInterval.get();
            }
            this.hyperLogLogs.get(interval).add(hashFunction.hashBytes(HadoopDruidIndexerConfig.JSON_MAPPER.writeValueAsBytes((Object)groupKey)).asBytes());
            context.getCounter((Enum)HadoopDruidIndexerConfig.IndexJobCounters.ROWS_PROCESSED_COUNTER).increment(1L);
        }

        public void run(Mapper.Context context) throws IOException, InterruptedException {
            this.setup(context);
            while (context.nextKeyValue()) {
                this.map(context.getCurrentKey(), context.getCurrentValue(), context);
            }
            for (Map.Entry<Interval, HyperLogLogCollector> entry : this.hyperLogLogs.entrySet()) {
                context.write((Object)new LongWritable(entry.getKey().getStartMillis()), (Object)new BytesWritable(entry.getValue().toByteArray()));
            }
            this.cleanup(context);
        }
    }

    public static class DetermineCardinalityReducer
    extends Reducer<LongWritable, BytesWritable, NullWritable, NullWritable> {
        private final List<Interval> intervals = new ArrayList<Interval>();
        @Nullable
        protected HadoopDruidIndexerConfig config = null;
        private boolean determineIntervals;

        protected void setup(Reducer.Context context) {
            this.config = HadoopDruidIndexerConfig.fromConfiguration(context.getConfiguration());
            this.determineIntervals = this.config.getInputIntervals().isEmpty();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void reduce(LongWritable key, Iterable<BytesWritable> values, Reducer.Context context) throws IOException {
            Interval interval;
            HyperLogLogCollector aggregate = HyperLogLogCollector.makeLatestCollector();
            for (BytesWritable value : values) {
                aggregate.fold(HyperLogLogCollector.makeCollector((ByteBuffer)ByteBuffer.wrap(value.getBytes(), 0, value.getLength())));
            }
            if (this.determineIntervals) {
                interval = this.config.getGranularitySpec().getSegmentGranularity().bucket(DateTimes.utc((long)key.get()));
            } else {
                Optional intervalOptional = this.config.getGranularitySpec().bucketInterval(DateTimes.utc((long)key.get()));
                if (!intervalOptional.isPresent()) {
                    throw new ISE("No bucket found for timestamp: %s", new Object[]{key.get()});
                }
                interval = (Interval)intervalOptional.get();
            }
            this.intervals.add(interval);
            Path outPath = this.config.makeSegmentPartitionInfoPath(interval);
            OutputStream out = Utils.makePathAndOutputStream((JobContext)context, outPath, this.config.isOverwriteFiles());
            try {
                HadoopDruidIndexerConfig.JSON_MAPPER.writerFor(Long.class).writeValue(out, (Object)aggregate.estimateCardinalityRound());
            }
            finally {
                Closeables.close((Closeable)out, (boolean)false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(Reducer.Context context) throws IOException, InterruptedException {
            super.run(context);
            if (this.determineIntervals) {
                Path outPath = this.config.makeIntervalInfoPath();
                OutputStream out = Utils.makePathAndOutputStream((JobContext)context, outPath, this.config.isOverwriteFiles());
                try {
                    HadoopDruidIndexerConfig.JSON_MAPPER.writerFor((TypeReference)new TypeReference<List<Interval>>(){}).writeValue(out, this.intervals);
                }
                finally {
                    Closeables.close((Closeable)out, (boolean)false);
                }
            }
        }
    }

    public static class DetermineHashedPartitionsPartitioner
    extends Partitioner<LongWritable, BytesWritable>
    implements Configurable {
        @Nullable
        private Configuration config;
        private boolean determineIntervals;
        @Nullable
        private Map<LongWritable, Integer> reducerLookup;

        public int getPartition(LongWritable interval, BytesWritable text, int numPartitions) {
            if ("local".equals(JobHelper.getJobTrackerAddress(this.config)) || this.determineIntervals) {
                return 0;
            }
            return this.reducerLookup.get(interval);
        }

        public Configuration getConf() {
            return this.config;
        }

        public void setConf(Configuration config) {
            this.config = config;
            HadoopDruidIndexerConfig hadoopConfig = HadoopDruidIndexerConfig.fromConfiguration(config);
            if (!hadoopConfig.getInputIntervals().isEmpty()) {
                this.determineIntervals = false;
                int reducerNumber = 0;
                ImmutableMap.Builder builder = ImmutableMap.builder();
                for (Interval interval : hadoopConfig.getSegmentGranularIntervals()) {
                    builder.put((Object)new LongWritable(interval.getStartMillis()), (Object)reducerNumber++);
                }
                this.reducerLookup = builder.build();
            } else {
                this.determineIntervals = true;
            }
        }
    }
}

