/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.io.writers;

import com.github.rvesse.airline.io.ControlCodeSource;
import com.github.rvesse.airline.io.decorations.BasicDecoration;
import com.github.rvesse.airline.io.decorations.sources.AnsiDecorationSource;
import com.github.rvesse.airline.io.writers.AnsiWriter;
import com.github.rvesse.airline.io.writers.WriterControlTracker;
import java.io.IOException;
import java.io.Writer;

public class ColorizedWriter<T>
extends AnsiWriter {
    protected WriterControlTracker<T> foregroundControl;
    protected WriterControlTracker<T> backgroundControl;
    protected WriterControlTracker<BasicDecoration> bold;
    protected WriterControlTracker<BasicDecoration> italic;
    protected WriterControlTracker<BasicDecoration> underline;
    protected WriterControlTracker<BasicDecoration> strikeThrough;

    public ColorizedWriter(Writer writer, ControlCodeSource<T> foregroundColorSource, ControlCodeSource<T> backgroundColorSource) {
        super(writer);
        if (foregroundColorSource == null) {
            throw new NullPointerException("foregroundColorSource cannot be null");
        }
        if (backgroundColorSource == null) {
            throw new NullPointerException("backgroundColorSource cannot be null");
        }
        this.foregroundControl = new WriterControlTracker<T>(writer, foregroundColorSource);
        this.backgroundControl = new WriterControlTracker<T>(writer, backgroundColorSource);
        this.registerControls(this.foregroundControl, this.backgroundControl);
        AnsiDecorationSource decorationsSource = new AnsiDecorationSource();
        this.bold = new WriterControlTracker(writer, decorationsSource);
        this.italic = new WriterControlTracker(writer, decorationsSource);
        this.underline = new WriterControlTracker(writer, decorationsSource);
        this.strikeThrough = new WriterControlTracker(writer, decorationsSource);
        this.registerControls(this.bold, this.italic, this.underline, this.strikeThrough);
    }

    public ColorizedWriter<T> setForegroundColor(T color) {
        this.foregroundControl.set(color);
        return this;
    }

    public ColorizedWriter<T> resetForegroundColor() throws IOException {
        this.foregroundControl.reset();
        return this;
    }

    public ColorizedWriter<T> setBackgroundColor(T color) {
        this.backgroundControl.set(color);
        return this;
    }

    public ColorizedWriter<T> resetBackgroundColor() throws IOException {
        this.backgroundControl.reset();
        return this;
    }

    public ColorizedWriter<T> setBold(boolean enabled) throws IOException {
        return this.setDecoration(enabled, BasicDecoration.BOLD, this.bold);
    }

    public ColorizedWriter<T> setItalic(boolean enabled) throws IOException {
        return this.setDecoration(enabled, BasicDecoration.ITALIC, this.italic);
    }

    public ColorizedWriter<T> setUnderline(boolean enabled) throws IOException {
        return this.setDecoration(enabled, BasicDecoration.UNDERLINE, this.underline);
    }

    public ColorizedWriter<T> setStrikeThrough(boolean enabled) throws IOException {
        return this.setDecoration(enabled, BasicDecoration.STRIKE_THROUGH, this.strikeThrough);
    }

    protected final ColorizedWriter<T> setDecoration(boolean enabled, BasicDecoration decoration, WriterControlTracker<BasicDecoration> control) throws IOException {
        if (enabled) {
            control.set(decoration);
        } else {
            control.reset();
        }
        return this;
    }
}

