/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.multilang;

import com.amazonaws.services.kinesis.clientlibrary.interfaces.v2.IRecordProcessor;
import com.amazonaws.services.kinesis.clientlibrary.interfaces.v2.IRecordProcessorFactory;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.KinesisClientLibConfiguration;
import com.amazonaws.services.kinesis.multilang.MultiLangRecordProcessor;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.concurrent.ExecutorService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MultiLangRecordProcessorFactory
implements IRecordProcessorFactory {
    private static final Log LOG = LogFactory.getLog(MultiLangRecordProcessorFactory.class);
    private static final String COMMAND_DELIMETER_REGEX = " +";
    private final String command;
    private final String[] commandArray;
    private final ObjectMapper objectMapper;
    private final ExecutorService executorService;
    private final KinesisClientLibConfiguration configuration;

    public MultiLangRecordProcessorFactory(String command, ExecutorService executorService, KinesisClientLibConfiguration configuration) {
        this(command, executorService, new ObjectMapper(), configuration);
    }

    public MultiLangRecordProcessorFactory(String command, ExecutorService executorService, ObjectMapper objectMapper, KinesisClientLibConfiguration configuration) {
        this.command = command;
        this.commandArray = command.split(COMMAND_DELIMETER_REGEX);
        this.executorService = executorService;
        this.objectMapper = objectMapper;
        this.configuration = configuration;
    }

    @Override
    public IRecordProcessor createProcessor() {
        LOG.debug((Object)String.format("Creating new record processor for client executable: %s", this.command));
        return new MultiLangRecordProcessor(new ProcessBuilder(this.commandArray), this.executorService, this.objectMapper, this.configuration);
    }

    String[] getCommandArray() {
        return this.commandArray;
    }
}

