/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.quantiles.sql;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.druid.query.aggregation.datasketches.SketchQueryContext;
import org.apache.druid.query.aggregation.datasketches.quantiles.DoublesSketchAggregatorFactory;
import org.apache.druid.query.aggregation.datasketches.quantiles.DoublesSketchModule;
import org.apache.druid.query.aggregation.datasketches.quantiles.sql.DoublesSketchApproxQuantileSqlAggregator;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.sql.calcite.aggregation.Aggregation;
import org.apache.druid.sql.calcite.aggregation.Aggregations;
import org.apache.druid.sql.calcite.aggregation.SqlAggregator;
import org.apache.druid.sql.calcite.expression.DruidExpression;
import org.apache.druid.sql.calcite.expression.OperatorConversions;
import org.apache.druid.sql.calcite.planner.Calcites;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.rel.InputAccessor;
import org.apache.druid.sql.calcite.rel.VirtualColumnRegistry;

public class DoublesSketchObjectSqlAggregator
implements SqlAggregator {
    private static final String NAME = "DS_QUANTILES_SKETCH";
    private static final SqlAggFunction FUNCTION_INSTANCE = (SqlAggFunction)OperatorConversions.aggregatorBuilder((String)"DS_QUANTILES_SKETCH").operandNames(new String[]{"column", "k"}).operandTypes(new SqlTypeFamily[]{SqlTypeFamily.ANY, SqlTypeFamily.EXACT_NUMERIC}).returnTypeInference(Calcites.complexReturnTypeWithNullability((ColumnType)DoublesSketchModule.TYPE, (boolean)false)).requiredOperandCount(1).literalOperands(new int[]{1}).functionCategory(SqlFunctionCategory.NUMERIC).build();

    public SqlAggFunction calciteFunction() {
        return FUNCTION_INSTANCE;
    }

    @Nullable
    public Aggregation toDruidAggregation(PlannerContext plannerContext, VirtualColumnRegistry virtualColumnRegistry, String name, AggregateCall aggregateCall, InputAccessor inputAccessor, List<Aggregation> existingAggregations, boolean finalizeAggregations) {
        DoublesSketchAggregatorFactory aggregatorFactory;
        int k;
        DruidExpression input = Aggregations.toDruidExpressionForNumericAggregator((PlannerContext)plannerContext, (RowSignature)inputAccessor.getInputRowSignature(), (RexNode)inputAccessor.getField(((Integer)aggregateCall.getArgList().get(0)).intValue()));
        if (input == null) {
            return null;
        }
        if (aggregateCall.getArgList().size() >= 2) {
            RexNode resolutionArg = inputAccessor.getField(((Integer)aggregateCall.getArgList().get(1)).intValue());
            if (!resolutionArg.isA(SqlKind.LITERAL)) {
                return null;
            }
            k = ((Number)((Object)RexLiteral.value((RexNode)resolutionArg))).intValue();
        } else {
            k = 128;
        }
        if (input.isDirectColumnAccess()) {
            aggregatorFactory = new DoublesSketchAggregatorFactory(name, input.getDirectColumn(), k, DoublesSketchApproxQuantileSqlAggregator.getMaxStreamLengthFromQueryContext(plannerContext.queryContext()), SketchQueryContext.isFinalizeOuterSketches(plannerContext));
        } else {
            String virtualColumnName = virtualColumnRegistry.getOrCreateVirtualColumnForExpression(input, ColumnType.FLOAT);
            aggregatorFactory = new DoublesSketchAggregatorFactory(name, virtualColumnName, k, DoublesSketchApproxQuantileSqlAggregator.getMaxStreamLengthFromQueryContext(plannerContext.queryContext()), SketchQueryContext.isFinalizeOuterSketches(plannerContext));
        }
        return Aggregation.create((List)ImmutableList.of((Object)((Object)aggregatorFactory)), null);
    }
}

