/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexing.common.TaskLock;
import org.apache.druid.indexing.common.TaskToolbox;
import org.apache.druid.indexing.common.actions.RetrieveUnusedSegmentsAction;
import org.apache.druid.indexing.common.actions.SegmentMetadataUpdateAction;
import org.apache.druid.indexing.common.task.AbstractFixedIntervalTask;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.server.security.ResourceAction;
import org.apache.druid.timeline.DataSegment;
import org.joda.time.Interval;

public class MoveTask
extends AbstractFixedIntervalTask {
    public static final String TYPE = "move";
    private static final Logger log = new Logger(MoveTask.class);
    private final Map<String, Object> targetLoadSpec;

    @JsonCreator
    public MoveTask(@JsonProperty(value="id") String id, @JsonProperty(value="dataSource") String dataSource, @JsonProperty(value="interval") Interval interval, @JsonProperty(value="target") Map<String, Object> targetLoadSpec, @JsonProperty(value="context") Map<String, Object> context, @JsonProperty(value="targetLoadSpec") Map<String, Object> targetLoadSpecCOMPAT) {
        super(MoveTask.getOrMakeId(id, TYPE, dataSource, interval), dataSource, interval, context);
        this.targetLoadSpec = targetLoadSpec == null ? targetLoadSpecCOMPAT : targetLoadSpec;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    @Nonnull
    @JsonIgnore
    public Set<ResourceAction> getInputSourceResources() {
        return ImmutableSet.of();
    }

    @Override
    public TaskStatus runTask(TaskToolbox toolbox) throws Exception {
        TaskLock myLock = this.getAndCheckLock(toolbox);
        List<DataSegment> unusedSegments = toolbox.getTaskActionClient().submit(new RetrieveUnusedSegmentsAction(myLock.getDataSource(), myLock.getInterval(), null, null, null));
        for (DataSegment unusedSegment : unusedSegments) {
            if (unusedSegment.getVersion().compareTo(myLock.getVersion()) > 0) {
                throw new ISE("Unused segment[%s] has version[%s] > task version[%s]", new Object[]{unusedSegment.getId(), unusedSegment.getVersion(), myLock.getVersion()});
            }
            log.info("OK to move segment: %s", new Object[]{unusedSegment.getId()});
        }
        for (DataSegment segment : unusedSegments) {
            DataSegment movedSegment = toolbox.getDataSegmentMover().move(segment, this.targetLoadSpec);
            toolbox.getTaskActionClient().submit(new SegmentMetadataUpdateAction((Set<DataSegment>)ImmutableSet.of((Object)movedSegment)));
        }
        return TaskStatus.success((String)this.getId());
    }

    @JsonProperty(value="target")
    public Map<String, Object> getTargetLoadSpec() {
        return this.targetLoadSpec;
    }
}

