/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.inject.Inject;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import org.apache.druid.audit.AuditEntry;
import org.apache.druid.audit.AuditInfo;
import org.apache.druid.audit.AuditManager;
import org.apache.druid.common.config.ConfigManager;
import org.apache.druid.common.config.Configs;
import org.apache.druid.common.config.JacksonConfigManager;
import org.apache.druid.error.DruidException;
import org.apache.druid.error.InternalServerError;
import org.apache.druid.error.NotFound;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.metadata.MetadataStorageConnector;
import org.apache.druid.metadata.MetadataStorageTablesConfig;
import org.apache.druid.server.coordinator.ClusterCompactionConfig;
import org.apache.druid.server.coordinator.CoordinatorDynamicConfig;
import org.apache.druid.server.coordinator.DataSourceCompactionConfig;
import org.apache.druid.server.coordinator.DataSourceCompactionConfigAuditEntry;
import org.apache.druid.server.coordinator.DataSourceCompactionConfigHistory;
import org.apache.druid.server.coordinator.DruidCompactionConfig;
import org.joda.time.Interval;

public class CoordinatorConfigManager {
    private static final Logger log = new Logger(CoordinatorConfigManager.class);
    private static final long UPDATE_RETRY_DELAY = 1000L;
    static final int MAX_UPDATE_RETRIES = 5;
    private final AuditManager auditManager;
    private final JacksonConfigManager jacksonConfigManager;
    private final MetadataStorageConnector metadataStorageConnector;
    private final MetadataStorageTablesConfig tablesConfig;

    @Inject
    public CoordinatorConfigManager(JacksonConfigManager jacksonConfigManager, MetadataStorageConnector metadataStorageConnector, MetadataStorageTablesConfig tablesConfig, AuditManager auditManager) {
        this.jacksonConfigManager = jacksonConfigManager;
        this.metadataStorageConnector = metadataStorageConnector;
        this.tablesConfig = tablesConfig;
        this.auditManager = auditManager;
    }

    public CoordinatorDynamicConfig getCurrentDynamicConfig() {
        CoordinatorDynamicConfig dynamicConfig = (CoordinatorDynamicConfig)this.jacksonConfigManager.watch("coordinator.config", CoordinatorDynamicConfig.class, (Object)CoordinatorDynamicConfig.builder().build()).get();
        return (CoordinatorDynamicConfig)Preconditions.checkNotNull((Object)dynamicConfig, (Object)"Got null config from watcher?!");
    }

    public ConfigManager.SetResult setDynamicConfig(CoordinatorDynamicConfig config, AuditInfo auditInfo) {
        return this.jacksonConfigManager.set("coordinator.config", (Object)config, auditInfo);
    }

    public DruidCompactionConfig getCurrentCompactionConfig() {
        DruidCompactionConfig config = (DruidCompactionConfig)this.jacksonConfigManager.watch("coordinator.compaction.config", DruidCompactionConfig.class, (Object)DruidCompactionConfig.empty()).get();
        return (DruidCompactionConfig)Preconditions.checkNotNull((Object)config, (Object)"Got null config from watcher?!");
    }

    public ConfigManager.SetResult getAndUpdateCompactionConfig(UnaryOperator<DruidCompactionConfig> operator, AuditInfo auditInfo) {
        DruidCompactionConfig updated;
        byte[] currentBytes = this.metadataStorageConnector.lookup(this.tablesConfig.getConfigTable(), "name", "payload", "coordinator.compaction.config");
        DruidCompactionConfig current = this.convertBytesToCompactionConfig(currentBytes);
        if (current.equals(updated = (DruidCompactionConfig)operator.apply(current))) {
            return ConfigManager.SetResult.ok();
        }
        return this.jacksonConfigManager.set("coordinator.compaction.config", currentBytes, (Object)updated, auditInfo);
    }

    public DruidCompactionConfig convertBytesToCompactionConfig(byte[] bytes) {
        return (DruidCompactionConfig)this.jacksonConfigManager.convertByteToConfig(bytes, DruidCompactionConfig.class, (Object)DruidCompactionConfig.empty());
    }

    public boolean updateCompactionTaskSlots(@Nullable Double compactionTaskSlotRatio, @Nullable Integer maxCompactionTaskSlots, AuditInfo auditInfo) {
        UnaryOperator operator = current -> {
            ClusterCompactionConfig currentClusterConfig = current.clusterConfig();
            ClusterCompactionConfig updatedClusterConfig = new ClusterCompactionConfig((Double)Configs.valueOrDefault((Object)compactionTaskSlotRatio, (Object)currentClusterConfig.getCompactionTaskSlotRatio()), Configs.valueOrDefault((Integer)maxCompactionTaskSlots, (int)currentClusterConfig.getMaxCompactionTaskSlots()), currentClusterConfig.getCompactionPolicy(), currentClusterConfig.isUseSupervisors(), currentClusterConfig.getEngine());
            return current.withClusterConfig(updatedClusterConfig);
        };
        return this.updateConfigHelper(operator, auditInfo);
    }

    public boolean updateClusterCompactionConfig(ClusterCompactionConfig config, AuditInfo auditInfo) {
        UnaryOperator operator = current -> current.withClusterConfig(config);
        return this.updateConfigHelper(operator, auditInfo);
    }

    public ClusterCompactionConfig getClusterCompactionConfig() {
        return this.getCurrentCompactionConfig().clusterConfig();
    }

    public boolean updateDatasourceCompactionConfig(DataSourceCompactionConfig config, AuditInfo auditInfo) {
        UnaryOperator callable = current -> current.withDatasourceConfig(config);
        return this.updateConfigHelper(callable, auditInfo);
    }

    public DataSourceCompactionConfig getDatasourceCompactionConfig(String dataSource) {
        DruidCompactionConfig current = this.getCurrentCompactionConfig();
        Optional<DataSourceCompactionConfig> config = current.findConfigForDatasource(dataSource);
        if (config.isPresent()) {
            return (DataSourceCompactionConfig)config.get();
        }
        throw NotFound.exception((String)"Datasource compaction config does not exist", (Object[])new Object[0]);
    }

    public boolean deleteDatasourceCompactionConfig(String dataSource, AuditInfo auditInfo) {
        UnaryOperator callable = current -> {
            Map<String, DataSourceCompactionConfig> configs = current.dataSourceToCompactionConfigMap();
            DataSourceCompactionConfig config = configs.remove(dataSource);
            if (config == null) {
                throw NotFound.exception((String)"Datasource compaction config does not exist", (Object[])new Object[0]);
            }
            return current.withDatasourceConfigs(List.copyOf(configs.values()));
        };
        return this.updateConfigHelper(callable, auditInfo);
    }

    public List<DataSourceCompactionConfigAuditEntry> getCompactionConfigHistory(String dataSource, @Nullable String interval, @Nullable Integer count) {
        Interval theInterval = interval == null ? null : Intervals.of((String)interval);
        try {
            List auditEntries = theInterval == null && count != null ? this.auditManager.fetchAuditHistory("coordinator.compaction.config", "coordinator.compaction.config", count.intValue()) : this.auditManager.fetchAuditHistory("coordinator.compaction.config", "coordinator.compaction.config", theInterval);
            DataSourceCompactionConfigHistory history = new DataSourceCompactionConfigHistory(dataSource);
            for (AuditEntry audit : auditEntries) {
                DruidCompactionConfig compactionConfig = this.convertBytesToCompactionConfig(audit.getPayload().serialized().getBytes(StandardCharsets.UTF_8));
                history.add(compactionConfig, audit.getAuditInfo(), audit.getAuditTime());
            }
            return history.getEntries();
        }
        catch (Exception e) {
            throw InternalServerError.exception((Throwable)Throwables.getRootCause((Throwable)e), (String)"Could not fetch audit entries", (Object[])new Object[0]);
        }
    }

    private boolean updateConfigHelper(UnaryOperator<DruidCompactionConfig> configUpdateOperator, AuditInfo auditInfo) {
        ConfigManager.SetResult setResult = null;
        try {
            for (int attemps = 0; attemps < 5 && !(setResult = this.getAndUpdateCompactionConfig(configUpdateOperator, auditInfo)).isOk() && setResult.isRetryable(); ++attemps) {
                this.updateRetryDelay();
            }
        }
        catch (DruidException e) {
            throw e;
        }
        catch (Exception e) {
            log.warn((Throwable)e, "Compaction config update failed", new Object[0]);
            throw InternalServerError.exception((Throwable)Throwables.getRootCause((Throwable)e), (String)"Failed to perform operation on compaction config", (Object[])new Object[0]);
        }
        if (setResult.isOk()) {
            return true;
        }
        if (setResult.getException() instanceof NoSuchElementException) {
            log.warn((Throwable)setResult.getException(), "Update compaction config failed", new Object[0]);
            throw NotFound.exception((Throwable)Throwables.getRootCause((Throwable)setResult.getException()), (String)"Compaction config does not exist", (Object[])new Object[0]);
        }
        log.warn((Throwable)setResult.getException(), "Update compaction config failed", new Object[0]);
        throw InternalServerError.exception((Throwable)Throwables.getRootCause((Throwable)setResult.getException()), (String)"Failed to perform operation on compaction config", (Object[])new Object[0]);
    }

    private void updateRetryDelay() {
        try {
            Thread.sleep(ThreadLocalRandom.current().nextLong(1000L));
        }
        catch (InterruptedException ie) {
            throw new RuntimeException(ie);
        }
    }
}

