// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.
// Code generated by informer-gen. DO NOT EDIT.

package v1

import (
	"context"
	time "time"

	disaggregatedv1 "github.com/apache/doris-operator/api/disaggregated/v1"
	versioned "github.com/apache/doris-operator/client/clientset/versioned"
	internalinterfaces "github.com/apache/doris-operator/client/informers/externalversions/internalinterfaces"
	v1 "github.com/apache/doris-operator/client/listers/disaggregated/v1"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	runtime "k8s.io/apimachinery/pkg/runtime"
	watch "k8s.io/apimachinery/pkg/watch"
	cache "k8s.io/client-go/tools/cache"
)

// DorisDisaggregatedClusterInformer provides access to a shared informer and lister for
// DorisDisaggregatedClusters.
type DorisDisaggregatedClusterInformer interface {
	Informer() cache.SharedIndexInformer
	Lister() v1.DorisDisaggregatedClusterLister
}

type dorisDisaggregatedClusterInformer struct {
	factory          internalinterfaces.SharedInformerFactory
	tweakListOptions internalinterfaces.TweakListOptionsFunc
	namespace        string
}

// NewDorisDisaggregatedClusterInformer constructs a new informer for DorisDisaggregatedCluster type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewDorisDisaggregatedClusterInformer(client versioned.Interface, namespace string, resyncPeriod time.Duration, indexers cache.Indexers) cache.SharedIndexInformer {
	return NewFilteredDorisDisaggregatedClusterInformer(client, namespace, resyncPeriod, indexers, nil)
}

// NewFilteredDorisDisaggregatedClusterInformer constructs a new informer for DorisDisaggregatedCluster type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewFilteredDorisDisaggregatedClusterInformer(client versioned.Interface, namespace string, resyncPeriod time.Duration, indexers cache.Indexers, tweakListOptions internalinterfaces.TweakListOptionsFunc) cache.SharedIndexInformer {
	return cache.NewSharedIndexInformer(
		&cache.ListWatch{
			ListFunc: func(options metav1.ListOptions) (runtime.Object, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.DisaggregatedV1().DorisDisaggregatedClusters(namespace).List(context.TODO(), options)
			},
			WatchFunc: func(options metav1.ListOptions) (watch.Interface, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.DisaggregatedV1().DorisDisaggregatedClusters(namespace).Watch(context.TODO(), options)
			},
		},
		&disaggregatedv1.DorisDisaggregatedCluster{},
		resyncPeriod,
		indexers,
	)
}

func (f *dorisDisaggregatedClusterInformer) defaultInformer(client versioned.Interface, resyncPeriod time.Duration) cache.SharedIndexInformer {
	return NewFilteredDorisDisaggregatedClusterInformer(client, f.namespace, resyncPeriod, cache.Indexers{cache.NamespaceIndex: cache.MetaNamespaceIndexFunc}, f.tweakListOptions)
}

func (f *dorisDisaggregatedClusterInformer) Informer() cache.SharedIndexInformer {
	return f.factory.InformerFor(&disaggregatedv1.DorisDisaggregatedCluster{}, f.defaultInformer)
}

func (f *dorisDisaggregatedClusterInformer) Lister() v1.DorisDisaggregatedClusterLister {
	return v1.NewDorisDisaggregatedClusterLister(f.Informer().GetIndexer())
}
