/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.editors.searchresult;

import java.util.Collection;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.studio.ldapbrowser.core.BrowserCoreConstants;
import org.apache.directory.studio.ldapbrowser.core.model.AttributeHierarchy;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.IValue;
import org.apache.directory.studio.ldapbrowser.core.model.schema.SchemaUtils;
import org.apache.directory.studio.ldapbrowser.ui.editors.searchresult.AbstractOpenEditorAction;
import org.apache.directory.studio.ldapbrowser.ui.editors.searchresult.Messages;
import org.apache.directory.studio.ldapbrowser.ui.editors.searchresult.SearchResultEditorActionGroup;
import org.apache.directory.studio.ldapbrowser.ui.editors.searchresult.SearchResultEditorCursor;
import org.apache.directory.studio.valueeditors.IValueEditor;
import org.apache.directory.studio.valueeditors.ValueEditorManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;

public class OpenBestEditorAction
extends AbstractOpenEditorAction {
    private IValueEditor bestValueEditor;

    public OpenBestEditorAction(TableViewer viewer, SearchResultEditorCursor cursor, ValueEditorManager valueEditorManager, SearchResultEditorActionGroup actionGroup) {
        super(viewer, cursor, valueEditorManager, actionGroup);
    }

    public IValueEditor getBestValueEditor() {
        return this.bestValueEditor;
    }

    public void dispose() {
        this.bestValueEditor = null;
        super.dispose();
    }

    public String getCommandId() {
        return null;
    }

    public ImageDescriptor getImageDescriptor() {
        return this.isEnabled() ? this.bestValueEditor.getValueEditorImageDescriptor() : null;
    }

    public String getText() {
        return this.isEnabled() ? this.bestValueEditor.getValueEditorName() : null;
    }

    public boolean isEnabled() {
        if (this.getSelectedSearchResults().length == 1 && this.getSelectedProperties().length == 1 && this.viewer.getCellModifier().canModify((Object)this.getSelectedSearchResults()[0], this.getSelectedProperties()[0])) {
            this.bestValueEditor = this.getSelectedAttributeHierarchies().length == 0 ? this.valueEditorManager.getCurrentValueEditor(this.getSelectedSearchResults()[0].getEntry(), this.getSelectedProperties()[0]) : this.valueEditorManager.getCurrentValueEditor(this.getSelectedAttributeHierarchies()[0]);
            this.cellEditor = this.bestValueEditor.getCellEditor();
            return true;
        }
        this.cellEditor = null;
        return false;
    }

    @Override
    public void run() {
        boolean ok = true;
        AttributeHierarchy[] attributeHierarchies = this.getSelectedAttributeHierarchies();
        if (attributeHierarchies.length == 1) {
            IValue value;
            AttributeType atd;
            IEntry entry;
            Collection allAtds;
            AttributeHierarchy attributeHierarchy = attributeHierarchies[0];
            StringBuffer message = new StringBuffer();
            if (attributeHierarchy.size() == 1 && attributeHierarchy.getAttribute().getValueSize() == 0 && !(allAtds = SchemaUtils.getAllAttributeTypeDescriptions((IEntry)(entry = attributeHierarchy.getAttribute().getEntry()))).contains(atd = attributeHierarchy.getAttribute().getAttributeTypeDescription())) {
                message.append(NLS.bind((String)Messages.getString("OpenBestEditorAction.AttributeNotInSubSchema"), (Object)attributeHierarchy.getAttribute().getDescription()));
                message.append(BrowserCoreConstants.LINE_SEPARATOR);
                message.append(BrowserCoreConstants.LINE_SEPARATOR);
            }
            if (attributeHierarchy.size() == 1 && attributeHierarchy.getAttribute().getValueSize() == 1 && attributeHierarchy.getAttributeDescription().equalsIgnoreCase(attributeHierarchy.getAttribute().getValues()[0].getAttribute().getDescription()) && !attributeHierarchy.getAttribute().getValues()[0].isRdnPart() && !(value = attributeHierarchy.getAttribute().getValues()[0]).isEmpty() && !SchemaUtils.isModifiable((AttributeType)value.getAttribute().getAttributeTypeDescription())) {
                message.append(NLS.bind((String)Messages.getString("OpenBestEditorAction.EditValueNotModifiable"), (Object)value.getAttribute().getDescription()));
                message.append(BrowserCoreConstants.LINE_SEPARATOR);
                message.append(BrowserCoreConstants.LINE_SEPARATOR);
            }
            if (message.length() > 0) {
                message.append(Messages.getString("OpenBestEditorAction.EditValueQuestion"));
                ok = MessageDialog.openConfirm((Shell)this.getShell(), (String)this.getText(), (String)message.toString());
            }
        }
        if (ok) {
            super.run();
        }
    }
}

