/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.factory;

import java.io.File;
import java.util.Set;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.server.core.api.DnFactory;
import org.apache.directory.server.core.api.partition.Partition;
import org.apache.directory.server.core.factory.PartitionFactory;
import org.apache.directory.server.core.partition.ldif.LdifPartition;
import org.apache.directory.server.xdbm.Index;
import org.apache.directory.server.xdbm.impl.avl.AvlIndex;

public class LdifPartitionFactory
implements PartitionFactory {
    @Override
    public LdifPartition createPartition(SchemaManager schemaManager, DnFactory dnFactory, String id, String suffix, int cacheSize, File workingDirectory) throws Exception {
        LdifPartition partition = new LdifPartition(schemaManager, dnFactory);
        partition.setId(id);
        partition.setSuffixDn(new Dn(suffix));
        partition.setCacheSize(500);
        partition.setPartitionPath(workingDirectory.toURI());
        return partition;
    }

    @Override
    public void addIndex(Partition partition, String attributeId, int cacheSize) throws Exception {
        if (!(partition instanceof LdifPartition)) {
            throw new IllegalArgumentException("Partition must be a LdifPartition");
        }
        LdifPartition ldifPartition = (LdifPartition)partition;
        Set<Index<?, String>> indexedAttributes = ldifPartition.getIndexedAttributes();
        AvlIndex index = new AvlIndex(attributeId, false);
        indexedAttributes.add(index);
        ldifPartition.setIndexedAttributes(indexedAttributes);
    }
}

