/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.outlet;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.generator.GeneratorException;
import org.apache.torque.generator.configuration.ConfigurationException;
import org.apache.torque.generator.configuration.mergepoint.MergepointMapping;
import org.apache.torque.generator.control.ControllerState;
import org.apache.torque.generator.control.action.MergepointAction;
import org.apache.torque.generator.outlet.Outlet;
import org.apache.torque.generator.outlet.OutletResult;
import org.apache.torque.generator.qname.QualifiedName;
import org.apache.torque.generator.source.SourceElement;
import org.apache.torque.generator.variable.Variable;
import org.apache.torque.generator.variable.VariableStore;

public abstract class OutletImpl
implements Outlet {
    private static Log log = LogFactory.getLog(OutletImpl.class);
    private final Map<String, MergepointMapping> mergepointMappings = new HashMap<String, MergepointMapping>();
    private final QualifiedName name;
    private String inputElementName;
    private String inputClass;

    public OutletImpl(QualifiedName name) {
        if (name == null) {
            throw new NullPointerException("name must not be null");
        }
        this.name = name;
    }

    @Override
    public QualifiedName getName() {
        return this.name;
    }

    @Override
    public String getInputElementName() {
        return this.inputElementName;
    }

    @Override
    public void setInputElementName(String inputElementName) {
        this.inputElementName = inputElementName;
    }

    @Override
    public String getInputClass() {
        return this.inputClass;
    }

    @Override
    public void setInputClass(String inputClass) {
        this.inputClass = inputClass;
    }

    @Override
    public void addMergepointMapping(MergepointMapping mergepointMapping) throws ConfigurationException {
        MergepointMapping oldMapping = this.mergepointMappings.get(mergepointMapping.getName());
        if (oldMapping != null) {
            throw new ConfigurationException("Attempted to add another mergepoint mapping for the name " + mergepointMapping.getName() + " : New mapping mapped to Actions " + String.valueOf(mergepointMapping.getActions()) + ", old mapping mapped to Actions " + String.valueOf(oldMapping.getActions()));
        }
        log.debug((Object)("adding mergepointMapping: " + String.valueOf(mergepointMapping)));
        this.mergepointMappings.put(mergepointMapping.getName(), mergepointMapping);
    }

    @Override
    public MergepointMapping setMergepointMapping(MergepointMapping mergepointMapping) {
        return this.mergepointMappings.put(mergepointMapping.getName(), mergepointMapping);
    }

    @Override
    public MergepointMapping getMergepointMapping(String name) {
        return this.mergepointMappings.get(name);
    }

    @Override
    public Map<String, MergepointMapping> getMergepointMappings() {
        return Collections.unmodifiableMap(this.mergepointMappings);
    }

    @Override
    public void beforeExecute(ControllerState controllerState) throws GeneratorException {
        if (this.inputElementName != null || this.inputClass != null) {
            Object model = controllerState.getModel();
            if (this.inputClass != null && !this.inputClass.equals(model.getClass().getName())) {
                throw new GeneratorException("The input model of outlet " + String.valueOf(this.getName()) + " must be of class " + this.inputClass + " (because of the value of the attribute inputClass on the outlet in the generator config) but is of class " + model.getClass().getName());
            }
            if (this.inputElementName != null && !SourceElement.class.isAssignableFrom(model.getClass())) {
                throw new GeneratorException("The input model of outlet " + String.valueOf(this.getName()) + " must be " + SourceElement.class.getName() + " or a subclass thereof (because the attribute elementName is set on the outlet in the generator config)  but is of class " + model.getClass().getName());
            }
            if (this.inputElementName != null && !this.inputElementName.equals(((SourceElement)model).getName())) {
                throw new GeneratorException("Input element name, " + ((SourceElement)model).getName() + ", is not the expected name, " + this.getInputElementName() + ", for outlet " + String.valueOf(this.getName()));
            }
        }
        controllerState.pushOutlet(this);
        controllerState.getVariableStore().startOutlet();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Executing outlet " + String.valueOf(this.getName()) + " on element " + String.valueOf(controllerState.getModel())));
        }
    }

    @Override
    public void afterExecute(ControllerState controllerState) {
        controllerState.getVariableStore().endOutlet();
        controllerState.popOutlet();
    }

    @Override
    public abstract OutletResult execute(ControllerState var1) throws GeneratorException;

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("(name=").append(this.name).append(",");
        result.append("inputElementName=").append(this.inputElementName);
        result.append(")");
        return result.toString();
    }

    public void setVariable(String key, Object value, ControllerState controllerState) {
        this.setVariable(key, value, Variable.Scope.CHILDREN, controllerState);
    }

    public void setVariable(String key, Object value, Variable.Scope scope, ControllerState controllerState) {
        QualifiedName qualifiedName = controllerState.getQualifiedName(key);
        Variable variable = new Variable(qualifiedName, value, scope);
        VariableStore variableStore = controllerState.getVariableStore();
        variableStore.set(variable);
    }

    public Object getVariable(String key, ControllerState controllerState) {
        QualifiedName qualifiedName = controllerState.getQualifiedName(key);
        VariableStore variableStore = controllerState.getVariableStore();
        Variable variable = variableStore.getInHierarchy(qualifiedName);
        Object value = null;
        if (variable != null) {
            value = variable.getValue();
        }
        return value;
    }

    public String mergepoint(String mergepointName, ControllerState controllerState) throws GeneratorException {
        MergepointMapping mergepointMapping;
        if (log.isDebugEnabled()) {
            log.debug((Object)("mergepoint() : Start for mergepoint " + mergepointName));
        }
        if ((mergepointMapping = this.getMergepointMapping(mergepointName)) == null) {
            if (log.isInfoEnabled()) {
                log.info((Object)("mergepoint() : End. Mapping " + mergepointName + " not found in outlet " + String.valueOf(this.getName()) + ", returning the empty String"));
            }
            return "";
        }
        List<MergepointAction> actions = mergepointMapping.getActions();
        if (actions.isEmpty()) {
            log.debug((Object)("No actions specified for action mapping with name " + mergepointName + " in outlet " + String.valueOf(controllerState.getOutlet().getName()) + " while generating to " + String.valueOf(controllerState.getOutputFile()) + " Returning the empty String."));
            return "";
        }
        StringBuilder result = new StringBuilder();
        for (MergepointAction action : actions) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("mergepoint() : Executing action " + String.valueOf(action)));
            }
            try {
                OutletResult actionResult = action.execute(controllerState);
                if (!actionResult.isStringResult()) {
                    throw new GeneratorException("mergepoint actions must return a String result! Mergepoint name: " + mergepointName + ", outlet name: " + controllerState.getOutlet().getName().toString());
                }
                result.append(actionResult.getStringResult());
            }
            catch (RuntimeException | GeneratorException e) {
                log.error((Object)("mergepoint() : Error executing action " + String.valueOf(action)), (Throwable)e);
                throw e;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("mergepoint() : End for mergepoint " + mergepointName));
        }
        return result.toString();
    }
}

