/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime.parser.node;

import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import org.apache.velocity.app.event.EventHandlerUtil;
import org.apache.velocity.context.InternalContextAdapter;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.TemplateInitException;
import org.apache.velocity.exception.VelocityException;
import org.apache.velocity.io.Filter;
import org.apache.velocity.runtime.Renderable;
import org.apache.velocity.runtime.directive.Block;
import org.apache.velocity.runtime.parser.Parser;
import org.apache.velocity.runtime.parser.Token;
import org.apache.velocity.runtime.parser.node.ASTAndNode;
import org.apache.velocity.runtime.parser.node.ASTExpression;
import org.apache.velocity.runtime.parser.node.ASTIfStatement;
import org.apache.velocity.runtime.parser.node.ASTIndex;
import org.apache.velocity.runtime.parser.node.ASTMethod;
import org.apache.velocity.runtime.parser.node.ASTNotNode;
import org.apache.velocity.runtime.parser.node.ASTOrNode;
import org.apache.velocity.runtime.parser.node.Node;
import org.apache.velocity.runtime.parser.node.ParserVisitor;
import org.apache.velocity.runtime.parser.node.SimpleNode;
import org.apache.velocity.util.ClassUtils;
import org.apache.velocity.util.DuckType;
import org.apache.velocity.util.StringUtils;
import org.apache.velocity.util.introspection.Info;
import org.apache.velocity.util.introspection.IntrospectionCacheData;
import org.apache.velocity.util.introspection.VelMethod;
import org.apache.velocity.util.introspection.VelPropertySet;

public class ASTReference
extends SimpleNode {
    private static final int NORMAL_REFERENCE = 1;
    private static final int FORMAL_REFERENCE = 2;
    private static final int QUIET_REFERENCE = 3;
    private static final int RUNT = 4;
    private int referenceType;
    private String nullString;
    private String rootString;
    private boolean escaped = false;
    private boolean computableReference = true;
    private boolean logOnNull = true;
    private String escPrefix = "";
    private String morePrefix = "";
    private String identifier = "";
    private boolean checkEmpty;
    private String literal = null;
    public boolean strictRef = false;
    private ASTIndex astIndex = null;
    public boolean strictEscape = false;
    private int numChildren = 0;
    protected Info uberInfo;

    public ASTReference(int n) {
        super(n);
    }

    public ASTReference(Parser parser, int n) {
        super(parser, n);
    }

    @Override
    public Object jjtAccept(ParserVisitor parserVisitor, Object object) {
        return parserVisitor.visit(this, object);
    }

    @Override
    public Object init(InternalContextAdapter internalContextAdapter, Object object) throws TemplateInitException {
        Node node;
        super.init(internalContextAdapter, object);
        this.strictEscape = this.rsvc.getBoolean("runtime.references.strict.escape", false);
        this.strictRef = this.rsvc.getBoolean("runtime.references.strict", false);
        this.rootString = this.rsvc.useStringInterning() ? this.getRoot().intern() : this.getRoot();
        this.numChildren = this.jjtGetNumChildren();
        this.literal = this.literal();
        if (this.numChildren > 0) {
            node = this.jjtGetChild(this.numChildren - 1);
            if (node instanceof ASTIndex) {
                this.astIndex = (ASTIndex)node;
            } else {
                this.identifier = node.getFirstTokenImage();
            }
        }
        this.uberInfo = new Info(this.getTemplateName(), this.getLine(), this.getColumn());
        this.logOnNull = this.rsvc.getBoolean("runtime.log.invalid.references", true);
        this.checkEmpty = this.rsvc.getBoolean("directive.if.emptycheck", true);
        if (this.strictRef && this.numChildren == 0) {
            this.logOnNull = false;
            node = this.jjtGetParent();
            if (node instanceof ASTNotNode || node instanceof ASTExpression || node instanceof ASTOrNode || node instanceof ASTAndNode) {
                while (node != null) {
                    if (node instanceof ASTIfStatement) {
                        this.strictRef = false;
                        break;
                    }
                    node = node.jjtGetParent();
                }
            }
        }
        this.saveTokenImages();
        this.cleanupParserAndTokens();
        return object;
    }

    public String getRootString() {
        return this.rootString;
    }

    @Override
    public Object execute(Object object, InternalContextAdapter internalContextAdapter) throws MethodInvocationException {
        boolean bl;
        boolean bl2 = bl = object != null;
        if (this.referenceType == 4) {
            return null;
        }
        Object object2 = this.getVariableValue(internalContextAdapter, this.rootString);
        if (object2 == null && !this.strictRef) {
            if (this.referenceType != 3 && (this.numChildren > 0 || !internalContextAdapter.containsKey(this.rootString) && !bl)) {
                return EventHandlerUtil.invalidGetMethod(this.rsvc, internalContextAdapter, "$" + this.rootString, null, null, this.uberInfo);
            }
            return null;
        }
        try {
            Object object3 = object2;
            int n = -1;
            for (int i = 0; i < this.numChildren; ++i) {
                if (this.strictRef && object2 == null) {
                    String string = this.jjtGetChild(i).getFirstTokenImage();
                    throw new VelocityException("Attempted to access '" + string + "' on a null value at " + StringUtils.formatFileString(this.uberInfo.getTemplateName(), this.jjtGetChild(i).getLine(), this.jjtGetChild(i).getColumn()));
                }
                object3 = object2;
                object2 = this.jjtGetChild(i).execute(object2, internalContextAdapter);
                if (object2 != null || this.strictRef) continue;
                n = i;
                break;
            }
            if (object2 == null) {
                if (n == -1) {
                    if (!(internalContextAdapter.containsKey(this.rootString) || this.referenceType == 3 || bl && this.jjtGetNumChildren() <= 0)) {
                        object2 = EventHandlerUtil.invalidGetMethod(this.rsvc, internalContextAdapter, "$" + this.rootString, object3, null, this.uberInfo);
                    }
                } else {
                    Node node = this.jjtGetChild(n);
                    IntrospectionCacheData introspectionCacheData = internalContextAdapter.icacheGet(node);
                    if (!(introspectionCacheData != null || this.referenceType == 3 || bl && n >= this.jjtGetNumChildren() - 1)) {
                        StringBuilder stringBuilder = new StringBuilder("$").append(this.rootString);
                        for (int i = 0; i <= n; ++i) {
                            Node node2 = this.jjtGetChild(i);
                            if (node2 instanceof ASTMethod) {
                                stringBuilder.append(".").append(((ASTMethod)node2).getMethodName()).append("()");
                                continue;
                            }
                            stringBuilder.append(".").append(node2.getFirstTokenImage());
                        }
                        if (node instanceof ASTMethod) {
                            String string = ((ASTMethod)this.jjtGetChild(n)).getMethodName();
                            object2 = EventHandlerUtil.invalidMethod(this.rsvc, internalContextAdapter, stringBuilder.toString(), object3, string, this.uberInfo);
                        } else {
                            String string = this.jjtGetChild(n).getFirstTokenImage();
                            object2 = EventHandlerUtil.invalidGetMethod(this.rsvc, internalContextAdapter, stringBuilder.toString(), object3, string, this.uberInfo);
                        }
                    }
                }
            }
            return object2;
        }
        catch (MethodInvocationException methodInvocationException) {
            methodInvocationException.setReferenceName(this.rootString);
            throw methodInvocationException;
        }
    }

    @Override
    public boolean render(InternalContextAdapter internalContextAdapter, Writer writer) throws IOException, MethodInvocationException {
        if (this.referenceType == 4) {
            writer.write(this.literal);
            return true;
        }
        Object object = null;
        object = this.escaped && this.strictEscape ? Boolean.TRUE : this.execute(null, internalContextAdapter);
        String string = null;
        if (this.escaped) {
            string = this.getNullString(internalContextAdapter);
            if (object == null) {
                writer.write(this.escPrefix);
                writer.write("\\");
                writer.write(string);
            } else {
                writer.write(this.escPrefix);
                writer.write(string);
            }
            return true;
        }
        object = EventHandlerUtil.referenceInsert(this.rsvc, internalContextAdapter, this.literal, object);
        String string2 = null;
        if (object != null) {
            if (object instanceof Renderable) {
                Renderable renderable = (Renderable)object;
                try {
                    writer.write(this.escPrefix);
                    writer.write(this.morePrefix);
                    if (renderable.render(internalContextAdapter, writer)) {
                        return true;
                    }
                }
                catch (RuntimeException runtimeException) {
                    this.log.error("Exception rendering " + (renderable instanceof Block.Reference ? "block " : "Renderable ") + this.rootString + " at " + StringUtils.formatFileString(this));
                    throw runtimeException;
                }
            }
            string2 = DuckType.asString(object);
        }
        if (object == null || string2 == null) {
            if (this.strictRef) {
                if (this.referenceType != 3) {
                    this.log.error("Prepend the reference with '$!' e.g., $!{} if you want Velocity to ignore the reference when it evaluates to null", (Object)this.literal().substring(1));
                    if (object == null) {
                        throw new VelocityException("Reference " + this.literal() + " evaluated to null when attempting to render at " + StringUtils.formatFileString(this));
                    }
                    throw new VelocityException("Reference " + this.literal() + " evaluated to object " + object.getClass().getName() + " whose toString() method returned null at " + StringUtils.formatFileString(this));
                }
                return true;
            }
            string = this.getNullString(internalContextAdapter);
            if (!this.strictEscape) {
                writer.write(this.escPrefix);
            }
            writer.write(this.escPrefix);
            writer.write(this.morePrefix);
            writer.write(string);
            if (this.logOnNull && this.referenceType != 3) {
                this.log.debug("Null reference [template '{}', line {}, column {}]: {} cannot be resolved.", new Object[]{this.getTemplateName(), this.getLine(), this.getColumn(), this.literal()});
            }
            return true;
        }
        writer.write(this.escPrefix);
        writer.write(this.morePrefix);
        if (writer instanceof Filter) {
            ((Filter)((Object)writer)).writeReference(string2);
        } else {
            writer.write(string2);
        }
        return true;
    }

    private String getNullString(InternalContextAdapter internalContextAdapter) {
        Object object = internalContextAdapter.get(".literal." + this.nullString);
        if (object != null) {
            return ((Node)object).literal();
        }
        return this.nullString;
    }

    @Override
    public boolean evaluate(InternalContextAdapter internalContextAdapter) throws MethodInvocationException {
        Object object = this.execute(this, internalContextAdapter);
        if (object == null) {
            return false;
        }
        try {
            return DuckType.asBoolean(object, this.checkEmpty);
        }
        catch (Exception exception) {
            throw new VelocityException("Reference evaluation threw an exception at " + StringUtils.formatFileString(this), exception);
        }
    }

    @Override
    public Object value(InternalContextAdapter internalContextAdapter) throws MethodInvocationException {
        return this.computableReference ? this.execute(null, internalContextAdapter) : null;
    }

    public static String printClass(Class clazz) {
        return clazz == null ? "null" : clazz.getName();
    }

    public boolean setValue(InternalContextAdapter internalContextAdapter, Object object) throws MethodInvocationException {
        if (this.jjtGetNumChildren() == 0) {
            internalContextAdapter.put(this.rootString, object);
            return true;
        }
        Object object2 = this.getVariableValue(internalContextAdapter, this.rootString);
        if (object2 == null) {
            this.log.error("reference set is not a valid reference at {}", (Object)StringUtils.formatFileString(this.uberInfo));
            return false;
        }
        for (int i = 0; i < this.numChildren - 1; ++i) {
            object2 = this.jjtGetChild(i).execute(object2, internalContextAdapter);
            if (object2 != null) continue;
            if (this.strictRef) {
                String string = this.jjtGetChild(i + 1).getFirstTokenImage();
                throw new MethodInvocationException("Attempted to access '" + string + "' on a null value", null, string, this.uberInfo.getTemplateName(), this.jjtGetChild(i + 1).getLine(), this.jjtGetChild(i + 1).getColumn());
            }
            this.log.error("reference set is not a valid reference at {}", (Object)StringUtils.formatFileString(this.uberInfo));
            return false;
        }
        if (this.astIndex != null) {
            Object object3 = this.astIndex.jjtGetChild(0).value(internalContextAdapter);
            object3 = ASTIndex.adjMinusIndexArg(object3, object2, internalContextAdapter, this.astIndex);
            Object[] objectArray = new Object[]{object3, object};
            String string = "set";
            Class[] classArray = new Class[]{objectArray[0] == null ? null : objectArray[0].getClass(), objectArray[1] == null ? null : objectArray[1].getClass()};
            VelMethod velMethod = ClassUtils.getMethod(string, objectArray, classArray, object2, internalContextAdapter, this.astIndex, false);
            if (velMethod == null) {
                string = "put";
                velMethod = ClassUtils.getMethod(string, objectArray, classArray, object2, internalContextAdapter, this.astIndex, false);
            }
            if (velMethod == null) {
                if (this.strictRef) {
                    throw new VelocityException("Found neither a 'set' or 'put' method with param types '(" + ASTReference.printClass(classArray[0]) + "," + ASTReference.printClass(classArray[1]) + ")' on class '" + object2.getClass().getName() + "' at " + StringUtils.formatFileString(this.astIndex));
                }
                return false;
            }
            try {
                velMethod.invoke(object2, objectArray);
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new MethodInvocationException("Exception calling method '" + string + "(" + ASTReference.printClass(classArray[0]) + "," + ASTReference.printClass(classArray[1]) + ")' in  " + object2.getClass(), exception.getCause(), this.identifier, this.astIndex.getTemplateName(), this.astIndex.getLine(), this.astIndex.getColumn());
            }
            return true;
        }
        try {
            VelPropertySet velPropertySet = this.rsvc.getUberspect().getPropertySet(object2, this.identifier, object, this.uberInfo);
            if (velPropertySet == null) {
                if (this.strictRef) {
                    throw new MethodInvocationException("Object '" + object2.getClass().getName() + "' does not contain property '" + this.identifier + "'", null, this.identifier, this.uberInfo.getTemplateName(), this.uberInfo.getLine(), this.uberInfo.getColumn());
                }
                return false;
            }
            velPropertySet.invoke(object2, object);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new MethodInvocationException("ASTReference: Invocation of method '" + this.identifier + "' in  " + object2.getClass() + " threw exception " + invocationTargetException.getTargetException().toString(), invocationTargetException.getTargetException(), this.identifier, this.getTemplateName(), this.getLine(), this.getColumn());
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            String string = "ASTReference setValue(): exception: " + exception + " template at " + StringUtils.formatFileString(this.uberInfo);
            this.log.error(string, (Throwable)exception);
            throw new VelocityException(string, exception);
        }
        return true;
    }

    private String getRoot() {
        int n;
        Token token = this.getFirstToken();
        int n2 = token.image.indexOf("\\!");
        if (n2 != -1) {
            if (this.strictEscape) {
                this.nullString = this.literal();
                this.escaped = true;
                return this.nullString;
            }
            int n3 = 0;
            int n4 = token.image.length();
            n3 = token.image.indexOf(36);
            if (n3 == -1) {
                this.log.error("ASTReference.getRoot(): internal error: no $ found for slashbang.");
                this.computableReference = false;
                this.nullString = token.image;
                return this.nullString;
            }
            while (n3 < n4 && token.image.charAt(n3) != '\\') {
                ++n3;
            }
            int n5 = n3;
            int n6 = 0;
            while (n3 < n4 && token.image.charAt(n3++) == '\\') {
                ++n6;
            }
            this.nullString = token.image.substring(0, n5);
            this.nullString = this.nullString + token.image.substring(n5, n5 + n6 - 1);
            this.nullString = this.nullString + token.image.substring(n5 + n6);
            this.computableReference = false;
            return this.nullString;
        }
        this.escaped = false;
        if (token.image.startsWith("\\")) {
            int n7 = token.image.length();
            for (n = 0; n < n7 && token.image.charAt(n) == '\\'; ++n) {
            }
            if (n % 2 != 0) {
                this.escaped = true;
            }
            if (n > 0) {
                this.escPrefix = token.image.substring(0, n / 2);
            }
            token.image = token.image.substring(n);
        }
        if ((n = token.image.lastIndexOf(36)) > 0) {
            this.morePrefix = this.morePrefix + token.image.substring(0, n);
            token.image = token.image.substring(n);
        }
        this.nullString = this.literal();
        if (token.image.startsWith("$!")) {
            this.referenceType = 3;
            if (!this.escaped) {
                this.nullString = "";
            }
            if (token.image.startsWith("$!{")) {
                return token.next.image;
            }
            return token.image.substring(2);
        }
        if (token.image.equals("${")) {
            this.referenceType = 2;
            return token.next.image;
        }
        if (token.image.startsWith("$")) {
            this.referenceType = 1;
            return token.image.substring(1);
        }
        this.referenceType = 4;
        return token.image;
    }

    public Object getVariableValue(InternalContextAdapter internalContextAdapter, String string) {
        Object object = null;
        try {
            object = internalContextAdapter.get(string);
        }
        catch (RuntimeException runtimeException) {
            this.log.error("Exception calling reference ${} at {}", (Object)string, (Object)StringUtils.formatFileString(this.uberInfo));
            throw runtimeException;
        }
        if (object == null && this.strictRef && !internalContextAdapter.containsKey(string)) {
            this.log.error("Variable ${} has not been set at {}", (Object)string, (Object)StringUtils.formatFileString(this.uberInfo));
            throw new MethodInvocationException("Variable $" + string + " has not been set", null, this.identifier, this.uberInfo.getTemplateName(), this.uberInfo.getLine(), this.uberInfo.getColumn());
        }
        return object;
    }
}

