/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.configuration.source;

import java.util.HashSet;
import java.util.Set;
import org.apache.torque.generator.configuration.ConfigurationException;
import org.apache.torque.generator.configuration.ConfigurationHandlers;
import org.apache.torque.generator.configuration.ConfigurationProvider;
import org.apache.torque.generator.configuration.SaxHelper;
import org.apache.torque.generator.configuration.UnitDescriptor;
import org.apache.torque.generator.configuration.source.SourceSaxHandler;
import org.apache.torque.generator.file.Fileset;
import org.apache.torque.generator.source.SourceProvider;
import org.apache.torque.generator.source.stream.FileSourceProvider;
import org.apache.torque.generator.source.stream.StreamSourceFormat;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class FileSourceSaxHandler
extends SourceSaxHandler {
    private String format;
    private Set<String> includes = new HashSet<String>();
    private Set<String> excludes = new HashSet<String>();
    private Boolean combineFiles;
    private StringBuilder currentInclude = null;
    private StringBuilder currentExclude = null;
    private SourceProvider sourceProvider;

    public FileSourceSaxHandler(ConfigurationProvider configurationProvider, UnitDescriptor unitDescriptor, ConfigurationHandlers configurationHandlers) {
        super(configurationProvider, unitDescriptor, configurationHandlers);
    }

    @Override
    public void startElement(String uri, String localName, String rawName, Attributes attributes) throws SAXException {
        if (rawName.equals("include")) {
            this.currentInclude = new StringBuilder();
        } else if (rawName.equals("exclude")) {
            this.currentExclude = new StringBuilder();
        } else if (rawName.equals("source")) {
            super.startElement(uri, localName, rawName, attributes);
            this.format = attributes.getValue("format");
            if (attributes.getValue("combineFiles") != null) {
                this.combineFiles = SaxHelper.getBooleanAttribute("combineFiles", attributes, "the element source");
            }
        } else {
            super.startElement(uri, localName, rawName, attributes);
        }
    }

    @Override
    public void endElement(String uri, String localName, String rawName) throws SAXException {
        if (rawName.equals("include")) {
            this.includes.add(this.currentInclude.toString());
            this.currentInclude = null;
        } else if (rawName.equals("exclude")) {
            this.excludes.add(this.currentExclude.toString());
            this.currentExclude = null;
        } else if (rawName.equals("source")) {
            try {
                StreamSourceFormat sourceFormat = null;
                if (this.format != null) {
                    Set<StreamSourceFormat> sourceFormats = this.getConfigurationHandlers().getStreamSourceFormats();
                    for (StreamSourceFormat candidate : sourceFormats) {
                        if (!this.format.equals(candidate.getKey())) continue;
                        sourceFormat = candidate;
                        break;
                    }
                    if (sourceFormat == null) {
                        throw new SAXException("Unknown source format : " + this.format + " Known types are: " + sourceFormats);
                    }
                }
                Fileset sourceFileset = new Fileset(this.getUnitDescriptor().getProjectPaths().getDefaultSourcePath(), this.includes, this.excludes);
                this.sourceProvider = new FileSourceProvider(sourceFormat, sourceFileset, this.combineFiles);
            }
            catch (ConfigurationException e) {
                throw new SAXException("Could not create source: " + e.getMessage(), e);
            }
            super.endElement(uri, localName, rawName);
            this.finished();
        } else {
            super.endElement(uri, localName, rawName);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.currentInclude != null) {
            for (int i = start; i < start + length; ++i) {
                this.currentInclude.append(ch[i]);
            }
        } else if (this.currentExclude != null) {
            for (int i = start; i < start + length; ++i) {
                this.currentExclude.append(ch[i]);
            }
        } else {
            super.characters(ch, start, length);
        }
    }

    @Override
    public SourceProvider getSourceProvider() {
        return this.sourceProvider;
    }
}

