/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.outlet.java;

import org.apache.torque.generator.GeneratorException;
import org.apache.torque.generator.control.ControllerState;
import org.apache.torque.generator.outlet.OutletResult;
import org.apache.torque.generator.outlet.java.OutletWithoutMergepoints;
import org.apache.torque.generator.qname.QualifiedName;

public class NewlineOutlet
extends OutletWithoutMergepoints {
    public static final char CARRIAGE_RETURN = '\r';
    public static final char NEWLINE = '\n';
    private int count = 1;
    private boolean windowsStyle = false;

    public NewlineOutlet(QualifiedName name) {
        super(name);
    }

    public OutletResult execute(ControllerState controllerState) throws GeneratorException {
        if (this.count < 0) {
            throw new GeneratorException("count must not be < 0");
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < this.count; ++i) {
            if (this.windowsStyle) {
                result.append('\r');
            }
            result.append('\n');
        }
        return new OutletResult(result.toString());
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public boolean isWindowsStyle() {
        return this.windowsStyle;
    }

    public void setWindowsStyle(boolean windowsStyle) {
        this.windowsStyle = windowsStyle;
    }
}

