/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.Torque;
import org.apache.torque.TorqueException;
import org.apache.torque.criteria.CriteriaInterface;
import org.apache.torque.sql.SqlBuilder;
import org.apache.torque.util.BasePeerImpl;
import org.apache.torque.util.Criteria;
import org.apache.torque.util.Transaction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LargeSelect<T>
implements Runnable,
Serializable {
    private static final long serialVersionUID = -1166842932571491942L;
    private int pageSize;
    private int memoryLimit;
    private volatile transient int blockBegin = 0;
    private volatile transient int blockEnd;
    private volatile int currentlyFilledTo = -1;
    private transient List<T> results = null;
    private transient Thread thread = null;
    private volatile transient boolean killThread = false;
    private volatile transient boolean threadRunning = false;
    private volatile transient boolean queryCompleted = false;
    private transient boolean totalsFinalized = false;
    private int position;
    private int totalPages = -1;
    private int totalRecords = 0;
    private CriteriaInterface<?> criteria = null;
    private transient List<T> lastResults;
    private BasePeerImpl<T> peer = null;
    public static final String DEFAULT_MORE_INDICATOR = "&gt;";
    private String moreIndicator = "&gt;";
    public static final int DEFAULT_MEMORY_LIMIT_PAGES = 5;
    private int memoryPageLimit = 5;
    private static final int QUERY_NOT_COMPLETED_SLEEP_TIME = 500;
    private static final int QUERY_STOP_SLEEP_TIME = 100;
    private Map<String, String> params = null;
    private static Log log = LogFactory.getLog(LargeSelect.class);

    public LargeSelect(CriteriaInterface<?> criteria, int pageSize, BasePeerImpl<T> peerImpl) {
        this(criteria, pageSize, 5, peerImpl);
    }

    public LargeSelect(CriteriaInterface<?> criteria, int pageSize, int memoryPageLimit, BasePeerImpl<T> peerImpl) {
        this.peer = peerImpl;
        if (criteria.getOffset() != 0L || criteria.getLimit() != -1) {
            throw new IllegalArgumentException("criteria must not use Offset and/or Limit.");
        }
        if (pageSize < 1) {
            throw new IllegalArgumentException("pageSize must be greater than zero.");
        }
        if (memoryPageLimit < 1) {
            throw new IllegalArgumentException("memoryPageLimit must be greater than zero.");
        }
        this.pageSize = pageSize;
        this.memoryLimit = pageSize * memoryPageLimit;
        this.criteria = criteria;
        this.blockEnd = this.blockBegin + this.memoryLimit - 1;
        this.startQuery(pageSize);
    }

    public List<T> getPage(int pageNumber) throws TorqueException {
        if (pageNumber < 1) {
            throw new IllegalArgumentException("pageNumber must be greater than zero.");
        }
        return this.getResults((pageNumber - 1) * this.pageSize);
    }

    public List<T> getNextResults() throws TorqueException {
        if (!this.getNextResultsAvailable()) {
            return this.getCurrentPageResults();
        }
        return this.getResults(this.position);
    }

    public List<T> getCurrentPageResults() throws TorqueException {
        return null == this.lastResults && this.position > 0 ? this.getResults(this.position) : this.lastResults;
    }

    public List<T> getPreviousResults() throws TorqueException {
        if (!this.getPreviousResultsAvailable()) {
            return this.getCurrentPageResults();
        }
        int start = this.position - 2 * this.pageSize < 0 ? 0 : this.position - 2 * this.pageSize;
        return this.getResults(start);
    }

    private List<T> getResults(int start) throws TorqueException {
        return this.getResults(start, this.pageSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized List<T> getResults(int start, int size) throws TorqueException {
        ArrayList<T> returnResults;
        if (log.isDebugEnabled()) {
            log.debug((Object)("getResults(start: " + start + ", size: " + size + ") invoked."));
        }
        if (size > this.memoryLimit) {
            throw new IllegalArgumentException("size (" + size + ") exceeds memory limit (" + this.memoryLimit + ").");
        }
        if (start >= this.blockBegin && start + size - 1 <= this.blockEnd) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("getResults(): Sleeping until start+size-1 (" + (start + size - 1) + ") > currentlyFilledTo (" + this.currentlyFilledTo + ") && !queryCompleted (!" + this.queryCompleted + ")"));
            }
            while (start + size - 1 > this.currentlyFilledTo && !this.queryCompleted) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    throw new TorqueException("Unexpected interruption", e);
                }
            }
        } else {
            if (start < this.blockBegin && start >= 0) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("getResults(): Paging backwards as start (" + start + ") < blockBegin (" + this.blockBegin + ") && start >= 0"));
                }
                this.stopQuery();
                if (this.memoryLimit >= 2 * size) {
                    this.blockBegin = start - size;
                    if (this.blockBegin < 0) {
                        this.blockBegin = 0;
                    }
                } else {
                    this.blockBegin = start;
                }
                this.blockEnd = this.blockBegin + this.memoryLimit - 1;
                this.startQuery(size);
                return this.getResults(start, size);
            }
            if (start + size - 1 > this.blockEnd) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("getResults(): Paging past end of loaded data as start+size-1 (" + (start + size - 1) + ") > blockEnd (" + this.blockEnd + ")"));
                }
                this.stopQuery();
                this.blockBegin = start;
                this.blockEnd = this.blockBegin + this.memoryLimit - 1;
                this.startQuery(size);
                return this.getResults(start, size);
            }
            throw new IllegalArgumentException("Parameter configuration not accounted for.");
        }
        int fromIndex = start - this.blockBegin;
        int toIndex = fromIndex + Math.min(size, this.results.size() - fromIndex);
        if (log.isDebugEnabled()) {
            log.debug((Object)("getResults(): Retrieving records from results elements start-blockBegin (" + fromIndex + ") through " + "fromIndex + Math.min(size, results.size() - fromIndex) (" + toIndex + ")"));
        }
        List<T> list = this.results;
        synchronized (list) {
            returnResults = new ArrayList<T>(this.results.subList(fromIndex, toIndex));
        }
        this.position = start + size;
        this.lastResults = returnResults;
        return returnResults;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block24: {
            block23: {
                Connection conn = null;
                try {
                    String query;
                    this.results = new ArrayList<T>(this.memoryLimit + 1);
                    this.criteria.setOffset(this.blockBegin);
                    this.criteria.setLimit(this.memoryLimit + 1);
                    if (this.criteria instanceof Criteria) {
                        this.peer.correctBooleans((Criteria)this.criteria);
                        this.peer.setDbName((Criteria)this.criteria);
                        query = SqlBuilder.buildQuery((Criteria)this.criteria).toString();
                    } else {
                        this.peer.correctBooleans((org.apache.torque.criteria.Criteria)this.criteria);
                        this.peer.setDbName((org.apache.torque.criteria.Criteria)this.criteria);
                        query = SqlBuilder.buildQuery((org.apache.torque.criteria.Criteria)this.criteria).toString();
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("run(): query = " + query));
                        log.debug((Object)("run(): memoryLimit = " + this.memoryLimit));
                        log.debug((Object)("run(): blockBegin = " + this.blockBegin));
                        log.debug((Object)("run(): blockEnd = " + this.blockEnd));
                    }
                    conn = Transaction.begin(this.criteria.getDbName());
                    boolean allRecordsRetrieved = false;
                    while (!this.killThread && !allRecordsRetrieved && this.currentlyFilledTo + this.pageSize <= this.blockEnd) {
                        List<T> tempResults;
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"run(): Invoking BasePeerImpl.doSelect()");
                        }
                        if ((tempResults = this.criteria instanceof Criteria ? this.peer.doSelect((Criteria)this.criteria, conn) : this.peer.doSelect((org.apache.torque.criteria.Criteria)this.criteria, conn)).size() < this.criteria.getLimit()) {
                            allRecordsRetrieved = true;
                        }
                        List<T> list = this.results;
                        synchronized (list) {
                            this.results.addAll(tempResults);
                        }
                        this.currentlyFilledTo += tempResults.size();
                        boolean perhapsLastPage = true;
                        if (this.results.size() == this.memoryLimit + 1) {
                            List<T> list2 = this.results;
                            synchronized (list2) {
                                this.results.remove(this.currentlyFilledTo--);
                            }
                            perhapsLastPage = false;
                        }
                        if (this.results.size() > 0 && this.blockBegin + this.currentlyFilledTo >= this.totalRecords) {
                            this.totalRecords = this.blockBegin + this.currentlyFilledTo + 1;
                        }
                        if (!allRecordsRetrieved) continue;
                        this.queryCompleted = true;
                        if (!perhapsLastPage || this.getCurrentPageNumber() > this.getTotalPages()) continue;
                        this.totalsFinalized = true;
                    }
                    Transaction.commit(conn);
                    conn = null;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"run(): While loop terminated because either:");
                        log.debug((Object)("run(): 1. qds.allRecordsRetrieved(): " + allRecordsRetrieved));
                        log.debug((Object)("run(): 2. killThread: " + this.killThread));
                        log.debug((Object)("run(): 3. !(currentlyFilledTo + size <= blockEnd): !" + (this.currentlyFilledTo + this.pageSize <= this.blockEnd)));
                        log.debug((Object)("run(): - currentlyFilledTo: " + this.currentlyFilledTo));
                        log.debug((Object)("run(): - size: " + this.pageSize));
                        log.debug((Object)("run(): - blockEnd: " + this.blockEnd));
                        log.debug((Object)("run(): - results.size(): " + this.results.size()));
                    }
                    if (conn == null) break block23;
                }
                catch (Exception e) {
                    log.error((Object)e);
                    break block24;
                }
                finally {
                    if (conn != null) {
                        Transaction.safeRollback(conn);
                    }
                    this.threadRunning = false;
                    this.queryCompleted = true;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Exiting query thread");
                    }
                }
                Transaction.safeRollback(conn);
            }
            this.threadRunning = false;
            this.queryCompleted = true;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Exiting query thread");
            }
        }
    }

    private synchronized void startQuery(int initialSize) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Starting query thread");
        }
        if (!this.threadRunning) {
            this.pageSize = initialSize;
            this.currentlyFilledTo = -1;
            this.queryCompleted = false;
            this.thread = new Thread(this);
            this.thread.setName("LargeSelect query Thread");
            this.thread.start();
            this.threadRunning = true;
            if (log.isDebugEnabled()) {
                log.debug((Object)"query thread started");
            }
        }
    }

    private synchronized void stopQuery() throws TorqueException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"stopQuery(): Stopping query thread");
        }
        if (this.threadRunning) {
            this.killThread = true;
            while (this.thread.isAlive()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    throw new TorqueException("Unexpected interruption", e);
                }
            }
            this.killThread = false;
            if (log.isDebugEnabled()) {
                log.debug((Object)"stopQuery(): query thread stopped.");
            }
        }
    }

    public int getCurrentPageNumber() {
        return this.position / this.pageSize;
    }

    public int getTotalRecords() {
        return this.totalRecords;
    }

    public boolean getPaginated() {
        if (!this.getTotalsFinalized()) {
            return true;
        }
        return this.blockBegin + this.currentlyFilledTo + 1 > this.pageSize;
    }

    public int getTotalPages() {
        if (this.totalPages > -1) {
            return this.totalPages;
        }
        int tempPageCount = this.getTotalRecords() / this.pageSize + (this.getTotalRecords() % this.pageSize > 0 ? 1 : 0);
        if (this.getTotalsFinalized()) {
            this.totalPages = tempPageCount;
        }
        return tempPageCount;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public boolean getTotalsFinalized() {
        return this.totalsFinalized;
    }

    public void setMoreIndicator(String moreIndicator) {
        this.moreIndicator = moreIndicator;
    }

    public String getMoreIndicator() {
        return this.moreIndicator;
    }

    public void setMemoryPageLimit(int memoryPageLimit) {
        this.memoryPageLimit = memoryPageLimit;
    }

    public int getMemoryPageLimit() {
        return this.memoryPageLimit;
    }

    public String getPageProgressText() {
        StringBuffer result = new StringBuffer();
        result.append(this.getCurrentPageNumber());
        result.append(" of ");
        if (!this.totalsFinalized) {
            result.append(this.moreIndicator);
            result.append(" ");
        }
        result.append(this.getTotalPages());
        return result.toString();
    }

    public int getCurrentPageSize() throws TorqueException {
        if (null == this.getCurrentPageResults()) {
            return 0;
        }
        return this.getCurrentPageResults().size();
    }

    public int getFirstRecordNoForPage() {
        if (this.getCurrentPageNumber() < 1) {
            return 0;
        }
        return (this.getCurrentPageNumber() - 1) * this.getPageSize() + 1;
    }

    public int getLastRecordNoForPage() throws TorqueException {
        if (0 == this.getCurrentPageNumber()) {
            return 0;
        }
        return (this.getCurrentPageNumber() - 1) * this.getPageSize() + this.getCurrentPageSize();
    }

    public String getRecordProgressText() throws TorqueException {
        StringBuffer result = new StringBuffer();
        result.append(this.getFirstRecordNoForPage());
        result.append(" - ");
        result.append(this.getLastRecordNoForPage());
        result.append(" of ");
        if (!this.totalsFinalized) {
            result.append(this.moreIndicator);
            result.append(" ");
        }
        result.append(this.getTotalRecords());
        return result.toString();
    }

    public boolean getNextResultsAvailable() {
        return !this.totalsFinalized || this.getCurrentPageNumber() < this.getTotalPages();
    }

    public boolean getPreviousResultsAvailable() {
        return this.getCurrentPageNumber() > 1;
    }

    public boolean hasResultsAvailable() {
        return this.getTotalRecords() > 0;
    }

    public synchronized void invalidateResult() throws TorqueException {
        this.stopQuery();
        this.blockBegin = 0;
        this.blockEnd = 0;
        this.currentlyFilledTo = -1;
        this.results = null;
        this.position = 0;
        this.totalPages = -1;
        this.totalRecords = 0;
        this.queryCompleted = false;
        this.totalsFinalized = false;
        this.lastResults = null;
    }

    public String getSearchParam(String name) {
        return this.getSearchParam(name, null);
    }

    public String getSearchParam(String name, String defaultValue) {
        if (null == this.params) {
            return defaultValue;
        }
        String value = this.params.get(name);
        return null == value ? defaultValue : value;
    }

    public void setSearchParam(String name, String value) {
        if (null == value) {
            this.removeSearchParam(name);
        } else if (null != name) {
            if (null == this.params) {
                this.params = new Hashtable<String, String>();
            }
            this.params.put(name, value);
        }
    }

    public void removeSearchParam(String name) {
        if (null != this.params) {
            this.params.remove(name);
        }
    }

    private void readObject(ObjectInputStream inputStream) throws IOException, ClassNotFoundException {
        inputStream.defaultReadObject();
        if (Torque.isInit()) {
            this.startQuery(this.pageSize);
        }
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("LargeSelect - TotalRecords: ");
        result.append(this.getTotalRecords());
        result.append(" TotalsFinalised: ");
        result.append(this.getTotalsFinalized());
        result.append("\nParameters:");
        if (null == this.params || this.params.size() == 0) {
            result.append(" No parameters have been set.");
        } else {
            Set<String> keys = this.params.keySet();
            for (String key : keys) {
                String val = this.params.get(key);
                result.append("\n ").append(key).append(": ").append(val);
            }
        }
        return result.toString();
    }
}

