/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.util;

import java.io.IOException;
import java.io.Writer;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.commons.collections.OrderedMapIterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.Column;
import org.apache.torque.ColumnImpl;
import org.apache.torque.TorqueException;
import org.apache.torque.criteria.SqlEnum;
import org.apache.torque.om.mapper.ObjectListMapper;
import org.apache.torque.sql.SqlBuilder;
import org.apache.torque.util.Criteria;
import org.apache.torque.util.ListOrderedMapCI;
import org.apache.torque.util.Transaction;
import org.apache.torque.util.UniqueList;
import org.apache.torque.util.functions.SQLFunction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SummaryHelper {
    private static Log logger = LogFactory.getLog(SummaryHelper.class);
    private List<Column> groupByColumns;
    private ListOrderedMapCI aggregates;
    private boolean excludeExprColumns = false;

    @Deprecated
    public List<ListOrderedMapCI> summarize(Criteria crit) throws TorqueException {
        return this.summarize(crit, (List)null);
    }

    public List<ListOrderedMapCI> summarize(org.apache.torque.criteria.Criteria crit) throws TorqueException {
        return this.summarize(crit, (List)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public List<ListOrderedMapCI> summarize(Criteria crit, List<Class<?>> resultTypes) throws TorqueException {
        Connection connection = null;
        try {
            connection = Transaction.begin(crit.getDbName());
            List<ListOrderedMapCI> result = this.summarize(crit, resultTypes, connection);
            Transaction.commit(connection);
            connection = null;
            List<ListOrderedMapCI> list = result;
            return list;
        }
        finally {
            if (connection != null) {
                Transaction.safeRollback(connection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ListOrderedMapCI> summarize(org.apache.torque.criteria.Criteria crit, List<Class<?>> resultTypes) throws TorqueException {
        Connection connection = null;
        try {
            connection = Transaction.begin(crit.getDbName());
            List<ListOrderedMapCI> result = this.summarize(crit, resultTypes, connection);
            Transaction.commit(connection);
            connection = null;
            List<ListOrderedMapCI> list = result;
            return list;
        }
        finally {
            if (connection != null) {
                Transaction.safeRollback(connection);
            }
        }
    }

    @Deprecated
    public List<ListOrderedMapCI> summarize(Criteria crit, Connection conn) throws TorqueException {
        return this.summarize(crit, null, conn);
    }

    public List<ListOrderedMapCI> summarize(org.apache.torque.criteria.Criteria crit, Connection conn) throws TorqueException {
        return this.summarize(crit, null, conn);
    }

    @Deprecated
    public List<ListOrderedMapCI> summarize(Criteria crit, List<Class<?>> resultTypes, Connection conn) throws TorqueException {
        Criteria c = this.buildCriteria(crit);
        String query = SqlBuilder.buildQuery(c).toString();
        ObjectListMapper mapper = new ObjectListMapper(resultTypes);
        Statement statement = null;
        ResultSet resultSet = null;
        ArrayList<List> rows = new ArrayList<List>();
        try {
            statement = conn.createStatement();
            long startTime = System.currentTimeMillis();
            logger.debug((Object)("Executing query " + query));
            resultSet = statement.executeQuery(query.toString());
            long queryEndTime = System.currentTimeMillis();
            logger.trace((Object)("query took " + (queryEndTime - startTime) + " milliseconds"));
            while (resultSet.next()) {
                List rowResult = (List)mapper.processRow(resultSet, 0, null);
                rows.add(rowResult);
            }
            long mappingEndTime = System.currentTimeMillis();
            logger.trace((Object)("mapping took " + (mappingEndTime - queryEndTime) + " milliseconds"));
        }
        catch (SQLException e) {
            throw new TorqueException(e);
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException e) {
                    logger.warn((Object)"error closing resultSet", (Throwable)e);
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    logger.warn((Object)"error closing statement", (Throwable)e);
                }
            }
        }
        Vector<ListOrderedMapCI> resultsList = new Vector<ListOrderedMapCI>(rows.size());
        ArrayList<String> columnNames = new ArrayList<String>();
        for (Column column : c.getSelectColumns()) {
            columnNames.add(column.getColumnName());
        }
        columnNames.addAll(c.getAsColumns().keySet());
        for (List row : rows) {
            ListOrderedMapCI recordMap = new ListOrderedMapCI();
            for (int i = 0; i < row.size(); ++i) {
                Object value = row.get(i);
                String cName = (String)columnNames.get(i);
                if (cName == null || cName.equals("")) {
                    if (this.excludeExprColumns()) continue;
                    cName = "Expr" + i;
                }
                recordMap.put(cName, value);
            }
            resultsList.add(recordMap);
        }
        return resultsList;
    }

    public List<ListOrderedMapCI> summarize(org.apache.torque.criteria.Criteria crit, List<Class<?>> resultTypes, Connection conn) throws TorqueException {
        org.apache.torque.criteria.Criteria c = this.buildCriteria(crit);
        String query = SqlBuilder.buildQuery(c).toString();
        ObjectListMapper mapper = new ObjectListMapper(resultTypes);
        Statement statement = null;
        ResultSet resultSet = null;
        ArrayList<List> rows = new ArrayList<List>();
        try {
            statement = conn.createStatement();
            long startTime = System.currentTimeMillis();
            logger.debug((Object)("Executing query " + query));
            resultSet = statement.executeQuery(query.toString());
            long queryEndTime = System.currentTimeMillis();
            logger.trace((Object)("query took " + (queryEndTime - startTime) + " milliseconds"));
            while (resultSet.next()) {
                List rowResult = (List)mapper.processRow(resultSet, 0, null);
                rows.add(rowResult);
            }
            long mappingEndTime = System.currentTimeMillis();
            logger.trace((Object)("mapping took " + (mappingEndTime - queryEndTime) + " milliseconds"));
        }
        catch (SQLException e) {
            throw new TorqueException(e);
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException e) {
                    logger.warn((Object)"error closing resultSet", (Throwable)e);
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    logger.warn((Object)"error closing statement", (Throwable)e);
                }
            }
        }
        Vector<ListOrderedMapCI> resultsList = new Vector<ListOrderedMapCI>(rows.size());
        ArrayList<String> columnNames = new ArrayList<String>();
        for (Column column : c.getSelectColumns()) {
            columnNames.add(column.getColumnName());
        }
        columnNames.addAll(c.getAsColumns().keySet());
        for (List row : rows) {
            ListOrderedMapCI recordMap = new ListOrderedMapCI();
            for (int i = 0; i < row.size(); ++i) {
                Object value = row.get(i);
                String cName = (String)columnNames.get(i);
                if (cName == null || cName.equals("")) {
                    if (this.excludeExprColumns()) continue;
                    cName = "Expr" + i;
                }
                recordMap.put(cName, value);
            }
            resultsList.add(recordMap);
        }
        return resultsList;
    }

    @Deprecated
    public Criteria buildCriteria(Criteria c) throws TorqueException {
        c.getSelectColumns().clear();
        c.getGroupByColumns().clear();
        UniqueList<String> criteriaSelectModifiers = c.getSelectModifiers();
        if (criteriaSelectModifiers != null && criteriaSelectModifiers.size() > 0 && criteriaSelectModifiers.contains(SqlEnum.DISTINCT.toString())) {
            criteriaSelectModifiers.remove(SqlEnum.DISTINCT.toString());
        }
        c.setIgnoreCase(false);
        List<Column> cols = this.getGroupByColumns();
        boolean haveFromTable = !cols.isEmpty();
        for (Column col : cols) {
            c.addGroupByColumn(col);
            c.addSelectColumn(col);
        }
        if (haveFromTable) {
            logger.debug((Object)"From table defined by Group By Cols");
        }
        if (!haveFromTable && !c.isEmpty()) {
            haveFromTable = true;
            logger.debug((Object)"From table defined by a where clause");
        }
        ListOrderedMapCI cMap = this.getAggregates();
        OrderedMapIterator iMap = cMap.orderedMapIterator();
        while (iMap.hasNext()) {
            String key = (String)iMap.next();
            SQLFunction f = (SQLFunction)iMap.getValue();
            Column col = f.getColumn();
            c.addAsColumn(key, new ColumnImpl(null, col.getTableName(), col.getColumnName(), f.getSqlExpression()));
            if (haveFromTable) continue;
            c.add(col, (Object)(col.getColumnName() + "=" + col.getColumnName()), SqlEnum.CUSTOM);
            haveFromTable = true;
            String table = col.getTableName();
            logger.debug((Object)("From table, '" + table + "', defined from aggregate column"));
        }
        if (!haveFromTable) {
            throw new TorqueException("No FROM table defined by the GroupBy set, criteria.setAlias, or specified function column!");
        }
        return c;
    }

    public org.apache.torque.criteria.Criteria buildCriteria(org.apache.torque.criteria.Criteria c) throws TorqueException {
        c.getSelectColumns().clear();
        c.getGroupByColumns().clear();
        UniqueList<String> criteriaSelectModifiers = c.getSelectModifiers();
        if (criteriaSelectModifiers != null && criteriaSelectModifiers.size() > 0 && criteriaSelectModifiers.contains(SqlEnum.DISTINCT.toString())) {
            criteriaSelectModifiers.remove(SqlEnum.DISTINCT.toString());
        }
        c.setIgnoreCase(false);
        List<Column> cols = this.getGroupByColumns();
        boolean haveFromTable = !cols.isEmpty();
        for (Column col : cols) {
            c.addGroupByColumn(col);
            c.addSelectColumn(col);
        }
        if (haveFromTable) {
            logger.debug((Object)"From table defined by Group By Cols");
        }
        if (!haveFromTable && c.getTopLevelCriterion() != null) {
            haveFromTable = true;
            logger.debug((Object)"From table defined by a where clause");
        }
        ListOrderedMapCI cMap = this.getAggregates();
        OrderedMapIterator iMap = cMap.orderedMapIterator();
        while (iMap.hasNext()) {
            String key = (String)iMap.next();
            SQLFunction f = (SQLFunction)iMap.getValue();
            Column col = f.getColumn();
            c.addAsColumn(key, new ColumnImpl(null, col.getTableName(), col.getColumnName(), f.getSqlExpression()));
            if (haveFromTable) continue;
            c.and(col, col.getColumnName() + "=" + col.getColumnName(), SqlEnum.CUSTOM);
            haveFromTable = true;
            String table = col.getTableName();
            logger.debug((Object)("From table, '" + table + "', defined from aggregate column"));
        }
        if (!haveFromTable) {
            throw new TorqueException("No FROM table defined by the GroupBy set, criteria.setAlias, or specified function column!");
        }
        return c;
    }

    public void addGroupBy(Column column) {
        this.getGroupByColumns().add(column);
    }

    public void addAggregate(String alias, SQLFunction function) {
        this.getAggregates().put(alias, function);
    }

    public void clear() {
        this.getGroupByColumns().clear();
        this.getAggregates().clear();
        this.setExcludeExprColumns(false);
    }

    public List<Column> getGroupByColumns() {
        if (this.groupByColumns == null) {
            this.groupByColumns = new Vector<Column>();
        }
        return this.groupByColumns;
    }

    public ListOrderedMapCI getAggregates() {
        if (this.aggregates == null) {
            this.aggregates = new ListOrderedMapCI();
        }
        return this.aggregates;
    }

    public void dumpResults(Writer out, List<?> results, boolean includeHeader) throws IOException {
        Iterator<?> i = results.iterator();
        boolean first = includeHeader;
        while (i.hasNext()) {
            ListOrderedMapCI rec = (ListOrderedMapCI)((Object)i.next());
            OrderedMapIterator rI = rec.orderedMapIterator();
            StringBuilder heading = new StringBuilder();
            StringBuilder recString = new StringBuilder();
            while (rI.hasNext()) {
                String colId = (String)rI.next();
                if (first) {
                    heading.append("\"").append(colId).append("\"");
                    if (rI.hasNext()) {
                        heading.append(", ");
                    }
                }
                Object v = rI.getValue();
                recString.append(v.toString());
                if (!rI.hasNext()) continue;
                recString.append(", ");
            }
            if (first) {
                first = false;
                out.write(heading.toString());
                out.write("\n");
            }
            out.write(recString.toString());
            out.write("\n");
        }
    }

    public boolean excludeExprColumns() {
        return this.excludeExprColumns;
    }

    public void setExcludeExprColumns(boolean excludeExprColumns) {
        this.excludeExprColumns = excludeExprColumns;
    }
}

