/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.store;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.RandomAccessFile;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.derby.tools.ij;
import org.apache.derbyTesting.functionTests.util.TestUtil;

public class TestDurabilityProperty {
    public static void main(String[] args) {
        try {
            TestDurabilityProperty.testNoSyncs(args);
            String derbyHome = System.getProperty("derby.system.home");
            TestDurabilityProperty.report("Is warning message about derby.system.durability=test present in derby.log =" + TestDurabilityProperty.isMessageInDerbyLog(derbyHome));
            TestDurabilityProperty.markerInControlFile(derbyHome);
            TestDurabilityProperty.report("2. shutdown database and reboot database without derby.system.durability=test and test for marker in log.ctrl file");
            TestDurabilityProperty.markerNotOverwritten(derbyHome);
        }
        catch (Throwable e) {
            TestDurabilityProperty.report("FAIL -- unexpected exception: " + String.valueOf(e));
            e.printStackTrace();
        }
    }

    public static long timeTakenToInsert(String mode, boolean create, boolean autoCommit) throws Exception {
        long timeTaken;
        block3: {
            System.setProperty("derby.system.durability", mode);
            Connection conn = ij.startJBMS();
            if (create) {
                Statement s = conn.createStatement();
                s.execute("create table t1 (c1 int, c2 int)");
                s.close();
            }
            timeTaken = TestDurabilityProperty.doInserts(conn, autoCommit);
            try {
                conn.close();
                TestUtil.getConnection("", "shutdown=true");
            }
            catch (SQLException sqle) {
                if ("XJ015".equals(sqle.getSQLState())) break block3;
                TestDurabilityProperty.report(sqle.getSQLState());
                TestDurabilityProperty.report("ERROR! during shutdown");
                sqle.printStackTrace();
            }
        }
        return timeTaken;
    }

    public static long doInserts(Connection conn, boolean autoCommit) throws Exception {
        PreparedStatement ps = conn.prepareStatement("insert into t1 values(?,?)");
        conn.setAutoCommit(autoCommit);
        long count = 0L;
        long start = System.currentTimeMillis();
        for (int i = 0; i < 500; ++i) {
            ps.setInt(1, i);
            ps.setInt(2, i);
            count += (long)ps.executeUpdate();
        }
        if (!autoCommit) {
            conn.commit();
        }
        long end = System.currentTimeMillis();
        if (count < 500L) {
            TestDurabilityProperty.report(" FAIL!! all rows didnt get inserted ?");
        }
        return end - start;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isMessageInDerbyLog(String derbyHome) throws Exception {
        BufferedReader reader = null;
        File derbylog = null;
        try {
            derbylog = new File(derbyHome, "derby.log");
            reader = new BufferedReader(new FileReader(derbylog));
            String line = null;
            while ((line = reader.readLine()) != null) {
                if (line.indexOf("derby.system.durability=test") == -1) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            derbylog = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void markerInControlFile(String derbyHome) throws Exception {
        try (RandomAccessFile controlFile = null;){
            int testModeNoSyncMarkerPosition = 28;
            int testModeNoSyncMarker = 2;
            controlFile = new RandomAccessFile(derbyHome + "/wombat/log/log.ctrl", "r");
            controlFile.seek(testModeNoSyncMarkerPosition);
            TestDurabilityProperty.report("log.ctrl file has durability testMode no sync marker value = " + ((controlFile.readByte() & testModeNoSyncMarker) != 0));
        }
    }

    public static void markerNotOverwritten(String derbyHome) throws Exception {
        Connection conn = null;
        System.setProperty("derby.system.durability", "");
        conn = ij.startJBMS();
        conn.close();
        TestDurabilityProperty.markerInControlFile(derbyHome);
        TestDurabilityProperty.report("Is warning message about derby.system.durability=test present in derby.log =" + TestDurabilityProperty.isMessageInDerbyLog(derbyHome));
    }

    public static void report(String msg) {
        System.out.println(msg);
    }

    public static void testNoSyncs(String[] args) throws Exception {
        boolean debug = false;
        TestDurabilityProperty.report("1. With derby.system.durability=test,Test to see if syncs are not happening ");
        ij.getPropertyArg((String[])args);
        boolean create = true;
        long timeCommitOn = TestDurabilityProperty.timeTakenToInsert("", create, true);
        String derbyHome = System.getProperty("derby.system.home");
        if (TestDurabilityProperty.isMessageInDerbyLog(derbyHome)) {
            TestDurabilityProperty.report("ERROR! System should not have been booted withderby.system.durability=test mode here");
        }
        create = false;
        long timeWithTestModeCommitOn = TestDurabilityProperty.timeTakenToInsert("test", create, true);
        long timeWithTestModeCommitOff = TestDurabilityProperty.timeTakenToInsert("test", create, false);
        if (debug) {
            TestDurabilityProperty.report("timeCommitOn = " + timeCommitOn);
            TestDurabilityProperty.report("timeWithTestModeCommitOn = " + timeWithTestModeCommitOn);
            TestDurabilityProperty.report("timeWithTestModeCommitOff = " + timeWithTestModeCommitOff);
        }
    }
}

